/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core.controllo_traffico.policy.driver.hazelcast;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.map.EntryProcessor;
import java.io.Serializable;
import java.util.Date;
import org.openspcoop2.core.controllo_traffico.beans.ActivePolicy;
import org.openspcoop2.core.controllo_traffico.beans.DatiCollezionati;
import org.openspcoop2.core.controllo_traffico.beans.IDUnivocoGroupByPolicy;
import org.openspcoop2.core.controllo_traffico.beans.MisurazioniTransazione;
import org.openspcoop2.core.controllo_traffico.driver.PolicyException;
import org.openspcoop2.core.controllo_traffico.driver.PolicyGroupByActiveThreadsType;
import org.openspcoop2.core.controllo_traffico.driver.PolicyNotFoundException;
import org.openspcoop2.pdd.core.controllo_traffico.policy.PolicyDateUtils;
import org.openspcoop2.pdd.core.controllo_traffico.policy.driver.hazelcast.AbstractPolicyGroupByActiveThreadsDistributed;
import org.openspcoop2.pdd.core.controllo_traffico.policy.driver.hazelcast.EndRequestProcessor;
import org.openspcoop2.pdd.core.controllo_traffico.policy.driver.hazelcast.StartRequestProcessor;
import org.openspcoop2.pdd.core.controllo_traffico.policy.driver.hazelcast.UpdateDatiRequestProcessor;
import org.openspcoop2.utils.Map;
import org.slf4j.Logger;

public class PolicyGroupByActiveThreadsDistributedNearCache
extends AbstractPolicyGroupByActiveThreadsDistributed {
    public PolicyGroupByActiveThreadsDistributedNearCache(ActivePolicy policy, String uniqueIdMap, HazelcastInstance hazelcast) throws PolicyException {
        super(policy, uniqueIdMap, PolicyGroupByActiveThreadsType.HAZELCAST_NEAR_CACHE, hazelcast);
    }

    public DatiCollezionati registerStartRequest(Logger log, String idTransazione, IDUnivocoGroupByPolicy datiGroupBy, Map<Object> ctx) throws PolicyException {
        datiGroupBy = this.augmentIDUnivoco(datiGroupBy);
        this.distributedMap.submitToKey((Object)datiGroupBy, (EntryProcessor)new StartRequestProcessor(this.activePolicy, ctx));
        DatiCollezionati datiCollezionati = (DatiCollezionati)this.distributedMap.get((Object)datiGroupBy);
        boolean newDati = false;
        if (datiCollezionati == null) {
            Date gestorePolicyConfigDate = PolicyDateUtils.readGestorePolicyConfigDateIntoContext(ctx);
            datiCollezionati = new DatiCollezionati(this.activePolicy.getInstanceConfiguration().getUpdateTime(), gestorePolicyConfigDate);
            newDati = true;
        } else if (datiCollezionati.getUpdatePolicyDate() != null && !datiCollezionati.getUpdatePolicyDate().equals(this.activePolicy.getInstanceConfiguration().getUpdateTime())) {
            datiCollezionati.resetCounters(this.activePolicy.getInstanceConfiguration().getUpdateTime());
        }
        DatiCollezionati datiCollezionatiPerPolicyVerifier = datiCollezionati.newInstance();
        if (newDati) {
            datiCollezionatiPerPolicyVerifier.initDatiIniziali(this.activePolicy);
            datiCollezionatiPerPolicyVerifier.checkDate(log, this.activePolicy);
        }
        datiCollezionati.registerStartRequest(log, this.activePolicy, ctx, datiCollezionatiPerPolicyVerifier);
        return datiCollezionatiPerPolicyVerifier;
    }

    public DatiCollezionati updateDatiStartRequestApplicabile(Logger log, String idTransazione, IDUnivocoGroupByPolicy datiGroupBy, Map<Object> ctx) throws PolicyException, PolicyNotFoundException {
        datiGroupBy = this.augmentIDUnivoco(datiGroupBy);
        this.distributedMap.submitToKey((Object)datiGroupBy, (EntryProcessor)new UpdateDatiRequestProcessor(this.activePolicy, ctx));
        DatiCollezionati datiCollezionati = (DatiCollezionati)this.distributedMap.get((Object)datiGroupBy);
        if (datiCollezionati == null) {
            log.debug("(idTransazione:" + idTransazione + ") Policy non ancora in Near Cache. Conto come fosse la prima richiesta; dati identificativi [" + datiGroupBy.toString() + "]");
            Date gestorePolicyConfigDate = PolicyDateUtils.readGestorePolicyConfigDateIntoContext(ctx);
            datiCollezionati = new DatiCollezionati(this.activePolicy.getInstanceConfiguration().getUpdateTime(), gestorePolicyConfigDate);
            datiCollezionati.registerStartRequest(log, this.activePolicy, null);
            return datiCollezionati;
        }
        DatiCollezionati datiCollezionatiPerPolicyVerifier = datiCollezionati.newInstance();
        boolean update = datiCollezionati.updateDatiStartRequestApplicabile(log, this.activePolicy, ctx, datiCollezionatiPerPolicyVerifier);
        if (update) {
            return datiCollezionatiPerPolicyVerifier;
        }
        return null;
    }

    public void registerStopRequest(Logger log, String idTransazione, IDUnivocoGroupByPolicy datiGroupBy, Map<Object> ctx, MisurazioniTransazione dati, boolean isApplicabile, boolean isViolata) throws PolicyException, PolicyNotFoundException {
        datiGroupBy = this.augmentIDUnivoco(datiGroupBy);
        this.distributedMap.submitToKey((Object)datiGroupBy, (EntryProcessor)new EndRequestProcessor(this.activePolicy, ctx, dati, isApplicabile, isViolata));
    }

    @Override
    public void resetCounters() {
        this.distributedMap.executeOnEntries((EntryProcessor & Serializable)entry -> {
            ((DatiCollezionati)entry.getValue()).resetCounters();
            entry.setValue((DatiCollezionati)entry.getValue());
            return true;
        });
    }
}

