/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core.controllo_traffico.policy.driver.hazelcast;

import com.fasterxml.jackson.databind.JsonNode;
import com.hazelcast.config.Config;
import com.hazelcast.config.InMemoryYamlConfig;
import com.hazelcast.config.NetworkConfig;
import com.hazelcast.config.YamlConfigBuilder;
import com.hazelcast.core.Hazelcast;
import com.hazelcast.core.HazelcastInstance;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.openspcoop2.core.controllo_traffico.driver.PolicyException;
import org.openspcoop2.core.controllo_traffico.driver.PolicyGroupByActiveThreadsType;
import org.openspcoop2.utils.Utilities;
import org.openspcoop2.utils.json.JsonPathExpressionEngine;
import org.openspcoop2.utils.json.JsonPathNotFoundException;
import org.openspcoop2.utils.json.YAMLUtils;
import org.openspcoop2.utils.resources.Charset;
import org.openspcoop2.utils.resources.FileSystemUtilities;
import org.slf4j.Logger;

public class HazelcastManager {
    private static String GOVWAY_INSTANCE_PORT = "GOVWAY_INSTANCE_PORT";
    public static Map<PolicyGroupByActiveThreadsType, HazelcastInstance> staticMapInstance = null;
    private static Map<PolicyGroupByActiveThreadsType, String> staticMapConfig = null;
    private static String groupId;
    private static YAMLUtils yamlUtils;
    private static JsonPathExpressionEngine engine;
    private static JsonNode sharedConfigNode;
    private static File shareConfigFile;
    private static Logger logStartup;
    private static Logger log;

    public static synchronized void initialize(Logger logStartup, Logger log, Map<PolicyGroupByActiveThreadsType, String> config, String groupId, File shareConfigFile) throws Exception {
        if (staticMapInstance == null) {
            System.setProperty("hazelcast.shutdownhook.enabled", "false");
            System.setProperty("hazelcast.logging.type", "log4j2");
            staticMapInstance = new HashMap<PolicyGroupByActiveThreadsType, HazelcastInstance>();
            staticMapConfig = new HashMap<PolicyGroupByActiveThreadsType, String>();
            HazelcastManager.groupId = groupId;
            HazelcastManager.logStartup = logStartup;
            HazelcastManager.log = log;
            if (shareConfigFile != null) {
                HazelcastManager.shareConfigFile = shareConfigFile;
                yamlUtils = YAMLUtils.getInstance();
                engine = new JsonPathExpressionEngine();
                String sharedContentBytes = FileSystemUtilities.readFile((File)shareConfigFile);
                try {
                    sharedConfigNode = yamlUtils.getAsNode(sharedContentBytes.getBytes());
                }
                catch (Throwable t) {
                    throw new PolicyException("Configuration '" + shareConfigFile.getAbsolutePath() + "' is not valid yaml config: " + t.getMessage() + "\n" + sharedContentBytes, t);
                }
                Config sharedConfig = null;
                try (ByteArrayInputStream bin = new ByteArrayInputStream(sharedContentBytes.getBytes());){
                    YamlConfigBuilder builder = new YamlConfigBuilder((InputStream)bin);
                    sharedConfig = builder.build();
                }
                catch (Throwable t) {
                    throw new PolicyException("Configuration '" + shareConfigFile.getAbsolutePath() + "' is not valid yaml config (YamlConfigBuilder): " + t.getMessage() + "\n" + sharedContentBytes, t);
                }
                if (sharedConfig != null && sharedConfig.getClusterName() != null && StringUtils.isNotEmpty((CharSequence)sharedConfig.getClusterName())) {
                    HazelcastManager.groupId = sharedConfig.getClusterName();
                }
            }
            if (config != null && !config.isEmpty()) {
                for (PolicyGroupByActiveThreadsType type : config.keySet()) {
                    File hazelcastConfigFile;
                    String pathConfig = config.get(type);
                    String content = null;
                    if (pathConfig != null && (hazelcastConfigFile = new File(pathConfig)).exists()) {
                        if (!hazelcastConfigFile.canRead()) {
                            throw new Exception("Hazelcast (type:" + String.valueOf(type) + ") file config [" + hazelcastConfigFile.getAbsolutePath() + "] cannot read");
                        }
                        content = FileSystemUtilities.readFile((File)hazelcastConfigFile);
                    }
                    if (content == null) {
                        String name = "";
                        switch (type) {
                            case HAZELCAST_MAP: {
                                name = "govway.hazelcast-map.yaml";
                                break;
                            }
                            case HAZELCAST_NEAR_CACHE: {
                                name = "govway.hazelcast-near-cache.yaml";
                                break;
                            }
                            case HAZELCAST_NEAR_CACHE_UNSAFE_SYNC_MAP: {
                                name = "govway.hazelcast-near-cache-unsafe-sync-map.yaml";
                                break;
                            }
                            case HAZELCAST_NEAR_CACHE_UNSAFE_ASYNC_MAP: {
                                name = "govway.hazelcast-near-cache-unsafe-async-map.yaml";
                                break;
                            }
                            case HAZELCAST_LOCAL_CACHE: {
                                name = "govway.hazelcast-local-cache.yaml";
                                break;
                            }
                            case HAZELCAST_REPLICATED_MAP: {
                                name = "govway.hazelcast-replicated-map.yaml";
                                break;
                            }
                            case HAZELCAST_ATOMIC_LONG: {
                                name = "govway.hazelcast-atomic-long-counters.yaml";
                                break;
                            }
                            case HAZELCAST_ATOMIC_LONG_ASYNC: {
                                name = "govway.hazelcast-atomic-long-async-counters.yaml";
                                break;
                            }
                            case HAZELCAST_PNCOUNTER: {
                                name = "govway.hazelcast-pn-counters.yaml";
                                break;
                            }
                            default: {
                                throw new Exception("Hazelcast type '" + String.valueOf(type) + "' unsupported");
                            }
                        }
                        content = Utilities.getAsString((InputStream)HazelcastManager.class.getResourceAsStream("/" + name), (String)Charset.UTF_8.getValue());
                    }
                    if (content == null) {
                        throw new Exception("Hazelcast (type:" + String.valueOf(type) + ") config undefined");
                    }
                    staticMapConfig.put(type, content);
                }
            }
        }
    }

    public static List<PolicyGroupByActiveThreadsType> getTipiGestoriHazelcastAttivi() throws PolicyException {
        if (staticMapInstance == null) {
            throw new PolicyException("Nessun gestore Hazelcast inizializzato");
        }
        ArrayList<PolicyGroupByActiveThreadsType> l = new ArrayList<PolicyGroupByActiveThreadsType>();
        l.addAll(staticMapInstance.keySet());
        return l;
    }

    public static boolean isAttivo(PolicyGroupByActiveThreadsType type) {
        if (staticMapInstance == null) {
            return false;
        }
        return staticMapInstance.containsKey(type);
    }

    public static HazelcastInstance getInstance(PolicyGroupByActiveThreadsType type) throws PolicyException {
        if (staticMapInstance == null) {
            throw new PolicyException("Nessun gestore Hazelcast inizializzato");
        }
        HazelcastInstance gestore = staticMapInstance.get(type);
        if (gestore == null) {
            HazelcastManager.initialize(type);
            gestore = staticMapInstance.get(type);
        }
        if (gestore == null) {
            throw new PolicyException("Gestore Hazelcast '" + String.valueOf(type) + "' non inizializzato ??");
        }
        return gestore;
    }

    private static synchronized void initialize(PolicyGroupByActiveThreadsType type) throws PolicyException {
        if (!staticMapInstance.containsKey(type)) {
            HazelcastManager.info("Inizializzazione Gestore Hazelcast '" + String.valueOf(type) + "' ...");
            staticMapInstance.put(type, HazelcastManager.newInstance(type));
            HazelcastManager.info("Inizializzazione Gestore Hazelcast '" + String.valueOf(type) + "' effettuata con successo");
        }
    }

    private static synchronized HazelcastInstance newInstance(PolicyGroupByActiveThreadsType type) throws PolicyException {
        String content = staticMapConfig.get(type);
        if (content == null) {
            throw new PolicyException("Hazelcast config undefined for type '" + String.valueOf(type) + "'");
        }
        String groupId = null;
        switch (type) {
            case HAZELCAST_MAP: {
                groupId = HazelcastManager.groupId + "-map";
                break;
            }
            case HAZELCAST_NEAR_CACHE: {
                groupId = HazelcastManager.groupId + "-near-cache";
                break;
            }
            case HAZELCAST_NEAR_CACHE_UNSAFE_SYNC_MAP: {
                groupId = HazelcastManager.groupId + "-near-cache-unsafe-sync-map";
                break;
            }
            case HAZELCAST_NEAR_CACHE_UNSAFE_ASYNC_MAP: {
                groupId = HazelcastManager.groupId + "-near-cache-unsafe-async-map";
                break;
            }
            case HAZELCAST_LOCAL_CACHE: {
                groupId = HazelcastManager.groupId + "-local-cache";
                break;
            }
            case HAZELCAST_REPLICATED_MAP: {
                groupId = HazelcastManager.groupId + "-replicated-map";
                break;
            }
            case HAZELCAST_PNCOUNTER: {
                groupId = HazelcastManager.groupId + "-pncounter";
                break;
            }
            case HAZELCAST_ATOMIC_LONG: {
                groupId = HazelcastManager.groupId + "-atomic-long";
                break;
            }
            case HAZELCAST_ATOMIC_LONG_ASYNC: {
                groupId = HazelcastManager.groupId + "-atomic-long-async";
                break;
            }
            default: {
                throw new PolicyException("Hazelcast type '" + String.valueOf(type) + "' unsupported");
            }
        }
        content = content.replace("cluster-name:", "cluster-name: " + groupId + "\n#cluster-name:");
        HazelcastManager.debug("Inizializzo hazelcast con la seguente configurazione (cluster-id" + groupId + "): " + content);
        InMemoryYamlConfig hazelcastConfig = new InMemoryYamlConfig(content);
        hazelcastConfig.setClusterName(groupId);
        HazelcastManager.setNetwork(hazelcastConfig, content, groupId);
        HazelcastInstance hazelcast = Hazelcast.newHazelcastInstance((Config)hazelcastConfig);
        if (hazelcast == null) {
            throw new PolicyException("Hazelcast init failed");
        }
        return hazelcast;
    }

    private static void setNetwork(InMemoryYamlConfig hazelcastConfig, String hazelcastConfigContent, String groupId) throws PolicyException {
        Config sharedConfig = null;
        if (shareConfigFile != null) {
            try (FileInputStream fin = new FileInputStream(shareConfigFile);){
                YamlConfigBuilder builder = new YamlConfigBuilder((InputStream)fin);
                sharedConfig = builder.build();
            }
            catch (Throwable t) {
                throw new PolicyException("Configuration '" + shareConfigFile.getAbsolutePath() + "' is not valid yaml config (YamlConfigBuilder): " + t.getMessage(), t);
            }
        }
        if (sharedConfig != null && sharedConfig.getNetworkConfig() != null) {
            boolean definedInstance;
            boolean definedShared;
            boolean definedInstance2;
            NetworkConfig ncShared = sharedConfig.getNetworkConfig();
            NetworkConfig ncInstance = hazelcastConfig.getNetworkConfig();
            Integer portHazelcastConfigInstance = null;
            if (ncInstance == null) {
                ncInstance = new NetworkConfig();
                hazelcastConfig.setNetworkConfig(ncInstance);
            } else {
                portHazelcastConfigInstance = hazelcastConfig.getNetworkConfig().getPort();
            }
            JsonNode instanceNode = null;
            try {
                instanceNode = yamlUtils.getAsNode(hazelcastConfigContent);
            }
            catch (Throwable t) {
                throw new PolicyException("Configuration '" + groupId + "' is not valid yaml config:\n" + hazelcastConfigContent);
            }
            if (ncShared.getPublicAddress() != null && !(definedInstance2 = HazelcastManager.isDefined("public-address", yamlUtils, engine, instanceNode))) {
                ncInstance.setPublicAddress(ncShared.getPublicAddress());
                HazelcastManager.debug("(cluster-id" + groupId + ") override public-address: " + ncInstance.getPublicAddress());
            }
            if ((ncShared.getOutboundPorts() != null && !ncShared.getOutboundPorts().isEmpty() || ncShared.getOutboundPortDefinitions() != null && !ncShared.getOutboundPortDefinitions().isEmpty()) && !(definedInstance2 = HazelcastManager.isDefined("outbound-ports", yamlUtils, engine, instanceNode))) {
                if (ncShared.getOutboundPorts() != null && !ncShared.getOutboundPorts().isEmpty()) {
                    ncInstance.setOutboundPorts(ncShared.getOutboundPorts());
                    HazelcastManager.debug("(cluster-id" + groupId + ") override outbound-ports: " + String.valueOf(ncInstance.getOutboundPorts()));
                }
                if (ncShared.getOutboundPortDefinitions() != null && !ncShared.getOutboundPortDefinitions().isEmpty()) {
                    ncInstance.setOutboundPortDefinitions(ncShared.getOutboundPortDefinitions());
                    HazelcastManager.debug("(cluster-id" + groupId + ") override outbound-ports (definitions): " + String.valueOf(ncInstance.getOutboundPortDefinitions()));
                }
            }
            if ((definedShared = HazelcastManager.isDefined("reuse-address", yamlUtils, engine, sharedConfigNode)) && !(definedInstance = HazelcastManager.isDefined("reuse-address", yamlUtils, engine, instanceNode))) {
                ncInstance.setReuseAddress(ncShared.isReuseAddress());
                HazelcastManager.debug("(cluster-id" + groupId + ") override reuse-address: " + ncInstance.isReuseAddress());
            }
            if (ncShared.getJoin() != null && !(definedInstance = HazelcastManager.isDefined("join", yamlUtils, engine, instanceNode))) {
                ncInstance.setJoin(ncShared.getJoin());
                if (ncInstance.getJoin().getTcpIpConfig() != null && portHazelcastConfigInstance != null && portHazelcastConfigInstance > 0 && ncInstance.getJoin().getTcpIpConfig().getMembers() != null && !ncInstance.getJoin().getTcpIpConfig().getMembers().isEmpty()) {
                    ArrayList<String> newList = new ArrayList<String>();
                    for (String member : ncInstance.getJoin().getTcpIpConfig().getMembers()) {
                        try {
                            if (member.contains(GOVWAY_INSTANCE_PORT)) {
                                newList.add(member.replace(GOVWAY_INSTANCE_PORT, "" + portHazelcastConfigInstance));
                                continue;
                            }
                            if (member.contains(GOVWAY_INSTANCE_PORT.toLowerCase())) {
                                newList.add(member.replace(GOVWAY_INSTANCE_PORT.toLowerCase(), "" + portHazelcastConfigInstance));
                                continue;
                            }
                            newList.add(member);
                        }
                        catch (Throwable t) {
                            HazelcastManager.error("(cluster-id" + groupId + ") tpcip analisi member '" + member + "' fallita: " + t.getMessage(), t);
                        }
                    }
                    ncInstance.getJoin().getTcpIpConfig().setMembers(newList);
                }
                HazelcastManager.debug("(cluster-id" + groupId + ") override join: " + String.valueOf(ncInstance.getJoin()));
            }
            if (ncShared.getInterfaces() != null && ncShared.getInterfaces().isEnabled() && !(definedInstance = HazelcastManager.isDefined("interfaces", yamlUtils, engine, instanceNode))) {
                ncInstance.setInterfaces(ncShared.getInterfaces());
                HazelcastManager.debug("(cluster-id" + groupId + ") override interfaces: " + String.valueOf(ncInstance.getInterfaces()));
            }
            if (ncShared.getIcmpFailureDetectorConfig() != null && ncShared.getIcmpFailureDetectorConfig().isEnabled() && !(definedInstance = HazelcastManager.isDefined("failure-detector", yamlUtils, engine, instanceNode))) {
                ncInstance.setIcmpFailureDetectorConfig(ncShared.getIcmpFailureDetectorConfig());
                HazelcastManager.debug("(cluster-id" + groupId + ") override failure-detector icmp: " + String.valueOf(ncInstance.getIcmpFailureDetectorConfig()));
            }
            if (ncShared.getMemberAddressProviderConfig() != null && ncShared.getMemberAddressProviderConfig().isEnabled() && !(definedInstance = HazelcastManager.isDefined("member-address-provider", yamlUtils, engine, instanceNode))) {
                ncInstance.setMemberAddressProviderConfig(ncShared.getMemberAddressProviderConfig());
                HazelcastManager.debug("(cluster-id" + groupId + ") override member-address-provider: " + String.valueOf(ncInstance.getMemberAddressProviderConfig()));
            }
            if (ncShared.getMemcacheProtocolConfig() != null && ncShared.getMemcacheProtocolConfig().isEnabled() && !(definedInstance = HazelcastManager.isDefined("memcache-protocol", yamlUtils, engine, instanceNode))) {
                ncInstance.setMemcacheProtocolConfig(ncShared.getMemcacheProtocolConfig());
                HazelcastManager.debug("(cluster-id" + groupId + ") override memcache-protocol: " + String.valueOf(ncInstance.getMemcacheProtocolConfig()));
            }
            if (ncShared.getRestApiConfig() != null && ncShared.getRestApiConfig().isEnabled() && !(definedInstance = HazelcastManager.isDefined("rest-api", yamlUtils, engine, instanceNode))) {
                ncInstance.setRestApiConfig(ncShared.getRestApiConfig());
                HazelcastManager.debug("(cluster-id" + groupId + ") override rest-api: " + String.valueOf(ncInstance.getRestApiConfig()));
            }
            if (ncShared.getSocketInterceptorConfig() != null && ncShared.getSocketInterceptorConfig().getClassName() != null && !(definedInstance = HazelcastManager.isDefined("socket-interceptor", yamlUtils, engine, instanceNode))) {
                ncInstance.setSocketInterceptorConfig(ncShared.getSocketInterceptorConfig());
                HazelcastManager.debug("(cluster-id" + groupId + ") override socket-interceptor: " + String.valueOf(ncInstance.getSocketInterceptorConfig()));
            }
            if (ncShared.getSSLConfig() != null && ncShared.getSSLConfig().isEnabled() && !(definedInstance = HazelcastManager.isDefined("ssl", yamlUtils, engine, instanceNode))) {
                ncInstance.setSSLConfig(ncShared.getSSLConfig());
                HazelcastManager.debug("(cluster-id" + groupId + ") override ssl: " + String.valueOf(ncInstance.getSSLConfig()));
            }
        }
    }

    private static boolean isDefined(String pattern, YAMLUtils yamlUtils, JsonPathExpressionEngine engine, JsonNode node) throws PolicyException {
        String prefixPattern = "$.hazelcast.network.";
        try {
            JsonNode result = engine.getJsonNodeMatchPattern(node, prefixPattern + pattern);
            return result != null;
        }
        catch (JsonPathNotFoundException notFound) {
            return false;
        }
        catch (Throwable t) {
            throw new PolicyException(t.getMessage(), t);
        }
    }

    private static void debug(String msg) {
        if (log != null) {
            log.debug(msg);
        }
        if (logStartup != null) {
            logStartup.debug(msg);
        }
    }

    private static void info(String msg) {
        if (log != null) {
            log.info(msg);
        }
        if (logStartup != null) {
            logStartup.info(msg);
        }
    }

    private static void error(String msg, Throwable e) {
        if (log != null) {
            log.error(msg, e);
        }
        if (logStartup != null) {
            logStartup.error(msg, e);
        }
    }

    public static synchronized void close() {
        if (staticMapInstance != null && !staticMapInstance.isEmpty()) {
            for (PolicyGroupByActiveThreadsType type : staticMapInstance.keySet()) {
                HazelcastInstance hazelcast = staticMapInstance.get(type);
                try {
                    hazelcast.shutdown();
                }
                catch (Throwable t) {
                    log.debug("Hazelcast '" + String.valueOf(type) + "' shutdown failed: " + t.getMessage(), t);
                }
            }
        }
    }

    static {
        yamlUtils = null;
        engine = null;
    }
}

