/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core.controllo_traffico.policy.driver;

import java.util.HashMap;
import org.openspcoop2.core.controllo_traffico.beans.DatiCollezionati;
import org.openspcoop2.core.controllo_traffico.beans.IDUnivocoGroupByPolicy;
import org.openspcoop2.core.controllo_traffico.beans.MisurazioniTransazione;
import org.openspcoop2.core.controllo_traffico.driver.IPolicyGroupByActiveThreads;
import org.openspcoop2.core.controllo_traffico.driver.PolicyException;
import org.openspcoop2.core.controllo_traffico.driver.PolicyNotFoundException;
import org.openspcoop2.utils.Map;
import org.openspcoop2.utils.transport.TransportUtils;
import org.openspcoop2.utils.transport.http.HttpResponse;
import org.openspcoop2.utils.transport.http.HttpUtilities;
import org.slf4j.Logger;

public class PolicyGroupByActiveThreadsWS
implements IPolicyGroupByActiveThreads {
    private String uriService;
    private String activeId;
    private Logger log;

    public PolicyGroupByActiveThreadsWS(String serviceUrl, String activeId, Logger log) {
        this.uriService = serviceUrl;
        this.activeId = activeId;
        this.log = log;
    }

    public DatiCollezionati registerStartRequest(Logger log, String idTransazione, IDUnivocoGroupByPolicy datiGroupBy, Map<Object> ctx) throws PolicyException {
        try {
            HashMap p = new HashMap();
            TransportUtils.setHeader(p, (String)"activeId", (String)this.activeId);
            TransportUtils.setHeader(p, (String)"groupById", (String)IDUnivocoGroupByPolicy.serialize((IDUnivocoGroupByPolicy)datiGroupBy));
            String url = TransportUtils.buildUrlWithParameters(p, (String)(this.uriService + "registerStartRequest"), (Logger)this.log);
            this.log.debug("[PolicyGroupByActiveThreadsWS.registerStartRequest] invoke (" + url + ") ...");
            HttpResponse response = HttpUtilities.getHTTPResponse((String)url);
            this.log.debug("[PolicyGroupByActiveThreadsWS.registerStartRequest] invoked with code [" + response.getResultHTTPOperation() + "]");
            if (response.getResultHTTPOperation() != 200) {
                throw new Exception("[httpCode:" + response.getResultHTTPOperation() + "] " + new String(response.getContent()));
            }
            return DatiCollezionati.deserialize((String)new String(response.getContent()));
        }
        catch (Exception e) {
            this.log.error("registerStartRequest error: " + e.getMessage(), (Throwable)e);
            throw new PolicyException(e.getMessage(), (Throwable)e);
        }
    }

    public DatiCollezionati updateDatiStartRequestApplicabile(Logger log, String idTransazione, IDUnivocoGroupByPolicy datiGroupBy, Map<Object> ctx) throws PolicyException, PolicyNotFoundException {
        try {
            HashMap p = new HashMap();
            TransportUtils.setHeader(p, (String)"activeId", (String)this.activeId);
            TransportUtils.setHeader(p, (String)"groupById", (String)IDUnivocoGroupByPolicy.serialize((IDUnivocoGroupByPolicy)datiGroupBy));
            String url = TransportUtils.buildUrlWithParameters(p, (String)(this.uriService + "updateStartRequest"), (Logger)this.log);
            this.log.debug("[PolicyGroupByActiveThreadsWS.updateDatiStartRequestApplicabile] invoke (" + url + ") ...");
            HttpResponse response = HttpUtilities.getHTTPResponse((String)url);
            this.log.debug("[PolicyGroupByActiveThreadsWS.updateDatiStartRequestApplicabile] invoked with code [" + response.getResultHTTPOperation() + "]");
            if (response.getResultHTTPOperation() != 200) {
                throw new Exception("[httpCode:" + response.getResultHTTPOperation() + "] " + new String(response.getContent()));
            }
            return DatiCollezionati.deserialize((String)new String(response.getContent()));
        }
        catch (Exception e) {
            this.log.error("updateDatiStartRequestApplicabile error: " + e.getMessage(), (Throwable)e);
            throw new PolicyException(e.getMessage(), (Throwable)e);
        }
    }

    public void registerStopRequest(Logger log, String idTransazione, IDUnivocoGroupByPolicy datiGroupBy, Map<Object> ctx, MisurazioniTransazione dati, boolean isApplicabile, boolean isViolata) throws PolicyException, PolicyNotFoundException {
        try {
            HashMap p = new HashMap();
            TransportUtils.setHeader(p, (String)"activeId", (String)this.activeId);
            TransportUtils.setHeader(p, (String)"groupById", (String)IDUnivocoGroupByPolicy.serialize((IDUnivocoGroupByPolicy)datiGroupBy));
            TransportUtils.setHeader(p, (String)"misurazioniTransazione", (String)MisurazioniTransazione.serialize((MisurazioniTransazione)dati));
            TransportUtils.setHeader(p, (String)"applicabile", (String)("" + isApplicabile));
            TransportUtils.setHeader(p, (String)"violata", (String)("" + isViolata));
            String url = TransportUtils.buildUrlWithParameters(p, (String)(this.uriService + "registerStopRequest"), (Logger)this.log);
            this.log.debug("[PolicyGroupByActiveThreadsWS.registerStopRequest] invoke (" + url + ") ...");
            HttpResponse response = HttpUtilities.getHTTPResponse((String)url);
            this.log.debug("[PolicyGroupByActiveThreadsWS.registerStopRequest] invoked with code [" + response.getResultHTTPOperation() + "]");
            if (response.getResultHTTPOperation() != 200) {
                throw new Exception("[httpCode:" + response.getResultHTTPOperation() + "] " + new String(response.getContent()));
            }
        }
        catch (Exception e) {
            this.log.error("registerStopRequest error: " + e.getMessage(), (Throwable)e);
            throw new PolicyException(e.getMessage(), (Throwable)e);
        }
    }
}

