/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core.controllo_traffico.policy;

import org.openspcoop2.core.constants.Costanti;
import org.openspcoop2.core.controllo_traffico.beans.DatiTransazione;
import org.openspcoop2.core.controllo_traffico.constants.TipoFiltroApplicativo;
import org.openspcoop2.message.MessageUtils;
import org.openspcoop2.message.OpenSPCoop2Message;
import org.openspcoop2.message.constants.MessageType;
import org.openspcoop2.message.soap.SoapUtils;
import org.openspcoop2.message.xml.XPathExpressionEngine;
import org.openspcoop2.pdd.config.OpenSPCoop2Properties;
import org.openspcoop2.pdd.config.dynamic.PddPluginLoader;
import org.openspcoop2.pdd.core.PdDContext;
import org.openspcoop2.pdd.core.connettori.InfoConnettoreIngresso;
import org.openspcoop2.pdd.core.controllo_traffico.plugins.Dati;
import org.openspcoop2.pdd.core.controllo_traffico.plugins.IRateLimiting;
import org.openspcoop2.pdd.core.handlers.InRequestProtocolContext;
import org.openspcoop2.protocol.sdk.state.URLProtocolContext;
import org.openspcoop2.utils.regexp.RegExpNotFoundException;
import org.openspcoop2.utils.regexp.RegularExpressionEngine;
import org.openspcoop2.utils.transport.TransportRequestContext;
import org.openspcoop2.utils.xml.AbstractXPathExpressionEngine;
import org.openspcoop2.utils.xml2json.JsonXmlPathExpressionEngine;
import org.slf4j.Logger;
import org.w3c.dom.Element;

public class PolicyFiltroApplicativoUtilities {
    public static String getValore(Logger log, String tipo, String nome, InRequestProtocolContext context, DatiTransazione datiTransazione, boolean forFilter) throws Exception {
        if (context == null) {
            throw new Exception("InRequestProtocolContext is null");
        }
        OpenSPCoop2Message message = context.getMessaggio();
        URLProtocolContext urlProtocolContext = context.getConnettore().getUrlProtocolContext();
        String soapAction = context.getConnettore().getSoapAction();
        PdDContext pddContext = null;
        if (context != null && context.getPddContext() != null) {
            pddContext = context.getPddContext();
        }
        InfoConnettoreIngresso connettore = context.getConnettore();
        return PolicyFiltroApplicativoUtilities.getValore(log, tipo, nome, datiTransazione, forFilter, message, urlProtocolContext, soapAction, pddContext, connettore);
    }

    public static String getValore(Logger log, String tipo, String nome, DatiTransazione datiTransazione, boolean forFilter, OpenSPCoop2Message message, URLProtocolContext urlProtocolContext, String soapActionParam, PdDContext pddContext, InfoConnettoreIngresso connettore) throws Exception {
        TipoFiltroApplicativo tipoFiltro = TipoFiltroApplicativo.toEnumConstant((String)tipo);
        switch (tipoFiltro) {
            case CONTENT_BASED: {
                String idTransazione = null;
                if (pddContext != null) {
                    idTransazione = (String)pddContext.getObject(Costanti.ID_TRANSAZIONE);
                }
                XPathExpressionEngine xPathEngine = null;
                boolean bufferMessage_readOnly = OpenSPCoop2Properties.getInstance().isReadByPathBufferEnabled();
                boolean checkSoapBodyEmpty = false;
                Element element = null;
                String elementJson = null;
                if (message != null) {
                    element = MessageUtils.getContentElement((OpenSPCoop2Message)message, (boolean)checkSoapBodyEmpty, (boolean)bufferMessage_readOnly, (String)idTransazione);
                    elementJson = MessageUtils.getContentString((OpenSPCoop2Message)message, (boolean)bufferMessage_readOnly, (String)idTransazione);
                }
                if (element != null) {
                    xPathEngine = new XPathExpressionEngine(message.getFactory());
                    return AbstractXPathExpressionEngine.extractAndConvertResultAsString((Element)element, (AbstractXPathExpressionEngine)xPathEngine, (String)nome, (Logger)log);
                }
                if (elementJson != null) {
                    return JsonXmlPathExpressionEngine.extractAndConvertResultAsString(elementJson, (String)nome, (Logger)log);
                }
                return null;
            }
            case URLBASED: {
                String urlInvocazionePD = urlProtocolContext.getUrlInvocazione_formBased();
                try {
                    return RegularExpressionEngine.getStringMatchPattern((String)urlInvocazionePD, (String)nome);
                }
                catch (RegExpNotFoundException notFound) {
                    return null;
                }
            }
            case FORM_BASED: {
                return urlProtocolContext.getParameterFirstValue(nome);
            }
            case HEADER_BASED: {
                return urlProtocolContext.getHeaderFirstValue(nome);
            }
            case SOAPACTION_BASED: {
                String soapAction = soapActionParam;
                if (soapAction == null) {
                    try {
                        soapAction = SoapUtils.getSoapAction((TransportRequestContext)urlProtocolContext, (MessageType)MessageType.SOAP_11, (String)urlProtocolContext.getContentType());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (soapAction == null) {
                        try {
                            soapAction = SoapUtils.getSoapAction((TransportRequestContext)urlProtocolContext, (MessageType)MessageType.SOAP_12, (String)urlProtocolContext.getContentType());
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
                if (soapAction != null) {
                    if ((soapAction = soapAction.trim()).startsWith("\"") && soapAction.length() > 1) {
                        soapAction = soapAction.substring(1);
                    }
                    if (soapAction.endsWith("\"") && soapAction.length() > 1) {
                        soapAction = soapAction.substring(0, soapAction.length() - 1);
                    }
                }
                return soapAction;
            }
            case INDIRIZZO_IP: {
                if (pddContext != null && pddContext.containsKey(Costanti.CLIENT_IP_REMOTE_ADDRESS)) {
                    return (String)pddContext.getObject(Costanti.CLIENT_IP_REMOTE_ADDRESS);
                }
                return null;
            }
            case INDIRIZZO_IP_FORWARDED: {
                if (pddContext != null && pddContext.containsKey(Costanti.CLIENT_IP_TRANSPORT_ADDRESS)) {
                    return (String)pddContext.getObject(Costanti.CLIENT_IP_TRANSPORT_ADDRESS);
                }
                return null;
            }
            case PLUGIN_BASED: {
                IRateLimiting rateLimitingPlugin = null;
                rateLimitingPlugin = PddPluginLoader.getInstance().newRateLimiting(nome);
                String className = null;
                try {
                    className = rateLimitingPlugin.getClass().getName();
                    Dati datiRichiesta = new Dati();
                    datiRichiesta.setConnettore(connettore);
                    datiRichiesta.setDatiTransazione(datiTransazione);
                    datiRichiesta.setMessaggio(message);
                    datiRichiesta.setPddContext(pddContext);
                    if (forFilter) {
                        return rateLimitingPlugin.estraiValoreFiltro(log, datiRichiesta);
                    }
                    return rateLimitingPlugin.estraiValoreCollezionamentoDati(log, datiRichiesta);
                }
                catch (Exception e) {
                    throw new Exception("Instance plugin [" + nome + "] [class:" + className + "] error: " + e.getMessage(), e);
                }
            }
        }
        throw new Exception("TipoFiltro [" + tipo + "] non gestito");
    }
}

