/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core.controllo_traffico;

import java.util.Date;
import org.openspcoop2.core.constants.Costanti;
import org.openspcoop2.core.eventi.constants.CodiceEventoControlloTraffico;
import org.openspcoop2.core.eventi.constants.TipoEvento;
import org.openspcoop2.pdd.core.controllo_traffico.CategoriaEventoControlloTraffico;
import org.openspcoop2.pdd.core.controllo_traffico.GeneratoreMessaggiErrore;
import org.openspcoop2.pdd.core.controllo_traffico.NotificatoreEventi;
import org.openspcoop2.pdd.core.controllo_traffico.SogliaReadTimeout;
import org.openspcoop2.pdd.core.controllo_traffico.TimeoutNotifierType;
import org.openspcoop2.pdd.core.transazioni.Transaction;
import org.openspcoop2.pdd.core.transazioni.TransactionContext;
import org.openspcoop2.pdd.core.transazioni.TransactionNotExistsException;
import org.openspcoop2.protocol.sdk.Context;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.protocol.sdk.constants.EsitoTransazioneName;
import org.openspcoop2.protocol.utils.EsitiProperties;
import org.openspcoop2.utils.ITimeoutNotifier;
import org.openspcoop2.utils.date.DateManager;
import org.slf4j.Logger;

public class TimeoutNotifier
implements ITimeoutNotifier {
    private Context context;
    private SogliaReadTimeout soglia;
    private TimeoutNotifierType type;
    private Logger log;
    private IProtocolFactory<?> protocolFactory;
    private boolean saveInContext;

    public TimeoutNotifier(Context context, IProtocolFactory<?> protocolFactory, SogliaReadTimeout soglia, TimeoutNotifierType type, Logger log, boolean saveInContext) {
        this.context = context;
        this.protocolFactory = protocolFactory;
        this.soglia = soglia;
        this.type = type;
        this.log = log;
        this.saveInContext = saveInContext;
    }

    public void notify(long count) {
        if (this.context != null) {
            if (this.saveInContext) {
                boolean alreadyExists = false;
                if (this.type != null) {
                    switch (this.type) {
                        case CONNECTION: {
                            alreadyExists = !GeneratoreMessaggiErrore.addPddContextInfoControlloTrafficoConnectionTimeout(this.context);
                            break;
                        }
                        case REQUEST: {
                            alreadyExists = !GeneratoreMessaggiErrore.addPddContextInfoControlloTrafficoReadRequestTimeout(this.context, true);
                            break;
                        }
                        case WAIT_RESPONSE: {
                            alreadyExists = !GeneratoreMessaggiErrore.addPddContextInfoControlloTrafficoReadTimeout(this.context, true);
                            break;
                        }
                        case RECEIVE_RESPONSE: {
                            alreadyExists = !GeneratoreMessaggiErrore.addPddContextInfoControlloTrafficoReadResponseTimeout(this.context, true);
                        }
                    }
                } else {
                    boolean bl = alreadyExists = !GeneratoreMessaggiErrore.addPddContextInfoControlloTrafficoReadTimeout(this.context, true);
                }
                if (alreadyExists) {
                    return;
                }
            }
            this.registraEvento();
        }
        Date dataEventoPolicyViolated = DateManager.getDate();
        CategoriaEventoControlloTraffico tipoEvento = TimeoutNotifierType.toCategoriaEventoControlloTraffico(this.type);
        try {
            EsitiProperties esitiProperties = EsitiProperties.getInstance((Logger)this.log, this.protocolFactory);
            EsitoTransazioneName esito = TimeoutNotifierType.toEsitoTransazioneName(this.type);
            Object descriptionPolicyViolated = esitiProperties.getEsitoDescription(esitiProperties.convertoToCode(esito));
            descriptionPolicyViolated = (String)descriptionPolicyViolated + " (soglia:" + this.soglia.getSogliaMs() + " ms)";
            NotificatoreEventi.getInstance().log(tipoEvento, this.soglia.getIdConfigurazione(), this.soglia.getConfigurazione(), dataEventoPolicyViolated, (String)descriptionPolicyViolated);
        }
        catch (Exception t) {
            this.log.error("Emissione evento non riuscito: " + t.getMessage(), (Throwable)t);
        }
    }

    private void registraEvento() {
        String idTransazione = (String)this.context.getObject(Costanti.ID_TRANSAZIONE);
        if (idTransazione != null) {
            Transaction tr = null;
            try {
                tr = TransactionContext.getTransaction(idTransazione);
            }
            catch (TransactionNotExistsException transactionNotExistsException) {
                // empty catch block
            }
            if (tr != null) {
                TipoEvento tipoEvento = TimeoutNotifierType.toTipoEvento(this.type);
                try {
                    tr.addEventoGestione(tipoEvento.getValue() + "_" + CodiceEventoControlloTraffico.VIOLAZIONE.getValue() + "_" + this.soglia.getIdConfigurazione());
                }
                catch (Exception t) {
                    this.log.error("Associazione evento alla transazione non riuscita: " + t.getMessage(), (Throwable)t);
                }
            }
        }
    }
}

