/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core.controllo_traffico;

import java.util.Date;
import org.openspcoop2.core.constants.Costanti;
import org.openspcoop2.core.eventi.constants.CodiceEventoControlloTraffico;
import org.openspcoop2.core.eventi.constants.TipoEvento;
import org.openspcoop2.pdd.core.controllo_traffico.CategoriaEventoControlloTraffico;
import org.openspcoop2.pdd.core.controllo_traffico.GeneratoreMessaggiErrore;
import org.openspcoop2.pdd.core.controllo_traffico.NotificatoreEventi;
import org.openspcoop2.pdd.core.controllo_traffico.SogliaDimensioneMessaggio;
import org.openspcoop2.pdd.core.transazioni.Transaction;
import org.openspcoop2.pdd.core.transazioni.TransactionContext;
import org.openspcoop2.pdd.core.transazioni.TransactionNotExistsException;
import org.openspcoop2.protocol.sdk.Context;
import org.openspcoop2.utils.ILimitExceededNotifier;
import org.openspcoop2.utils.date.DateManager;
import org.slf4j.Logger;

public class LimitExceededNotifier
implements ILimitExceededNotifier {
    private Context context;
    private SogliaDimensioneMessaggio soglia;
    private Logger log;

    public LimitExceededNotifier(Context context, SogliaDimensioneMessaggio soglia, Logger log) {
        this.context = context;
        this.soglia = soglia;
        this.log = log;
    }

    public void notify(long count, boolean contentLengthExceeded) {
        if (this.context != null) {
            GeneratoreMessaggiErrore.addContextInfoControlloTrafficoPolicyViolated(this.context, false);
            this.registraEvento();
        }
        Date dataEventoPolicyViolated = DateManager.getDate();
        CategoriaEventoControlloTraffico tipoEvento = null;
        tipoEvento = this.soglia.isPolicyGlobale() ? CategoriaEventoControlloTraffico.POLICY_GLOBALE : CategoriaEventoControlloTraffico.POLICY_API;
        Object descriptionPolicyViolated = contentLengthExceeded ? "Rilevato messaggio con dimensione indicata nel Content-Length superiore al limite consentito" : "Rilevato messaggio con dimensione superiore al limite consentito";
        descriptionPolicyViolated = (String)descriptionPolicyViolated + " (soglia:" + this.soglia.getSogliaKb() + " kb)";
        try {
            NotificatoreEventi.getInstance().log(tipoEvento, this.soglia.getIdPolicyConGruppo(), this.soglia.getConfigurazione(), dataEventoPolicyViolated, (String)descriptionPolicyViolated);
        }
        catch (Exception t) {
            this.log.error("Emissione evento non riuscito: " + t.getMessage(), (Throwable)t);
        }
    }

    private void registraEvento() {
        String idTransazione = (String)this.context.getObject(Costanti.ID_TRANSAZIONE);
        if (idTransazione != null) {
            Transaction tr = null;
            try {
                tr = TransactionContext.getTransaction(idTransazione);
            }
            catch (TransactionNotExistsException transactionNotExistsException) {
                // empty catch block
            }
            if (tr != null) {
                TipoEvento tipoEvento = null;
                tipoEvento = this.soglia.isPolicyGlobale() ? TipoEvento.RATE_LIMITING_POLICY_GLOBALE : TipoEvento.RATE_LIMITING_POLICY_API;
                try {
                    tr.addEventoGestione(tipoEvento.getValue() + "_" + CodiceEventoControlloTraffico.VIOLAZIONE.getValue() + "_" + this.soglia.getNomePolicy());
                }
                catch (Exception t) {
                    this.log.error("Associazione evento alla transazione non riuscita: " + t.getMessage(), (Throwable)t);
                }
            }
        }
    }
}

