/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core.controllo_traffico;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.openspcoop2.core.commons.CoreException;
import org.openspcoop2.core.config.PortaApplicativa;
import org.openspcoop2.core.config.PortaDelegata;
import org.openspcoop2.core.config.Proprieta;
import org.openspcoop2.core.config.driver.DriverConfigurazioneException;
import org.openspcoop2.core.config.driver.DriverConfigurazioneNotFound;
import org.openspcoop2.core.constants.TipoPdD;
import org.openspcoop2.core.controllo_traffico.AttivazionePolicy;
import org.openspcoop2.core.controllo_traffico.AttivazionePolicyFiltro;
import org.openspcoop2.core.controllo_traffico.ConfigurazionePolicy;
import org.openspcoop2.core.controllo_traffico.ElencoIdPolicyAttive;
import org.openspcoop2.core.controllo_traffico.IdActivePolicy;
import org.openspcoop2.core.controllo_traffico.beans.DatiTransazione;
import org.openspcoop2.core.controllo_traffico.beans.UniqueIdentifierUtilities;
import org.openspcoop2.core.controllo_traffico.constants.RuoloPolicy;
import org.openspcoop2.core.controllo_traffico.constants.TipoRisorsaPolicyAttiva;
import org.openspcoop2.core.controllo_traffico.utils.PolicyUtilities;
import org.openspcoop2.core.id.IDPortaApplicativa;
import org.openspcoop2.core.id.IDPortaDelegata;
import org.openspcoop2.message.OpenSPCoop2Message;
import org.openspcoop2.pdd.config.ConfigurazionePdDManager;
import org.openspcoop2.pdd.config.CostantiProprieta;
import org.openspcoop2.pdd.config.OpenSPCoop2Properties;
import org.openspcoop2.pdd.core.PdDContext;
import org.openspcoop2.pdd.core.controllo_traffico.ConfigurazioneGatewayControlloTraffico;
import org.openspcoop2.pdd.core.controllo_traffico.SogliaDimensioneMessaggio;
import org.openspcoop2.pdd.core.controllo_traffico.SoglieDimensioneMessaggi;
import org.openspcoop2.pdd.core.controllo_traffico.policy.InterceptorPolicyUtilities;
import org.openspcoop2.pdd.core.controllo_traffico.policy.PolicyFiltroApplicativoUtilities;
import org.openspcoop2.pdd.core.controllo_traffico.policy.PolicyVerifier;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.protocol.sdk.state.RequestInfo;
import org.openspcoop2.protocol.sdk.state.URLProtocolContext;
import org.slf4j.Logger;

public class DimensioneMessaggiConfigurationUtils {
    private DimensioneMessaggiConfigurationUtils() {
    }

    private static void logDebug(Logger log, String msg) {
        if (log != null) {
            log.debug(msg);
        }
    }

    public static SoglieDimensioneMessaggi readSoglieDimensioneMessaggi(TipoPdD tipoPdD, String nomePorta, DatiTransazione datiTransazione, Logger log, URLProtocolContext urlProtocolContext, RequestInfo requestInfo, PdDContext pddContext, IProtocolFactory<?> protocolFactory) throws CoreException {
        SoglieDimensioneMessaggi soglie;
        block57: {
            boolean mapFromRequestInfo;
            Map<TipoRisorsaPolicyAttiva, ElencoIdPolicyAttive> mapPolicyAttive;
            ConfigurazionePdDManager configPdDManager;
            ConfigurazioneGatewayControlloTraffico configurazioneControlloTraffico;
            block56: {
                OpenSPCoop2Properties op2Properties = OpenSPCoop2Properties.getInstance();
                configurazioneControlloTraffico = op2Properties.getConfigurazioneControlloTraffico();
                configPdDManager = ConfigurazionePdDManager.getInstance();
                soglie = null;
                mapPolicyAttive = null;
                mapFromRequestInfo = false;
                try {
                    ElencoIdPolicyAttive cloned;
                    if (requestInfo != null && requestInfo.getRequestRateLimitingConfig() != null) {
                        if (requestInfo.getRequestRateLimitingConfig().getNomePorta() == null && nomePorta != null) {
                            requestInfo.getRequestRateLimitingConfig().setDatiPorta(tipoPdD, nomePorta, datiTransazione != null ? datiTransazione.getIdServizio() : null, datiTransazione != null ? datiTransazione.getSoggettoFruitore() : null);
                        }
                        if (requestInfo.getRequestRateLimitingConfig().getMapPolicyAttive_dimensioneMessaggi() != null) {
                            mapPolicyAttive = requestInfo.getRequestRateLimitingConfig().getMapPolicyAttive_dimensioneMessaggi();
                            mapFromRequestInfo = true;
                        }
                    }
                    if (mapFromRequestInfo) break block56;
                    mapPolicyAttive = new HashMap();
                    if (tipoPdD != null && nomePorta != null) {
                        Map<TipoRisorsaPolicyAttiva, ElencoIdPolicyAttive> mapPolicyAttiveAPI = null;
                        try {
                            mapPolicyAttiveAPI = configPdDManager.getElencoIdPolicyAttiveAPIDimensioneMessaggio(configurazioneControlloTraffico.isPolicyReadedWithDynamicCache(), tipoPdD, nomePorta);
                        }
                        catch (DriverConfigurazioneNotFound driverConfigurazioneNotFound) {
                            // empty catch block
                        }
                        if (mapPolicyAttiveAPI != null && !mapPolicyAttiveAPI.isEmpty()) {
                            for (TipoRisorsaPolicyAttiva tipoRisorsaPolicyAttiva : mapPolicyAttiveAPI.keySet()) {
                                ElencoIdPolicyAttive elencoPolicyAttiveAPI = mapPolicyAttiveAPI.get(tipoRisorsaPolicyAttiva);
                                if (elencoPolicyAttiveAPI == null) continue;
                                cloned = (ElencoIdPolicyAttive)elencoPolicyAttiveAPI.clone();
                                mapPolicyAttive.put(tipoRisorsaPolicyAttiva, cloned);
                            }
                        }
                    }
                    Map<TipoRisorsaPolicyAttiva, ElencoIdPolicyAttive> mapPolicyAttiveGlobali = null;
                    try {
                        mapPolicyAttiveGlobali = configPdDManager.getElencoIdPolicyAttiveGlobaliDimensioneMessaggio(configurazioneControlloTraffico.isPolicyReadedWithDynamicCache());
                    }
                    catch (DriverConfigurazioneNotFound it) {
                        // empty catch block
                    }
                    if (mapPolicyAttiveGlobali != null && !mapPolicyAttiveGlobali.isEmpty()) {
                        for (TipoRisorsaPolicyAttiva tipoRisorsaPolicyAttiva : mapPolicyAttiveGlobali.keySet()) {
                            ElencoIdPolicyAttive elencoPolicyAttiveGlobali = mapPolicyAttiveGlobali.get(tipoRisorsaPolicyAttiva);
                            if (mapPolicyAttive.containsKey(tipoRisorsaPolicyAttiva)) {
                                ElencoIdPolicyAttive elencoPolicyAttiveCloned = (ElencoIdPolicyAttive)mapPolicyAttive.get(tipoRisorsaPolicyAttiva);
                                for (IdActivePolicy idActivePolicyGlobale : elencoPolicyAttiveGlobali.getIdActivePolicyList()) {
                                    elencoPolicyAttiveCloned.addIdActivePolicy(idActivePolicyGlobale);
                                }
                                continue;
                            }
                            cloned = (ElencoIdPolicyAttive)elencoPolicyAttiveGlobali.clone();
                            mapPolicyAttive.put(tipoRisorsaPolicyAttiva, cloned);
                        }
                    }
                    if (requestInfo != null && requestInfo.getRequestRateLimitingConfig() != null) {
                        requestInfo.getRequestRateLimitingConfig().setMapPolicyAttive_dimensioneMessaggi(mapPolicyAttive);
                    }
                }
                catch (Exception e) {
                    throw new CoreException("Configurazione non disponibile: " + e.getMessage(), (Throwable)e);
                }
            }
            try {
                if (mapPolicyAttive == null || mapPolicyAttive.isEmpty()) break block57;
                int policyTotali = 0;
                int policyDisabilitate = 0;
                int policyFiltrate = 0;
                int policyRispettate = 0;
                int policyInErrore = 0;
                for (TipoRisorsaPolicyAttiva tipoRisorsaPolicyAttiva : mapPolicyAttive.keySet()) {
                    if (!TipoRisorsaPolicyAttiva.DIMENSIONE_MASSIMA_MESSAGGIO.equals((Object)tipoRisorsaPolicyAttiva)) continue;
                    ElencoIdPolicyAttive elencoPolicyAttivePerRisorsa = (ElencoIdPolicyAttive)mapPolicyAttive.get(tipoRisorsaPolicyAttiva);
                    boolean policyRispettataCheRichiedeBreak = false;
                    boolean policyViolataBreak = false;
                    for (IdActivePolicy idActive : elencoPolicyAttivePerRisorsa.getIdActivePolicyList()) {
                        ++policyTotali;
                        try {
                            if (idActive.isEnabled()) {
                                boolean matchFiltro;
                                AttivazionePolicy attivazionePolicy = null;
                                try {
                                    String id = UniqueIdentifierUtilities.getUniqueId((IdActivePolicy)idActive);
                                    if (mapFromRequestInfo) {
                                        attivazionePolicy = requestInfo.getRequestRateLimitingConfig().getAttivazionePolicy_dimensioneMessaggi(id);
                                    }
                                    if (attivazionePolicy == null) {
                                        attivazionePolicy = configPdDManager.getAttivazionePolicy(configurazioneControlloTraffico.isPolicyReadedWithDynamicCache(), id);
                                        if (requestInfo != null && requestInfo.getRequestRateLimitingConfig() != null) {
                                            requestInfo.getRequestRateLimitingConfig().addAttivazionePolicy_dimensioneMessaggi(id, attivazionePolicy);
                                        }
                                    }
                                }
                                catch (DriverConfigurazioneNotFound notFound) {
                                    throw new CoreException("Istanza di Policy con id [" + idActive.getNome() + "] non esistente: " + notFound.getMessage(), (Throwable)notFound);
                                }
                                if (attivazionePolicy == null) {
                                    throw new CoreException("Istanza di Policy con id [" + idActive.getNome() + "] non esistente?");
                                }
                                String alias = PolicyUtilities.getNomeActivePolicy((String)attivazionePolicy.getAlias(), (String)attivazionePolicy.getIdActivePolicy());
                                boolean bl = matchFiltro = !policyRispettataCheRichiedeBreak && !policyViolataBreak && InterceptorPolicyUtilities.filter(attivazionePolicy.getFiltro(), datiTransazione, null, requestInfo);
                                if (matchFiltro) {
                                    if (attivazionePolicy.getFiltro().isEnabled() && attivazionePolicy.getFiltro().isInformazioneApplicativaEnabled()) {
                                        OpenSPCoop2Message message = null;
                                        String soapActionParam = null;
                                        String valorePresente = PolicyFiltroApplicativoUtilities.getValore(log, attivazionePolicy.getFiltro().getInformazioneApplicativaTipo(), attivazionePolicy.getFiltro().getInformazioneApplicativaNome(), datiTransazione, true, message, urlProtocolContext, soapActionParam, pddContext, null);
                                        if (valorePresente == null || !valorePresente.equals(attivazionePolicy.getFiltro().getInformazioneApplicativaValore())) {
                                            ++policyFiltrate;
                                            if (valorePresente == null) {
                                                valorePresente = "n.d.";
                                            }
                                            DimensioneMessaggiConfigurationUtils.logDebug(log, "Filtro Applicativo atteso [" + attivazionePolicy.getFiltro().getInformazioneApplicativaValore() + "] differente da quello estratto dalla transazione [" + valorePresente + "]");
                                            matchFiltro = false;
                                        }
                                    }
                                    if (!matchFiltro) continue;
                                    if (soglie == null) {
                                        soglie = new SoglieDimensioneMessaggi();
                                    }
                                    long sogliaRichiesta = -1L;
                                    long sogliaRisposta = -1L;
                                    if (attivazionePolicy.isRidefinisci()) {
                                        if (attivazionePolicy.getValore2() != null) {
                                            sogliaRichiesta = attivazionePolicy.getValore2();
                                        }
                                        if (attivazionePolicy.getValore() != null) {
                                            sogliaRisposta = attivazionePolicy.getValore();
                                        }
                                    } else {
                                        ConfigurazionePolicy configurazionePolicy = null;
                                        try {
                                            String id = idActive.getIdPolicy();
                                            if (mapFromRequestInfo) {
                                                configurazionePolicy = requestInfo.getRequestRateLimitingConfig().getConfigurazionePolicy_dimensioneMessaggi(id);
                                            }
                                            if (configurazionePolicy == null) {
                                                configurazionePolicy = configPdDManager.getConfigurazionePolicy(configurazioneControlloTraffico.isPolicyReadedWithDynamicCache(), id);
                                                if (requestInfo != null && requestInfo.getRequestRateLimitingConfig() != null) {
                                                    requestInfo.getRequestRateLimitingConfig().addConfigurazionePolicy_dimensioneMessaggi(id, configurazionePolicy);
                                                }
                                            }
                                        }
                                        catch (DriverConfigurazioneNotFound notFound) {
                                            throw new CoreException("Policy con id [" + idActive.getIdPolicy() + "] non esistente: " + notFound.getMessage(), (Throwable)notFound);
                                        }
                                        if (configurazionePolicy == null) {
                                            throw new CoreException("Policy con id [" + idActive.getIdPolicy() + "] non esistente?");
                                        }
                                        if (configurazionePolicy.getValore2() != null) {
                                            sogliaRichiesta = configurazionePolicy.getValore2();
                                        }
                                        if (configurazionePolicy.getValore() != null) {
                                            sogliaRisposta = configurazionePolicy.getValore();
                                        }
                                    }
                                    if (sogliaRichiesta > 0L) {
                                        boolean updateRichiesta = false;
                                        if (soglie.getRichiesta() == null || sogliaRichiesta < soglie.getRichiesta().getSogliaKb()) {
                                            updateRichiesta = true;
                                        }
                                        if (updateRichiesta) {
                                            soglie.setRichiesta(DimensioneMessaggiConfigurationUtils.build(sogliaRichiesta, attivazionePolicy, protocolFactory, configPdDManager, requestInfo, tipoPdD, nomePorta));
                                        }
                                    }
                                    if (sogliaRisposta > 0L) {
                                        boolean updateRisposta = false;
                                        if (soglie.getRisposta() == null || sogliaRisposta < soglie.getRisposta().getSogliaKb()) {
                                            updateRisposta = true;
                                        }
                                        if (updateRisposta) {
                                            soglie.setRisposta(DimensioneMessaggiConfigurationUtils.build(sogliaRisposta, attivazionePolicy, protocolFactory, configPdDManager, requestInfo, tipoPdD, nomePorta));
                                        }
                                    }
                                    ++policyRispettate;
                                    if (attivazionePolicy.isContinuaValutazione()) continue;
                                    policyRispettataCheRichiedeBreak = true;
                                    continue;
                                }
                                ++policyFiltrate;
                                if (policyRispettataCheRichiedeBreak) {
                                    DimensioneMessaggiConfigurationUtils.logDebug(log, "[policy: " + alias + "] rilevata precedente policy soddisfatta");
                                    continue;
                                }
                                if (policyViolataBreak) {
                                    DimensioneMessaggiConfigurationUtils.logDebug(log, "[policy: " + alias + "] rilevata precedente policy violata");
                                    continue;
                                }
                                DimensioneMessaggiConfigurationUtils.logDebug(log, "[policy: " + alias + "] i dati della transazione non rispettano i criteri di filtro impostati: " + PolicyUtilities.toStringFilter((AttivazionePolicyFiltro)attivazionePolicy.getFiltro()));
                                continue;
                            }
                            ++policyDisabilitate;
                            DimensioneMessaggiConfigurationUtils.logDebug(log, "[policy: " + idActive.getNome() + "] policy disabilitata");
                        }
                        catch (Throwable e) {
                            ++policyInErrore;
                            log.error("Errore durante il controllo della policy con id[" + idActive.getNome() + "]: " + e.getMessage(), e);
                        }
                    }
                }
                DimensioneMessaggiConfigurationUtils.logDebug(log, "Valutazione policy totali[" + policyTotali + "] disabilitate[" + policyDisabilitate + "] filtrate[" + policyFiltrate + "] utilizzate[" + policyRispettate + "] inErrore[" + policyInErrore + "]");
            }
            catch (Exception e) {
                throw new CoreException("Errore durante l'identificazione dei limiti sulla dimensione dei messaggi: " + e.getMessage(), (Throwable)e);
            }
        }
        if (soglie != null && (soglie.getRichiesta() == null || soglie.getRisposta() == null)) {
            soglie = null;
        }
        return soglie;
    }

    private static SogliaDimensioneMessaggio build(long sogliaKb, AttivazionePolicy attivazionePolicy, IProtocolFactory<?> protocolFactory, ConfigurazionePdDManager configPdDManager, RequestInfo requestInfo, TipoPdD tipoPdD, String nomePorta) throws ProtocolException, DriverConfigurazioneException {
        SogliaDimensioneMessaggio soglia = new SogliaDimensioneMessaggio();
        soglia.setSogliaKb(sogliaKb);
        OpenSPCoop2Properties op2Properties = OpenSPCoop2Properties.getInstance();
        soglia.setUseContentLengthHeader(op2Properties.isLimitedInputStreamUseContentLength());
        soglia.setUseContentLengthHeaderAcceptZeroValue(op2Properties.isLimitedInputStreamUseContentLengthAcceptZeroValue());
        boolean policyPorta = attivazionePolicy.getFiltro() != null && attivazionePolicy.getFiltro().getEnabled() && attivazionePolicy.getFiltro().getNomePorta() != null && attivazionePolicy.getFiltro().getRuoloPorta() != null;
        soglia.setPolicyGlobale(!policyPorta);
        soglia.setNomePolicy(PolicyUtilities.getNomeActivePolicy((String)attivazionePolicy.getAlias(), (String)attivazionePolicy.getIdActivePolicy()));
        String idPolicyConGruppo = null;
        String configurazione = null;
        String idAPI = null;
        if (!soglia.isPolicyGlobale()) {
            idAPI = PolicyVerifier.getIdAPI(attivazionePolicy, protocolFactory, configPdDManager, requestInfo);
        }
        idPolicyConGruppo = PolicyUtilities.buildIdConfigurazioneEventoPerPolicy((AttivazionePolicy)attivazionePolicy, null, idAPI);
        configurazione = PolicyUtilities.buildConfigurazioneEventoPerPolicy((AttivazionePolicy)attivazionePolicy, (boolean)soglia.isPolicyGlobale());
        soglia.setIdPolicyConGruppo(idPolicyConGruppo);
        soglia.setConfigurazione(configurazione);
        IDPortaDelegata idPD = null;
        IDPortaApplicativa idPA = null;
        if (tipoPdD != null && nomePorta != null && StringUtils.isNotEmpty((CharSequence)nomePorta)) {
            if (TipoPdD.DELEGATA.equals((Object)tipoPdD)) {
                idPD = new IDPortaDelegata();
                idPD.setNome(nomePorta);
            } else {
                idPA = new IDPortaApplicativa();
                idPA.setNome(nomePorta);
            }
        } else if (policyPorta) {
            if (RuoloPolicy.DELEGATA.equals((Object)attivazionePolicy.getFiltro().getRuoloPorta())) {
                idPD = new IDPortaDelegata();
                idPD.setNome(attivazionePolicy.getFiltro().getNomePorta());
            } else {
                idPA = new IDPortaApplicativa();
                idPA.setNome(attivazionePolicy.getFiltro().getNomePorta());
            }
        }
        List<Proprieta> listP = null;
        listP = idPD != null ? DimensioneMessaggiConfigurationUtils.readProperties(idPD, configPdDManager, requestInfo) : DimensioneMessaggiConfigurationUtils.readProperties(idPA, configPdDManager, requestInfo);
        if (listP != null && !listP.isEmpty()) {
            soglia.setUseContentLengthHeader(CostantiProprieta.isRateLimitingUseHttpContentLength(listP, soglia.isUseContentLengthHeader()));
            soglia.setUseContentLengthHeaderAcceptZeroValue(CostantiProprieta.isRateLimitingUseHttpContentLengthAcceptZeroValue(listP, soglia.isUseContentLengthHeaderAcceptZeroValue()));
        }
        return soglia;
    }

    private static List<Proprieta> readProperties(IDPortaDelegata idPD, ConfigurazionePdDManager configPdDManager, RequestInfo requestInfo) throws DriverConfigurazioneException {
        List listP = null;
        PortaDelegata pd = configPdDManager.getPortaDelegataSafeMethod(idPD, requestInfo);
        if (pd != null) {
            listP = pd.getProprieta();
        }
        return listP;
    }

    private static List<Proprieta> readProperties(IDPortaApplicativa idPA, ConfigurazionePdDManager configPdDManager, RequestInfo requestInfo) throws DriverConfigurazioneException {
        List listP = null;
        PortaApplicativa pa = configPdDManager.getPortaApplicativaSafeMethod(idPA, requestInfo);
        if (pa != null) {
            listP = pa.getProprieta();
        }
        return listP;
    }
}

