/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core.connettori.httpcore5.nio;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hc.core5.concurrent.FutureCallback;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpResponse;
import org.openspcoop2.pdd.config.OpenSPCoop2Properties;
import org.openspcoop2.pdd.core.connettori.ConnettoreException;
import org.openspcoop2.pdd.core.connettori.ConnettoreLogger;
import org.openspcoop2.pdd.core.connettori.ConnettoreMsg;
import org.openspcoop2.pdd.core.connettori.ConnettoreUtils;
import org.openspcoop2.pdd.core.connettori.httpcore5.nio.ConnettoreHTTPCORE;
import org.openspcoop2.pdd.core.connettori.httpcore5.nio.ConnettoreHTTPCORERedirectCallback;
import org.openspcoop2.pdd.core.connettori.httpcore5.nio.ConnettoreHTTPCOREResponse;
import org.openspcoop2.pdd.core.transazioni.TransactionContext;
import org.openspcoop2.pdd.services.connector.AsyncResponseCallbackClientEvent;
import org.openspcoop2.pdd.services.connector.IAsyncResponseCallback;
import org.openspcoop2.utils.BooleanNullable;
import org.openspcoop2.utils.transport.TransportUtils;
import org.openspcoop2.utils.transport.http.HttpBodyParameters;

public class ConnettoreHTTPCOREResponseCallback
implements FutureCallback<ConnettoreHTTPCOREResponse> {
    private ConnettoreHTTPCORE connettore;
    private ConnettoreMsg request;
    private HttpBodyParameters httpBody;
    private boolean connettoreDebug;
    private ConnettoreLogger connettoreLogger;
    private boolean switchThreadContext = false;
    private String function;
    private BooleanNullable switchThreadLocalContextDoneHolder = BooleanNullable.FALSE();

    public ConnettoreHTTPCOREResponseCallback(ConnettoreHTTPCORE connettore, ConnettoreMsg request, HttpBodyParameters httpBody) {
        this.connettore = connettore;
        this.request = request;
        this.httpBody = httpBody;
        this.connettoreDebug = this.connettore.isDebug();
        this.connettoreLogger = this.connettore.getLogger();
        if (TransactionContext.isUseThreadLocal()) {
            this.switchThreadContext = true;
            this.function = "ResponseCallback-" + this.getClass().getName();
        }
    }

    public void completed(ConnettoreHTTPCOREResponse responseParam) {
        OpenSPCoop2Properties openspcoopProperties = OpenSPCoop2Properties.getInstance();
        Map<String, List<String>> connettorePropertiesTrasportoRisposta = this.connettore.getPropertiesTrasportoRisposta();
        try {
            if (this.switchThreadContext) {
                this.connettore.checkThreadLocalContext(this.function, this.switchThreadLocalContextDoneHolder);
            }
            HttpResponse response = responseParam.getHttpResponse();
            HttpEntity httpEntityResponse = responseParam.getEntity();
            if (this.connettoreDebug) {
                this.connettoreLogger.debug("NIO - Callback Response started after 'complete' event ...");
            }
            if (this.connettoreDebug) {
                this.connettoreLogger.debug("Analisi risposta...");
            }
            Header[] hdrRisposta = response.getHeaders();
            HashMap mapHeaderHttpResponse = new HashMap();
            if (hdrRisposta != null) {
                for (int i = 0; i < hdrRisposta.length; ++i) {
                    String key = null;
                    String value = null;
                    if (hdrRisposta[i].getName() == null) {
                        if (this.connettoreDebug) {
                            this.connettoreLogger.debug("HTTP risposta [ReturnCode] [" + hdrRisposta[i].getValue() + "]...");
                        }
                        key = "ReturnCode";
                        value = hdrRisposta[i].getValue();
                    } else {
                        if (this.connettoreDebug) {
                            this.connettoreLogger.debug("HTTP risposta [" + hdrRisposta[i].getName() + "] [" + hdrRisposta[i].getValue() + "]...");
                        }
                        key = hdrRisposta[i].getName();
                        value = hdrRisposta[i].getValue();
                    }
                    TransportUtils.addHeader(connettorePropertiesTrasportoRisposta, (String)key, (String)value);
                    ArrayList<String> list = null;
                    if (mapHeaderHttpResponse.containsKey(key)) {
                        list = (ArrayList<String>)mapHeaderHttpResponse.get(key);
                    }
                    if (list == null) {
                        list = new ArrayList<String>();
                        mapHeaderHttpResponse.put(key, list);
                    }
                    list.add(value);
                }
            }
            this.connettore.setTipoRisposta(TransportUtils.getObjectAsString(mapHeaderHttpResponse, (String)"Content-Type"));
            String contentLengthHdr = TransportUtils.getObjectAsString(mapHeaderHttpResponse, (String)"Content-Length");
            if (contentLengthHdr != null) {
                this.connettore.setContentLength(Long.parseLong(contentLengthHdr));
            } else if (httpEntityResponse != null && httpEntityResponse.getContentLength() > 0L) {
                this.connettore.setContentLength(httpEntityResponse.getContentLength());
            }
            if (this.connettore.isSoap()) {
                String mimeTypeAttachment;
                this.connettore.setImbustamentoConAttachment(false);
                if ("true".equals(TransportUtils.getObjectAsString(mapHeaderHttpResponse, (String)openspcoopProperties.getTunnelSOAPKeyWord_headerTrasporto()))) {
                    this.connettore.setImbustamentoConAttachment(true);
                }
                if ((mimeTypeAttachment = TransportUtils.getObjectAsString(mapHeaderHttpResponse, (String)openspcoopProperties.getTunnelSOAPKeyWordMimeType_headerTrasporto())) == null) {
                    mimeTypeAttachment = "application/openspcoop2";
                }
                this.connettore.setMimeTypeAttachment(mimeTypeAttachment);
            }
            if (this.connettoreDebug) {
                this.connettoreLogger.debug("Analisi risposta input stream e risultato http...");
            }
            this.connettore.initConfigurationAcceptOnlyReturnCode202or200();
            this.connettore.setCodiceTrasporto(response.getCode());
            this.connettore.setResultHTTPMessage(response.getReasonPhrase());
            if (this.connettore.getCodiceTrasporto() < 300) {
                if (this.connettore.isSoap() && this.connettore.isAcceptOnlyReturnCode202or200() && this.connettore.getCodiceTrasporto() != 200 && this.connettore.getCodiceTrasporto() != 202) {
                    throw new ConnettoreException("Return code [" + this.connettore.getCodiceTrasporto() + "] non consentito dal WS-I Basic Profile (http://www.ws-i.org/Profiles/BasicProfile-1.1-2004-08-24.html#HTTP_Success_Status_Codes)");
                }
                if (this.httpBody.isDoInput() && httpEntityResponse != null) {
                    this.connettore.setInputStreamResponse(httpEntityResponse != null ? httpEntityResponse.getContent() : null);
                }
            } else if (this.connettore.getCodiceTrasporto() < 400) {
                String redirectLocation = TransportUtils.getObjectAsString(mapHeaderHttpResponse, (String)"Location");
                if (this.connettore.isFollowRedirects()) {
                    if (redirectLocation == null) {
                        throw new ConnettoreException("Non \u00e8 stato rilevato l'header HTTP [Location] necessario alla gestione del Redirect (code:" + this.connettore.getCodiceTrasporto() + ")");
                    }
                    TransportUtils.removeObject(this.request.getConnectorProperties(), (String)"location");
                    TransportUtils.removeObject(this.request.getConnectorProperties(), (String)"numberRedirect");
                    TransportUtils.removeObject(this.request.getConnectorProperties(), (String)"routeRedirect");
                    this.request.getConnectorProperties().put("location", redirectLocation);
                    this.request.getConnectorProperties().put("numberRedirect", "" + (this.connettore.getNumberRedirect() + 1));
                    if (this.connettore.getRouteRedirect() != null) {
                        this.request.getConnectorProperties().put("routeRedirect", this.connettore.getRouteRedirect() + " -> " + redirectLocation);
                    } else {
                        this.request.getConnectorProperties().put("routeRedirect", redirectLocation);
                    }
                    if (this.connettore.getOriginalAbsolutePrefixForRelativeRedirectLocation() == null) {
                        this.connettore.setOriginalAbsolutePrefixForRelativeRedirectLocation(this.connettore.url.getProtocol() + "://" + this.connettore.url.getHost() + ":" + this.connettore.url.getPort());
                    }
                    this.connettore.setRedirectLocation(redirectLocation);
                    if (redirectLocation.startsWith("/")) {
                        this.connettore.setRedirectLocation(this.connettore.getOriginalAbsolutePrefixForRelativeRedirectLocation() + redirectLocation);
                    }
                    this.connettoreLogger.warn("(hope:" + (this.connettore.getNumberRedirect() + 1) + ") Redirect verso [" + redirectLocation + "] ...");
                    if (this.connettore.getNumberRedirect() == this.connettore.getMaxNumberRedirects()) {
                        throw new ConnettoreException(ConnettoreUtils.getPrefixRedirect(this.connettore.getCodiceTrasporto(), redirectLocation) + "non consentita ulteriormente, sono gi\u00e0 stati gestiti " + this.connettore.getMaxNumberRedirects() + " redirects: " + this.connettore.getRouteRedirect());
                    }
                    boolean acceptOnlyReturnCode307 = false;
                    if (this.connettore.isSoap()) {
                        acceptOnlyReturnCode307 = "ConsegnaContenutiApplicativi".equals(this.connettore.getIdModulo()) ? openspcoopProperties.isAcceptOnlyReturnCode_307_consegnaContenutiApplicativi() : openspcoopProperties.isAcceptOnlyReturnCode_307_inoltroBuste();
                    }
                    if (acceptOnlyReturnCode307 && this.connettore.getCodiceTrasporto() != 307) {
                        throw new ConnettoreException("Return code [" + this.connettore.getCodiceTrasporto() + "] (redirect Location:" + redirectLocation + ") non consentito dal WS-I Basic Profile (http://www.ws-i.org/Profiles/BasicProfile-1.1-2004-08-24.html#HTTP_Redirect_Status_Codes)");
                    }
                    if (this.connettore.getPropertiesTrasportoRisposta() != null) {
                        this.connettore.getPropertiesTrasportoRisposta().clear();
                    }
                    IAsyncResponseCallback callback = this.request.getAsyncResponseCallback();
                    this.request.setAsyncResponseCallback(new ConnettoreHTTPCORERedirectCallback(this, callback));
                    this.connettore.disconnect();
                    this.connettore.send(this.request);
                    return;
                }
                if (this.connettore.isSoap()) {
                    throw new ConnettoreException(ConnettoreUtils.getPrefixRedirect(this.connettore.getCodiceTrasporto(), redirectLocation) + "non attiva");
                }
                this.connettoreLogger.debug(ConnettoreUtils.getPrefixRedirect(this.connettore.getCodiceTrasporto(), redirectLocation) + "non attiva");
                if (this.connettore.internalGetLocationValue() != null && redirectLocation != null) {
                    this.connettore.setLocation(this.connettore.internalGetLocationValue() + " [redirect-location: " + redirectLocation + "]");
                }
                if (httpEntityResponse != null) {
                    this.connettore.setInputStreamResponse(httpEntityResponse.getContent());
                }
            } else if (httpEntityResponse != null) {
                this.connettore.setInputStreamResponse(httpEntityResponse.getContent());
            }
        }
        catch (Exception e) {
            this.writeExceptionResponse(e);
            this.notifyCallbackFinished(AsyncResponseCallbackClientEvent.COMPLETED);
            this.connettore.freeResources();
            return;
        }
        this.handleResponse();
    }

    public void handlePostRedirect(IAsyncResponseCallback prevCB) {
        try {
            if (this.connettore.getEccezioneProcessamento() != null) {
                throw this.connettore.getEccezioneProcessamento();
            }
            if (this.connettore.getMaxNumberRedirects() == this.connettore.getNumberRedirect()) {
                throw new ConnettoreException(ConnettoreUtils.getPrefixRedirect(this.connettore.getCodiceTrasporto(), this.connettore.getRedirectLocation()) + "non consentita ulteriormente, sono gi\u00e0 stati gestiti " + this.connettore.getMaxNumberRedirects() + " redirects: " + this.connettore.getRouteRedirect());
            }
        }
        catch (Exception e) {
            this.writeExceptionResponse(e);
        }
        finally {
            this.request.setAsyncResponseCallback(prevCB);
            this.notifyCallbackFinished(AsyncResponseCallbackClientEvent.COMPLETED);
        }
    }

    private void handleResponse() {
        Map<String, List<String>> connettorePropertiesTrasportoRisposta = this.connettore.getPropertiesTrasportoRisposta();
        try {
            this.connettore.postOutRequest();
            this.connettore.preInResponse();
            this.connettore.setNotifierInputStreamParams(null);
            if (this.connettore.getPreInResponseContext() != null) {
                this.connettore.setNotifierInputStreamParams(this.connettore.getPreInResponseContext().getNotifierInputStreamParams());
            }
            this.connettore.normalizeInputStreamResponse(this.connettore.readConnectionTimeout, this.connettore.readConnectionTimeoutConfigurazioneGlobale);
            this.connettore.initCheckContentTypeConfiguration();
            if (this.connettore.isDumpBinarioRisposta() && !this.connettore.dumpResponse(connettorePropertiesTrasportoRisposta)) {
                this.connettore.setAsyncInvocationSuccess(false);
                return;
            }
            if (this.connettore.isRest()) {
                if (!this.connettore.doRestResponse()) {
                    this.connettore.setAsyncInvocationSuccess(false);
                    return;
                }
            } else if (!this.connettore.doSoapResponse()) {
                this.connettore.setAsyncInvocationSuccess(false);
                return;
            }
            if (this.connettoreDebug) {
                this.connettoreLogger.info("Gestione invio/risposta http effettuata con successo", false);
            }
            this.connettore.configureSSE();
            this.connettore.setAsyncInvocationSuccess(true);
        }
        catch (Exception e) {
            this.writeExceptionResponse(e);
        }
        finally {
            this.notifyCallbackFinished(AsyncResponseCallbackClientEvent.COMPLETED);
        }
    }

    public void failed(Exception e) {
        try {
            if (this.switchThreadContext) {
                this.switchThreadContext("failed");
            }
            if (this.connettoreDebug && this.connettoreLogger != null) {
                this.connettoreLogger.debug("NIO - Callback Response started after 'failed' event ...");
            }
            this.writeExceptionResponse(e);
        }
        finally {
            this.notifyCallbackFinished(AsyncResponseCallbackClientEvent.FAILED);
        }
    }

    public void cancelled() {
        try {
            if (this.switchThreadContext) {
                this.switchThreadContext("cancelled");
            }
            if (this.connettoreDebug && this.connettoreLogger != null) {
                this.connettoreLogger.debug("NIO - Callback Response started after 'cancelled' event ...");
            }
            this.writeExceptionResponse(new Exception("Cancelled"));
        }
        finally {
            this.notifyCallbackFinished(AsyncResponseCallbackClientEvent.CANCELLED);
        }
    }

    private void switchThreadContext(String method) {
        block2: {
            try {
                this.connettore.checkThreadLocalContext(this.function, this.switchThreadLocalContextDoneHolder);
            }
            catch (Exception eError) {
                if (this.connettoreLogger == null) break block2;
                this.connettoreLogger.error("gestione checkThreadLocalContext in '" + method + "' terminata con errore: " + eError.getMessage(), eError);
            }
        }
    }

    private void notifyCallbackFinished(AsyncResponseCallbackClientEvent clientEvent) {
        this.connettore.freeResources();
        this.connettore.asyncComplete(clientEvent);
        if (this.connettoreDebug) {
            this.connettoreLogger.debug("NIO - Callback Response finished");
        }
    }

    private void writeExceptionResponse(Exception e) {
        this.connettore.setEccezioneProcessamento(e);
        String msgErrore = this.connettore.readExceptionMessageFromException(e);
        boolean connect = this.connettore.processConnectionTimeoutException(this.connettore.connectionTimeout, this.connettore.connectionTimeoutConfigurazioneGlobale, e, msgErrore);
        boolean read = this.connettore.processReadTimeoutException(this.connettore.readConnectionTimeout, this.connettore.readConnectionTimeoutConfigurazioneGlobale, e, msgErrore);
        msgErrore = ConnettoreHTTPCORE.correctMessageTimeout(connect, read, msgErrore);
        if (this.connettore.isGenerateErrorWithConnectorPrefix()) {
            this.connettore.setErrore("Errore avvenuto durante la consegna HTTP: " + msgErrore);
        } else {
            this.connettore.setErrore(msgErrore);
        }
        this.connettoreLogger.error("Errore avvenuto durante la consegna HTTP: " + msgErrore, e);
        this.connettore.setAsyncInvocationSuccess(false);
    }
}

