/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core.connettori.httpcore5;

import java.net.URL;
import java.util.concurrent.TimeUnit;
import org.apache.hc.client5.http.classic.methods.HttpDelete;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.classic.methods.HttpHead;
import org.apache.hc.client5.http.classic.methods.HttpOptions;
import org.apache.hc.client5.http.classic.methods.HttpPatch;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.classic.methods.HttpPut;
import org.apache.hc.client5.http.classic.methods.HttpTrace;
import org.apache.hc.client5.http.classic.methods.HttpUriRequestBase;
import org.apache.hc.client5.http.config.ConnectionConfig;
import org.apache.hc.client5.http.config.RequestConfig;
import org.openspcoop2.pdd.core.connettori.AbstractConnettoreConnectionConfig;
import org.openspcoop2.pdd.core.connettori.ConnettoreException;
import org.openspcoop2.pdd.core.connettori.ConnettoreHttpPoolParams;
import org.openspcoop2.pdd.core.connettori.httpcore5.CustomHttpCoreEntity;
import org.openspcoop2.utils.transport.http.HttpRequestMethod;

public class ConnettoreHTTPCOREUtils {
    private ConnettoreHTTPCOREUtils() {
    }

    public static ConnectionConfig buildConnectionConfig(ConnettoreHttpPoolParams poolParams, long connectionTimeout, boolean idleConnectionEvictorEnabled, int sleepTimeSeconds) {
        ConnectionConfig.Builder buider = ConnectionConfig.custom();
        buider.setConnectTimeout(connectionTimeout, TimeUnit.MILLISECONDS);
        if (poolParams.getValidateAfterInactivity() != null) {
            buider.setValidateAfterInactivity((long)poolParams.getValidateAfterInactivity().intValue(), TimeUnit.MILLISECONDS);
        }
        if (idleConnectionEvictorEnabled) {
            buider.setTimeToLive((long)sleepTimeSeconds, TimeUnit.SECONDS);
        }
        return buider.build();
    }

    public static void setTimeout(RequestConfig.Builder requestConfigBuilder, AbstractConnettoreConnectionConfig connectionConfig) {
        int connectionTimeout = -1;
        connectionTimeout = connectionConfig.getConnectionTimeout() != null ? connectionConfig.getConnectionTimeout() : 10000;
        requestConfigBuilder.setConnectionRequestTimeout((long)connectionTimeout, TimeUnit.MILLISECONDS);
        int readTimeout = -1;
        readTimeout = connectionConfig.getReadTimeout() != null ? connectionConfig.getReadTimeout() : 120000;
        requestConfigBuilder.setResponseTimeout((long)readTimeout, TimeUnit.MILLISECONDS);
    }

    public static void setRedirect(RequestConfig.Builder requestConfigBuilder, AbstractConnettoreConnectionConfig connectionConfig) {
        requestConfigBuilder.setRedirectsEnabled(connectionConfig.isFollowRedirect());
        requestConfigBuilder.setCircularRedirectsAllowed(true);
        requestConfigBuilder.setMaxRedirects(connectionConfig.getMaxNumberRedirects());
    }

    public static HttpUriRequestBase buildHttpRequest(HttpRequestMethod httpMethod, URL url) throws ConnettoreException {
        if (httpMethod == null) {
            throw new ConnettoreException("HttpRequestMethod non definito");
        }
        Object httpRequest = null;
        switch (httpMethod) {
            case GET: {
                httpRequest = new HttpGet(url.toString());
                break;
            }
            case DELETE: {
                httpRequest = new HttpDelete(url.toString());
                break;
            }
            case HEAD: {
                httpRequest = new HttpHead(url.toString());
                break;
            }
            case POST: {
                httpRequest = new HttpPost(url.toString());
                break;
            }
            case PUT: {
                httpRequest = new HttpPut(url.toString());
                break;
            }
            case OPTIONS: {
                httpRequest = new HttpOptions(url.toString());
                break;
            }
            case TRACE: {
                httpRequest = new HttpTrace(url.toString());
                break;
            }
            case PATCH: {
                httpRequest = new HttpPatch(url.toString());
                break;
            }
            default: {
                httpRequest = new CustomHttpCoreEntity(httpMethod, url.toString());
            }
        }
        return httpRequest;
    }
}

