/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core.connettori;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openspcoop2.core.config.InvocazioneCredenziali;
import org.openspcoop2.core.config.Property;
import org.openspcoop2.core.config.driver.DriverConfigurazioneException;
import org.openspcoop2.core.config.driver.DriverConfigurazioneNotFound;
import org.openspcoop2.core.id.IDAccordo;
import org.openspcoop2.core.id.IDPortaApplicativa;
import org.openspcoop2.core.transazioni.TransazioneApplicativoServer;
import org.openspcoop2.message.OpenSPCoop2Message;
import org.openspcoop2.pdd.config.ConfigurazionePdDManager;
import org.openspcoop2.pdd.config.ForwardProxy;
import org.openspcoop2.pdd.core.PdDContext;
import org.openspcoop2.pdd.core.controllo_traffico.PolicyTimeoutConfig;
import org.openspcoop2.pdd.core.handlers.OutRequestContext;
import org.openspcoop2.pdd.core.token.PolicyNegoziazioneToken;
import org.openspcoop2.pdd.logger.MsgDiagnostico;
import org.openspcoop2.pdd.services.connector.IAsyncResponseCallback;
import org.openspcoop2.protocol.engine.builder.Sbustamento;
import org.openspcoop2.protocol.sdk.Busta;
import org.openspcoop2.protocol.sdk.BustaRawContent;
import org.openspcoop2.protocol.sdk.Context;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.protocol.sdk.ProtocolMessage;
import org.openspcoop2.protocol.sdk.builder.ProprietaManifestAttachments;
import org.openspcoop2.protocol.sdk.constants.FaseSbustamento;
import org.openspcoop2.protocol.sdk.constants.RuoloMessaggio;
import org.openspcoop2.protocol.sdk.state.IState;
import org.openspcoop2.protocol.sdk.state.RequestInfo;
import org.openspcoop2.utils.transport.TransportRequestContext;

public class ConnettoreMsg {
    private String tipoConnector;
    private OpenSPCoop2Message request;
    private Map<String, String> properties;
    protected boolean generateErrorWithConnectorPrefix = true;
    private boolean sbustamentoSoap;
    private boolean sbustamentoInformazioniProtocollo;
    private Map<String, List<String>> propertiesTrasporto;
    private Map<String, List<String>> propertiesUrlBased;
    private String tipoAutenticazione;
    private InvocazioneCredenziali credenziali;
    private Busta busta;
    private String idModulo;
    private IProtocolFactory<?> protocolFactory;
    private boolean gestioneManifest = false;
    private ProprietaManifestAttachments proprietaManifestAttachments = null;
    private BustaRawContent<?> soapProtocolInfo = null;
    private boolean localForward = false;
    private RuoloMessaggio ruoloMessaggio = RuoloMessaggio.RICHIESTA;
    private PolicyNegoziazioneToken policyNegoziazioneToken;
    private PolicyTimeoutConfig policyTimeoutConfig;
    private OutRequestContext outRequestContext;
    private MsgDiagnostico msgDiagnostico;
    private IState state;
    private TransazioneApplicativoServer transazioneApplicativoServer;
    private IDPortaApplicativa idPortaApplicativa;
    private Date dataConsegnaTransazioneApplicativoServer;
    private ForwardProxy forwardProxy;
    private IDAccordo idAccordo;
    private IAsyncResponseCallback asyncResponseCallback;
    private String urlInvocazionePorta;
    private Boolean forceSendContent = null;
    private boolean sbustamentoProtocolInfoEffettuato = false;
    private boolean checkPresenzaHeaderPrimaSbustamento = false;

    public ConnettoreMsg() {
    }

    public ConnettoreMsg(String type, OpenSPCoop2Message r, Property[] p) {
        HashMap<String, String> pr = new HashMap<String, String>();
        if (p != null) {
            for (int i = 0; i < p.length; ++i) {
                if (p[i] == null) continue;
                pr.put(p[i].getNome(), p[i].getValore());
            }
        }
        this.tipoConnector = type;
        this.request = r;
        this.properties = pr;
    }

    public ConnettoreMsg(String type, OpenSPCoop2Message r, Map<String, String> p) {
        this(type, r, p, false, null, null, true);
    }

    public ConnettoreMsg(String type, OpenSPCoop2Message r, Property[] p, boolean sb, String tipoAuth, InvocazioneCredenziali cr, boolean isRichiesta) {
        this(type, r, new HashMap<String, String>(), sb, tipoAuth, cr, isRichiesta);
        HashMap<String, String> pr = new HashMap<String, String>();
        if (p != null) {
            for (int i = 0; i < p.length; ++i) {
                if (p[i] == null) continue;
                pr.put(p[i].getNome(), p[i].getValore());
            }
        }
        this.properties = pr;
    }

    public ConnettoreMsg(String type, OpenSPCoop2Message r, Map<String, String> p, boolean sb, String tipoAuth, InvocazioneCredenziali cr, boolean isRichiesta) {
        this.tipoConnector = type;
        this.request = r;
        this.properties = p;
        this.sbustamentoSoap = sb;
        this.tipoAutenticazione = tipoAuth;
        this.credenziali = cr;
    }

    public void setTipoConnettore(String tipo) {
        this.tipoConnector = tipo;
    }

    public void setRequestMessage(OpenSPCoop2Message r) {
        this.request = r;
    }

    public void setConnectorProperties(Map<String, String> p) {
        this.properties = p;
    }

    public void setSbustamentoSOAP(boolean sb) {
        this.sbustamentoSoap = sb;
    }

    public void setAutenticazione(String tipoAuth) {
        this.tipoAutenticazione = tipoAuth;
    }

    public void setCredenziali(InvocazioneCredenziali cr) {
        this.credenziali = cr;
    }

    public void setGenerateErrorWithConnectorPrefix(boolean generateErrorWithConnectorPrefix) {
        this.generateErrorWithConnectorPrefix = generateErrorWithConnectorPrefix;
    }

    public void setIdAccordo(IDAccordo id) {
        this.idAccordo = id;
    }

    public void setUrlInvocazionePorta(String urlInvocazionePorta) {
        this.urlInvocazionePorta = urlInvocazionePorta;
    }

    public void forceSendContent() {
        this.forceSendContent = true;
    }

    public String getTipoConnettore() {
        return this.tipoConnector;
    }

    public void setCheckPresenzaHeaderPrimaSbustamento(boolean checkPresenzaHeaderPrimaSbustamento) {
        this.checkPresenzaHeaderPrimaSbustamento = checkPresenzaHeaderPrimaSbustamento;
    }

    public OpenSPCoop2Message getRequestMessage(RequestInfo requestInfo, PdDContext pddContext) throws ProtocolException {
        if (!this.localForward && this.sbustamentoInformazioniProtocollo && !this.sbustamentoProtocolInfoEffettuato) {
            boolean protocolloPresente = true;
            if (this.checkPresenzaHeaderPrimaSbustamento) {
                try {
                    protocolloPresente = this.protocolFactory.createValidazioneSintattica(this.state).verifyProtocolPresence(this.outRequestContext.getTipoPorta(), this.busta.getProfiloDiCollaborazione(), this.ruoloMessaggio, this.request);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (protocolloPresente) {
                Sbustamento sbustatore = new Sbustamento(this.protocolFactory, this.state);
                ProtocolMessage protocolMessage = sbustatore.sbustamento(this.request, (Context)pddContext, this.busta, this.ruoloMessaggio, this.gestioneManifest, this.proprietaManifestAttachments, FaseSbustamento.PRE_CONSEGNA_RICHIESTA, requestInfo);
                if (protocolMessage != null) {
                    this.soapProtocolInfo = protocolMessage.getBustaRawContent();
                    this.request = protocolMessage.getMessage();
                }
                this.sbustamentoProtocolInfoEffettuato = true;
            }
        }
        return this.request;
    }

    public TransportRequestContext getTransportRequestContext() {
        if (this.request != null) {
            return this.request.getTransportRequestContext();
        }
        return null;
    }

    public Map<String, String> getConnectorProperties() {
        return this.properties;
    }

    public boolean isSbustamentoSOAP() {
        return this.sbustamentoSoap;
    }

    public String getAutenticazione() {
        return this.tipoAutenticazione;
    }

    public InvocazioneCredenziali getCredenziali() {
        return this.credenziali;
    }

    public Map<String, List<String>> getPropertiesTrasporto() {
        return this.propertiesTrasporto;
    }

    public Map<String, List<String>> getPropertiesUrlBased() {
        return this.propertiesUrlBased;
    }

    public void setPropertiesTrasporto(Map<String, List<String>> propertiesTrasporto) {
        this.propertiesTrasporto = propertiesTrasporto;
    }

    public void setPropertiesUrlBased(Map<String, List<String>> propertiesUrlBased) {
        this.propertiesUrlBased = propertiesUrlBased;
    }

    public Busta getBusta() {
        return this.busta;
    }

    public void setBusta(Busta busta) {
        this.busta = busta;
    }

    public String getIdModulo() {
        return this.idModulo;
    }

    public void setIdModulo(String idModulo) {
        this.idModulo = idModulo;
    }

    public boolean isSbustamentoInformazioniProtocollo() {
        return this.sbustamentoInformazioniProtocollo;
    }

    public void setSbustamentoInformazioniProtocollo(boolean sbustamentoInformazioniProtocollo) {
        this.sbustamentoInformazioniProtocollo = sbustamentoInformazioniProtocollo;
    }

    public RuoloMessaggio getRuoloMessaggio() {
        return this.ruoloMessaggio;
    }

    public void setRuoloMessaggio(RuoloMessaggio ruoloMessaggio) {
        this.ruoloMessaggio = ruoloMessaggio;
    }

    public void setProtocolFactory(IProtocolFactory<?> protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public void setGestioneManifest(boolean gestioneManifest) {
        this.gestioneManifest = gestioneManifest;
    }

    public void setProprietaManifestAttachments(ProprietaManifestAttachments proprietaManifestAttachments) {
        this.proprietaManifestAttachments = proprietaManifestAttachments;
    }

    public BustaRawContent<?> getSoapProtocolInfo() {
        return this.soapProtocolInfo;
    }

    public boolean isLocalForward() {
        return this.localForward;
    }

    public void setLocalForward(boolean localForward) {
        this.localForward = localForward;
    }

    public OutRequestContext getOutRequestContext() {
        return this.outRequestContext;
    }

    public void setOutRequestContext(OutRequestContext outRequestContext) {
        this.outRequestContext = outRequestContext;
    }

    public MsgDiagnostico getMsgDiagnostico() {
        return this.msgDiagnostico;
    }

    public void setMsgDiagnostico(MsgDiagnostico msgDiagnostico) {
        this.msgDiagnostico = msgDiagnostico;
    }

    public IState getState() {
        return this.state;
    }

    public void setState(IState state) {
        this.state = state;
    }

    public boolean isGenerateErrorWithConnectorPrefix() {
        return this.generateErrorWithConnectorPrefix;
    }

    public IAsyncResponseCallback getAsyncResponseCallback() {
        return this.asyncResponseCallback;
    }

    public void setAsyncResponseCallback(IAsyncResponseCallback asyncResponseCallback) {
        this.asyncResponseCallback = asyncResponseCallback;
    }

    public PolicyNegoziazioneToken getPolicyNegoziazioneToken() {
        return this.policyNegoziazioneToken;
    }

    public void setPolicyNegoziazioneToken(PolicyNegoziazioneToken policyNegoziazioneToken) {
        this.policyNegoziazioneToken = policyNegoziazioneToken;
    }

    public void initPolicyGestioneToken(ConfigurazionePdDManager configPdDManager, RequestInfo requestInfo) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        if (this.properties != null && !this.properties.isEmpty()) {
            for (String propertyName : this.properties.keySet()) {
                String tokenPolicy;
                if (!"tokenPolicy".equals(propertyName) || (tokenPolicy = this.properties.get(propertyName)) == null || "".equals(tokenPolicy)) continue;
                boolean forceNoCache = true;
                this.policyNegoziazioneToken = configPdDManager.getPolicyNegoziazioneToken(!forceNoCache, tokenPolicy, requestInfo);
            }
        }
    }

    public PolicyTimeoutConfig getPolicyTimeoutConfig() {
        return this.policyTimeoutConfig;
    }

    public void setPolicyTimeoutConfig(PolicyTimeoutConfig policyConfig) {
        this.policyTimeoutConfig = policyConfig;
    }

    public TransazioneApplicativoServer getTransazioneApplicativoServer() {
        return this.transazioneApplicativoServer;
    }

    public void setTransazioneApplicativoServer(TransazioneApplicativoServer transazioneApplicativoServer) {
        this.transazioneApplicativoServer = transazioneApplicativoServer;
    }

    public IDPortaApplicativa getIdPortaApplicativa() {
        return this.idPortaApplicativa;
    }

    public void setIdPortaApplicativa(IDPortaApplicativa idPortaApplicativa) {
        this.idPortaApplicativa = idPortaApplicativa;
    }

    public Date getDataConsegnaTransazioneApplicativoServer() {
        return this.dataConsegnaTransazioneApplicativoServer;
    }

    public void setDataConsegnaTransazioneApplicativoServer(Date dataConsegnaTransazioneApplicativoServer) {
        this.dataConsegnaTransazioneApplicativoServer = dataConsegnaTransazioneApplicativoServer;
    }

    public ForwardProxy getForwardProxy() {
        return this.forwardProxy;
    }

    public void setForwardProxy(ForwardProxy forwardProxy) {
        this.forwardProxy = forwardProxy;
    }

    public IDAccordo getIdAccordo() {
        return this.idAccordo;
    }

    public String getUrlInvocazionePorta() {
        return this.urlInvocazionePorta;
    }

    public boolean isForceSendContent() {
        return this.forceSendContent != null ? this.forceSendContent : false;
    }
}

