/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core.connettori;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.openspcoop2.core.id.IDServizio;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.core.registry.driver.IDServizioFactory;
import org.openspcoop2.pdd.logger.OpenSPCoop2Logger;
import org.openspcoop2.utils.UtilsException;
import org.slf4j.Logger;

public class ConnettoreJMSProperties {
    public static final String JMS_PREFIX_PROPERTY = "org.openspcoop.pubblicazione.";
    private static Logger log = OpenSPCoop2Logger.getLoggerOpenSPCoopCore();
    private Properties reader = new Properties();
    private static ConnettoreJMSProperties connettoreJMSProperties = null;

    private ConnettoreJMSProperties() throws UtilsException {
        try (InputStream properties = ConnettoreJMSProperties.class.getResourceAsStream("/govway.jmsPublisher.properties");){
            this.reader.load(properties);
        }
        catch (Exception e) {
            this.doError(e);
        }
    }

    private void doError(Exception e) throws UtilsException {
        log.error("Riscontrato errore durante la lettura del file 'govway.jmsPublisher.properties': " + e.getMessage(), (Throwable)e);
        throw new UtilsException("ConnettoreJMSProperties initialize error: " + e.getMessage(), (Throwable)e);
    }

    public static boolean initialize() {
        try {
            connettoreJMSProperties = new ConnettoreJMSProperties();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ConnettoreJMSProperties getInstance() {
        if (connettoreJMSProperties != null) return connettoreJMSProperties;
        Class<ConnettoreJMSProperties> clazz = ConnettoreJMSProperties.class;
        synchronized (ConnettoreJMSProperties.class) {
            if (connettoreJMSProperties != null) return connettoreJMSProperties;
            ConnettoreJMSProperties.initialize();
            // ** MonitorExit[var0] (shouldn't be in output)
            return connettoreJMSProperties;
        }
    }

    public Map<String, IDServizio> getIDServiziPubblicazione() {
        HashMap<String, IDServizio> servizi = new HashMap<String, IDServizio>();
        try {
            ArrayList<String> idServizi = new ArrayList<String>();
            Enumeration<?> en = this.reader.propertyNames();
            while (en.hasMoreElements()) {
                String property = (String)en.nextElement();
                if (!property.startsWith(JMS_PREFIX_PROPERTY)) continue;
                String key = property.substring(JMS_PREFIX_PROPERTY.length());
                int indexOf = key.indexOf(".");
                if ((key = key.substring(0, indexOf)) != null) {
                    key = key.trim();
                }
                if (idServizi.contains(key)) continue;
                idServizi.add(key);
            }
            for (int i = 0; i < idServizi.size(); ++i) {
                IDSoggetto idSoggetto = new IDSoggetto();
                idSoggetto.setTipo((String)this.reader.get(JMS_PREFIX_PROPERTY + (String)idServizi.get(i) + ".tipoSoggettoErogatore"));
                idSoggetto.setNome((String)this.reader.get(JMS_PREFIX_PROPERTY + (String)idServizi.get(i) + ".soggettoErogatore"));
                String tipoServizio = (String)this.reader.get(JMS_PREFIX_PROPERTY + (String)idServizi.get(i) + ".tipoServizio");
                String nomeServizio = (String)this.reader.get(JMS_PREFIX_PROPERTY + (String)idServizi.get(i) + ".servizio");
                Integer versioneServizio = Integer.parseInt((String)this.reader.get(JMS_PREFIX_PROPERTY + (String)idServizi.get(i) + ".versioneServizio"));
                IDServizio idServizio = IDServizioFactory.getInstance().getIDServizioFromValues(tipoServizio, nomeServizio, idSoggetto, versioneServizio.intValue());
                servizi.put((String)idServizi.get(i), idServizio);
            }
            return servizi;
        }
        catch (Throwable e) {
            log.error("Riscontrato errore durante la lettura dei servizi pubblicatori : 'org.openspcoop.pubblicazione.*'", e);
            servizi = null;
            return servizi;
        }
    }

    public Properties getJNDIContextConfigurazione(String id) {
        Properties prop = new Properties();
        try {
            String ricerca = JMS_PREFIX_PROPERTY + id + ".jndi.contextProperty.";
            Enumeration<?> en = this.reader.propertyNames();
            while (en.hasMoreElements()) {
                String value;
                String property = (String)en.nextElement();
                if (!property.startsWith(ricerca)) continue;
                String key = property.substring(ricerca.length());
                if (key != null) {
                    key = key.trim();
                }
                if ((value = this.reader.getProperty(property)) != null) {
                    value = value.trim();
                }
                if (key == null || value == null) continue;
                prop.setProperty(key, value);
            }
            return prop;
        }
        catch (Exception e) {
            String msg = "Riscontrato errore durante la lettura delle propriete' JNDI per la configurazione: " + e.getMessage();
            log.error(msg, (Throwable)e);
            prop = null;
            return prop;
        }
    }

    public Properties getJNDIPoolConfigurazione(String id) {
        Properties prop = new Properties();
        try {
            String ricerca = JMS_PREFIX_PROPERTY + id + ".jndi.poolProperty.";
            Enumeration<?> en = this.reader.propertyNames();
            while (en.hasMoreElements()) {
                String value;
                String property = (String)en.nextElement();
                if (!property.startsWith(ricerca)) continue;
                String key = property.substring(ricerca.length());
                if (key != null) {
                    key = key.trim();
                }
                if ((value = this.reader.getProperty(property)) != null) {
                    value = value.trim();
                }
                if (key == null || value == null) continue;
                prop.setProperty(key, value);
            }
            return prop;
        }
        catch (Exception e) {
            String msg = "Riscontrato errore durante la lettura delle propriete' JNDI per la configurazione: " + e.getMessage();
            log.error(msg, (Throwable)e);
            prop = null;
            return prop;
        }
    }

    public String[] getClassNameSetPropertiesJMS() {
        String[] sNull = null;
        try {
            String value = this.reader.getProperty("org.openspcoop.pubblicazione.setProprietaJMS.class");
            if (value != null) {
                String[] classi = (value = value.trim()).split(",");
                if (classi != null) {
                    for (int i = 0; i < classi.length; ++i) {
                        classi[i] = classi[i].trim();
                    }
                }
                return classi;
            }
            return sNull;
        }
        catch (Exception e) {
            String msg = "Riscontrato errore durante la lettura delle classi da utilizzare per il setting delle proprieta' JMS: " + e.getMessage();
            log.error(msg, (Throwable)e);
            return sNull;
        }
    }
}

