/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core.connettori;

import jakarta.xml.soap.SOAPBody;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSocketFactory;
import org.apache.commons.lang3.StringUtils;
import org.openspcoop2.core.constants.TransferLengthModes;
import org.openspcoop2.core.transazioni.constants.TipoMessaggio;
import org.openspcoop2.message.OpenSPCoop2Message;
import org.openspcoop2.message.OpenSPCoop2SoapMessage;
import org.openspcoop2.message.constants.MessageType;
import org.openspcoop2.message.soap.TunnelSoapUtils;
import org.openspcoop2.pdd.core.connettori.ConnettoreException;
import org.openspcoop2.pdd.core.connettori.ConnettoreExtBaseHTTP;
import org.openspcoop2.pdd.core.connettori.ConnettoreMsg;
import org.openspcoop2.pdd.core.connettori.ConnettoreUtils;
import org.openspcoop2.utils.NameValue;
import org.openspcoop2.utils.Utilities;
import org.openspcoop2.utils.UtilsMultiException;
import org.openspcoop2.utils.date.DateManager;
import org.openspcoop2.utils.io.Base64Utilities;
import org.openspcoop2.utils.io.DumpByteArrayOutputStream;
import org.openspcoop2.utils.resources.Charset;
import org.openspcoop2.utils.resources.Loader;
import org.openspcoop2.utils.transport.TransportUtils;
import org.openspcoop2.utils.transport.http.HttpBodyParameters;
import org.openspcoop2.utils.transport.http.HttpRequestMethod;
import org.openspcoop2.utils.transport.http.HttpUtilities;
import org.openspcoop2.utils.transport.http.RFC2047Encoding;
import org.openspcoop2.utils.transport.http.RFC2047Utilities;
import org.openspcoop2.utils.transport.http.SSLConfig;
import org.openspcoop2.utils.transport.http.SSLUtilities;
import org.openspcoop2.utils.transport.http.WrappedLogSSLSocketFactory;
import org.slf4j.Logger;

public class ConnettoreHTTP
extends ConnettoreExtBaseHTTP {
    public static final String ENDPOINT_TYPE = "httpUrlConn";
    protected HttpURLConnection httpConn = null;
    protected boolean keepAlive = false;

    public ConnettoreHTTP() {
    }

    public ConnettoreHTTP(boolean https) {
        super(https);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean sendHTTP(ConnettoreMsg request) {
        int connectionTimeout = -1;
        boolean connectionTimeoutConfigurazioneGlobale = true;
        int readConnectionTimeout = -1;
        boolean readConnectionTimeoutConfigurazioneGlobale = true;
        try {
            String apiKey;
            NameValue nv;
            Object sslSocketFactory;
            HttpsURLConnection httpsConn;
            if (this.debug) {
                this.logger.debug("Creazione URL...");
            }
            this.buildLocation();
            if (this.debug) {
                this.logger.debug("Creazione URL [" + this.location + "]...");
            }
            URL url = new URI(this.location).toURL();
            HashMap<String, List<String>> propertiesTrasportoDebug = null;
            if (this.isDumpBinarioRichiesta()) {
                propertiesTrasportoDebug = new HashMap<String, List<String>>();
            }
            URLConnection connection = null;
            if (this.proxyType == null) {
                if (this.debug) {
                    this.logger.info("Creazione connessione alla URL [" + this.location + "]...", false);
                }
                connection = url.openConnection();
            } else {
                if (this.debug) {
                    this.logger.info("Creazione connessione alla URL [" + this.location + "] (via proxy " + this.proxyHostname + ":" + this.proxyPort + ") (username[" + this.proxyUsername + "] psw[" + this.proxyPassword + "])...", false);
                }
                if (this.proxyUsername != null) {
                    // empty if block
                }
                Proxy proxy = new Proxy(this.proxyType, new InetSocketAddress(this.proxyHostname, this.proxyPort));
                connection = url.openConnection(proxy);
            }
            this.httpConn = (HttpURLConnection)connection;
            if (this.sslContextProperties != null) {
                httpsConn = (HttpsURLConnection)this.httpConn;
                sslSocketFactory = this.buildSSLContextFactory().getSslSocketFactory(this.requestInfo);
                if (this.debug) {
                    clientCertificateConfigurated = this.sslContextProperties.getKeyStoreLocation();
                    sslSocketFactory = new WrappedLogSSLSocketFactory((SSLSocketFactory)sslSocketFactory, this.logger.getLogger(), this.logger.buildMsg(""), clientCertificateConfigurated);
                }
                httpsConn.setSSLSocketFactory((SSLSocketFactory)sslSocketFactory);
                StringBuilder bfLog = new StringBuilder();
                HostnameVerifier hostnameVerifier = SSLUtilities.generateHostnameVerifier((SSLConfig)this.sslContextProperties, (StringBuilder)bfLog, (Logger)this.logger.getLogger(), (Loader)this.loader);
                if (this.debug) {
                    this.logger.debug(bfLog.toString());
                }
                if (hostnameVerifier != null) {
                    httpsConn.setHostnameVerifier(hostnameVerifier);
                }
            } else if (this.debug && (sslSocketFactory = this.httpConn) instanceof HttpsURLConnection && (httpsConn = (HttpsURLConnection)sslSocketFactory).getSSLSocketFactory() != null) {
                sslSocketFactory = httpsConn.getSSLSocketFactory();
                clientCertificateConfigurated = SSLUtilities.getJvmHttpsClientCertificateConfigurated();
                sslSocketFactory = new WrappedLogSSLSocketFactory((SSLSocketFactory)sslSocketFactory, this.logger.getLogger(), this.logger.buildMsg(""), clientCertificateConfigurated);
                httpsConn.setSSLSocketFactory((SSLSocketFactory)sslSocketFactory);
            }
            this.httpConn.setInstanceFollowRedirects(false);
            MessageType requestMessageType = this.requestMsg.getMessageType();
            OpenSPCoop2SoapMessage soapMessageRequest = null;
            if (this.debug) {
                this.logger.debug("Tipologia Servizio: " + String.valueOf(this.requestMsg.getServiceBinding()));
            }
            if (this.isSoap) {
                soapMessageRequest = this.requestMsg.castAsSoap();
            }
            this.requestMsg.updateContentType();
            if (this.proxyType != null && this.proxyUsername != null) {
                if (this.debug) {
                    this.logger.debug("Impostazione autenticazione per proxy (username[" + this.proxyUsername + "] password[" + this.proxyPassword + "]) ...");
                }
                if (this.proxyUsername != null && this.proxyPassword != null) {
                    String authentication = this.proxyUsername + ":" + this.proxyPassword;
                    authentication = "Basic " + Base64Utilities.encodeAsString((byte[])authentication.getBytes());
                    this.setRequestHeader("Proxy-Authorization", authentication, propertiesTrasportoDebug);
                    if (this.debug) {
                        this.logger.info("Impostazione autenticazione per proxy (username[" + this.proxyUsername + "] password[" + this.proxyPassword + "]) [" + authentication + "]", false);
                    }
                }
            }
            String contentTypeRichiesta = null;
            if (this.debug) {
                this.logger.debug("Impostazione content type...");
            }
            if (this.isSoap) {
                contentTypeRichiesta = this.sbustamentoSoap && soapMessageRequest.countAttachments() > 0 && TunnelSoapUtils.isTunnelOpenSPCoopSoap((OpenSPCoop2SoapMessage)soapMessageRequest) ? TunnelSoapUtils.getContentTypeTunnelOpenSPCoopSoap((SOAPBody)soapMessageRequest.getSOAPBody()) : this.requestMsg.getContentType();
                if (contentTypeRichiesta == null) {
                    throw new ConnettoreException("Content-Type del messaggio da spedire non definito");
                }
            } else {
                contentTypeRichiesta = this.requestMsg.getContentType();
            }
            if (this.debug) {
                this.logger.info("Impostazione http Content-Type [" + contentTypeRichiesta + "]", false);
            }
            if (contentTypeRichiesta != null) {
                this.setRequestHeader("Content-Type", contentTypeRichiesta, propertiesTrasportoDebug);
            }
            if (this.httpMethod == null) {
                throw new ConnettoreException("HttpRequestMethod non definito");
            }
            if (this.debug) {
                this.logger.debug("Impostazione transfer-length...");
            }
            if (TransferLengthModes.TRANSFER_ENCODING_CHUNKED.equals((Object)this.tlm)) {
                HttpUtilities.setChunkedStreamingMode((HttpURLConnection)this.httpConn, (int)this.chunkLength, (HttpRequestMethod)this.httpMethod, (String)contentTypeRichiesta);
            }
            if (this.debug) {
                this.logger.info("Impostazione transfer-length effettuata (chunkLength:" + this.chunkLength + "): " + String.valueOf(this.tlm), false);
            }
            if (this.debug) {
                this.logger.debug("Impostazione timeout...");
            }
            if (this.properties.get("connectionTimeout") != null) {
                try {
                    connectionTimeout = Integer.parseInt((String)this.properties.get("connectionTimeout"));
                    connectionTimeoutConfigurazioneGlobale = this.properties.containsKey("connectionTimeoutGlobale");
                }
                catch (Exception e) {
                    this.logger.error("Parametro 'connectionTimeout' errato", e);
                }
            }
            if (connectionTimeout == -1) {
                connectionTimeout = 10000;
            }
            if (this.properties.get("readConnectionTimeout") != null) {
                try {
                    readConnectionTimeout = Integer.parseInt((String)this.properties.get("readConnectionTimeout"));
                    readConnectionTimeoutConfigurazioneGlobale = this.properties.containsKey("readConnectionTimeoutGlobale");
                }
                catch (Exception e) {
                    this.logger.error("Parametro readConnectionTimeout errato", e);
                }
            }
            if (readConnectionTimeout == -1) {
                readConnectionTimeout = 120000;
            }
            if (this.debug) {
                this.logger.info("Impostazione http timeout CT[" + connectionTimeout + "] RT[" + readConnectionTimeout + "]", false);
            }
            this.httpConn.setConnectTimeout(connectionTimeout);
            this.httpConn.setReadTimeout(readConnectionTimeout);
            if (this.debug) {
                this.logger.debug("Impostazione autenticazione...");
            }
            String user = null;
            String password = null;
            if (this.credenziali != null) {
                user = this.credenziali.getUser();
                password = this.credenziali.getPassword();
            } else {
                user = (String)this.properties.get("user");
                password = (String)this.properties.get("password");
            }
            if (user != null && password != null) {
                String authentication = user + ":" + password;
                authentication = "Basic " + Base64Utilities.encodeAsString((byte[])authentication.getBytes());
                this.setRequestHeader("Authorization", authentication, propertiesTrasportoDebug);
                if (this.debug) {
                    this.logger.info("Impostazione autenticazione (username:" + user + " password:" + password + ") [" + authentication + "]", false);
                }
            }
            if ((nv = this.getTokenHeader()) != null) {
                if (this.requestMsg != null && this.requestMsg.getTransportRequestContext() != null) {
                    this.requestMsg.getTransportRequestContext().removeHeader(nv.getName());
                }
                this.setRequestHeader(nv.getName(), nv.getValue(), propertiesTrasportoDebug);
                if (this.debug) {
                    this.logger.info("Impostazione autenticazione token (header-name '" + nv.getName() + "' value '" + nv.getValue() + "')", false);
                }
            }
            if ((apiKey = (String)this.properties.get("apiKey")) != null && StringUtils.isNotEmpty((CharSequence)apiKey)) {
                String appId;
                String apiKeyHeader = (String)this.properties.get("apiKeyHeader");
                if (apiKeyHeader == null || StringUtils.isEmpty((CharSequence)apiKeyHeader)) {
                    apiKeyHeader = "X-API-KEY";
                }
                this.setRequestHeader(apiKeyHeader, apiKey, propertiesTrasportoDebug);
                if (this.debug) {
                    this.logger.info("Impostazione autenticazione api key [" + apiKeyHeader + "]=[" + apiKey + "]", false);
                }
                if ((appId = (String)this.properties.get("appId")) != null && StringUtils.isNotEmpty((CharSequence)appId)) {
                    String appIdHeader = (String)this.properties.get("appIdHeader");
                    if (appIdHeader == null || StringUtils.isEmpty((CharSequence)appIdHeader)) {
                        appIdHeader = "X-APP-ID";
                    }
                    this.setRequestHeader(appIdHeader, appId, propertiesTrasportoDebug);
                    if (this.debug) {
                        this.logger.info("Impostazione autenticazione api key (app id) [" + appIdHeader + "]=[" + appId + "]", false);
                    }
                }
            }
            if (this.forwardProxyHeaderName != null && this.forwardProxyHeaderValue != null) {
                if (this.requestMsg != null && this.requestMsg.getTransportRequestContext() != null) {
                    this.requestMsg.getTransportRequestContext().removeHeader(this.forwardProxyHeaderName);
                }
                this.setRequestHeader(this.forwardProxyHeaderName, this.forwardProxyHeaderValue, propertiesTrasportoDebug);
                if (this.debug) {
                    this.logger.info("Impostazione ForwardProxy (header-name '" + this.forwardProxyHeaderName + "' value '" + this.forwardProxyHeaderValue + "')", false);
                }
            }
            if (this.debug) {
                this.logger.debug("Impostazione header di trasporto...");
            }
            this.forwardHttpRequestHeader();
            if (this.propertiesTrasporto != null) {
                for (String key : this.propertiesTrasporto.keySet()) {
                    List values = (List)this.propertiesTrasporto.get(key);
                    if (this.debug && values != null && !values.isEmpty()) {
                        for (Object value : values) {
                            this.logger.info("Set Transport Header [" + key + "]=[" + (String)value + "]", false);
                        }
                    }
                    if (this.encodingRFC2047) {
                        ArrayList<String> valuesEncoded = new ArrayList<String>();
                        if (values != null && !values.isEmpty()) {
                            Object value;
                            value = values.iterator();
                            while (value.hasNext()) {
                                String value2 = (String)value.next();
                                if (!RFC2047Utilities.isAllCharactersInCharset((String)value2, (Charset)this.charsetRFC2047)) {
                                    String encoded = RFC2047Utilities.encode((String)value2, (Charset)this.charsetRFC2047, (RFC2047Encoding)this.encodingAlgorithmRFC2047);
                                    if (this.debug) {
                                        this.logger.info("RFC2047 Encoded value in [" + encoded + "] (charset:" + String.valueOf(this.charsetRFC2047) + " encoding-algorithm:" + String.valueOf(this.encodingAlgorithmRFC2047) + ")", false);
                                    }
                                    valuesEncoded.add(encoded);
                                    continue;
                                }
                                valuesEncoded.add(value2);
                            }
                        }
                        this.setRequestHeader(this.validazioneHeaderRFC2047, key, valuesEncoded, this.logger, propertiesTrasportoDebug);
                        continue;
                    }
                    this.setRequestHeader(this.validazioneHeaderRFC2047, key, values, this.logger, propertiesTrasportoDebug);
                }
            }
            if (this.isSoap && !this.sbustamentoSoap) {
                if (this.debug) {
                    this.logger.debug("Impostazione soap action...");
                }
                boolean existsTransportProperties = false;
                if (TransportUtils.containsKey((Map)this.propertiesTrasporto, (String)"SOAPAction")) {
                    this.soapAction = TransportUtils.getFirstValue((Map)this.propertiesTrasporto, (String)"SOAPAction");
                    boolean bl = existsTransportProperties = this.soapAction != null;
                }
                if (!existsTransportProperties) {
                    this.soapAction = soapMessageRequest.getSoapAction();
                }
                if (this.soapAction == null) {
                    this.soapAction = "\"OpenSPCoop\"";
                }
                if (MessageType.SOAP_11.equals((Object)this.requestMsg.getMessageType()) && !existsTransportProperties) {
                    this.setRequestHeader("SOAPAction", this.soapAction, propertiesTrasportoDebug);
                }
                if (this.debug) {
                    this.logger.info("SOAP Action inviata [" + this.soapAction + "]", false);
                }
            }
            if (this.debug) {
                this.logger.info("Impostazione " + String.valueOf(this.httpMethod) + "...", false);
            }
            HttpUtilities.setStream((HttpURLConnection)this.httpConn, (HttpRequestMethod)this.httpMethod, (String)contentTypeRichiesta);
            HttpBodyParameters httpBody = new HttpBodyParameters(this.httpMethod, contentTypeRichiesta);
            boolean httpBodyIsDoOutput = httpBody.isDoOutput();
            if (!httpBody.isDoOutput() && request.isForceSendContent()) {
                this.httpConn.setDoOutput(true);
                httpBodyIsDoOutput = true;
            }
            if (httpBodyIsDoOutput) {
                block144: {
                    boolean consumeRequestMessage = true;
                    if (this.followRedirects) {
                        consumeRequestMessage = false;
                    }
                    if (this.debug) {
                        this.logger.debug("Spedizione byte (consume-request-message:" + consumeRequestMessage + ")...");
                    }
                    OutputStream out = this.httpConn.getOutputStream();
                    if (this.isDumpBinarioRichiesta()) {
                        DumpByteArrayOutputStream bout = new DumpByteArrayOutputStream(this.dumpBinarioSoglia, this.dumpBinarioRepositoryFile, this.idTransazione, TipoMessaggio.RICHIESTA_USCITA_DUMP_BINARIO.getValue());
                        try {
                            this.emitDiagnosticStartDumpBinarioRichiestaUscita();
                            if (this.isSoap && this.sbustamentoSoap) {
                                this.logger.debug("Sbustamento...");
                                TunnelSoapUtils.sbustamentoMessaggio((OpenSPCoop2Message)soapMessageRequest, (OutputStream)bout);
                            } else {
                                this.requestMsg.writeTo((OutputStream)bout, consumeRequestMessage);
                            }
                            bout.flush();
                            bout.close();
                            if (bout.isSerializedOnFileSystem()) {
                                try (FileInputStream fin = new FileInputStream(bout.getSerializedFile());){
                                    Utilities.copy((InputStream)fin, (OutputStream)out);
                                }
                            } else {
                                out.write(bout.toByteArray());
                            }
                            out.flush();
                            out.close();
                            this.dataRichiestaInoltrata = DateManager.getDate();
                            this.dumpBinarioRichiestaUscita(bout, requestMessageType, contentTypeRichiesta, this.location, propertiesTrasportoDebug);
                        }
                        finally {
                            try {
                                bout.clearResources();
                            }
                            catch (Throwable t) {
                                this.logger.error("Release resources failed: " + t.getMessage(), t);
                            }
                        }
                    }
                    if (this.isSoap && this.sbustamentoSoap) {
                        if (this.debug) {
                            this.logger.debug("Sbustamento...");
                        }
                        TunnelSoapUtils.sbustamentoMessaggio((OpenSPCoop2Message)soapMessageRequest, (OutputStream)out);
                    } else {
                        this.requestMsg.writeTo(out, consumeRequestMessage);
                    }
                    try {
                        out.flush();
                        out.close();
                    }
                    catch (IOException io) {
                        if (io.getMessage() != null && io.getMessage().equals("closed")) break block144;
                        throw io;
                    }
                }
                this.dataRichiestaInoltrata = DateManager.getDate();
            } else if (this.isDumpBinarioRichiesta()) {
                this.emitDiagnosticStartDumpBinarioRichiestaUscita();
                this.dumpBinarioRichiestaUscita(null, null, null, this.location, propertiesTrasportoDebug);
            }
            if (this.debug) {
                this.logger.debug("Analisi risposta...");
            }
            Map<String, List<String>> mapHeaderHttpResponse = this.httpConn.getHeaderFields();
            boolean protocolHttp10 = false;
            if (mapHeaderHttpResponse != null && mapHeaderHttpResponse.size() > 0) {
                if (this.propertiesTrasportoRisposta == null) {
                    this.propertiesTrasportoRisposta = new HashMap();
                }
                for (String keyHttpResponse : mapHeaderHttpResponse.keySet()) {
                    List<String> valueHttpResponse = mapHeaderHttpResponse.get(keyHttpResponse);
                    if (valueHttpResponse != null) {
                        for (int i = 0; i < valueHttpResponse.size(); ++i) {
                            if (!this.debug) continue;
                            this.logger.debug("HTTP risposta [" + keyHttpResponse + "] [" + valueHttpResponse.get(i) + "]...");
                        }
                    }
                    if (keyHttpResponse == null) {
                        keyHttpResponse = "ReturnCode";
                        if (valueHttpResponse != null && valueHttpResponse.contains("/1.0")) {
                            protocolHttp10 = true;
                        }
                    }
                    this.propertiesTrasportoRisposta.put(keyHttpResponse, valueHttpResponse);
                }
            }
            this.setKeepAlive(protocolHttp10, TransportUtils.getObjectAsString(mapHeaderHttpResponse, (String)"Connection"));
            this.tipoRisposta = TransportUtils.getObjectAsString(mapHeaderHttpResponse, (String)"Content-Type");
            String contentLenghtString = TransportUtils.getObjectAsString(mapHeaderHttpResponse, (String)"Content-Length");
            if (contentLenghtString != null) {
                this.contentLength = Integer.valueOf(contentLenghtString).intValue();
            } else if (this.httpConn.getContentLength() > 0) {
                this.contentLength = this.httpConn.getContentLength();
            }
            if (this.isSoap) {
                this.imbustamentoConAttachment = false;
                if ("true".equals(TransportUtils.getObjectAsString(mapHeaderHttpResponse, (String)this.openspcoopProperties.getTunnelSOAPKeyWord_headerTrasporto()))) {
                    this.imbustamentoConAttachment = true;
                }
                this.mimeTypeAttachment = TransportUtils.getObjectAsString(mapHeaderHttpResponse, (String)this.openspcoopProperties.getTunnelSOAPKeyWordMimeType_headerTrasporto());
                if (this.mimeTypeAttachment == null) {
                    this.mimeTypeAttachment = "application/openspcoop2";
                }
            }
            if (this.debug) {
                this.logger.debug("Analisi risposta input stream e risultato http...");
            }
            this.initConfigurationAcceptOnlyReturnCode202or200();
            this.codice = this.httpConn.getResponseCode();
            this.resultHTTPMessage = this.httpConn.getResponseMessage();
            if (this.codice >= 400) {
                this.isResponse = this.httpConn.getErrorStream();
            } else if (this.codice > 299) {
                String redirectLocation = TransportUtils.getObjectAsString(mapHeaderHttpResponse, (String)"Location");
                if (this.followRedirects) {
                    if (redirectLocation == null) {
                        throw new ConnettoreException("Non \u00e8 stato rilevato l'header HTTP [Location] necessario alla gestione del Redirect (code:" + this.codice + ")");
                    }
                    TransportUtils.removeObject(request.getConnectorProperties(), (String)"location");
                    TransportUtils.removeObject(request.getConnectorProperties(), (String)"numberRedirect");
                    TransportUtils.removeObject(request.getConnectorProperties(), (String)"routeRedirect");
                    request.getConnectorProperties().put("location", redirectLocation);
                    request.getConnectorProperties().put("numberRedirect", "" + (this.numberRedirect + 1));
                    if (this.routeRedirect != null) {
                        request.getConnectorProperties().put("routeRedirect", this.routeRedirect + " -> " + redirectLocation);
                    } else {
                        request.getConnectorProperties().put("routeRedirect", redirectLocation);
                    }
                    if (this.originalAbsolutePrefixForRelativeRedirectLocation == null) {
                        this.originalAbsolutePrefixForRelativeRedirectLocation = url.getProtocol() + "://" + url.getHost() + ":" + url.getPort();
                    }
                    this.redirectLocation = redirectLocation;
                    if (this.redirectLocation.startsWith("/")) {
                        this.redirectLocation = this.originalAbsolutePrefixForRelativeRedirectLocation + this.redirectLocation;
                    }
                    this.logger.warn("(hope:" + (this.numberRedirect + 1) + ") Redirect verso [" + redirectLocation + "] ...");
                    if (this.numberRedirect == this.maxNumberRedirects) {
                        throw new ConnettoreException(ConnettoreUtils.getPrefixRedirect(this.codice, redirectLocation) + "non consentita ulteriormente, sono gi\u00e0 stati gestiti " + this.maxNumberRedirects + " redirects: " + this.routeRedirect);
                    }
                    boolean acceptOnlyReturnCode307 = false;
                    if (this.isSoap) {
                        acceptOnlyReturnCode307 = "ConsegnaContenutiApplicativi".equals(this.idModulo) ? this.openspcoopProperties.isAcceptOnlyReturnCode_307_consegnaContenutiApplicativi() : this.openspcoopProperties.isAcceptOnlyReturnCode_307_inoltroBuste();
                    }
                    if (acceptOnlyReturnCode307 && this.codice != 307) {
                        throw new ConnettoreException("Return code [" + this.codice + "] (redirect Location:" + redirectLocation + ") non consentito dal WS-I Basic Profile (http://www.ws-i.org/Profiles/BasicProfile-1.1-2004-08-24.html#HTTP_Redirect_Status_Codes)");
                    }
                    this.clearRequestHeader();
                    if (this.propertiesTrasportoRisposta != null) {
                        this.propertiesTrasportoRisposta.clear();
                    }
                    this.contentLength = -1L;
                    this.disconnect();
                    return this.send(request);
                }
                if (this.isSoap) {
                    throw new ConnettoreException(ConnettoreUtils.getPrefixRedirect(this.codice, redirectLocation) + "non attiva");
                }
                this.logger.debug(ConnettoreUtils.getPrefixRedirect(this.codice, redirectLocation) + "non attiva");
                if (this.location != null && redirectLocation != null) {
                    this.location = this.location + " [redirect-location: " + redirectLocation + "]";
                }
                if (httpBody.isDoInput()) {
                    this.isResponse = this.httpConn.getInputStream();
                    if (this.isResponse == null) {
                        this.isResponse = this.httpConn.getErrorStream();
                    }
                }
            } else {
                if (this.isSoap && this.acceptOnlyReturnCode202or200 && this.codice != 200 && this.codice != 202) {
                    throw new ConnettoreException("Return code [" + this.codice + "] non consentito dal WS-I Basic Profile (http://www.ws-i.org/Profiles/BasicProfile-1.1-2004-08-24.html#HTTP_Success_Status_Codes)");
                }
                if (httpBody.isDoInput()) {
                    this.isResponse = this.httpConn.getInputStream();
                }
            }
            this.postOutRequest();
            this.preInResponse();
            this.notifierInputStreamParams = null;
            if (this.preInResponseContext != null) {
                this.notifierInputStreamParams = this.preInResponseContext.getNotifierInputStreamParams();
            }
            this.normalizeInputStreamResponse(readConnectionTimeout, readConnectionTimeoutConfigurazioneGlobale);
            this.initCheckContentTypeConfiguration();
            if (this.isDumpBinarioRisposta() && !this.dumpResponse(this.propertiesTrasportoRisposta)) {
                return false;
            }
            if (this.isRest ? !this.doRestResponse() : !this.doSoapResponse()) {
                return false;
            }
            if (this.debug) {
                this.logger.info("Gestione invio/risposta http effettuata con successo", false);
            }
            return true;
        }
        catch (Exception e) {
            this.eccezioneProcessamento = e;
            String msgErrore = this.readExceptionMessageFromException(e);
            this.errore = this.generateErrorWithConnectorPrefix ? "Errore avvenuto durante la consegna HTTP: " + msgErrore : msgErrore;
            this.logger.error("Errore avvenuto durante la consegna HTTP: " + msgErrore, e);
            this.processConnectionTimeoutException(connectionTimeout, connectionTimeoutConfigurazioneGlobale, e, msgErrore);
            this.processReadTimeoutException(readConnectionTimeout, readConnectionTimeoutConfigurazioneGlobale, e, msgErrore);
            return false;
        }
    }

    @Override
    public void disconnect() throws ConnettoreException {
        ArrayList<Throwable> listExceptionChiusura = new ArrayList<Throwable>();
        try {
            if (this.isResponse != null) {
                if (this.debug && this.logger != null) {
                    this.logger.debug("Chiusura socket...");
                }
                try {
                    this.isResponse.close();
                }
                catch (Throwable t) {
                    if (this.logger != null) {
                        this.logger.debug("Chiusura socket fallita: " + t.getMessage(), t);
                    }
                    listExceptionChiusura.add(t);
                }
            }
            if (this.httpConn != null) {
                if (this.debug && this.logger != null) {
                    this.logger.debug("Chiusura connessione...");
                }
                try {
                    if (!this.keepAlive) {
                        this.httpConn.disconnect();
                    }
                }
                catch (Throwable t) {
                    if (this.logger != null) {
                        this.logger.debug("Chiusura connessione fallita: " + t.getMessage(), t);
                    }
                    listExceptionChiusura.add(t);
                }
            }
            try {
                super.disconnect();
            }
            catch (Throwable t) {
                if (this.logger != null) {
                    this.logger.debug("Chiusura risorse fallita: " + t.getMessage(), t);
                }
                listExceptionChiusura.add(t);
            }
        }
        catch (Exception e) {
            throw new ConnettoreException("Chiusura connessione non riuscita: " + e.getMessage(), e);
        }
        if (!listExceptionChiusura.isEmpty()) {
            UtilsMultiException multiException = new UtilsMultiException(listExceptionChiusura.toArray(new Throwable[1]));
            throw new ConnettoreException("Chiusura connessione non riuscita: " + multiException.getMessage(), multiException);
        }
    }

    private void setKeepAlive(boolean protocolHttp10, String connectionHeaderValue) {
        this.keepAlive = "close".equalsIgnoreCase(connectionHeaderValue) ? false : (!protocolHttp10 ? true : (connectionHeaderValue != null ? "keep-alive".equalsIgnoreCase(connectionHeaderValue) : false));
    }

    @Override
    protected String getTipoImplConnettore() {
        if (this.tipoConnettore != null && StringUtils.isNotEmpty((CharSequence)this.tipoConnettore)) {
            return this.tipoConnettore;
        }
        return this.connettoreHttps ? "httpsUrlConn" : ENDPOINT_TYPE;
    }

    @Override
    protected void setRequestHeader(String key, List<String> values) throws ConnettoreException {
        if (values != null && !values.isEmpty()) {
            for (String value : values) {
                this.httpConn.addRequestProperty(key, value);
            }
        }
    }
}

