/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core.connettori;

import java.util.ArrayList;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.openspcoop2.pdd.core.connettori.AbstractConnettoreConnection;
import org.openspcoop2.pdd.logger.OpenSPCoop2Logger;
import org.openspcoop2.utils.threads.BaseThread;
import org.slf4j.Logger;

public abstract class AbstractConnettoreConnectionEvictor
extends BaseThread {
    protected int closeIdleConnectionsAfterSeconds;
    protected boolean debug;
    protected Logger logConnettori;
    private Map<String, Object> mapConnection;
    private String id;

    protected AbstractConnettoreConnectionEvictor(boolean debug, int sleepTimeSeconds, int closeIdleConnectionsAfterSeconds, Object mapConnection, String id) {
        this.setTimeout(sleepTimeSeconds);
        this.debug = debug;
        this.closeIdleConnectionsAfterSeconds = closeIdleConnectionsAfterSeconds;
        this.logConnettori = OpenSPCoop2Logger.getLoggerOpenSPCoopConnettori();
        this.mapConnection = (Map)mapConnection;
        this.id = id;
    }

    protected String getIdConnettore() {
        return this.id;
    }

    protected void logDebug(String msg) {
        if (this.logConnettori != null) {
            this.logConnettori.debug(msg);
        }
    }

    protected void logDebug(String msg, Exception e) {
        if (this.logConnettori != null) {
            this.logConnettori.debug(msg, (Throwable)e);
        }
    }

    protected void logError(String msg) {
        if (this.logConnettori != null) {
            this.logConnettori.error(msg);
        }
    }

    protected void logError(String msg, Exception e) {
        if (this.logConnettori != null) {
            this.logConnettori.error(msg, (Throwable)e);
        }
    }

    protected abstract String getLogPrefix();

    protected void print(StringBuilder sb, String msg) {
        if (sb != null) {
            sb.append(msg + "\n");
        } else {
            this.logDebug(this.getLogPrefix() + msg);
        }
    }

    protected void printError(StringBuilder sb, String msg) {
        if (sb != null) {
            sb.append(msg + "\n");
        } else {
            this.logError(this.getLogPrefix() + msg);
        }
    }

    protected void printError(StringBuilder sb, String msg, Exception e) {
        if (sb != null) {
            sb.append(msg + "\n");
        } else {
            this.logError(this.getLogPrefix() + msg, e);
        }
    }

    protected abstract boolean check();

    protected void process() {
        boolean check = this.check();
        if (check) {
            this.check(null);
        }
    }

    protected void check(StringBuilder sb) {
        ArrayList<String> removedKeys = new ArrayList<String>();
        if (this.mapConnection != null) {
            this.print(sb, "Client attivi: " + this.mapConnection.size());
            for (Map.Entry<String, Object> entry : this.mapConnection.entrySet()) {
                String key = entry.getKey();
                if (key == null) continue;
                String prefix = "Client (" + key + ") ";
                Object o = this.mapConnection.get(key);
                AbstractConnettoreConnection connection = null;
                if (!(o instanceof AbstractConnettoreConnection)) {
                    this.printError(sb, prefix + "Incompatible type '" + o.getClass().getName() + "'");
                    continue;
                }
                connection = (AbstractConnettoreConnection)o;
                if (!connection.isExpired()) {
                    connection.checkExpire();
                }
                if (this.debug && connection != null) {
                    String status = connection.getStatus();
                    if (status != null && StringUtils.isNotEmpty((CharSequence)status)) {
                        this.print(sb, prefix + "(expired:" + connection.isExpired() + "): status: " + connection.getStatus());
                    } else {
                        this.print(sb, prefix + "(expired:" + connection.isExpired() + ")");
                    }
                }
                if (!connection.isExpired() || !connection.isReadyForClose()) continue;
                removedKeys.add(key);
            }
            while (!removedKeys.isEmpty()) {
                String key = (String)removedKeys.remove(0);
                String prefix = "Client (" + key + ") ";
                this.logDebug(prefix + "close unused connection ...");
                Object o = this.mapConnection.get(key);
                AbstractConnettoreConnection connection = null;
                if (!(o instanceof AbstractConnettoreConnection)) {
                    this.printError(sb, prefix + "close unused connection failed: incompatible type '" + o.getClass().getName() + "'");
                    continue;
                }
                connection = (AbstractConnettoreConnection)o;
                try {
                    connection.close();
                    this.print(sb, prefix + "close unused connection ok");
                    this.mapConnection.remove(key);
                }
                catch (Exception e) {
                    this.printError(sb, prefix + "close unused connection failed: " + e.getMessage(), e);
                }
            }
        }
    }
}

