/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core.byok;

import java.util.Map;
import org.openspcoop2.security.SecurityException;
import org.openspcoop2.security.keystore.BYOKUnwrapManager;
import org.openspcoop2.utils.certificate.byok.BYOKProvider;
import org.openspcoop2.utils.certificate.byok.BYOKRequestParams;
import org.openspcoop2.utils.transport.http.IBYOKUnwrapManager;

public class BYOKUnwrapPolicyUtilities {
    private BYOKUnwrapPolicyUtilities() {
    }

    public static BYOKRequestParams getBYOKRequestParams(String keystoreByokPolicy, Map<String, Object> dynamicMap) throws SecurityException {
        BYOKRequestParams byokParams = null;
        if (BYOKProvider.isPolicyDefined((String)keystoreByokPolicy)) {
            try {
                byokParams = BYOKProvider.getBYOKRequestParamsByUnwrapBYOKPolicy((String)keystoreByokPolicy, dynamicMap);
            }
            catch (Exception e) {
                throw new SecurityException(e.getMessage(), (Throwable)e);
            }
        }
        return byokParams;
    }

    public static IBYOKUnwrapManager getBYOKUnwrapManager(String keystoreByokPolicy, Map<String, Object> dynamicMap) throws SecurityException {
        BYOKRequestParams byokParams = BYOKUnwrapPolicyUtilities.getBYOKRequestParams(keystoreByokPolicy, dynamicMap);
        BYOKUnwrapManager byokUnwrapManager = null;
        if (byokParams != null) {
            byokUnwrapManager = new BYOKUnwrapManager(keystoreByokPolicy, byokParams);
        }
        return byokUnwrapManager;
    }
}

