/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core.behaviour.conditional;

import java.util.Set;
import java.util.TreeMap;
import org.openspcoop2.core.registry.Resource;
import org.openspcoop2.pdd.core.Utilities;
import org.openspcoop2.pdd.core.behaviour.BehaviourException;
import org.openspcoop2.pdd.core.behaviour.conditional.ConfigurazioneSelettoreCondizione;
import org.openspcoop2.pdd.core.behaviour.conditional.ConfigurazioneSelettoreCondizioneRegola;
import org.openspcoop2.pdd.core.behaviour.conditional.IdentificazioneFallitaConfigurazione;
import org.openspcoop2.utils.regexp.RegExpException;
import org.openspcoop2.utils.regexp.RegExpNotFoundException;
import org.openspcoop2.utils.regexp.RegExpNotValidException;
import org.openspcoop2.utils.regexp.RegularExpressionEngine;

public class ConfigurazioneCondizionale {
    private boolean byFilter = true;
    private ConfigurazioneSelettoreCondizione defaultConfig;
    private TreeMap<String, ConfigurazioneSelettoreCondizioneRegola> regolaList = new TreeMap();
    private IdentificazioneFallitaConfigurazione condizioneNonIdentificata;
    private IdentificazioneFallitaConfigurazione nessunConnettoreTrovato;

    public boolean isByFilter() {
        return this.byFilter;
    }

    public void setByFilter(boolean byFilter) {
        this.byFilter = byFilter;
    }

    public ConfigurazioneSelettoreCondizione getDefaultConfig() {
        return this.defaultConfig;
    }

    public void setDefaultConfig(ConfigurazioneSelettoreCondizione defaultConfig) {
        this.defaultConfig = defaultConfig;
    }

    public void addRegola(ConfigurazioneSelettoreCondizioneRegola config) throws BehaviourException {
        if (config.getRegola() == null) {
            throw new BehaviourException("Nome Regola non indicata");
        }
        if (!this.regolaList.isEmpty()) {
            for (String nomeRegola : this.regolaList.keySet()) {
                if (!nomeRegola.equalsIgnoreCase(config.getRegola())) continue;
                throw new BehaviourException("Esiste gi\u00e0 una regola con nome '" + nomeRegola + "'");
            }
        }
        this.regolaList.put(config.getRegola(), config);
    }

    public ConfigurazioneSelettoreCondizioneRegola getRegolaByOperazione(String operazione, Resource restResource) throws RegExpException {
        if (!this.regolaList.isEmpty()) {
            for (String nomeRegola : this.getRegoleOrdinate()) {
                ConfigurazioneSelettoreCondizioneRegola config = this.regolaList.get(nomeRegola);
                boolean match = this.isMatch(operazione, restResource, config);
                if (!match) continue;
                return config;
            }
        }
        return null;
    }

    private boolean isMatch(String operazione, Resource restResource, ConfigurazioneSelettoreCondizioneRegola config) throws RegExpException {
        String[] parseResourceRest;
        boolean match = false;
        if (operazione.equals(config.getPatternOperazione())) {
            match = true;
        }
        if (!match && restResource != null && config.getPatternOperazione() != null && !"".equals(config.getPatternOperazione()) && (parseResourceRest = Utilities.parseResourceRest(config.getPatternOperazione())) != null) {
            match = Utilities.isRestResourceMatch(parseResourceRest, restResource);
        }
        if (!match) {
            boolean exprRegular = false;
            try {
                RegularExpressionEngine.validate((String)config.getPatternOperazione());
                exprRegular = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (exprRegular) {
                try {
                    match = RegularExpressionEngine.isMatch((String)operazione, (String)config.getPatternOperazione());
                }
                catch (RegExpNotFoundException | RegExpNotValidException throwable) {
                    // empty catch block
                }
            }
        }
        return match;
    }

    public String getNomeRegolaByOperazione(String operazione, Resource restResource) throws RegExpException {
        ConfigurazioneSelettoreCondizioneRegola c = this.getRegolaByOperazione(operazione, restResource);
        return c != null ? c.getRegola() : null;
    }

    public ConfigurazioneSelettoreCondizioneRegola getRegola(String nomeRegola) {
        return this.regolaList.get(nomeRegola);
    }

    public Set<String> getRegoleOrdinate() {
        return this.regolaList.keySet();
    }

    public void removeRegola(String nomeRegola) {
        this.regolaList.remove(nomeRegola);
    }

    public int sizeRegole() {
        return this.regolaList.size();
    }

    public TreeMap<String, ConfigurazioneSelettoreCondizioneRegola> getRegolaList() {
        return this.regolaList;
    }

    public void setRegolaList(TreeMap<String, ConfigurazioneSelettoreCondizioneRegola> regolaList) {
        this.regolaList = regolaList;
    }

    public IdentificazioneFallitaConfigurazione getCondizioneNonIdentificata() {
        return this.condizioneNonIdentificata;
    }

    public void setCondizioneNonIdentificata(IdentificazioneFallitaConfigurazione condizioneNonIdentificata) {
        this.condizioneNonIdentificata = condizioneNonIdentificata;
    }

    public IdentificazioneFallitaConfigurazione getNessunConnettoreTrovato() {
        return this.nessunConnettoreTrovato;
    }

    public void setNessunConnettoreTrovato(IdentificazioneFallitaConfigurazione nessunConnettoreTrovato) {
        this.nessunConnettoreTrovato = nessunConnettoreTrovato;
    }
}

