/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core.behaviour.built_in.load_balance;

import org.openspcoop2.core.config.PortaApplicativa;
import org.openspcoop2.core.config.PortaApplicativaServizioApplicativo;
import org.openspcoop2.core.config.constants.StatoFunzionalita;
import org.openspcoop2.core.id.IDServizioApplicativo;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.message.OpenSPCoop2Message;
import org.openspcoop2.pdd.core.CostantiPdD;
import org.openspcoop2.pdd.core.GestoreMessaggi;
import org.openspcoop2.pdd.core.behaviour.AbstractBehaviour;
import org.openspcoop2.pdd.core.behaviour.Behaviour;
import org.openspcoop2.pdd.core.behaviour.BehaviourEmitDiagnosticException;
import org.openspcoop2.pdd.core.behaviour.BehaviourException;
import org.openspcoop2.pdd.core.behaviour.BehaviourForwardTo;
import org.openspcoop2.pdd.core.behaviour.BehaviourForwardToFilter;
import org.openspcoop2.pdd.core.behaviour.BehaviourLoadBalancer;
import org.openspcoop2.pdd.core.behaviour.IBehaviour;
import org.openspcoop2.pdd.core.behaviour.built_in.load_balance.ConfigurazioneLoadBalancer;
import org.openspcoop2.pdd.logger.OpenSPCoop2Logger;
import org.openspcoop2.protocol.sdk.Busta;
import org.openspcoop2.protocol.sdk.state.IState;
import org.openspcoop2.protocol.sdk.state.RequestInfo;

public class LoadBalancerBehaviour
extends AbstractBehaviour
implements IBehaviour {
    private IState state;

    public LoadBalancerBehaviour(IState state) {
        this.state = state;
    }

    @Override
    public Behaviour behaviour(GestoreMessaggi gestoreMessaggioRichiesta, Busta busta, PortaApplicativa pa, RequestInfo requestInfo) throws BehaviourException, BehaviourEmitDiagnosticException {
        Behaviour behaviour = null;
        try {
            behaviour = new Behaviour();
            OpenSPCoop2Message msg = null;
            try {
                msg = gestoreMessaggioRichiesta.getMessage();
            }
            catch (Exception e) {
                throw new BehaviourException(e.getMessage(), e);
            }
            ConfigurazioneLoadBalancer config = ConfigurazioneLoadBalancer.read(pa, msg, busta, requestInfo, this.getPddContext(), this.msgDiag, OpenSPCoop2Logger.getLoggerOpenSPCoopCore(), this.state);
            if (config.getPool().isEmpty()) {
                throw new BehaviourException("Nessun connettore selezionabile");
            }
            if (config.getConnectorSelected() == null || "".equals(config.getConnectorSelected())) {
                throw new BehaviourException("Nessun connettore selezionato");
            }
            String nomeConnettore = config.getConnectorSelected();
            for (PortaApplicativaServizioApplicativo servizioApplicativo : pa.getServizioApplicativoList()) {
                if (servizioApplicativo.getDatiConnettore() != null && servizioApplicativo.getDatiConnettore().getStato() != null && !StatoFunzionalita.ABILITATO.equals((Object)servizioApplicativo.getDatiConnettore().getStato())) continue;
                String nomeConnettoreSA = "Default";
                if (servizioApplicativo.getDatiConnettore() != null && servizioApplicativo.getDatiConnettore().getNome() != null) {
                    nomeConnettoreSA = servizioApplicativo.getDatiConnettore().getNome();
                }
                if (!nomeConnettore.equals(nomeConnettoreSA)) continue;
                BehaviourForwardTo forwardTo = new BehaviourForwardTo();
                BehaviourForwardToFilter filter = new BehaviourForwardToFilter();
                forwardTo.setFilter(filter);
                IDServizioApplicativo id = new IDServizioApplicativo();
                id.setIdSoggettoProprietario(new IDSoggetto(busta.getTipoDestinatario(), busta.getDestinatario()));
                id.setNome(servizioApplicativo.getNome());
                filter.getAccessListServiziApplicativi().add(id);
                behaviour.getForwardTo().add(forwardTo);
                this.getPddContext().addObject(CostantiPdD.CONNETTORE_MULTIPLO_SELEZIONATO, servizioApplicativo.getNome());
                BehaviourLoadBalancer c = new BehaviourLoadBalancer();
                c.setLoadBalancerPool(config.getPool());
                c.setConnectorName(nomeConnettore);
                behaviour.setLoadBalancer(c);
                break;
            }
        }
        catch (BehaviourEmitDiagnosticException e) {
            throw e;
        }
        catch (BehaviourException e) {
            throw e;
        }
        return behaviour;
    }
}

