/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core.autorizzazione.pa;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import org.openspcoop2.core.id.IDServizio;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.core.registry.driver.IDServizioFactory;
import org.openspcoop2.message.OpenSPCoop2Message;
import org.openspcoop2.pdd.core.autorizzazione.AutorizzazioneException;
import org.openspcoop2.pdd.core.autorizzazione.pa.AbstractAutorizzazioneContenutoBase;
import org.openspcoop2.pdd.core.autorizzazione.pa.DatiInvocazionePortaApplicativa;
import org.openspcoop2.pdd.core.autorizzazione.pa.EsitoAutorizzazionePortaApplicativa;
import org.openspcoop2.pdd.logger.OpenSPCoop2Logger;
import org.openspcoop2.protocol.sdk.constants.CodiceErroreCooperazione;
import org.openspcoop2.protocol.sdk.constants.ErroriCooperazione;
import org.openspcoop2.protocol.sdk.constants.IntegrationFunctionError;

public class AutorizzazioneContenutoBusteKO
extends AbstractAutorizzazioneContenutoBase {
    @Override
    public EsitoAutorizzazionePortaApplicativa process(DatiInvocazionePortaApplicativa datiInvocazione, OpenSPCoop2Message msg) throws AutorizzazioneException {
        EsitoAutorizzazionePortaApplicativa esito = new EsitoAutorizzazionePortaApplicativa();
        try {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            msg.writeTo((OutputStream)bout, false);
            bout.flush();
            bout.close();
            System.out.println("(TestKO) Messaggio ricevuto (Ruolo busta: " + datiInvocazione.getRuoloBusta().toString() + "): " + bout.toString());
            IDSoggetto soggettoFruitore = datiInvocazione.getIdSoggettoFruitore();
            IDServizio servizio = datiInvocazione.getIdServizio();
            String errore = "Il soggetto " + soggettoFruitore.getTipo() + "/" + soggettoFruitore.getNome() + " non e' autorizzato ad invocare il servizio " + IDServizioFactory.getInstance().getUriFromIDServizio(servizio) + " con il contenuto applicativo fornito";
            esito.setErroreCooperazione(IntegrationFunctionError.CONTENT_AUTHORIZATION_DENY, ErroriCooperazione.AUTORIZZAZIONE_FALLITA.getErroreAutorizzazione(errore, CodiceErroreCooperazione.SICUREZZA_AUTORIZZAZIONE_FALLITA));
            esito.setAutorizzato(false);
            return esito;
        }
        catch (Exception e) {
            esito.setEccezioneProcessamento(e);
            OpenSPCoop2Logger.getLoggerOpenSPCoopCore().error("Autorizzazione per contenuto non riuscita", (Throwable)e);
            throw new AutorizzazioneException("Errore di processamento durante l'autorizzazione per contenuto buste: " + e.getMessage(), e);
        }
    }
}

