/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core.autorizzazione.pa;

import java.util.List;
import org.herasaf.xacml.core.context.impl.DecisionType;
import org.openspcoop2.core.id.IDServizio;
import org.openspcoop2.core.id.IDServizioApplicativo;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.pdd.core.autorizzazione.AutorizzazioneException;
import org.openspcoop2.pdd.core.autorizzazione.XACMLPolicyUtilities;
import org.openspcoop2.pdd.core.autorizzazione.pa.AbstractAutorizzazioneBase;
import org.openspcoop2.pdd.core.autorizzazione.pa.DatiInvocazionePortaApplicativa;
import org.openspcoop2.pdd.core.autorizzazione.pa.EsitoAutorizzazionePortaApplicativa;
import org.openspcoop2.pdd.logger.OpenSPCoop2Logger;
import org.openspcoop2.protocol.sdk.constants.CodiceErroreCooperazione;
import org.openspcoop2.protocol.sdk.constants.CodiceErroreIntegrazione;
import org.openspcoop2.protocol.sdk.constants.ErroriCooperazione;
import org.openspcoop2.protocol.sdk.constants.ErroriIntegrazione;
import org.openspcoop2.protocol.sdk.constants.IntegrationFunctionError;
import org.openspcoop2.utils.Semaphore;
import org.openspcoop2.utils.SemaphoreLock;
import org.openspcoop2.utils.xacml.MarshallUtilities;
import org.openspcoop2.utils.xacml.PolicyDecisionPoint;
import org.openspcoop2.utils.xacml.ResultCombining;
import org.openspcoop2.utils.xacml.ResultUtilities;
import org.openspcoop2.utils.xacml.XacmlRequest;
import org.slf4j.Logger;

abstract class AbstractAutorizzazioneXacmlPolicy
extends AbstractAutorizzazioneBase {
    private boolean checkRuoloRegistro;
    private boolean checkRuoloEsterno;
    private String nomeAutorizzazione;
    private Logger log = null;
    private XacmlRequest xacmlRequest = null;
    private String xacmlRequestAsString = null;
    private String policyKey = null;
    private Semaphore semaphore = new Semaphore("AbstractAutorizzazioneXacmlPolicyPA");

    protected AbstractAutorizzazioneXacmlPolicy(boolean checkRuoloRegistro, boolean checkRuoloEsterno, String nomeAutorizzazione) {
        this.checkRuoloRegistro = checkRuoloRegistro;
        this.checkRuoloEsterno = checkRuoloEsterno;
        this.nomeAutorizzazione = nomeAutorizzazione;
        this.log = OpenSPCoop2Logger.getLoggerOpenSPCoopCore();
    }

    private XacmlRequest getXacmlRequest(DatiInvocazionePortaApplicativa datiInvocazione, Logger log) throws AutorizzazioneException {
        if (this.xacmlRequest == null) {
            this.initXacmlRequest(datiInvocazione, log);
        }
        return this.xacmlRequest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initXacmlRequest(DatiInvocazionePortaApplicativa datiInvocazione, Logger log) throws AutorizzazioneException {
        SemaphoreLock lock = this.semaphore.acquireThrowRuntime("initXacmlRequest");
        try {
            if (this.xacmlRequest == null) {
                if (datiInvocazione.getIdPA() != null) {
                    this.policyKey = "http://govway.org/in/" + datiInvocazione.getIdPA().getNome();
                } else if (datiInvocazione.getIdPD() != null) {
                    this.policyKey = "http://govway.org/out/" + datiInvocazione.getIdPD().getNome();
                } else {
                    throw new AutorizzazioneException("Identificativo Porta non presente");
                }
                this.xacmlRequest = XACMLPolicyUtilities.newXacmlRequest(this.getProtocolFactory(), datiInvocazione, this.checkRuoloRegistro, this.checkRuoloEsterno, this.policyKey);
                this.xacmlRequestAsString = new String(MarshallUtilities.marshallRequest((XacmlRequest)this.xacmlRequest));
                this.log.debug("XACML-Request (idPolicy:" + this.policyKey + "): " + this.xacmlRequestAsString);
            }
        }
        finally {
            this.semaphore.release(lock, "initXacmlRequest");
        }
    }

    @Override
    public String getSuffixKeyAuthorizationResultInCache(DatiInvocazionePortaApplicativa datiInvocazione) {
        try {
            this.initDatiPolicy(datiInvocazione, false);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.xacmlRequestAsString;
    }

    @Override
    public boolean saveAuthorizationResultInCache() {
        return true;
    }

    private void initDatiPolicy(DatiInvocazionePortaApplicativa datiInvocazione, boolean throwError) throws Exception {
        block3: {
            if (this.xacmlRequestAsString == null) {
                try {
                    this.getXacmlRequest(datiInvocazione, this.log);
                }
                catch (Exception e) {
                    this.log.error("Autorizzazione " + this.nomeAutorizzazione + " non riuscita (create XACML-Request)", (Throwable)e);
                    if (!throwError) break block3;
                    throw e;
                }
            }
        }
    }

    @Override
    public EsitoAutorizzazionePortaApplicativa process(DatiInvocazionePortaApplicativa datiInvocazione) throws AutorizzazioneException {
        EsitoAutorizzazionePortaApplicativa esito = new EsitoAutorizzazionePortaApplicativa();
        IDServizioApplicativo idSA = datiInvocazione.getIdentitaServizioApplicativoFruitore();
        IDSoggetto idSoggetto = datiInvocazione.getIdSoggettoFruitore();
        IDServizio idServizio = datiInvocazione.getIdServizio();
        Object errore = AbstractAutorizzazioneBase.getErrorString(idSA, idSoggetto, idServizio);
        try {
            this.initDatiPolicy(datiInvocazione, true);
        }
        catch (Exception e) {
            this.log.error("Autorizzazione " + this.nomeAutorizzazione + " (" + this.policyKey + ") non riuscita (init XACML-Policy)", (Throwable)e);
            esito.setErroreCooperazione(IntegrationFunctionError.INTERNAL_REQUEST_ERROR, ErroriCooperazione.AUTORIZZAZIONE_FALLITA.getErroreAutorizzazione((String)errore, CodiceErroreCooperazione.SICUREZZA));
            esito.setAutorizzato(false);
            esito.setEccezioneProcessamento(e);
            return esito;
        }
        String xacmlPolicyPorta = null;
        try {
            if (datiInvocazione.getPa() != null) {
                xacmlPolicyPorta = datiInvocazione.getPa().getXacmlPolicy();
            } else if (datiInvocazione.getPd() != null) {
                xacmlPolicyPorta = datiInvocazione.getPd().getXacmlPolicy();
            }
            XACMLPolicyUtilities.loadPolicy(xacmlPolicyPorta, idServizio, this.policyKey, false, null, this.log);
        }
        catch (Exception e) {
            this.log.error("Autorizzazione " + this.nomeAutorizzazione + " (" + this.policyKey + ") non riuscita (load XACML-Policy)", (Throwable)e);
            esito.setErroreCooperazione(IntegrationFunctionError.INTERNAL_REQUEST_ERROR, ErroriCooperazione.AUTORIZZAZIONE_FALLITA.getErroreAutorizzazione((String)errore, CodiceErroreCooperazione.SICUREZZA));
            esito.setAutorizzato(false);
            esito.setEccezioneProcessamento(e);
            return esito;
        }
        XacmlRequest xacmlRequest = null;
        try {
            xacmlRequest = this.getXacmlRequest(datiInvocazione, this.log);
        }
        catch (Exception e) {
            this.log.error("Autorizzazione " + this.nomeAutorizzazione + " (" + this.policyKey + ") non riuscita (create XACML-Request)", (Throwable)e);
            esito.setErroreCooperazione(IntegrationFunctionError.INTERNAL_REQUEST_ERROR, ErroriCooperazione.AUTORIZZAZIONE_FALLITA.getErroreAutorizzazione((String)errore, CodiceErroreCooperazione.SICUREZZA));
            esito.setAutorizzato(false);
            esito.setEccezioneProcessamento(e);
            return esito;
        }
        List results = null;
        try {
            results = ResultUtilities.evaluate((XacmlRequest)xacmlRequest, (Logger)this.log, (String)this.policyKey, (PolicyDecisionPoint)XACMLPolicyUtilities.getPolicyDecisionPoint(this.log));
        }
        catch (Exception e) {
            this.log.error("Autorizzazione " + this.nomeAutorizzazione + " (" + this.policyKey + ") non riuscita (evaluate XACML-Request)", (Throwable)e);
            esito.setErroreCooperazione(IntegrationFunctionError.INTERNAL_REQUEST_ERROR, ErroriCooperazione.AUTORIZZAZIONE_FALLITA.getErroreAutorizzazione((String)errore, CodiceErroreCooperazione.SICUREZZA));
            esito.setAutorizzato(false);
            esito.setEccezioneProcessamento(e);
            return esito;
        }
        DecisionType decision = ResultCombining.combineDenyOverrides((List)results);
        if (DecisionType.PERMIT.equals((Object)decision)) {
            esito.setAutorizzato(true);
            return esito;
        }
        try {
            String resultAsStringForLog = ResultUtilities.toRawString((List)results);
            this.log.error("Autorizzazione con XACMLPolicy fallita (" + this.policyKey + ") ;\nrequest: " + this.xacmlRequestAsString + "\npolicy: " + xacmlPolicyPorta + "\nresults (size:" + results.size() + "): \n" + resultAsStringForLog);
            String resultAsString = ResultUtilities.toString((List)results, (DecisionType)decision);
            if (errore != null) {
                errore = (String)errore + " ";
            }
            errore = (String)errore + "(" + resultAsString + ")";
            esito.setErroreCooperazione(IntegrationFunctionError.AUTHORIZATION_POLICY_DENY, ErroriCooperazione.AUTORIZZAZIONE_FALLITA.getErroreAutorizzazione((String)errore, CodiceErroreCooperazione.SICUREZZA_AUTORIZZAZIONE_FALLITA));
            esito.setAutorizzato(false);
            return esito;
        }
        catch (Exception e) {
            this.log.error("Autorizzazione " + this.nomeAutorizzazione + " (" + this.policyKey + ") fallita (read XACML-Results)", (Throwable)e);
            esito.setErroreIntegrazione(IntegrationFunctionError.INTERNAL_REQUEST_ERROR, ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_536_CONFIGURAZIONE_NON_DISPONIBILE));
            esito.setErroreCooperazione(IntegrationFunctionError.INTERNAL_REQUEST_ERROR, ErroriCooperazione.AUTORIZZAZIONE_FALLITA.getErroreAutorizzazione((String)errore, CodiceErroreCooperazione.SICUREZZA));
            esito.setAutorizzato(false);
            esito.setEccezioneProcessamento(e);
            return esito;
        }
    }
}

