/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import org.openspcoop2.message.OpenSPCoop2Message;
import org.openspcoop2.message.constants.MessageType;
import org.openspcoop2.message.constants.ServiceBinding;
import org.openspcoop2.message.context.SerializedContext;
import org.openspcoop2.message.context.SerializedParameter;
import org.openspcoop2.message.exception.MessageException;
import org.openspcoop2.message.exception.MessageNotSupportedException;
import org.openspcoop2.pdd.core.CostantiPdD;
import org.openspcoop2.pdd.core.SavedMessage;
import org.openspcoop2.pdd.core.state.OpenSPCoopStateless;
import org.openspcoop2.protocol.sdk.Context;
import org.openspcoop2.protocol.sdk.state.RequestInfo;
import org.openspcoop2.protocol.sdk.state.RequestInfoConfigUtilities;
import org.openspcoop2.protocol.sdk.state.StateMessage;
import org.openspcoop2.utils.MapKey;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.beans.WriteToSerializerType;
import org.openspcoop2.utils.serialization.JavaSerializer;

public class SavedMessagePSUtilities {
    private SavedMessagePSUtilities() {
    }

    public static void save(SavedMessage savedMessage, OpenSPCoop2Message msg, boolean isRichiesta, boolean portaDiTipoStateless, boolean consumeMessage, Timestamp oraRegistrazione) throws UtilsException {
        if (!portaDiTipoStateless) {
            StateMessage stateMsg = isRichiesta ? (StateMessage)savedMessage.openspcoopstate.getStatoRichiesta() : (StateMessage)savedMessage.openspcoopstate.getStatoRisposta();
            Connection connectionDB = stateMsg.getConnectionDB();
            SavedMessagePSUtilities.saveStateful(savedMessage, msg, consumeMessage, oraRegistrazione, connectionDB, stateMsg);
        } else if (isRichiesta) {
            ((OpenSPCoopStateless)savedMessage.openspcoopstate).setRichiestaMsg(msg);
        } else {
            ((OpenSPCoopStateless)savedMessage.openspcoopstate).setRispostaMsg(msg);
        }
    }

    private static void saveStateful(SavedMessage savedMessage, OpenSPCoop2Message msg, boolean consumeMessage, Timestamp oraRegistrazione, Connection connectionDB, StateMessage stateMsg) throws UtilsException {
        Statement pstmt = null;
        try {
            StringBuilder query = new StringBuilder();
            query.append("INSERT INTO  ");
            query.append("DEFINIZIONE_MESSAGGI");
            if (savedMessage.saveOnFS) {
                query.append(" (ID_MESSAGGIO,TIPO,CONTENT_TYPE,ORA_REGISTRAZIONE) VALUES ( ? , ? , ? , ? )");
            } else {
                query.append(" (ID_MESSAGGIO,TIPO,CONTENT_TYPE,ORA_REGISTRAZIONE,MSG_BYTES,MSG_CONTEXT) VALUES ( ? , ? , ? , ? , ? , ?)");
            }
            pstmt = connectionDB.prepareStatement(query.toString());
            pstmt.setString(1, savedMessage.idMessaggio);
            if ("INBOX".equals(savedMessage.box)) {
                pstmt.setString(2, "INBOX");
            } else {
                pstmt.setString(2, "OUTBOX");
            }
            SavedMessagePSUtilities.saveNormalizeRequestInfoBeforeSerialization(savedMessage, msg, consumeMessage, (PreparedStatement)pstmt);
            String contentType = SavedMessagePSUtilities.readContentType(msg);
            pstmt.setString(3, contentType);
            pstmt.setTimestamp(4, oraRegistrazione);
            stateMsg.getPreparedStatement().put("INSERT (MSG_OP_STEP1a) saveMessage[" + savedMessage.idMessaggio + "," + savedMessage.box + "]", (PreparedStatement)pstmt);
        }
        catch (Exception e) {
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
            }
            catch (Exception contentType) {
                // empty catch block
            }
            String errorMsg = "SOAP_MESSAGE, save : " + savedMessage.box + "/" + savedMessage.idMessaggio + ": " + e.getMessage();
            savedMessage.logError(errorMsg, e);
            throw new UtilsException(errorMsg, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void saveNormalizeRequestInfoBeforeSerialization(SavedMessage savedMessage, OpenSPCoop2Message msg, boolean consumeMessage, PreparedStatement pstmt) throws UtilsException, MessageException, IOException, SQLException {
        RequestInfo requestInfoBackup = RequestInfoConfigUtilities.normalizeRequestInfoBeforeSerialization((OpenSPCoop2Message)msg);
        try {
            SavedMessagePSUtilities.save(savedMessage, msg, consumeMessage, pstmt);
        }
        finally {
            if (requestInfoBackup != null) {
                RequestInfoConfigUtilities.restoreRequestInfoAfterSerialization((OpenSPCoop2Message)msg, (RequestInfo)requestInfoBackup);
            }
        }
    }

    private static void save(SavedMessage savedMessage, OpenSPCoop2Message msg, boolean consumeMessage, PreparedStatement pstmt) throws UtilsException, MessageException, IOException, SQLException {
        if (savedMessage.saveOnFS) {
            String saveDir = savedMessage.getBaseDir();
            savedMessage.checkInizializzazioneWorkingDir(saveDir);
            String pathBytes = saveDir + savedMessage.keyMsgBytes;
            savedMessage.saveMessageBytes(pathBytes, msg, consumeMessage, false);
            String pathContext = saveDir + savedMessage.keyMsgContext;
            savedMessage.saveMessageContext(pathContext, msg, false);
        } else {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            msg.writeTo((OutputStream)bout, consumeMessage);
            bout.flush();
            bout.close();
            savedMessage.adapter.setBinaryData(pstmt, 5, bout.toByteArray());
            bout = new ByteArrayOutputStream();
            msg.serializeResourcesTo((OutputStream)bout);
            bout.flush();
            bout.close();
            savedMessage.adapter.setBinaryData(pstmt, 6, bout.toByteArray());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String readContentType(OpenSPCoop2Message msg) throws UtilsException, MessageException, MessageNotSupportedException {
        String prefix = "Rilevata una richiesta " + String.valueOf(msg.getServiceBinding());
        String contentType = msg.getContentType();
        if (contentType != null) {
            if (!"".equals(contentType)) return contentType;
        }
        if (!ServiceBinding.REST.equals((Object)msg.getServiceBinding())) throw new UtilsException(prefix + " per la quale non \u00e8 stato fornito un ContentType");
        if (!MessageType.BINARY.equals((Object)msg.getMessageType())) throw new UtilsException(prefix + " " + String.valueOf(msg.getMessageType()) + " per la quale non \u00e8 stato fornito un ContentType");
        if (!msg.castAsRest().hasContent()) return "____EMPTY____";
        throw new UtilsException(prefix + " " + String.valueOf(msg.getMessageType()) + " con payload per la quale non \u00e8 stato fornito un ContentType");
    }

    public static void updateResponse(SavedMessage savedMessage, OpenSPCoop2Message msg, boolean consumeMessage) throws UtilsException {
        StateMessage stateMsg = (StateMessage)savedMessage.openspcoopstate.getStatoRisposta();
        Connection connectionDB = stateMsg.getConnectionDB();
        Statement pstmt = null;
        try {
            StringBuilder query = new StringBuilder();
            query.append("UPDATE ");
            query.append("DEFINIZIONE_MESSAGGI");
            query.append(" SET ");
            query.append(" RESPONSE_CONTENT_TYPE=? ");
            if (!savedMessage.saveOnFS) {
                query.append(" , RESPONSE_MSG_BYTES=? ");
                query.append(" , RESPONSE_MSG_CONTEXT=? ");
            }
            query.append(" WHERE ID_MESSAGGIO=? AND TIPO=?");
            pstmt = connectionDB.prepareStatement(query.toString());
            int index = 1;
            String contentType = SavedMessagePSUtilities.readContentType(msg);
            pstmt.setString(index++, contentType);
            index = SavedMessagePSUtilities.updateResponseNormalizeRequestInfoBeforeSerialization(savedMessage, msg, consumeMessage, (PreparedStatement)pstmt, index);
            pstmt.setString(index++, savedMessage.idMessaggio);
            if ("INBOX".equals(savedMessage.box)) {
                pstmt.setString(index, "INBOX");
            } else {
                pstmt.setString(index, "OUTBOX");
            }
            stateMsg.getPreparedStatement().put("UPDATE (RESPONSE) saveMessage[" + savedMessage.idMessaggio + "," + savedMessage.box + "]", (PreparedStatement)pstmt);
        }
        catch (Exception e) {
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
            }
            catch (Exception index) {
                // empty catch block
            }
            String errorMsg = "SOAP_MESSAGE, update response : " + savedMessage.box + "/" + savedMessage.idMessaggio + ": " + e.getMessage();
            savedMessage.logError(errorMsg, e);
            throw new UtilsException(errorMsg, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int updateResponseNormalizeRequestInfoBeforeSerialization(SavedMessage savedMessage, OpenSPCoop2Message msg, boolean consumeMessage, PreparedStatement pstmt, int index) throws UtilsException, MessageException, IOException, SQLException {
        RequestInfo requestInfoBackup = RequestInfoConfigUtilities.normalizeRequestInfoBeforeSerialization((OpenSPCoop2Message)msg);
        try {
            int n = SavedMessagePSUtilities.updateResponse(savedMessage, msg, consumeMessage, pstmt, index);
            return n;
        }
        finally {
            if (requestInfoBackup != null) {
                RequestInfoConfigUtilities.restoreRequestInfoAfterSerialization((OpenSPCoop2Message)msg, (RequestInfo)requestInfoBackup);
            }
        }
    }

    private static int updateResponse(SavedMessage savedMessage, OpenSPCoop2Message msg, boolean consumeMessage, PreparedStatement pstmt, int index) throws UtilsException, MessageException, IOException, SQLException {
        if (savedMessage.saveOnFS) {
            String saveDir = savedMessage.getBaseDir();
            savedMessage.checkInizializzazioneWorkingDir(saveDir);
            String pathBytes = saveDir + savedMessage.keyMsgResponseBytes;
            savedMessage.saveMessageBytes(pathBytes, msg, consumeMessage, false);
            String pathContext = saveDir + savedMessage.keyMsgResponseContext;
            savedMessage.saveMessageContext(pathContext, msg, false);
        } else {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            msg.writeTo((OutputStream)bout, consumeMessage);
            bout.flush();
            bout.close();
            savedMessage.adapter.setBinaryData(pstmt, index++, bout.toByteArray());
            bout = new ByteArrayOutputStream();
            msg.serializeResourcesTo((OutputStream)bout);
            bout.flush();
            bout.close();
            savedMessage.adapter.setBinaryData(pstmt, index++, bout.toByteArray());
        }
        return index;
    }

    public static void updateTransactionContext(SavedMessage savedMessage, Context transactionContext) throws UtilsException {
        if (transactionContext == null || transactionContext.isEmpty()) {
            return;
        }
        SerializedContext sc = SavedMessagePSUtilities.buildSerializedContext(transactionContext);
        if (savedMessage.saveOnFS) {
            String saveDir = savedMessage.getBaseDir();
            savedMessage.checkInizializzazioneWorkingDir(saveDir);
            String pathBytes = saveDir + savedMessage.keyMsgTransactionContext;
            savedMessage.saveTransactionContext(pathBytes, sc, false);
        } else {
            StateMessage stateMsg = (StateMessage)savedMessage.openspcoopstate.getStatoRisposta();
            Connection connectionDB = stateMsg.getConnectionDB();
            StringBuilder query = new StringBuilder();
            query.append("UPDATE ");
            query.append("DEFINIZIONE_MESSAGGI");
            query.append(" SET ");
            query.append(" TRANSACTION_CONTEXT=? ");
            query.append(" WHERE ID_MESSAGGIO=? AND TIPO=?");
            try (PreparedStatement pstmt = connectionDB.prepareStatement(query.toString());){
                int index = 1;
                ByteArrayOutputStream bout = new ByteArrayOutputStream();
                sc.writeTo((OutputStream)bout, WriteToSerializerType.XML_JAXB);
                bout.flush();
                bout.close();
                savedMessage.adapter.setBinaryData(pstmt, index++, bout.toByteArray());
                pstmt.setString(index++, savedMessage.idMessaggio);
                if ("INBOX".equals(savedMessage.box)) {
                    pstmt.setString(index, "INBOX");
                } else {
                    pstmt.setString(index, "OUTBOX");
                }
                pstmt.executeUpdate();
            }
            catch (Exception e) {
                String errorMsg = "SOAP_MESSAGE, update transaction context : " + savedMessage.box + "/" + savedMessage.idMessaggio + ": " + e.getMessage();
                savedMessage.logError(errorMsg, e);
                throw new UtilsException(errorMsg, (Throwable)e);
            }
        }
    }

    private static SerializedContext buildSerializedContext(Context transactionContext) throws UtilsException {
        try {
            SerializedContext sc = new SerializedContext();
            JavaSerializer jSerializer = new JavaSerializer();
            for (MapKey key : transactionContext.keySet()) {
                Object o = transactionContext.get(key);
                if (CostantiPdD.SALVA_CONTESTO_IDENTIFICATIVO_MESSAGGIO_NOTIFICA.equals((Object)key) || !(o instanceof Serializable)) continue;
                SerializedParameter p = new SerializedParameter();
                p.setNome((String)((Object)key.getValue()));
                p.setClasse(o.getClass().getName());
                ByteArrayOutputStream bout = new ByteArrayOutputStream();
                SavedMessagePSUtilities.jSerialize(jSerializer, o, bout, p);
                bout.flush();
                bout.close();
                p.setBase(bout.toByteArray());
                sc.addProperty(p);
            }
            return sc;
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), (Throwable)e);
        }
    }

    private static void jSerialize(JavaSerializer jSerializer, Object o, ByteArrayOutputStream bout, SerializedParameter p) throws UtilsException {
        try {
            jSerializer.writeObject(o, (OutputStream)bout);
        }
        catch (Exception t) {
            throw new UtilsException("Serialization error (nome:" + p.getNome() + " classe:" + p.getClasse() + "): " + t.getMessage(), (Throwable)t);
        }
    }
}

