/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core;

import org.openspcoop2.core.config.constants.MTOMProcessorType;
import org.openspcoop2.core.constants.Costanti;
import org.openspcoop2.core.constants.TipoPdD;
import org.openspcoop2.message.OpenSPCoop2Message;
import org.openspcoop2.message.OpenSPCoop2SoapMessage;
import org.openspcoop2.message.constants.MessageRole;
import org.openspcoop2.message.constants.ServiceBinding;
import org.openspcoop2.pdd.config.MTOMProcessorConfig;
import org.openspcoop2.pdd.config.MessageSecurityConfig;
import org.openspcoop2.pdd.core.CostantiPdD;
import org.openspcoop2.pdd.core.PdDContext;
import org.openspcoop2.pdd.core.transazioni.Transaction;
import org.openspcoop2.pdd.core.transazioni.TransactionContext;
import org.openspcoop2.pdd.core.transazioni.TransactionNotExistsException;
import org.openspcoop2.pdd.logger.MsgDiagnostico;
import org.openspcoop2.protocol.sdk.constants.RuoloMessaggio;
import org.slf4j.Logger;

public class MTOMProcessor {
    private MTOMProcessorConfig config;
    private MessageSecurityConfig secConfig;
    private TipoPdD tipoPdD;
    private MsgDiagnostico msgDiag;
    private Logger log;
    private PdDContext pddContext;
    private Transaction transactionNullable;

    public MTOMProcessor(MTOMProcessorConfig config, MessageSecurityConfig secConfig, TipoPdD tipoPdD, MsgDiagnostico msgDiag, Logger log, PdDContext pddContext) {
        this.config = config;
        this.secConfig = secConfig;
        this.tipoPdD = tipoPdD;
        this.msgDiag = msgDiag;
        this.log = log;
        this.pddContext = pddContext;
        if (this.pddContext != null && this.pddContext.containsKey(Costanti.ID_TRANSAZIONE)) {
            String idTransazione = (String)this.pddContext.getObject(Costanti.ID_TRANSAZIONE);
            try {
                this.transactionNullable = TransactionContext.getTransaction(idTransazione);
            }
            catch (TransactionNotExistsException transactionNotExistsException) {
                // empty catch block
            }
        }
    }

    public MTOMProcessorType getMTOMProcessorType() {
        if (this.config != null) {
            return this.config.getMtomProcessorType();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mtomBeforeSecurity(OpenSPCoop2Message msg, RuoloMessaggio tipo) throws Exception {
        boolean emitDiagDisabled;
        block27: {
            if (msg == null) {
                return;
            }
            if (!ServiceBinding.SOAP.equals((Object)msg.getServiceBinding())) {
                return;
            }
            emitDiagDisabled = false;
            if (this.isEngineEnabled()) {
                if (this.isMTOMBeforeSecurity(tipo)) {
                    if (this.transactionNullable != null) {
                        switch (tipo) {
                            case RICHIESTA: {
                                this.transactionNullable.getTempiElaborazione().startGestioneAttachmentsRichiesta();
                                break;
                            }
                            case RISPOSTA: {
                                this.transactionNullable.getTempiElaborazione().startGestioneAttachmentsRisposta();
                            }
                        }
                    }
                    try {
                        this.setProcessorTypeIntoDiagnostic(tipo);
                        this.emitDiagnostic(tipo, "mtom.processamentoRichiestaInCorso", "mtom.processamentoRispostaInCorso");
                        try {
                            this.mtomApply(msg.castAsSoap());
                            this.emitDiagnostic(tipo, "mtom.processamentoRichiestaEffettuato", "mtom.processamentoRispostaEffettuato");
                            break block27;
                        }
                        catch (Exception e) {
                            if (MessageRole.REQUEST.equals((Object)msg.getMessageRole())) {
                                this.pddContext.addObject(Costanti.ERRORE_ALLEGATI_MESSAGGIO_RICHIESTA, "true");
                            } else {
                                this.pddContext.addObject(Costanti.ERRORE_ALLEGATI_MESSAGGIO_RISPOSTA, "true");
                            }
                            this.msgDiag.addKeywordErroreProcessamento(e);
                            this.log.error("[MTOM BeforeSecurity " + tipo.getTipo() + "] " + e.getMessage(), (Throwable)e);
                            this.emitDiagnostic(tipo, "mtom.processamentoRichiestaInErrore", "mtom.processamentoRispostaInErrore");
                            throw e;
                        }
                    }
                    finally {
                        if (this.transactionNullable != null) {
                            switch (tipo) {
                                case RICHIESTA: {
                                    this.transactionNullable.getTempiElaborazione().endGestioneAttachmentsRichiesta();
                                    break;
                                }
                                case RISPOSTA: {
                                    this.transactionNullable.getTempiElaborazione().endGestioneAttachmentsRisposta();
                                }
                            }
                        }
                    }
                }
                emitDiagDisabled = true;
            } else {
                emitDiagDisabled = true;
            }
        }
        if (emitDiagDisabled) {
            this.emitDiagnostic(tipo, "mtom.beforeSecurity.processamentoRichiestaDisabilitato", "mtom.beforeSecurity.processamentoRispostaDisabilitato");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mtomAfterSecurity(OpenSPCoop2Message msg, RuoloMessaggio tipo) throws Exception {
        boolean emitDiagDisabled;
        block25: {
            if (msg == null) {
                return;
            }
            if (!ServiceBinding.SOAP.equals((Object)msg.getServiceBinding())) {
                return;
            }
            emitDiagDisabled = false;
            if (this.isEngineEnabled()) {
                if (!this.isMTOMBeforeSecurity(tipo)) {
                    if (this.transactionNullable != null) {
                        switch (tipo) {
                            case RICHIESTA: {
                                this.transactionNullable.getTempiElaborazione().startGestioneAttachmentsRichiesta();
                                break;
                            }
                            case RISPOSTA: {
                                this.transactionNullable.getTempiElaborazione().startGestioneAttachmentsRisposta();
                            }
                        }
                    }
                    try {
                        this.setProcessorTypeIntoDiagnostic(tipo);
                        this.emitDiagnostic(tipo, "mtom.processamentoRichiestaInCorso", "mtom.processamentoRispostaInCorso");
                        try {
                            this.mtomApply(msg.castAsSoap());
                            this.emitDiagnostic(tipo, "mtom.processamentoRichiestaEffettuato", "mtom.processamentoRispostaEffettuato");
                            break block25;
                        }
                        catch (Exception e) {
                            this.msgDiag.addKeywordErroreProcessamento(e);
                            this.log.error("[MTOM AfterSecurity " + tipo.getTipo() + "] " + e.getMessage(), (Throwable)e);
                            this.emitDiagnostic(tipo, "mtom.processamentoRichiestaInErrore", "mtom.processamentoRispostaInErrore");
                            throw e;
                        }
                    }
                    finally {
                        if (this.transactionNullable != null) {
                            switch (tipo) {
                                case RICHIESTA: {
                                    this.transactionNullable.getTempiElaborazione().endGestioneAttachmentsRichiesta();
                                    break;
                                }
                                case RISPOSTA: {
                                    this.transactionNullable.getTempiElaborazione().endGestioneAttachmentsRisposta();
                                }
                            }
                        }
                    }
                }
                emitDiagDisabled = true;
            } else {
                emitDiagDisabled = true;
            }
        }
        if (emitDiagDisabled) {
            this.emitDiagnostic(tipo, "mtom.afterSecurity.processamentoRichiestaDisabilitato", "mtom.afterSecurity.processamentoRispostaDisabilitato");
        }
    }

    private void setProcessorTypeIntoDiagnostic(RuoloMessaggio tipo) {
        switch (tipo) {
            case RICHIESTA: {
                this.msgDiag.addKeyword("@TIPO_PROCESSAMENTO_MTOM_RICHIESTA@", this.config.getMtomProcessorType().getValue());
                this.pddContext.addObject(CostantiPdD.TIPO_PROCESSAMENTO_MTOM_RICHIESTA, this.config.getMtomProcessorType().getValue());
                break;
            }
            case RISPOSTA: {
                this.msgDiag.addKeyword("@TIPO_PROCESSAMENTO_MTOM_RISPOSTA@", this.config.getMtomProcessorType().getValue());
                this.pddContext.addObject(CostantiPdD.TIPO_PROCESSAMENTO_MTOM_RISPOSTA, this.config.getMtomProcessorType().getValue());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void emitDiagnostic(RuoloMessaggio tipo, String idDiagnosticRichiesta, String idDiagnosticRisposta) {
        String originalPrefix = this.msgDiag.getPrefixMsgPersonalizzati();
        try {
            switch (this.tipoPdD) {
                case DELEGATA: {
                    this.msgDiag.setPrefixMsgPersonalizzati("inoltroBuste.");
                    break;
                }
                case APPLICATIVA: {
                    this.msgDiag.setPrefixMsgPersonalizzati("ricezioneBuste.");
                    break;
                }
                default: {
                    return;
                }
            }
            switch (tipo) {
                case RICHIESTA: {
                    this.msgDiag.logPersonalizzato(idDiagnosticRichiesta);
                    return;
                }
                case RISPOSTA: {
                    this.msgDiag.logPersonalizzato(idDiagnosticRisposta);
                    return;
                }
            }
            return;
        }
        finally {
            this.msgDiag.setPrefixMsgPersonalizzati(originalPrefix);
        }
    }

    private void mtomApply(OpenSPCoop2SoapMessage msg) throws Exception {
        switch (this.config.getMtomProcessorType()) {
            case PACKAGING: {
                if (this.config.getInfo() == null || this.config.getInfo().size() <= 0) break;
                msg.mtomPackaging(this.config.getInfo());
                break;
            }
            case UNPACKAGING: {
                msg.mtomUnpackaging();
                break;
            }
            case VERIFY: {
                if (this.config.getInfo() == null || this.config.getInfo().size() <= 0) break;
                msg.mtomVerify(this.config.getInfo());
                break;
            }
        }
    }

    private boolean isMTOMBeforeSecurity(RuoloMessaggio tipoTraccia) throws Exception {
        MTOMProcessorType processorType = null;
        processorType = this.config != null && this.config.getMtomProcessorType() != null ? this.config.getMtomProcessorType() : MTOMProcessorType.DISABLE;
        Boolean applyToMtom = null;
        if (this.secConfig != null && this.secConfig.getApplyToMtom() != null) {
            applyToMtom = this.secConfig.getApplyToMtom();
        }
        switch (this.tipoPdD) {
            case DELEGATA: {
                switch (tipoTraccia) {
                    case RICHIESTA: {
                        switch (processorType) {
                            case DISABLE: {
                                throw new Exception("Caso non previsto [" + String.valueOf(processorType) + "] Delegata.richiesta.disabile");
                            }
                            case PACKAGING: {
                                if (applyToMtom == null) {
                                    return false;
                                }
                                return applyToMtom != false;
                            }
                            case UNPACKAGING: {
                                if (applyToMtom == null) {
                                    return false;
                                }
                                return applyToMtom == false;
                            }
                            case VERIFY: {
                                return true;
                            }
                        }
                        throw new Exception("Caso non previsto Delegata.richiesta.[" + String.valueOf(processorType) + "]");
                    }
                    case RISPOSTA: {
                        switch (processorType) {
                            case DISABLE: {
                                throw new Exception("Caso non previsto [" + String.valueOf(processorType) + "] Delegata.risposta.disabile");
                            }
                            case PACKAGING: {
                                if (applyToMtom == null) {
                                    return true;
                                }
                                return applyToMtom != false;
                            }
                            case UNPACKAGING: {
                                if (applyToMtom == null) {
                                    return true;
                                }
                                return applyToMtom == false;
                            }
                            case VERIFY: {
                                return true;
                            }
                        }
                        throw new Exception("Caso non previsto Delegata.risposta.[" + String.valueOf(processorType) + "]");
                    }
                }
                throw new Exception("Tipo non gestito [" + String.valueOf(tipoTraccia) + "] in Delegata.risposta");
            }
            case APPLICATIVA: {
                switch (tipoTraccia) {
                    case RICHIESTA: {
                        switch (processorType) {
                            case DISABLE: {
                                throw new Exception("Caso non previsto [" + String.valueOf(processorType) + "] Applicativa.richiesta.disabile");
                            }
                            case PACKAGING: {
                                if (applyToMtom == null) {
                                    return true;
                                }
                                return applyToMtom != false;
                            }
                            case UNPACKAGING: {
                                if (applyToMtom == null) {
                                    return true;
                                }
                                return applyToMtom == false;
                            }
                            case VERIFY: {
                                return true;
                            }
                        }
                        throw new Exception("Caso non previsto Applicativa.richiesta.[" + String.valueOf(processorType) + "]");
                    }
                    case RISPOSTA: {
                        switch (processorType) {
                            case DISABLE: {
                                throw new Exception("Caso non previsto [" + String.valueOf(processorType) + "] Applicativa.risposta.disabile");
                            }
                            case PACKAGING: {
                                if (applyToMtom == null) {
                                    return false;
                                }
                                return applyToMtom != false;
                            }
                            case UNPACKAGING: {
                                if (applyToMtom == null) {
                                    return false;
                                }
                                return applyToMtom == false;
                            }
                            case VERIFY: {
                                return true;
                            }
                        }
                        throw new Exception("Caso non previsto Applicativa.risposta.[" + String.valueOf(processorType) + "]");
                    }
                }
                throw new Exception("Tipo non gestito [" + String.valueOf(tipoTraccia) + "] in Applicativa.risposta");
            }
        }
        throw new Exception("Ruolo [" + String.valueOf(this.tipoPdD) + "] non gestito");
    }

    private boolean isEngineEnabled() {
        if (!TipoPdD.DELEGATA.equals((Object)this.tipoPdD) && !TipoPdD.APPLICATIVA.equals((Object)this.tipoPdD)) {
            return false;
        }
        return this.config != null && this.config.getMtomProcessorType() != null && !MTOMProcessorType.DISABLE.equals((Object)this.config.getMtomProcessorType());
    }
}

