/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import org.openspcoop2.core.config.PortaApplicativa;
import org.openspcoop2.core.config.PortaDelegata;
import org.openspcoop2.core.config.ServizioApplicativo;
import org.openspcoop2.core.config.driver.DriverConfigurazioneNotFound;
import org.openspcoop2.core.constants.Costanti;
import org.openspcoop2.core.constants.TipoPdD;
import org.openspcoop2.core.id.IDPortaApplicativa;
import org.openspcoop2.core.id.IDServizio;
import org.openspcoop2.core.id.IDServizioApplicativo;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.message.OpenSPCoop2Message;
import org.openspcoop2.message.OpenSPCoop2MessageFactory;
import org.openspcoop2.message.OpenSPCoop2SoapMessage;
import org.openspcoop2.message.constants.MessageRole;
import org.openspcoop2.message.constants.MessageType;
import org.openspcoop2.message.exception.ParseException;
import org.openspcoop2.message.utils.MessageUtilities;
import org.openspcoop2.message.xml.MessageXMLUtils;
import org.openspcoop2.pdd.config.MTOMProcessorConfig;
import org.openspcoop2.pdd.config.MessageSecurityConfig;
import org.openspcoop2.pdd.config.OpenSPCoop2Properties;
import org.openspcoop2.pdd.config.RichiestaApplicativa;
import org.openspcoop2.pdd.config.RichiestaDelegata;
import org.openspcoop2.pdd.core.EJBUtils;
import org.openspcoop2.pdd.core.GestoreMessaggi;
import org.openspcoop2.pdd.core.LocalForwardException;
import org.openspcoop2.pdd.core.LocalForwardParameter;
import org.openspcoop2.pdd.core.MTOMProcessor;
import org.openspcoop2.pdd.core.PdDContext;
import org.openspcoop2.pdd.core.behaviour.Behaviour;
import org.openspcoop2.pdd.core.dynamic.DynamicMapBuilderUtils;
import org.openspcoop2.pdd.core.handlers.HandlerException;
import org.openspcoop2.pdd.core.state.OpenSPCoopState;
import org.openspcoop2.pdd.core.transazioni.Transaction;
import org.openspcoop2.pdd.core.transazioni.TransactionContext;
import org.openspcoop2.pdd.services.ServicesUtils;
import org.openspcoop2.pdd.services.error.AbstractErrorGenerator;
import org.openspcoop2.pdd.services.error.RicezioneBusteExternalErrorGenerator;
import org.openspcoop2.pdd.services.error.RicezioneContenutiApplicativiInternalErrorGenerator;
import org.openspcoop2.protocol.sdk.Busta;
import org.openspcoop2.protocol.sdk.Context;
import org.openspcoop2.protocol.sdk.Eccezione;
import org.openspcoop2.protocol.sdk.SecurityInfo;
import org.openspcoop2.protocol.sdk.builder.ProprietaErroreApplicativo;
import org.openspcoop2.protocol.sdk.constants.CodiceErroreCooperazione;
import org.openspcoop2.protocol.sdk.constants.CodiceErroreIntegrazione;
import org.openspcoop2.protocol.sdk.constants.ErroreCooperazione;
import org.openspcoop2.protocol.sdk.constants.ErroreIntegrazione;
import org.openspcoop2.protocol.sdk.constants.ErroriCooperazione;
import org.openspcoop2.protocol.sdk.constants.ErroriIntegrazione;
import org.openspcoop2.protocol.sdk.constants.IntegrationFunctionError;
import org.openspcoop2.protocol.sdk.constants.ProfiloDiCollaborazione;
import org.openspcoop2.protocol.sdk.constants.RuoloMessaggio;
import org.openspcoop2.protocol.sdk.constants.SubCodiceErrore;
import org.openspcoop2.protocol.sdk.state.IState;
import org.openspcoop2.protocol.sdk.state.RequestInfo;
import org.openspcoop2.protocol.sdk.validator.IValidazioneSemantica;
import org.openspcoop2.security.message.MessageSecurityContext;
import org.openspcoop2.security.message.MessageSecurityContextParameters;
import org.openspcoop2.security.message.SubErrorCodeSecurity;
import org.openspcoop2.security.message.constants.SecurityConstants;
import org.openspcoop2.security.message.engine.MessageSecurityFactory;
import org.openspcoop2.security.message.engine.WSSUtilities;
import org.openspcoop2.utils.Utilities;
import org.openspcoop2.utils.date.DateManager;
import org.openspcoop2.utils.date.DateUtils;
import org.openspcoop2.utils.digest.IDigestReader;
import org.w3c.dom.Node;

public class LocalForwardEngine {
    private LocalForwardParameter localForwardParameter;
    private EJBUtils ejbUtils = null;
    private RicezioneContenutiApplicativiInternalErrorGenerator generatoreErrorePortaDelegata = null;
    private RicezioneBusteExternalErrorGenerator generatoreErrorePortaApplicativa = null;
    private Busta busta = null;
    private IDPortaApplicativa idPA = null;
    private PortaApplicativa pa = null;
    private RichiestaApplicativa richiestaApplicativa = null;
    private RichiestaDelegata richiestaDelegata = null;
    private PortaDelegata pd = null;
    private ServizioApplicativo sa = null;
    private OpenSPCoop2Properties propertiesReader = null;
    private RequestInfo requestInfo = null;
    private IntegrationFunctionError _integrationFunctionError;
    private SecurityInfo securityInfoRequest = null;
    private OpenSPCoop2Message responseMessageError = null;
    private OpenSPCoop2Message requestMessageAfterProcess = null;
    private MessageSecurityConfig securityConfigPDRequest = null;
    private MessageSecurityConfig securityConfigPARequest = null;
    private SecurityInfo securityInfoResponse = null;
    private OpenSPCoop2Message responseMessageAfterProcess = null;

    private IntegrationFunctionError getIntegrationFunctionError(PdDContext pddContext) {
        if (this._integrationFunctionError != null) {
            return this._integrationFunctionError;
        }
        return AbstractErrorGenerator.getIntegrationInternalError(pddContext);
    }

    public LocalForwardEngine(LocalForwardParameter localForwardParameter) throws LocalForwardException {
        this.localForwardParameter = localForwardParameter;
        try {
            String servizioApplicativo;
            ProprietaErroreApplicativo fault;
            IDServizio idServizio;
            IDSoggetto soggettoFruitore;
            String profiloGestione;
            IState state;
            block11: {
                this.propertiesReader = OpenSPCoop2Properties.getInstance();
                this.richiestaDelegata = this.localForwardParameter.getRichiestaDelegata();
                this.richiestaApplicativa = this.localForwardParameter.getRichiestaApplicativa();
                ((OpenSPCoopState)this.localForwardParameter.getOpenspcoopstate()).setIDMessaggioSessione(this.localForwardParameter.getIdRequest());
                state = ((OpenSPCoopState)this.localForwardParameter.getOpenspcoopstate()).getStatoRichiesta();
                profiloGestione = null;
                soggettoFruitore = null;
                idServizio = null;
                fault = null;
                servizioApplicativo = null;
                String scenarioCooperazione = null;
                if (this.richiestaApplicativa != null) {
                    profiloGestione = this.richiestaApplicativa.getProfiloGestione();
                    soggettoFruitore = this.richiestaApplicativa.getSoggettoFruitore();
                    idServizio = this.richiestaApplicativa.getIDServizio();
                    fault = null;
                    servizioApplicativo = this.richiestaApplicativa.getServizioApplicativo();
                    scenarioCooperazione = this.richiestaApplicativa.getScenario();
                    this.idPA = this.richiestaApplicativa.getIdPortaApplicativa();
                    this.busta = this.localForwardParameter.getBusta();
                } else {
                    profiloGestione = this.richiestaDelegata.getProfiloGestione();
                    soggettoFruitore = this.richiestaDelegata.getIdSoggettoFruitore();
                    idServizio = this.richiestaDelegata.getIdServizio();
                    fault = this.richiestaDelegata.getFault();
                    servizioApplicativo = this.richiestaDelegata.getServizioApplicativo();
                    if (ProfiloDiCollaborazione.ONEWAY.equals((Object)this.localForwardParameter.getInfoServizio().getProfiloDiCollaborazione())) {
                        scenarioCooperazione = "OneWay_InvocazioneServizio";
                    } else if (ProfiloDiCollaborazione.SINCRONO.equals((Object)this.localForwardParameter.getInfoServizio().getProfiloDiCollaborazione())) {
                        scenarioCooperazione = "Sincrono_InvocazioneServizio";
                    }
                    this.idPA = this.localForwardParameter.getIdPortaApplicativaIndirizzata();
                    this.richiestaApplicativa = new RichiestaApplicativa(soggettoFruitore, this.localForwardParameter.getIdModulo(), this.localForwardParameter.getIdentitaPdD(), this.idPA);
                    this.richiestaApplicativa.setIdCorrelazioneApplicativa(this.localForwardParameter.getIdCorrelazioneApplicativa());
                    this.richiestaApplicativa.setProfiloGestione(profiloGestione);
                    this.richiestaApplicativa.setRicevutaAsincrona(false);
                    this.richiestaApplicativa.setLocalForward(true);
                    this.richiestaApplicativa.setScenario(scenarioCooperazione);
                    if (!"Anonimo".equals(servizioApplicativo)) {
                        this.richiestaApplicativa.setIdentitaServizioApplicativoFruitore(servizioApplicativo);
                    }
                    this.busta = new Busta(this.localForwardParameter.getProtocolFactory(), this.localForwardParameter.getInfoServizio(), soggettoFruitore, idServizio.getSoggettoErogatore(), this.localForwardParameter.getIdRequest(), false);
                    this.busta.setID(this.localForwardParameter.getIdRequest());
                }
                this.pd = this.localForwardParameter.getConfigurazionePdDReader().getPortaDelegata(this.richiestaDelegata.getIdPortaDelegata(), this.requestInfo);
                try {
                    IDServizioApplicativo idSA = new IDServizioApplicativo();
                    idSA.setNome(this.richiestaDelegata.getServizioApplicativo());
                    idSA.setIdSoggettoProprietario(this.richiestaDelegata.getIdSoggettoFruitore());
                    this.sa = this.localForwardParameter.getConfigurazionePdDReader().getServizioApplicativo(idSA, this.requestInfo);
                }
                catch (DriverConfigurazioneNotFound e) {
                    if ("Anonimo".equals(this.richiestaDelegata.getServizioApplicativo())) break block11;
                    throw e;
                }
            }
            this.requestInfo = (RequestInfo)this.localForwardParameter.getPddContext().getObject(Costanti.REQUEST_INFO);
            if (fault == null) {
                fault = this.propertiesReader.getProprietaGestioneErrorePD(this.localForwardParameter.getProtocolFactory().createProtocolManager());
                fault.setDominio(this.localForwardParameter.getIdentitaPdD().getCodicePorta());
                fault.setIdModulo(this.localForwardParameter.getIdModulo());
                this.localForwardParameter.getConfigurazionePdDReader().aggiornaProprietaGestioneErrorePD(fault, this.sa);
            }
            this.ejbUtils = new EJBUtils(this.localForwardParameter.getIdentitaPdD(), TipoPdD.DELEGATA, this.localForwardParameter.getIdModulo(), this.localForwardParameter.getIdRequest(), this.localForwardParameter.getIdRequest(), "OUTBOX", this.localForwardParameter.getOpenspcoopstate(), this.localForwardParameter.getMsgDiag(), false, this.localForwardParameter.getImplementazionePdDMittente(), this.localForwardParameter.getImplementazionePdDDestinatario(), profiloGestione, this.localForwardParameter.getPddContext());
            this.ejbUtils.setOneWayVersione11(this.localForwardParameter.isOneWayVersione11());
            this.ejbUtils.setPortaDiTipoStateless_esclusoOneWay11(this.localForwardParameter.isStateless() && !this.localForwardParameter.isOneWayVersione11());
            this.generatoreErrorePortaDelegata = new RicezioneContenutiApplicativiInternalErrorGenerator(this.localForwardParameter.getLog(), this.localForwardParameter.getIdModulo(), this.requestInfo);
            this.generatoreErrorePortaDelegata.updateInformazioniCooperazione(soggettoFruitore, idServizio);
            this.generatoreErrorePortaDelegata.updateInformazioniCooperazione(servizioApplicativo);
            this.generatoreErrorePortaDelegata.updateProprietaErroreApplicativo(fault);
            this.generatoreErrorePortaApplicativa = new RicezioneBusteExternalErrorGenerator(this.localForwardParameter.getLog(), this.localForwardParameter.getIdModulo(), this.requestInfo, state);
            this.generatoreErrorePortaApplicativa.updateInformazioniCooperazione(soggettoFruitore, idServizio);
            this.generatoreErrorePortaApplicativa.updateInformazioniCooperazione(servizioApplicativo);
            this.ejbUtils.setGeneratoreErrorePortaApplicativa(this.generatoreErrorePortaApplicativa);
            this.pa = this.localForwardParameter.getConfigurazionePdDReader().getPortaApplicativa(this.idPA, this.requestInfo);
        }
        catch (Exception e) {
            throw new LocalForwardException(e.getMessage(), e);
        }
    }

    public void updateLocalForwardParameter(LocalForwardParameter localForwardParameter) throws LocalForwardException {
        this.localForwardParameter = localForwardParameter;
    }

    public void setIntegrationFunctionError(IntegrationFunctionError integrationError) {
        this._integrationFunctionError = integrationError;
    }

    private Transaction getTransactionNullable() {
        String idTransazione = (String)this.localForwardParameter.getPddContext().getObject(Costanti.ID_TRANSAZIONE);
        Transaction transactionNullable = null;
        try {
            transactionNullable = TransactionContext.getTransaction(idTransazione);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return transactionNullable;
    }

    public SecurityInfo getSecurityInfoRequest() {
        return this.securityInfoRequest;
    }

    public OpenSPCoop2Message getResponseMessageError() {
        return this.responseMessageError;
    }

    public OpenSPCoop2Message getRequestMessageAfterProcess() {
        return this.requestMessageAfterProcess;
    }

    public boolean processRequest(OpenSPCoop2Message requestMessage) throws LocalForwardException {
        try {
            ArrayList<Eccezione> eccezioniSicurezza;
            IntegrationFunctionError integrationFunctionError;
            boolean logDiagnosticError;
            MTOMProcessor mtomProcessor;
            Object posizione;
            PdDContext pddContext;
            Exception configException;
            ErroreIntegrazione erroreIntegrazione;
            block73: {
                IValidazioneSemantica validazioneSemantica;
                IDigestReader digestReader;
                String tipoSicurezza;
                MessageSecurityContextParameters contextParameters;
                MessageSecurityContext messageSecurityContext;
                String msgErrore;
                MTOMProcessorConfig mtomConfig;
                boolean messageSecurityApply;
                IState state;
                MessageSecurityFactory messageSecurityFactory;
                CodiceErroreCooperazione codiceErroreCooperazione;
                block72: {
                    erroreIntegrazione = null;
                    codiceErroreCooperazione = null;
                    configException = null;
                    messageSecurityFactory = new MessageSecurityFactory();
                    state = ((OpenSPCoopState)this.localForwardParameter.getOpenspcoopstate()).getStatoRichiesta();
                    pddContext = this.localForwardParameter.getPddContext();
                    messageSecurityApply = false;
                    this.localForwardParameter.getMsgDiag().mediumDebug("init MTOM Processor / SecurityContext (PD) ...");
                    mtomConfig = null;
                    msgErrore = null;
                    posizione = null;
                    mtomProcessor = null;
                    logDiagnosticError = true;
                    integrationFunctionError = null;
                    try {
                        this.securityConfigPDRequest = this.localForwardParameter.getConfigurazionePdDReader().getMessageSecurityForSender(this.pd, this.localForwardParameter.getLog(), requestMessage, this.busta, this.requestInfo, this.localForwardParameter.getPddContext());
                    }
                    catch (Exception e) {
                        posizione = "LetturaParametriSicurezzaMessaggioPDRequest";
                        erroreIntegrazione = ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento((Throwable)e, CodiceErroreIntegrazione.CODICE_536_CONFIGURAZIONE_NON_DISPONIBILE);
                        configException = e;
                        integrationFunctionError = IntegrationFunctionError.INTERNAL_REQUEST_ERROR;
                    }
                    if (erroreIntegrazione == null) {
                        try {
                            mtomConfig = this.localForwardParameter.getConfigurazionePdDReader().getMTOMProcessorForSender(this.pd);
                        }
                        catch (Exception e) {
                            posizione = "LetturaParametriMTOMProcessorPDRequest";
                            erroreIntegrazione = ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento((Throwable)e, CodiceErroreIntegrazione.CODICE_536_CONFIGURAZIONE_NON_DISPONIBILE);
                            configException = e;
                            integrationFunctionError = IntegrationFunctionError.INTERNAL_REQUEST_ERROR;
                        }
                    }
                    if (erroreIntegrazione == null) {
                        mtomProcessor = new MTOMProcessor(mtomConfig, this.securityConfigPDRequest, TipoPdD.DELEGATA, this.localForwardParameter.getMsgDiag(), this.localForwardParameter.getLog(), this.localForwardParameter.getPddContext());
                    }
                    if (mtomProcessor != null && erroreIntegrazione == null) {
                        try {
                            mtomProcessor.mtomBeforeSecurity(requestMessage, RuoloMessaggio.RICHIESTA);
                        }
                        catch (Exception e) {
                            logDiagnosticError = false;
                            posizione = "MTOMProcessor(BeforeSec-" + String.valueOf(mtomProcessor.getMTOMProcessorType()) + ")PDRequest";
                            erroreIntegrazione = ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento((Throwable)e, CodiceErroreIntegrazione.CODICE_557_MTOM_PROCESSOR_ERROR);
                            configException = e;
                            integrationFunctionError = IntegrationFunctionError.ATTACHMENTS_PROCESSING_REQUEST_FAILED;
                        }
                    }
                    messageSecurityContext = null;
                    if (erroreIntegrazione == null) {
                        if (this.securityConfigPDRequest != null && this.securityConfigPDRequest.getFlowParameters() != null && this.securityConfigPDRequest.getFlowParameters().size() > 0) {
                            try {
                                this.localForwardParameter.getMsgDiag().mediumDebug("Inizializzazione contesto di Message Security (PD) della richiesta ...");
                                messageSecurityApply = true;
                                contextParameters = new MessageSecurityContextParameters();
                                contextParameters.setUseActorDefaultIfNotDefined(this.propertiesReader.isGenerazioneActorDefault(this.localForwardParameter.getImplementazionePdDDestinatario()));
                                contextParameters.setActorDefault(this.propertiesReader.getActorDefault(this.localForwardParameter.getImplementazionePdDDestinatario()));
                                contextParameters.setLog(this.localForwardParameter.getLog());
                                contextParameters.setFunctionAsClient(true);
                                contextParameters.setPrefixWsuId(this.propertiesReader.getPrefixWsuId());
                                contextParameters.setRemoveAllWsuIdRef(this.propertiesReader.isRemoveAllWsuIdRef());
                                contextParameters.setIdFruitore(this.richiestaDelegata.getIdSoggettoFruitore());
                                contextParameters.setIdServizio(this.richiestaDelegata.getIdServizio());
                                contextParameters.setPddFruitore(this.localForwardParameter.getIdPdDMittente());
                                contextParameters.setPddErogatore(this.localForwardParameter.getIdPdDDestinatario());
                                messageSecurityContext = messageSecurityFactory.getMessageSecurityContext(contextParameters);
                                messageSecurityContext.setOutgoingProperties(this.securityConfigPDRequest.getFlowParameters());
                                this.localForwardParameter.getMsgDiag().mediumDebug("Inizializzazione contesto di Message Security (PD) della richiesta completata con successo");
                                if (WSSUtilities.isNormalizeToSaajImpl((MessageSecurityContext)messageSecurityContext)) {
                                    this.localForwardParameter.getMsgDiag().mediumDebug("Normalize to saajImpl");
                                    this.requestMessageAfterProcess = requestMessage = requestMessage.normalizeToSaajImpl();
                                }
                                tipoSicurezza = SecurityConstants.convertActionToString((Map)messageSecurityContext.getOutgoingProperties());
                                this.localForwardParameter.getMsgDiag().addKeyword("@TIPO_SICUREZZA_MESSAGGIO_RICHIESTA@", tipoSicurezza);
                                this.localForwardParameter.getMsgDiag().logPersonalizzato("inoltroBuste.", "messageSecurity.processamentoRichiestaInCorso");
                                DynamicMapBuilderUtils.injectDynamicMap(this.busta, this.requestInfo, (org.openspcoop2.utils.Map<Object>)pddContext, this.localForwardParameter.getLog());
                                if (!messageSecurityContext.processOutgoing(requestMessage, (org.openspcoop2.utils.Map)this.localForwardParameter.getPddContext(), this.getTransactionNullable() != null ? this.getTransactionNullable().getTempiElaborazione() : null)) {
                                    msgErrore = messageSecurityContext.getMsgErrore();
                                    codiceErroreCooperazione = messageSecurityContext.getCodiceErrore();
                                    this.localForwardParameter.getMsgDiag().addKeyword("@ERRORE_PROCESSAMENTO@", "[" + String.valueOf(codiceErroreCooperazione) + "] " + msgErrore);
                                    this.localForwardParameter.getMsgDiag().logPersonalizzato("inoltroBuste.", "messageSecurity.processamentoRichiestaInErrore");
                                    break block72;
                                }
                                this.localForwardParameter.getMsgDiag().logPersonalizzato("inoltroBuste.", "messageSecurity.processamentoRichiestaEffettuato");
                            }
                            catch (Exception e) {
                                this.localForwardParameter.getMsgDiag().addKeywordErroreProcessamento(e);
                                this.localForwardParameter.getMsgDiag().logPersonalizzato("inoltroBuste.", "messageSecurity.processamentoRichiestaInErrore");
                                this.localForwardParameter.getLog().error("[MessageSecurityRequest]" + e.getMessage(), (Throwable)e);
                                posizione = "MessageSecurityPortaDelegataRequestFlow";
                                erroreIntegrazione = ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento((Throwable)e, CodiceErroreIntegrazione.CODICE_536_CONFIGURAZIONE_NON_DISPONIBILE);
                                configException = e;
                                integrationFunctionError = IntegrationFunctionError.MESSAGE_SECURITY_REQUEST_FAILED;
                            }
                        } else {
                            this.localForwardParameter.getMsgDiag().logPersonalizzato("inoltroBuste.", "messageSecurity.processamentoRichiestaDisabilitato");
                        }
                    }
                }
                if (erroreIntegrazione == null && codiceErroreCooperazione == null) {
                    digestReader = null;
                    if (messageSecurityContext != null) {
                        digestReader = messageSecurityContext.getDigestReader(requestMessage != null ? requestMessage.getFactory() : OpenSPCoop2MessageFactory.getDefaultMessageFactory());
                    }
                    if (digestReader != null) {
                        try {
                            this.localForwardParameter.getMsgDiag().mediumDebug("ReadSecurityInformation (PD) ...");
                            validazioneSemantica = this.localForwardParameter.getProtocolFactory().createValidazioneSemantica(state);
                            this.securityInfoRequest = validazioneSemantica.readSecurityInformation(digestReader, requestMessage);
                        }
                        catch (Exception e) {
                            posizione = "LetturaInformazioniSicurezzaPDRequest";
                            erroreIntegrazione = ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_549_SECURITY_INFO_READER_ERROR);
                            configException = e;
                            integrationFunctionError = IntegrationFunctionError.MESSAGE_SECURITY_REQUEST_FAILED;
                        }
                    }
                }
                if (mtomProcessor != null && erroreIntegrazione == null) {
                    try {
                        mtomProcessor.mtomAfterSecurity(requestMessage, RuoloMessaggio.RICHIESTA);
                    }
                    catch (Exception e) {
                        logDiagnosticError = false;
                        posizione = "MTOMProcessor(AfterSec-" + String.valueOf(mtomProcessor.getMTOMProcessorType()) + ")PDRequest";
                        erroreIntegrazione = ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento((Throwable)e, CodiceErroreIntegrazione.CODICE_557_MTOM_PROCESSOR_ERROR);
                        configException = e;
                        integrationFunctionError = IntegrationFunctionError.ATTACHMENTS_PROCESSING_REQUEST_FAILED;
                    }
                }
                if (erroreIntegrazione != null || codiceErroreCooperazione != null) {
                    if (integrationFunctionError == null) {
                        integrationFunctionError = IntegrationFunctionError.INTERNAL_REQUEST_ERROR;
                    }
                    if (erroreIntegrazione != null) {
                        if (logDiagnosticError) {
                            this.localForwardParameter.getMsgDiag().logErroreGenerico(erroreIntegrazione.getDescrizione(this.localForwardParameter.getProtocolFactory()), (String)posizione);
                        }
                        this.responseMessageError = this.generatoreErrorePortaDelegata.build((Context)pddContext, integrationFunctionError, erroreIntegrazione, configException, null);
                    } else {
                        Eccezione ecc = Eccezione.getEccezioneValidazione((ErroreCooperazione)ErroriCooperazione.MESSAGE_SECURITY.getErroreMessageSecurity(msgErrore, codiceErroreCooperazione), this.localForwardParameter.getProtocolFactory());
                        if (logDiagnosticError) {
                            this.localForwardParameter.getMsgDiag().logErroreGenerico(ecc.getDescrizione(this.localForwardParameter.getProtocolFactory()), (String)posizione);
                        }
                        this.responseMessageError = this.generatoreErrorePortaDelegata.build((Context)pddContext, integrationFunctionError, ecc, this.richiestaDelegata.getIdSoggettoFruitore(), null);
                    }
                    if (!logDiagnosticError) {
                        this.localForwardParameter.getLog().error("(" + (String)posizione + ") " + Utilities.readFirstErrorValidMessageFromException((Throwable)configException), (Throwable)configException);
                    }
                }
                if (this.responseMessageError != null) {
                    return false;
                }
                this.localForwardParameter.getMsgDiag().mediumDebug("init MTOM Processor / SecurityContext (PA) ...");
                erroreIntegrazione = null;
                codiceErroreCooperazione = null;
                configException = null;
                mtomConfig = null;
                mtomProcessor = null;
                msgErrore = null;
                posizione = null;
                messageSecurityContext = null;
                logDiagnosticError = true;
                integrationFunctionError = null;
                try {
                    this.securityConfigPARequest = this.localForwardParameter.getConfigurazionePdDReader().getMessageSecurityForReceiver(this.pa, this.localForwardParameter.getLog(), requestMessage, this.busta, this.requestInfo, this.localForwardParameter.getPddContext());
                }
                catch (Exception e) {
                    posizione = "LetturaParametriSicurezzaMessaggioPARequest";
                    erroreIntegrazione = ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento((Throwable)e, CodiceErroreIntegrazione.CODICE_536_CONFIGURAZIONE_NON_DISPONIBILE);
                    configException = e;
                    integrationFunctionError = IntegrationFunctionError.INTERNAL_REQUEST_ERROR;
                }
                if (erroreIntegrazione == null) {
                    try {
                        mtomConfig = this.localForwardParameter.getConfigurazionePdDReader().getMTOMProcessorForReceiver(this.pa);
                    }
                    catch (Exception e) {
                        posizione = "LetturaParametriMTOMProcessorPARequest";
                        erroreIntegrazione = ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento((Throwable)e, CodiceErroreIntegrazione.CODICE_536_CONFIGURAZIONE_NON_DISPONIBILE);
                        configException = e;
                        integrationFunctionError = IntegrationFunctionError.INTERNAL_REQUEST_ERROR;
                    }
                }
                if (erroreIntegrazione == null) {
                    mtomProcessor = new MTOMProcessor(mtomConfig, this.securityConfigPARequest, TipoPdD.APPLICATIVA, this.localForwardParameter.getMsgDiag(), this.localForwardParameter.getLog(), this.localForwardParameter.getPddContext());
                }
                if (mtomProcessor != null && erroreIntegrazione == null) {
                    try {
                        mtomProcessor.mtomBeforeSecurity(requestMessage, RuoloMessaggio.RICHIESTA);
                    }
                    catch (Exception e) {
                        logDiagnosticError = false;
                        posizione = "MTOMProcessor(BeforeSec-" + String.valueOf(mtomProcessor.getMTOMProcessorType()) + ")PARequest";
                        erroreIntegrazione = ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento((Throwable)e, CodiceErroreIntegrazione.CODICE_557_MTOM_PROCESSOR_ERROR);
                        configException = e;
                        integrationFunctionError = IntegrationFunctionError.ATTACHMENTS_PROCESSING_REQUEST_FAILED;
                    }
                }
                if (erroreIntegrazione == null && this.securityConfigPARequest != null && this.securityConfigPARequest.getFlowParameters() != null && this.securityConfigPARequest.getFlowParameters().size() > 0) {
                    try {
                        this.localForwardParameter.getMsgDiag().mediumDebug("Inizializzazione contesto di Message Security (PA) della richiesta ...");
                        if (messageSecurityApply) {
                            OpenSPCoop2SoapMessage soapMessage = requestMessage.castAsSoap();
                            DOMSource s = (DOMSource)soapMessage.getSOAPPart().getContent();
                            Node n = s.getNode();
                            MessageXMLUtils xmlUtils = MessageXMLUtils.getInstance((OpenSPCoop2MessageFactory)requestMessage.getFactory());
                            byte[] bytes = xmlUtils.toByteArray(n);
                            soapMessage.getSOAPPart().setContent((Source)new DOMSource(xmlUtils.newElement(bytes)));
                        }
                        contextParameters = new MessageSecurityContextParameters();
                        contextParameters.setUseActorDefaultIfNotDefined(this.propertiesReader.isGenerazioneActorDefault(this.localForwardParameter.getImplementazionePdDMittente()));
                        contextParameters.setActorDefault(this.propertiesReader.getActorDefault(this.localForwardParameter.getImplementazionePdDMittente()));
                        contextParameters.setLog(this.localForwardParameter.getLog());
                        contextParameters.setFunctionAsClient(false);
                        contextParameters.setPrefixWsuId(this.propertiesReader.getPrefixWsuId());
                        contextParameters.setRemoveAllWsuIdRef(this.propertiesReader.isRemoveAllWsuIdRef());
                        contextParameters.setIdFruitore(this.richiestaDelegata.getIdSoggettoFruitore());
                        contextParameters.setIdServizio(this.richiestaDelegata.getIdServizio());
                        contextParameters.setPddFruitore(this.localForwardParameter.getIdPdDMittente());
                        contextParameters.setPddErogatore(this.localForwardParameter.getIdPdDDestinatario());
                        messageSecurityContext = messageSecurityFactory.getMessageSecurityContext(contextParameters);
                        messageSecurityContext.setIncomingProperties(this.securityConfigPARequest.getFlowParameters());
                        this.localForwardParameter.getMsgDiag().mediumDebug("Inizializzazione contesto di Message Security (PA) della richiesta completata con successo");
                    }
                    catch (Exception e) {
                        posizione = "MessageSecurityPortaApplicativaRequestFlowInitContext";
                        erroreIntegrazione = ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento((Throwable)e, CodiceErroreIntegrazione.CODICE_536_CONFIGURAZIONE_NON_DISPONIBILE);
                        configException = e;
                        integrationFunctionError = IntegrationFunctionError.INTERNAL_REQUEST_ERROR;
                    }
                }
                if (erroreIntegrazione == null && messageSecurityContext != null) {
                    digestReader = null;
                    if (messageSecurityContext != null) {
                        digestReader = messageSecurityContext.getDigestReader(requestMessage != null ? requestMessage.getFactory() : OpenSPCoop2MessageFactory.getDefaultMessageFactory());
                    }
                    if (digestReader != null) {
                        try {
                            this.localForwardParameter.getMsgDiag().mediumDebug("ReadSecurityInformation (PA) ...");
                            validazioneSemantica = this.localForwardParameter.getProtocolFactory().createValidazioneSemantica(state);
                            this.securityInfoRequest = validazioneSemantica.readSecurityInformation(digestReader, requestMessage);
                        }
                        catch (Exception e) {
                            posizione = "LetturaInformazioniSicurezzaPARequest";
                            erroreIntegrazione = ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_549_SECURITY_INFO_READER_ERROR);
                            configException = e;
                            integrationFunctionError = IntegrationFunctionError.MESSAGE_SECURITY_REQUEST_FAILED;
                        }
                    }
                }
                eccezioniSicurezza = new ArrayList<Eccezione>();
                if (erroreIntegrazione == null && messageSecurityContext != null) {
                    try {
                        if (WSSUtilities.isNormalizeToSaajImpl(messageSecurityContext)) {
                            this.localForwardParameter.getMsgDiag().mediumDebug("Normalize to saajImpl");
                            this.requestMessageAfterProcess = requestMessage = requestMessage.normalizeToSaajImpl();
                        }
                        tipoSicurezza = SecurityConstants.convertActionToString((Map)messageSecurityContext.getIncomingProperties());
                        this.localForwardParameter.getMsgDiag().addKeyword("@TIPO_SICUREZZA_MESSAGGIO_RICHIESTA@", tipoSicurezza);
                        this.localForwardParameter.getMsgDiag().logPersonalizzato("ricezioneBuste.", "messageSecurity.processamentoRichiestaInCorso");
                        DynamicMapBuilderUtils.injectDynamicMap(this.busta, this.requestInfo, (org.openspcoop2.utils.Map<Object>)this.localForwardParameter.getPddContext(), this.localForwardParameter.getLog());
                        if (!messageSecurityContext.processIncoming(requestMessage, this.busta, (org.openspcoop2.utils.Map)this.localForwardParameter.getPddContext(), this.getTransactionNullable() != null ? this.getTransactionNullable().getTempiElaborazione() : null)) {
                            Eccezione ecc;
                            if (messageSecurityContext.getListaSubCodiceErrore() != null && messageSecurityContext.getListaSubCodiceErrore().size() > 0) {
                                List subCodiciErrore = messageSecurityContext.getListaSubCodiceErrore();
                                for (SubErrorCodeSecurity subCodiceErrore : subCodiciErrore) {
                                    Eccezione ecc2 = new Eccezione(ErroriCooperazione.MESSAGE_SECURITY.getErroreMessageSecurity(subCodiceErrore.getMsgErrore(), messageSecurityContext.getCodiceErrore()), true, null, this.localForwardParameter.getProtocolFactory());
                                    ecc2.setSubCodiceEccezione((SubCodiceErrore)subCodiceErrore);
                                    eccezioniSicurezza.add(ecc2);
                                }
                            } else {
                                ecc = new Eccezione(ErroriCooperazione.MESSAGE_SECURITY.getErroreMessageSecurity(messageSecurityContext.getMsgErrore(), messageSecurityContext.getCodiceErrore()), true, null, this.localForwardParameter.getProtocolFactory());
                                eccezioniSicurezza.add(ecc);
                            }
                            ecc = (Eccezione)eccezioniSicurezza.get(0);
                            this.localForwardParameter.getMsgDiag().addKeyword("@ERRORE_PROCESSAMENTO@", "[" + String.valueOf(ecc.getCodiceEccezione()) + "] " + ecc.getDescrizione(this.localForwardParameter.getProtocolFactory()));
                            this.localForwardParameter.getMsgDiag().logPersonalizzato("ricezioneBuste.", "messageSecurity.processamentoRichiestaInErrore");
                            break block73;
                        }
                        this.localForwardParameter.getMsgDiag().logPersonalizzato("ricezioneBuste.", "messageSecurity.processamentoRichiestaEffettuato");
                    }
                    catch (Exception e) {
                        this.localForwardParameter.getMsgDiag().addKeywordErroreProcessamento(e);
                        this.localForwardParameter.getMsgDiag().logPersonalizzato("ricezioneBuste.", "messageSecurity.processamentoRichiestaInErrore");
                        posizione = "MessageSecurityPortaApplicativaRequestFlow";
                        erroreIntegrazione = ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento((Throwable)e, CodiceErroreIntegrazione.CODICE_536_CONFIGURAZIONE_NON_DISPONIBILE);
                        configException = e;
                        integrationFunctionError = IntegrationFunctionError.MESSAGE_SECURITY_REQUEST_FAILED;
                    }
                } else if (erroreIntegrazione == null) {
                    this.localForwardParameter.getMsgDiag().logPersonalizzato("ricezioneBuste.", "messageSecurity.processamentoRichiestaDisabilitato");
                }
            }
            if (mtomProcessor != null && erroreIntegrazione == null) {
                try {
                    mtomProcessor.mtomAfterSecurity(requestMessage, RuoloMessaggio.RICHIESTA);
                }
                catch (Exception e) {
                    logDiagnosticError = false;
                    posizione = "MTOMProcessor(AfterSec-" + String.valueOf(mtomProcessor.getMTOMProcessorType()) + ")PARequest";
                    erroreIntegrazione = ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento((Throwable)e, CodiceErroreIntegrazione.CODICE_557_MTOM_PROCESSOR_ERROR);
                    configException = e;
                    integrationFunctionError = IntegrationFunctionError.ATTACHMENTS_PROCESSING_REQUEST_FAILED;
                }
            }
            if (erroreIntegrazione != null || eccezioniSicurezza.size() > 0) {
                if (integrationFunctionError == null) {
                    integrationFunctionError = IntegrationFunctionError.INTERNAL_REQUEST_ERROR;
                }
                if (erroreIntegrazione != null) {
                    if (logDiagnosticError) {
                        this.localForwardParameter.getMsgDiag().logErroreGenerico(erroreIntegrazione.getDescrizione(this.localForwardParameter.getProtocolFactory()), (String)posizione);
                    }
                    this.responseMessageError = this.generatoreErrorePortaDelegata.build((Context)pddContext, integrationFunctionError, erroreIntegrazione, configException, null);
                } else {
                    Eccezione ecc = (Eccezione)eccezioniSicurezza.get(0);
                    if (logDiagnosticError) {
                        this.localForwardParameter.getMsgDiag().logErroreGenerico(ecc.getDescrizione(this.localForwardParameter.getProtocolFactory()), (String)posizione);
                    }
                    this.responseMessageError = this.generatoreErrorePortaDelegata.build((Context)pddContext, integrationFunctionError, ecc, this.richiestaDelegata.getIdSoggettoFruitore(), null);
                }
                if (!logDiagnosticError) {
                    this.localForwardParameter.getLog().error("(" + (String)posizione + ") " + Utilities.readFirstErrorValidMessageFromException((Throwable)configException), (Throwable)configException);
                }
            }
            return this.responseMessageError == null;
        }
        catch (Exception e) {
            throw new LocalForwardException(e.getMessage(), e);
        }
    }

    public void sendRequest(GestoreMessaggi gestoreMessaggiRequest) throws LocalForwardException {
        try {
            Behaviour behaviour = this.ejbUtils.sendToConsegnaContenutiApplicativi(this.requestInfo, this.richiestaApplicativa, this.busta, gestoreMessaggiRequest, this.pa, this.localForwardParameter.getRepositoryBuste(), this.richiestaDelegata);
            boolean behaviourResponseTo = behaviour != null && behaviour.isResponseTo();
            GestoreMessaggi msgOK = null;
            if (behaviourResponseTo) {
                this.localForwardParameter.getPddContext().addObject(Costanti.DATA_PRESA_IN_CARICO, DateUtils.getSimpleDateFormatMs().format(DateManager.getDate()));
                this.localForwardParameter.getMsgDiag().mediumDebug("Invio messaggio 'OK' al modulo di RicezioneContenutiApplicativi (Behaviour)...");
                OpenSPCoop2Message responseToMessage = null;
                if (behaviour.getResponseTo() != null) {
                    responseToMessage = behaviour.getResponseTo().getMessage();
                }
                if (responseToMessage == null) {
                    responseToMessage = this.localForwardParameter.getProtocolFactory().createProtocolManager().isHttpEmptyResponseOneWay() ? MessageUtilities.buildEmptyMessage((OpenSPCoop2MessageFactory)OpenSPCoop2MessageFactory.getDefaultMessageFactory(), (MessageType)this.requestInfo.getIntegrationRequestMessageType(), (MessageRole)MessageRole.RESPONSE) : this.ejbUtils.buildOpenSPCoopOK(this.requestInfo.getIntegrationRequestMessageType(), this.localForwardParameter.getIdRequest());
                }
                msgOK = this.ejbUtils.sendRispostaApplicativaOK(responseToMessage, this.richiestaDelegata, this.pd, this.sa);
            } else if (!this.localForwardParameter.isStateless() || this.localForwardParameter.isOneWayVersione11() || this.ejbUtils.isGestioneSolamenteConIntegrationManager()) {
                this.localForwardParameter.getPddContext().addObject(Costanti.DATA_PRESA_IN_CARICO, DateUtils.getSimpleDateFormatMs().format(DateManager.getDate()));
                this.localForwardParameter.getMsgDiag().mediumDebug("Invio messaggio 'OK' al modulo di RicezioneContenutiApplicativi...");
                msgOK = this.localForwardParameter.getProtocolFactory().createProtocolManager().isHttpEmptyResponseOneWay() ? this.ejbUtils.sendRispostaApplicativaOK(MessageUtilities.buildEmptyMessage((OpenSPCoop2MessageFactory)OpenSPCoop2MessageFactory.getDefaultMessageFactory(), (MessageType)this.requestInfo.getIntegrationRequestMessageType(), (MessageRole)MessageRole.RESPONSE), this.richiestaDelegata, this.pd, this.sa) : this.ejbUtils.sendRispostaApplicativaOK(this.ejbUtils.buildOpenSPCoopOK(this.requestInfo.getIntegrationRequestMessageType(), this.localForwardParameter.getIdRequest()), this.richiestaDelegata, this.pd, this.sa);
            }
            if (msgOK != null) {
                msgOK.addMessaggiIntoCache_readFromTable("Imbustamento", "messaggio OK");
            }
            if (msgOK != null) {
                msgOK.addProprietariIntoCache_readFromTable("Imbustamento", "messaggio OK", this.localForwardParameter.getIdRequest(), false);
            }
        }
        catch (Exception e) {
            throw new LocalForwardException(e.getMessage(), e);
        }
    }

    public SecurityInfo getSecurityInfoResponse() {
        return this.securityInfoResponse;
    }

    public OpenSPCoop2Message getResponseMessageAfterProcess() {
        return this.responseMessageAfterProcess;
    }

    public boolean processResponse(OpenSPCoop2Message responseMessage) throws LocalForwardException {
        try {
            Eccezione ecc;
            IValidazioneSemantica validazioneSemantica;
            IDigestReader digestReader;
            MessageSecurityContext messageSecurityContext;
            IntegrationFunctionError integrationFunctionError;
            boolean logDiagnosticError;
            MTOMProcessor mtomProcessor;
            Object posizione;
            String msgErrore;
            PdDContext pddContext;
            IState state;
            Exception configException;
            CodiceErroreCooperazione codiceErroreCooperazione;
            ErroreIntegrazione erroreIntegrazione;
            block70: {
                MessageSecurityContextParameters contextParameters;
                MTOMProcessorConfig mtomConfig;
                MessageSecurityConfig securityConfig;
                boolean messageSecurityApply;
                MessageSecurityFactory messageSecurityFactory;
                block69: {
                    erroreIntegrazione = null;
                    codiceErroreCooperazione = null;
                    configException = null;
                    messageSecurityFactory = new MessageSecurityFactory();
                    state = ((OpenSPCoopState)this.localForwardParameter.getOpenspcoopstate()).getStatoRisposta();
                    pddContext = this.localForwardParameter.getPddContext();
                    messageSecurityApply = false;
                    this.localForwardParameter.getMsgDiag().mediumDebug("init MTOM Processor / SecurityContext (PA-Response) ...");
                    securityConfig = null;
                    mtomConfig = null;
                    msgErrore = null;
                    posizione = null;
                    mtomProcessor = null;
                    logDiagnosticError = true;
                    integrationFunctionError = null;
                    try {
                        securityConfig = this.localForwardParameter.getConfigurazionePdDReader().getMessageSecurityForSender(this.pa, this.localForwardParameter.getLog(), responseMessage, this.busta, this.requestInfo, this.localForwardParameter.getPddContext(), this.securityConfigPARequest);
                    }
                    catch (Exception e) {
                        posizione = "LetturaParametriSicurezzaMessaggioPAResponse";
                        erroreIntegrazione = ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento((Throwable)e, CodiceErroreIntegrazione.CODICE_536_CONFIGURAZIONE_NON_DISPONIBILE);
                        configException = e;
                        integrationFunctionError = IntegrationFunctionError.INTERNAL_RESPONSE_ERROR;
                    }
                    if (erroreIntegrazione == null) {
                        try {
                            mtomConfig = this.localForwardParameter.getConfigurazionePdDReader().getMTOMProcessorForSender(this.pa);
                        }
                        catch (Exception e) {
                            posizione = "LetturaParametriMTOMProcessorPAResponse";
                            erroreIntegrazione = ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento((Throwable)e, CodiceErroreIntegrazione.CODICE_536_CONFIGURAZIONE_NON_DISPONIBILE);
                            configException = e;
                            integrationFunctionError = IntegrationFunctionError.INTERNAL_RESPONSE_ERROR;
                        }
                    }
                    if (erroreIntegrazione == null) {
                        mtomProcessor = new MTOMProcessor(mtomConfig, securityConfig, TipoPdD.APPLICATIVA, this.localForwardParameter.getMsgDiag(), this.localForwardParameter.getLog(), this.localForwardParameter.getPddContext());
                    }
                    if (mtomProcessor != null && erroreIntegrazione == null) {
                        try {
                            mtomProcessor.mtomBeforeSecurity(responseMessage, RuoloMessaggio.RISPOSTA);
                        }
                        catch (Exception e) {
                            logDiagnosticError = false;
                            posizione = "MTOMProcessor(BeforeSec-" + String.valueOf(mtomProcessor.getMTOMProcessorType()) + ")PAResponse";
                            erroreIntegrazione = ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento((Throwable)e, CodiceErroreIntegrazione.CODICE_557_MTOM_PROCESSOR_ERROR);
                            configException = e;
                            integrationFunctionError = IntegrationFunctionError.ATTACHMENTS_PROCESSING_RESPONSE_FAILED;
                        }
                    }
                    messageSecurityContext = null;
                    if (erroreIntegrazione == null && securityConfig != null && securityConfig.getFlowParameters() != null && securityConfig.getFlowParameters().size() > 0) {
                        try {
                            this.localForwardParameter.getMsgDiag().mediumDebug("Inizializzazione contesto di Message Security (PA) della risposta ...");
                            contextParameters = new MessageSecurityContextParameters();
                            contextParameters.setUseActorDefaultIfNotDefined(this.propertiesReader.isGenerazioneActorDefault(this.localForwardParameter.getImplementazionePdDMittente()));
                            contextParameters.setActorDefault(this.propertiesReader.getActorDefault(this.localForwardParameter.getImplementazionePdDMittente()));
                            contextParameters.setLog(this.localForwardParameter.getLog());
                            contextParameters.setFunctionAsClient(true);
                            contextParameters.setPrefixWsuId(this.propertiesReader.getPrefixWsuId());
                            contextParameters.setIdFruitore(this.richiestaDelegata.getIdSoggettoFruitore());
                            contextParameters.setIdServizio(this.richiestaDelegata.getIdServizio());
                            contextParameters.setPddFruitore(this.localForwardParameter.getIdPdDMittente());
                            contextParameters.setPddErogatore(this.localForwardParameter.getIdPdDDestinatario());
                            messageSecurityContext = messageSecurityFactory.getMessageSecurityContext(contextParameters);
                            messageSecurityContext.setOutgoingProperties(securityConfig.getFlowParameters());
                            this.localForwardParameter.getMsgDiag().mediumDebug("Inizializzazione contesto di Message Security (PA) della risposta completata con successo");
                        }
                        catch (Exception e) {
                            posizione = "MessageSecurityPortaApplicativaResponseFlowInitContext";
                            erroreIntegrazione = ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento((Throwable)e, CodiceErroreIntegrazione.CODICE_536_CONFIGURAZIONE_NON_DISPONIBILE);
                            configException = e;
                            integrationFunctionError = IntegrationFunctionError.INTERNAL_RESPONSE_ERROR;
                        }
                    }
                    if (erroreIntegrazione == null && messageSecurityContext != null) {
                        digestReader = null;
                        if (messageSecurityContext != null) {
                            digestReader = messageSecurityContext.getDigestReader(responseMessage != null ? responseMessage.getFactory() : OpenSPCoop2MessageFactory.getDefaultMessageFactory());
                        }
                        if (digestReader != null) {
                            try {
                                this.localForwardParameter.getMsgDiag().mediumDebug("ReadSecurityInformation (PA-Response) ...");
                                validazioneSemantica = this.localForwardParameter.getProtocolFactory().createValidazioneSemantica(state);
                                this.securityInfoResponse = validazioneSemantica.readSecurityInformation(digestReader, responseMessage);
                            }
                            catch (Exception e) {
                                posizione = "LetturaInformazioniSicurezzaPAResponse";
                                erroreIntegrazione = ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_549_SECURITY_INFO_READER_ERROR);
                                configException = e;
                                integrationFunctionError = IntegrationFunctionError.MESSAGE_SECURITY_RESPONSE_FAILED;
                            }
                        }
                    }
                    if (erroreIntegrazione == null && messageSecurityContext != null) {
                        try {
                            if (WSSUtilities.isNormalizeToSaajImpl(messageSecurityContext)) {
                                this.localForwardParameter.getMsgDiag().mediumDebug("Normalize to saajImpl");
                                this.responseMessageAfterProcess = responseMessage = responseMessage.normalizeToSaajImpl();
                            }
                            String tipoSicurezza = SecurityConstants.convertActionToString((Map)messageSecurityContext.getOutgoingProperties());
                            this.localForwardParameter.getMsgDiag().addKeyword("@TIPO_SICUREZZA_MESSAGGIO_RISPOSTA@", tipoSicurezza);
                            this.localForwardParameter.getMsgDiag().logPersonalizzato("ricezioneBuste.", "messageSecurity.processamentoRispostaInCorso");
                            messageSecurityApply = true;
                            DynamicMapBuilderUtils.injectDynamicMap(this.busta, this.requestInfo, (org.openspcoop2.utils.Map<Object>)pddContext, this.localForwardParameter.getLog());
                            if (!messageSecurityContext.processOutgoing(responseMessage, (org.openspcoop2.utils.Map)this.localForwardParameter.getPddContext(), this.getTransactionNullable() != null ? this.getTransactionNullable().getTempiElaborazione() : null)) {
                                msgErrore = messageSecurityContext.getMsgErrore();
                                codiceErroreCooperazione = messageSecurityContext.getCodiceErrore();
                                this.localForwardParameter.getMsgDiag().addKeyword("@ERRORE_PROCESSAMENTO@", "[" + String.valueOf(codiceErroreCooperazione) + "] " + msgErrore);
                                this.localForwardParameter.getMsgDiag().logPersonalizzato("ricezioneBuste.", "messageSecurity.processamentoRispostaInErrore");
                                break block69;
                            }
                            this.localForwardParameter.getMsgDiag().logPersonalizzato("ricezioneBuste.", "messageSecurity.processamentoRispostaEffettuato");
                        }
                        catch (Exception e) {
                            this.localForwardParameter.getMsgDiag().addKeywordErroreProcessamento(e);
                            this.localForwardParameter.getMsgDiag().logPersonalizzato("ricezioneBuste.", "messageSecurity.processamentoRispostaInErrore");
                            posizione = "MessageSecurityPortaApplicativaResponseFlow";
                            erroreIntegrazione = ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento((Throwable)e, CodiceErroreIntegrazione.CODICE_536_CONFIGURAZIONE_NON_DISPONIBILE);
                            configException = e;
                            integrationFunctionError = IntegrationFunctionError.MESSAGE_SECURITY_RESPONSE_FAILED;
                        }
                    } else if (erroreIntegrazione == null) {
                        this.localForwardParameter.getMsgDiag().logPersonalizzato("ricezioneBuste.", "messageSecurity.processamentoRispostaDisabilitato");
                    }
                }
                if (mtomProcessor != null && erroreIntegrazione == null) {
                    try {
                        mtomProcessor.mtomAfterSecurity(responseMessage, RuoloMessaggio.RISPOSTA);
                    }
                    catch (Exception e) {
                        logDiagnosticError = false;
                        posizione = "MTOMProcessor(AfterSec-" + String.valueOf(mtomProcessor.getMTOMProcessorType()) + ")PAResponse";
                        erroreIntegrazione = ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento((Throwable)e, CodiceErroreIntegrazione.CODICE_557_MTOM_PROCESSOR_ERROR);
                        configException = e;
                        integrationFunctionError = IntegrationFunctionError.ATTACHMENTS_PROCESSING_RESPONSE_FAILED;
                    }
                }
                if (erroreIntegrazione != null || codiceErroreCooperazione != null) {
                    if (integrationFunctionError == null) {
                        integrationFunctionError = IntegrationFunctionError.INTERNAL_RESPONSE_ERROR;
                    }
                    if (erroreIntegrazione != null) {
                        if (logDiagnosticError) {
                            this.localForwardParameter.getMsgDiag().logErroreGenerico(erroreIntegrazione.getDescrizione(this.localForwardParameter.getProtocolFactory()), (String)posizione);
                        }
                        this.responseMessageError = this.generatoreErrorePortaDelegata.build((Context)pddContext, integrationFunctionError, erroreIntegrazione, configException, responseMessage != null ? responseMessage.getParseException() : null);
                    } else {
                        ecc = Eccezione.getEccezioneValidazione((ErroreCooperazione)ErroriCooperazione.MESSAGE_SECURITY.getErroreMessageSecurity(msgErrore, codiceErroreCooperazione), this.localForwardParameter.getProtocolFactory());
                        if (logDiagnosticError) {
                            this.localForwardParameter.getMsgDiag().logErroreGenerico(ecc.getDescrizione(this.localForwardParameter.getProtocolFactory()), (String)posizione);
                        }
                        this.responseMessageError = this.generatoreErrorePortaDelegata.build((Context)pddContext, integrationFunctionError, ecc, this.richiestaDelegata.getIdSoggettoFruitore(), null);
                    }
                    if (!logDiagnosticError) {
                        this.localForwardParameter.getLog().error("(" + (String)posizione + ") " + Utilities.readFirstErrorValidMessageFromException((Throwable)configException), (Throwable)configException);
                    }
                }
                if (this.responseMessageError != null) {
                    return false;
                }
                this.localForwardParameter.getMsgDiag().mediumDebug("init MTOM Processor / SecurityContext (PD-Response) ...");
                erroreIntegrazione = null;
                codiceErroreCooperazione = null;
                configException = null;
                securityConfig = null;
                mtomConfig = null;
                mtomProcessor = null;
                msgErrore = null;
                posizione = null;
                messageSecurityContext = null;
                logDiagnosticError = true;
                integrationFunctionError = null;
                try {
                    securityConfig = this.localForwardParameter.getConfigurazionePdDReader().getMessageSecurityForReceiver(this.pd, this.localForwardParameter.getLog(), responseMessage, this.busta, this.requestInfo, this.localForwardParameter.getPddContext(), this.securityConfigPDRequest);
                }
                catch (Exception e) {
                    posizione = "LetturaParametriSicurezzaMessaggioPDResponse";
                    erroreIntegrazione = ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento((Throwable)e, CodiceErroreIntegrazione.CODICE_536_CONFIGURAZIONE_NON_DISPONIBILE);
                    configException = e;
                    integrationFunctionError = IntegrationFunctionError.INTERNAL_RESPONSE_ERROR;
                }
                if (erroreIntegrazione == null) {
                    try {
                        mtomConfig = this.localForwardParameter.getConfigurazionePdDReader().getMTOMProcessorForReceiver(this.pd);
                    }
                    catch (Exception e) {
                        posizione = "LetturaParametriMTOMProcessorPDResponse";
                        erroreIntegrazione = ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento((Throwable)e, CodiceErroreIntegrazione.CODICE_536_CONFIGURAZIONE_NON_DISPONIBILE);
                        configException = e;
                        integrationFunctionError = IntegrationFunctionError.INTERNAL_RESPONSE_ERROR;
                    }
                }
                if (erroreIntegrazione == null) {
                    mtomProcessor = new MTOMProcessor(mtomConfig, securityConfig, TipoPdD.DELEGATA, this.localForwardParameter.getMsgDiag(), this.localForwardParameter.getLog(), this.localForwardParameter.getPddContext());
                }
                if (mtomProcessor != null && erroreIntegrazione == null) {
                    try {
                        mtomProcessor.mtomBeforeSecurity(responseMessage, RuoloMessaggio.RISPOSTA);
                    }
                    catch (Exception e) {
                        logDiagnosticError = false;
                        posizione = "MTOMProcessor(BeforeSec-" + String.valueOf(mtomProcessor.getMTOMProcessorType()) + ")PDResponse";
                        erroreIntegrazione = ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento((Throwable)e, CodiceErroreIntegrazione.CODICE_557_MTOM_PROCESSOR_ERROR);
                        configException = e;
                        integrationFunctionError = IntegrationFunctionError.ATTACHMENTS_PROCESSING_RESPONSE_FAILED;
                    }
                }
                if (erroreIntegrazione == null) {
                    if (securityConfig != null && securityConfig.getFlowParameters() != null && securityConfig.getFlowParameters().size() > 0) {
                        try {
                            this.localForwardParameter.getMsgDiag().mediumDebug("Inizializzazione contesto di Message Security (PD) della risposta ...");
                            if (messageSecurityApply) {
                                OpenSPCoop2SoapMessage soapMessage = responseMessage.castAsSoap();
                                DOMSource s = (DOMSource)soapMessage.getSOAPPart().getContent();
                                Node n = s.getNode();
                                MessageXMLUtils xmlUtils = MessageXMLUtils.getInstance((OpenSPCoop2MessageFactory)responseMessage.getFactory());
                                byte[] bytes = xmlUtils.toByteArray(n);
                                soapMessage.getSOAPPart().setContent((Source)new DOMSource(xmlUtils.newElement(bytes)));
                            }
                            contextParameters = new MessageSecurityContextParameters();
                            contextParameters.setUseActorDefaultIfNotDefined(this.propertiesReader.isGenerazioneActorDefault(this.localForwardParameter.getImplementazionePdDDestinatario()));
                            contextParameters.setActorDefault(this.propertiesReader.getActorDefault(this.localForwardParameter.getImplementazionePdDDestinatario()));
                            contextParameters.setLog(this.localForwardParameter.getLog());
                            contextParameters.setFunctionAsClient(false);
                            contextParameters.setPrefixWsuId(this.propertiesReader.getPrefixWsuId());
                            contextParameters.setIdFruitore(this.richiestaDelegata.getIdSoggettoFruitore());
                            contextParameters.setIdServizio(this.richiestaDelegata.getIdServizio());
                            contextParameters.setPddFruitore(this.localForwardParameter.getIdPdDMittente());
                            contextParameters.setPddErogatore(this.localForwardParameter.getIdPdDDestinatario());
                            messageSecurityContext = messageSecurityFactory.getMessageSecurityContext(contextParameters);
                            messageSecurityContext.setIncomingProperties(securityConfig.getFlowParameters());
                            this.localForwardParameter.getMsgDiag().mediumDebug("Inizializzazione contesto di Message Security (PD) della risposta completata con successo");
                            if (WSSUtilities.isNormalizeToSaajImpl((MessageSecurityContext)messageSecurityContext)) {
                                this.localForwardParameter.getMsgDiag().mediumDebug("Normalize to saajImpl");
                                this.responseMessageAfterProcess = responseMessage = responseMessage.normalizeToSaajImpl();
                            }
                            String tipoSicurezza = SecurityConstants.convertActionToString((Map)messageSecurityContext.getIncomingProperties());
                            this.localForwardParameter.getMsgDiag().addKeyword("@TIPO_SICUREZZA_MESSAGGIO_RISPOSTA@", tipoSicurezza);
                            this.localForwardParameter.getMsgDiag().logPersonalizzato("inoltroBuste.", "messageSecurity.processamentoRispostaInCorso");
                            DynamicMapBuilderUtils.injectDynamicMap(this.busta, this.requestInfo, (org.openspcoop2.utils.Map<Object>)this.localForwardParameter.getPddContext(), this.localForwardParameter.getLog());
                            if (!messageSecurityContext.processIncoming(responseMessage, this.busta, (org.openspcoop2.utils.Map)this.localForwardParameter.getPddContext(), this.getTransactionNullable() != null ? this.getTransactionNullable().getTempiElaborazione() : null)) {
                                msgErrore = messageSecurityContext.getMsgErrore();
                                codiceErroreCooperazione = messageSecurityContext.getCodiceErrore();
                                this.localForwardParameter.getMsgDiag().addKeyword("@ERRORE_PROCESSAMENTO@", "[" + String.valueOf(codiceErroreCooperazione) + "] " + msgErrore);
                                this.localForwardParameter.getMsgDiag().logPersonalizzato("inoltroBuste.", "messageSecurity.processamentoRispostaInErrore");
                                break block70;
                            }
                            this.localForwardParameter.getMsgDiag().logPersonalizzato("inoltroBuste.", "messageSecurity.processamentoRispostaEffettuato");
                        }
                        catch (Exception e) {
                            this.localForwardParameter.getMsgDiag().addKeywordErroreProcessamento(e);
                            this.localForwardParameter.getMsgDiag().logPersonalizzato("inoltroBuste.", "messageSecurity.processamentoRispostaInErrore");
                            posizione = "MessageSecurityPortaDelegataResponseFlow";
                            erroreIntegrazione = ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento((Throwable)e, CodiceErroreIntegrazione.CODICE_536_CONFIGURAZIONE_NON_DISPONIBILE);
                            configException = e;
                            integrationFunctionError = IntegrationFunctionError.MESSAGE_SECURITY_RESPONSE_FAILED;
                        }
                    } else {
                        this.localForwardParameter.getMsgDiag().logPersonalizzato("inoltroBuste.", "messageSecurity.processamentoRispostaDisabilitato");
                    }
                }
            }
            if (erroreIntegrazione == null && codiceErroreCooperazione == null) {
                digestReader = null;
                if (messageSecurityContext != null) {
                    digestReader = messageSecurityContext.getDigestReader(responseMessage != null ? responseMessage.getFactory() : OpenSPCoop2MessageFactory.getDefaultMessageFactory());
                }
                if (digestReader != null) {
                    try {
                        this.localForwardParameter.getMsgDiag().mediumDebug("ReadSecurityInformation (PD-Response) ...");
                        validazioneSemantica = this.localForwardParameter.getProtocolFactory().createValidazioneSemantica(state);
                        this.securityInfoResponse = validazioneSemantica.readSecurityInformation(digestReader, responseMessage);
                    }
                    catch (Exception e) {
                        posizione = "LetturaInformazioniSicurezzaPDResponse";
                        erroreIntegrazione = ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_549_SECURITY_INFO_READER_ERROR);
                        configException = e;
                        integrationFunctionError = IntegrationFunctionError.MESSAGE_SECURITY_RESPONSE_FAILED;
                    }
                }
            }
            if (mtomProcessor != null && erroreIntegrazione == null) {
                try {
                    mtomProcessor.mtomAfterSecurity(responseMessage, RuoloMessaggio.RISPOSTA);
                }
                catch (Exception e) {
                    logDiagnosticError = false;
                    posizione = "MTOMProcessor(AfterSec-" + String.valueOf(mtomProcessor.getMTOMProcessorType()) + ")PDResponse";
                    erroreIntegrazione = ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento((Throwable)e, CodiceErroreIntegrazione.CODICE_557_MTOM_PROCESSOR_ERROR);
                    configException = e;
                    integrationFunctionError = IntegrationFunctionError.ATTACHMENTS_PROCESSING_RESPONSE_FAILED;
                }
            }
            if (erroreIntegrazione != null || codiceErroreCooperazione != null) {
                if (integrationFunctionError == null) {
                    integrationFunctionError = IntegrationFunctionError.INTERNAL_RESPONSE_ERROR;
                }
                if (erroreIntegrazione != null) {
                    if (logDiagnosticError) {
                        this.localForwardParameter.getMsgDiag().logErroreGenerico(erroreIntegrazione.getDescrizione(this.localForwardParameter.getProtocolFactory()), (String)posizione);
                    }
                    this.responseMessageError = this.generatoreErrorePortaDelegata.build((Context)pddContext, integrationFunctionError, erroreIntegrazione, configException, responseMessage != null ? responseMessage.getParseException() : null);
                } else {
                    ecc = Eccezione.getEccezioneValidazione((ErroreCooperazione)ErroriCooperazione.MESSAGE_SECURITY.getErroreMessageSecurity(msgErrore, codiceErroreCooperazione), this.localForwardParameter.getProtocolFactory());
                    if (logDiagnosticError) {
                        this.localForwardParameter.getMsgDiag().logErroreGenerico(ecc.getDescrizione(this.localForwardParameter.getProtocolFactory()), (String)posizione);
                    }
                    this.responseMessageError = this.generatoreErrorePortaDelegata.build((Context)pddContext, integrationFunctionError, ecc, this.richiestaDelegata.getIdSoggettoFruitore(), null);
                }
                if (!logDiagnosticError) {
                    this.localForwardParameter.getLog().error("(" + (String)posizione + ") " + Utilities.readFirstErrorValidMessageFromException((Throwable)configException), (Throwable)configException);
                }
            }
            return this.responseMessageError == null;
        }
        catch (Exception e) {
            throw new LocalForwardException(e.getMessage(), e);
        }
    }

    public void sendErrore(PdDContext pddContext, ErroreIntegrazione errore, Throwable eErrore, ParseException parseException) throws LocalForwardException {
        try {
            IntegrationFunctionError integrationFunctionError = this.getIntegrationFunctionError(pddContext);
            OpenSPCoop2Message responseMessageError = this.generatoreErrorePortaDelegata.build((Context)pddContext, integrationFunctionError, errore, eErrore, parseException);
            if (integrationFunctionError != null && (IntegrationFunctionError.SERVICE_UNAVAILABLE.equals((Object)integrationFunctionError) || IntegrationFunctionError.ENDPOINT_REQUEST_TIMED_OUT.equals((Object)integrationFunctionError))) {
                boolean isEnabled = this.propertiesReader.isEnabledServiceUnavailableRetryAfterPAConnectionFailed();
                Integer retryAfterSeconds = this.propertiesReader.getServiceUnavailableRetryAfterSecondsPAConnectionFailed();
                Integer retryAfterBackOffSeconds = this.propertiesReader.getServiceUnavailableRetryAfterSecondsRandomBackoffPAConnectionFailed();
                if (isEnabled && retryAfterSeconds != null && retryAfterSeconds > 0) {
                    int seconds = retryAfterSeconds;
                    if (retryAfterBackOffSeconds != null && retryAfterBackOffSeconds > 0) {
                        seconds += ServicesUtils.getRandom().nextInt(retryAfterBackOffSeconds);
                    }
                    responseMessageError.forceTransportHeader("Retry-After", "" + seconds);
                }
            }
            if (eErrore instanceof HandlerException) {
                HandlerException he = (HandlerException)eErrore;
                he.customized(responseMessageError);
            }
            this.sendErrore(responseMessageError);
        }
        catch (Exception e) {
            throw new LocalForwardException(e.getMessage(), e);
        }
    }

    public void sendErrore(PdDContext pddContext, Eccezione errore, IDSoggetto dominio, ParseException parseException) throws LocalForwardException {
        try {
            IntegrationFunctionError integrationFunctionError = this.getIntegrationFunctionError(pddContext);
            OpenSPCoop2Message responseMessageError = this.generatoreErrorePortaDelegata.build((Context)pddContext, integrationFunctionError, errore, dominio, parseException);
            this.sendErrore(responseMessageError);
        }
        catch (Exception e) {
            throw new LocalForwardException(e.getMessage(), e);
        }
    }

    public void sendErrore(OpenSPCoop2Message responseMessageError) throws LocalForwardException {
        try {
            this.ejbUtils.sendRispostaApplicativaErrore(responseMessageError, this.richiestaDelegata, true, this.pd, this.sa);
        }
        catch (Exception e) {
            throw new LocalForwardException(e.getMessage(), e);
        }
    }

    public void sendResponse(String idRisposta) throws LocalForwardException {
        try {
            GestoreMessaggi msgResponse = null;
            this.localForwardParameter.getMsgDiag().mediumDebug("Send risposta applicativa...");
            this.ejbUtils.setIdMessage(idRisposta);
            msgResponse = this.ejbUtils.sendRispostaApplicativa(this.richiestaDelegata, this.pd, this.sa);
            if (msgResponse != null) {
                msgResponse.addMessaggiIntoCache_readFromTable("SbustamentoRisposte", "risposte");
            }
            if (msgResponse != null) {
                msgResponse.addProprietariIntoCache_readFromTable("SbustamentoRisposte", "risposte", this.localForwardParameter.getIdRequest(), false);
            }
        }
        catch (Exception e) {
            throw new LocalForwardException(e.getMessage(), e);
        }
    }
}

