/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core;

import jakarta.xml.soap.SOAPEnvelope;
import java.io.ByteArrayOutputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.openspcoop2.core.commons.CoreException;
import org.openspcoop2.core.config.CorrelazioneApplicativa;
import org.openspcoop2.core.config.CorrelazioneApplicativaElemento;
import org.openspcoop2.core.config.CorrelazioneApplicativaRisposta;
import org.openspcoop2.core.config.CorrelazioneApplicativaRispostaElemento;
import org.openspcoop2.core.config.PortaApplicativa;
import org.openspcoop2.core.config.PortaDelegata;
import org.openspcoop2.core.config.constants.CostantiConfigurazione;
import org.openspcoop2.core.constants.Costanti;
import org.openspcoop2.core.id.IDPortaApplicativa;
import org.openspcoop2.core.id.IDPortaDelegata;
import org.openspcoop2.core.id.IDServizio;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.core.registry.Resource;
import org.openspcoop2.message.MessageUtils;
import org.openspcoop2.message.OpenSPCoop2Message;
import org.openspcoop2.message.constants.MessageType;
import org.openspcoop2.message.constants.ServiceBinding;
import org.openspcoop2.message.xml.XPathExpressionEngine;
import org.openspcoop2.pdd.config.ConfigurazionePdDManager;
import org.openspcoop2.pdd.config.CostantiProprieta;
import org.openspcoop2.pdd.config.OpenSPCoop2Properties;
import org.openspcoop2.pdd.core.GestoreCorrelazioneApplicativaConfig;
import org.openspcoop2.pdd.core.GestoreCorrelazioneApplicativaPSUtilities;
import org.openspcoop2.pdd.core.GestoreMessaggiException;
import org.openspcoop2.pdd.core.PdDContext;
import org.openspcoop2.pdd.core.Utilities;
import org.openspcoop2.pdd.core.behaviour.conditional.ConditionalUtils;
import org.openspcoop2.pdd.core.dynamic.DynamicUtils;
import org.openspcoop2.pdd.core.dynamic.ErrorHandler;
import org.openspcoop2.pdd.core.dynamic.MessageContent;
import org.openspcoop2.pdd.core.integrazione.HeaderIntegrazione;
import org.openspcoop2.pdd.core.transazioni.Transaction;
import org.openspcoop2.pdd.services.connector.FormUrlEncodedHttpServletRequest;
import org.openspcoop2.protocol.engine.Configurazione;
import org.openspcoop2.protocol.sdk.Busta;
import org.openspcoop2.protocol.sdk.Context;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.protocol.sdk.constants.CodiceErroreIntegrazione;
import org.openspcoop2.protocol.sdk.constants.ErroreIntegrazione;
import org.openspcoop2.protocol.sdk.constants.ErroriIntegrazione;
import org.openspcoop2.protocol.sdk.state.IState;
import org.openspcoop2.protocol.sdk.state.RequestInfo;
import org.openspcoop2.protocol.sdk.state.StateMessage;
import org.openspcoop2.protocol.sdk.state.URLProtocolContext;
import org.openspcoop2.utils.LoggerWrapperFactory;
import org.openspcoop2.utils.Map;
import org.openspcoop2.utils.MapKey;
import org.openspcoop2.utils.date.DateManager;
import org.openspcoop2.utils.regexp.RegularExpressionEngine;
import org.openspcoop2.utils.sql.ISQLQueryObject;
import org.openspcoop2.utils.sql.SQLObjectFactory;
import org.openspcoop2.utils.sql.SQLQueryObjectException;
import org.openspcoop2.utils.transport.http.HttpServletTransportRequestContext;
import org.openspcoop2.utils.xml.AbstractXPathExpressionEngine;
import org.openspcoop2.utils.xml2json.JsonXmlPathExpressionEngine;
import org.slf4j.Logger;
import org.w3c.dom.Comment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class GestoreCorrelazioneApplicativa {
    protected Logger log = null;
    public static final String CORRELAZIONE_APPLICATIVA = "CORRELAZIONE_APPLICATIVA";
    public static final String CORRELAZIONE_APPLICATIVA_COLUMN_ID_APPLICATIVO = "ID_APPLICATIVO";
    public static final String CORRELAZIONE_APPLICATIVA_COLUMN_ID_MESSAGGIO = "ID_MESSAGGIO";
    public static final MapKey<String> CONTEXT_CORRELAZIONE_APPLICATIVA_RICHIESTA = Map.newMapKey((String)"CONTEXT_CORRELAZIONE_APPLICATIVA_RICHIESTA");
    public static final MapKey<String> CONTEXT_CORRELAZIONE_APPLICATIVA_RISPOSTA = Map.newMapKey((String)"CONTEXT_CORRELAZIONE_APPLICATIVA_RISPOSTA");
    protected IState state;
    private String idBustaCorrelato;
    private String idCorrelazione;
    protected ErroreIntegrazione errore;
    protected IDSoggetto soggettoFruitore;
    protected IDServizio idServizio;
    private Busta busta;
    private Resource restResource;
    protected String servizioApplicativo;
    private boolean riusoIdentificativo = false;
    protected IProtocolFactory<?> protocolFactory = null;
    private Transaction transaction;
    private PdDContext pddContext;
    private RequestInfo requestInfo;
    private PortaDelegata pd;
    private PortaApplicativa pa;
    private int maxLengthCorrelazioneApplicativa = 255;
    private int maxLengthExceededCorrelazioneApplicativaIdentificazioneFallitaBloccaTruncateRequest = -1;
    private int maxLengthExceededCorrelazioneApplicativaIdentificazioneFallitaAccettaTruncateRequest = -1;
    private int maxLengthExceededCorrelazioneApplicativaIdentificazioneFallitaBloccaTruncateResponse = -1;
    private int maxLengthExceededCorrelazioneApplicativaIdentificazioneFallitaAccettaTruncateResponse = -1;
    private boolean isRichiestaIdentificativoEstrattoIsNullThrowError = false;
    private boolean isRispostaIdentificativoEstrattoIsNullThrowError = false;
    private boolean isRichiestaIdentificativoEstrattoIsEmptyThrowError = false;
    private boolean isRispostaIdentificativoEstrattoIsEmptyThrowError = false;
    private boolean isRichiestaRegolaCorrelazioneNonTrovataBlocca = false;
    private boolean isRispostaRegolaCorrelazioneNonTrovataBlocca = false;
    private static final String ERRORE_IDENTIFICAZIONE_MESSAGE = "errore durante l'analisi dell'elementName: ";
    private static final String ERRORE_IDENTIFICAZIONE_NON_IDENTIFICATO_NEL_ELEMENTO = "identificativo di correlazione applicativa non identificato nell'elemento [";
    private static final String ERRORE_IDENTIFICAZIONE_NON_IDENTIFICATO_NEL_ELEMENTO_MODALITA_URL_BASED = "] con modalita' di acquisizione urlBased (Pattern:";
    private static final String ERRORE_IDENTIFICAZIONE_NON_IDENTIFICATO_NEL_ELEMENTO_MODALITA_HEADER_BASED = "] con modalita' di acquisizione headerBased (Header:";
    private static final String ERRORE_IDENTIFICAZIONE_NON_IDENTIFICATO_NEL_ELEMENTO_MODALITA_CONTENT_BASED = "] con modalita' di acquisizione contentBased (Pattern:";
    private static final String ERRORE_IDENTIFICAZIONE_NON_IDENTIFICATO_NEL_ELEMENTO_MODALITA_TEMPLATE_BASED = "] con modalita' di acquisizione ";
    private static final String ERRORE_IDENTIFICAZIONE_PER_ELEMENTO = "identificativo di correlazione applicativa per l'elemento [";
    private static final String ERRORE_IDENTIFICAZIONE_PER_ELEMENTO_MODALITA_INPUT_BASED = "con modalita' di acquisizione inputBased non presente tra le informazioni di integrazione";
    private static final String COLUMN_SCADENZA = "SCADENZA";
    private static final String COLUMN_ORA_REGISTRAZIONE = "ORA_REGISTRAZIONE";
    private static final boolean RICHIESTA = true;
    private static final boolean RISPOSTA = false;
    private static final boolean BLOCCA = true;
    private static final boolean ACCETTA = false;

    public boolean isRiusoIdentificativo() {
        return this.riusoIdentificativo;
    }

    public GestoreCorrelazioneApplicativa(GestoreCorrelazioneApplicativaConfig config) {
        this.state = config.getState();
        this.log = config.getAlog() != null ? config.getAlog() : LoggerWrapperFactory.getLogger(GestoreCorrelazioneApplicativa.class);
        this.soggettoFruitore = config.getSoggettoFruitore();
        this.idServizio = config.getIdServizio();
        this.busta = config.getBusta();
        this.servizioApplicativo = config.getServizioApplicativo();
        this.protocolFactory = config.getProtocolFactory();
        this.transaction = config.getTransaction();
        this.pddContext = config.getPddContext();
        if (this.pddContext != null && this.pddContext.containsKey(Costanti.REQUEST_INFO)) {
            this.requestInfo = (RequestInfo)this.pddContext.getObject(Costanti.REQUEST_INFO);
        }
        List proprieta = null;
        if (config.getPd() != null) {
            this.pd = config.getPd();
            proprieta = this.pd.getProprietaList();
        } else if (config.getPa() != null) {
            this.pa = config.getPa();
            proprieta = this.pa.getProprietaList();
        }
        OpenSPCoop2Properties op2Properties = OpenSPCoop2Properties.getInstance();
        this.maxLengthCorrelazioneApplicativa = op2Properties.getMaxLengthCorrelazioneApplicativa();
        try {
            if (CostantiProprieta.isCorrelazioneApplicativaRichiestaIdentificazioneFallitaBloccaTruncate(proprieta, op2Properties.isMaxLengthExceededCorrelazioneApplicativaIdentificazioneFallitaBloccaTruncate())) {
                this.maxLengthExceededCorrelazioneApplicativaIdentificazioneFallitaBloccaTruncateRequest = op2Properties.getMaxLengthExceededCorrelazioneApplicativaIdentificazioneFallitaBloccaTruncate();
            }
        }
        catch (Exception e) {
            this.log.error("[isCorrelazioneApplicativaRichiesta_identificazioneFallita_blocca_truncate] failed: " + e.getMessage(), (Throwable)e);
        }
        try {
            if (CostantiProprieta.isCorrelazioneApplicativaRispostaIdentificazioneFallitaBloccaTruncate(proprieta, op2Properties.isMaxLengthExceededCorrelazioneApplicativaIdentificazioneFallitaBloccaTruncate())) {
                this.maxLengthExceededCorrelazioneApplicativaIdentificazioneFallitaBloccaTruncateResponse = op2Properties.getMaxLengthExceededCorrelazioneApplicativaIdentificazioneFallitaBloccaTruncate();
            }
        }
        catch (Exception e) {
            this.log.error("[isCorrelazioneApplicativaRisposta_identificazioneFallita_blocca_truncate] failed: " + e.getMessage(), (Throwable)e);
        }
        try {
            if (CostantiProprieta.isCorrelazioneApplicativaRichiestaIdentificazioneFallitaAccettaTruncate(proprieta, op2Properties.isMaxLengthExceededCorrelazioneApplicativaIdentificazioneFallitaAccettaTruncate())) {
                this.maxLengthExceededCorrelazioneApplicativaIdentificazioneFallitaAccettaTruncateRequest = op2Properties.getMaxLengthExceededCorrelazioneApplicativaIdentificazioneFallitaAccettaTruncate();
            }
        }
        catch (Exception e) {
            this.log.error("[isCorrelazioneApplicativaRichiesta_identificazioneFallita_accetta_truncate] failed: " + e.getMessage(), (Throwable)e);
        }
        try {
            if (CostantiProprieta.isCorrelazioneApplicativaRispostaIdentificazioneFallitaAccettaTruncate(proprieta, op2Properties.isMaxLengthExceededCorrelazioneApplicativaIdentificazioneFallitaAccettaTruncate())) {
                this.maxLengthExceededCorrelazioneApplicativaIdentificazioneFallitaAccettaTruncateResponse = op2Properties.getMaxLengthExceededCorrelazioneApplicativaIdentificazioneFallitaAccettaTruncate();
            }
        }
        catch (Exception e) {
            this.log.error("[isCorrelazioneApplicativaRisposta_identificazioneFallita_accetta_truncate] failed: " + e.getMessage(), (Throwable)e);
        }
        try {
            this.isRichiestaIdentificativoEstrattoIsNullThrowError = CostantiProprieta.isCorrelazioneApplicativaRichiestaIdentificativoEstrattoIsNullTerminaTransazioneConErrore(proprieta, op2Properties.isRepositoryCorrelazioneApplicativaRichiestaIdentificativoEstrattoIsNullConsideraErrore());
        }
        catch (Exception e) {
            this.log.error("[isCorrelazioneApplicativaRichiesta_identificativoEstrattoIsNull_terminaTransazioneConErrore] failed: " + e.getMessage(), (Throwable)e);
        }
        try {
            this.isRispostaIdentificativoEstrattoIsNullThrowError = CostantiProprieta.isCorrelazioneApplicativaRispostaIdentificativoEstrattoIsNullTerminaTransazioneConErrore(proprieta, op2Properties.isRepositoryCorrelazioneApplicativaRispostaIdentificativoEstrattoIsNullConsideraErrore());
        }
        catch (Exception e) {
            this.log.error("[isCorrelazioneApplicativaRisposta_identificativoEstrattoIsNull_terminaTransazioneConErrore] failed: " + e.getMessage(), (Throwable)e);
        }
        try {
            this.isRichiestaIdentificativoEstrattoIsEmptyThrowError = CostantiProprieta.isCorrelazioneApplicativaRichiestaIdentificativoEstrattoIsEmptyTerminaTransazioneConErrore(proprieta, op2Properties.isRepositoryCorrelazioneApplicativaRichiestaIdentificativoEstrattoIsEmptyConsideraErrore());
        }
        catch (Exception e) {
            this.log.error("[isCorrelazioneApplicativaRichiesta_identificativoEstrattoIsEmpty_terminaTransazioneConErrore] failed: " + e.getMessage(), (Throwable)e);
        }
        try {
            this.isRispostaIdentificativoEstrattoIsEmptyThrowError = CostantiProprieta.isCorrelazioneApplicativaRispostaIdentificativoEstrattoIsEmptyTerminaTransazioneConErrore(proprieta, op2Properties.isRepositoryCorrelazioneApplicativaRispostaIdentificativoEstrattoIsEmptyConsideraErrore());
        }
        catch (Exception e) {
            this.log.error("[isCorrelazioneApplicativaRisposta_identificativoEstrattoIsEmpty_terminaTransazioneConErrore] failed: " + e.getMessage(), (Throwable)e);
        }
        try {
            this.isRichiestaRegolaCorrelazioneNonTrovataBlocca = CostantiProprieta.isCorrelazioneApplicativaRichiestaRegolaNonTrovataTerminaTransazioneConErrore(proprieta, op2Properties.isRepositoryCorrelazioneApplicativaRichiestaRegolaCorrelazioneNonTrovataBlocca());
        }
        catch (Exception e) {
            this.log.error("[isCorrelazioneApplicativaRichiesta_regolaNonTrovata_terminaTransazioneConErrore] failed: " + e.getMessage(), (Throwable)e);
        }
        try {
            this.isRispostaRegolaCorrelazioneNonTrovataBlocca = CostantiProprieta.isCorrelazioneApplicativaRispostaRegolaNonTrovataTerminaTransazioneConErrore(proprieta, op2Properties.isRepositoryCorrelazioneApplicativaRispostaRegolaCorrelazioneNonTrovataBlocca());
        }
        catch (Exception e) {
            this.log.error("[isCorrelazioneApplicativaRisposta_regolaNonTrovata_terminaTransazioneConErrore] failed: " + e.getMessage(), (Throwable)e);
        }
    }

    public void updateState(IState state) {
        this.state = state;
    }

    private String buildErroreLunghezzaIdentificativo(String idCorrelazioneApplicativa) {
        return "Identificativo di correlazione applicativa identificato possiede una lunghezza (" + idCorrelazioneApplicativa.length() + ") superiore ai " + this.maxLengthCorrelazioneApplicativa + " caratteri consentiti";
    }

    private void checkExtractedIdentifierIsNull(String idCorrelazioneApplicativa, boolean request) throws GestoreMessaggiException {
        boolean identificativoEstrattoIsNullThrowError;
        boolean bl = identificativoEstrattoIsNullThrowError = request ? this.isRichiestaIdentificativoEstrattoIsNullThrowError : this.isRispostaIdentificativoEstrattoIsNullThrowError;
        if (idCorrelazioneApplicativa == null && identificativoEstrattoIsNullThrowError) {
            throw new GestoreMessaggiException("extracted identifier is null");
        }
    }

    private void checkExtractedIdentifierIsEmpty(String idCorrelazioneApplicativa, boolean request) throws GestoreMessaggiException {
        boolean identificativoEstrattoIsEmptyThrowError;
        boolean bl = identificativoEstrattoIsEmptyThrowError = request ? this.isRichiestaIdentificativoEstrattoIsEmptyThrowError : this.isRispostaIdentificativoEstrattoIsEmptyThrowError;
        if (StringUtils.isEmpty((CharSequence)idCorrelazioneApplicativa) && identificativoEstrattoIsEmptyThrowError) {
            throw new GestoreMessaggiException("extracted identifier is empty");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void verificaCorrelazione(CorrelazioneApplicativa correlazioneApplicativa, URLProtocolContext urlProtocolContext, OpenSPCoop2Message message, HeaderIntegrazione headerIntegrazione, boolean readFirstHeaderIntegrazione) throws GestoreMessaggiException, ProtocolException {
        if (this.transaction != null) {
            this.transaction.getTempiElaborazione().startCorrelazioneApplicativaRichiesta();
        }
        try {
            this.verificaCorrelazioneEngine(correlazioneApplicativa, urlProtocolContext, message, headerIntegrazione, readFirstHeaderIntegrazione);
        }
        finally {
            if (this.transaction != null) {
                this.transaction.getTempiElaborazione().endCorrelazioneApplicativaRichiesta();
            }
        }
    }

    public boolean verificaCorrelazioneIdentificativoRichiesta() throws GestoreMessaggiException {
        try {
            boolean bl = this.verificaCorrelazioneIdentificativoRichiestaEngine();
            return bl;
        }
        finally {
            if (this.transaction != null) {
                this.transaction.getTempiElaborazione().endCorrelazioneApplicativaRichiesta();
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private void verificaCorrelazioneEngine(CorrelazioneApplicativa correlazioneApplicativa, URLProtocolContext urlProtocolContext, OpenSPCoop2Message message, HeaderIntegrazione headerIntegrazione, boolean readFirstHeaderIntegrazione) throws GestoreMessaggiException, ProtocolException {
        if (correlazioneApplicativa == null) {
            this.errore = ErroriIntegrazione.ERRORE_416_CORRELAZIONE_APPLICATIVA_RICHIESTA_ERRORE.getErrore416_CorrelazioneApplicativaRichiesta("dati per l'identificazione dell'id di correlazione non presenti");
            throw new GestoreMessaggiException(this.errore.getDescrizione(this.protocolFactory));
        }
        if (message == null) {
            this.errore = ErroriIntegrazione.ERRORE_416_CORRELAZIONE_APPLICATIVA_RICHIESTA_ERRORE.getErrore416_CorrelazioneApplicativaRichiesta("messaggio non presente");
            throw new GestoreMessaggiException(this.errore.getDescrizione(this.protocolFactory));
        }
        element = null;
        elementJson = null;
        try {
            idTransazione = null;
            if (this.pddContext != null) {
                idTransazione = (String)this.pddContext.getObject(Costanti.ID_TRANSAZIONE);
            }
            bufferMessageReadOnly = OpenSPCoop2Properties.getInstance().isReadByPathBufferEnabled();
            checkSoapBodyEmpty = false;
            element = MessageUtils.getContentElement((OpenSPCoop2Message)message, (boolean)checkSoapBodyEmpty, (boolean)bufferMessageReadOnly, (String)idTransazione);
            elementJson = MessageUtils.getContentString((OpenSPCoop2Message)message, (boolean)bufferMessageReadOnly, (String)idTransazione);
        }
        catch (Exception e) {
            throw new GestoreMessaggiException(e.getMessage(), e);
        }
        checkElementoInTransito = false;
        if (correlazioneApplicativa.sizeElementoList() > 1) {
            checkElementoInTransito = true;
        } else if (correlazioneApplicativa.sizeElementoList() > 0 && (elemento = correlazioneApplicativa.getElemento(0)).getNome() != null && !"".equals(elemento.getNome())) {
            checkElementoInTransito = true;
        }
        nList = null;
        if (checkElementoInTransito) {
            try {
                if (ServiceBinding.SOAP.equals((Object)message.getServiceBinding())) {
                    envelope = (SOAPEnvelope)element;
                    if (envelope == null) {
                        throw new CoreException("Envelope non presente nel messaggio Soap");
                    }
                    if (envelope.getBody() == null || !envelope.getBody().hasChildNodes()) {
                        throw new CoreException("Body applicativo non presente nel messaggio Soap");
                    }
                    nListSoapBody = envelope.getBody().getChildNodes();
                    if (nListSoapBody == null || nListSoapBody.getLength() == 0) {
                        throw new CoreException("Elementi del Body non presenti?");
                    }
                    nList = new ArrayList<E>();
                    for (elem = 0; elem < nListSoapBody.getLength(); ++elem) {
                        nodeInEsame = nListSoapBody.item(elem);
                        if (nodeInEsame instanceof Text || nodeInEsame instanceof Comment) continue;
                        nList.add(nodeInEsame);
                    }
                } else if (MessageType.XML.equals((Object)message.getMessageType()) || MessageType.MIME_MULTIPART.equals((Object)message.getMessageType())) {
                    if (element != null) {
                        nList = new ArrayList<Node>();
                        nList.add(element);
                    }
                } else {
                    checkElementoInTransito = false;
                }
            }
            catch (Exception e) {
                this.errore = ErroriIntegrazione.ERRORE_416_CORRELAZIONE_APPLICATIVA_RICHIESTA_ERRORE.getErrore416_CorrelazioneApplicativaRichiesta("errore durante l'analisi dell'elementName: " + e.getMessage());
                throw new GestoreMessaggiException(this.errore.getDescrizione(this.protocolFactory), e);
            }
        }
        xPathEngine = new XPathExpressionEngine(message.getFactory());
        c = new ArrayList<CorrelazioneApplicativaElemento>();
        posizioneElementoQualsiasi = -1;
        for (i = 0; i < correlazioneApplicativa.sizeElementoList(); ++i) {
            elemento = correlazioneApplicativa.getElemento(i);
            if (elemento.getNome() == null || "".equals(elemento.getNome())) {
                if (posizioneElementoQualsiasi != -1) {
                    this.errore = ErroriIntegrazione.ERRORE_416_CORRELAZIONE_APPLICATIVA_RICHIESTA_ERRORE.getErrore416_CorrelazioneApplicativaRichiesta("errore durante l'analisi dell'elementName: piu' di un elemento '*' non puo' essere definito");
                    throw new GestoreMessaggiException(this.errore.getDescrizione(this.protocolFactory));
                }
                posizioneElementoQualsiasi = i;
                continue;
            }
            c.add(elemento);
        }
        if (posizioneElementoQualsiasi >= 0) {
            c.add(correlazioneApplicativa.getElemento(posizioneElementoQualsiasi));
        }
        findCorrelazione = false;
        correlazioneNonRiuscitaDaAccettare = false;
        idCorrelazioneApplicativa = null;
        posizioneUltimoNodo = -1;
        if (checkElementoInTransito && nList != null) {
            for (elem = 0; elem < nList.size(); ++elem) {
                nodeInEsame = (Node)nList.get(elem);
                if (nodeInEsame instanceof Text || nodeInEsame instanceof Comment) continue;
                posizioneUltimoNodo = elem;
            }
        } else {
            posizioneUltimoNodo = 0;
        }
        nomiPresentiBody = new ArrayList<String>();
        if (checkElementoInTransito && nList != null) {
            for (elem = 0; elem < nList.size(); ++elem) {
                elementName = null;
                nodeInEsame = (Node)nList.get(elem);
                if (nodeInEsame instanceof Text || nodeInEsame instanceof Comment) continue;
                try {
                    elementName = nodeInEsame.getLocalName();
                }
                catch (Exception e) {
                    this.errore = ErroriIntegrazione.ERRORE_416_CORRELAZIONE_APPLICATIVA_RICHIESTA_ERRORE.getErrore416_CorrelazioneApplicativaRichiesta("errore durante l'analisi dell'elementName: " + e.getMessage());
                    throw new GestoreMessaggiException(this.errore.getDescrizione(this.protocolFactory), e);
                }
                if (elementName == null) continue;
                nomiPresentiBody.add(elementName);
            }
        } else {
            nomiPresentiBody.add("PresenteSoloRegola*");
        }
        block22: for (elem = 0; elem < nomiPresentiBody.size(); ++elem) {
            elementName = (String)nomiPresentiBody.get(elem);
            if (findCorrelazione) break;
            for (i = 0; i < c.size(); ++i) {
                block110: {
                    elemento = (CorrelazioneApplicativaElemento)c.get(i);
                    bloccaIdentificazioneNonRiuscita = true;
                    if (CostantiConfigurazione.ACCETTA.equals((Object)elemento.getIdentificazioneFallita())) {
                        bloccaIdentificazioneNonRiuscita = false;
                    }
                    matchNodePerCorrelazioneApplicativa = false;
                    nomeElemento = null;
                    if (elemento.getNome() == null || "".equals(elemento.getNome())) {
                        matchNodePerCorrelazioneApplicativa = true;
                        nomeElemento = "*";
                        if (elem != posizioneUltimoNodo) {
                            continue;
                        }
                    } else if (this.idServizio != null && this.idServizio.getAzione() != null && this.idServizio.getAzione().equals(elemento.getNome()) || elementName.equals(elemento.getNome())) {
                        matchNodePerCorrelazioneApplicativa = true;
                        nomeElemento = elemento.getNome();
                    } else {
                        isResourceRest = false;
                        if (ServiceBinding.REST.equals((Object)message.getServiceBinding())) {
                            isResourceRest = this.isMatchResourceRest(elemento.getNome());
                        }
                        if (isResourceRest) {
                            matchNodePerCorrelazioneApplicativa = true;
                            nomeElemento = elemento.getNome();
                        } else {
                            try {
                                if (element == null && elementJson == null) {
                                    throw new CoreException("Contenuto non disponibile su cui effettuare un match");
                                }
                                nomeElemento = element != null ? AbstractXPathExpressionEngine.extractAndConvertResultAsString((Element)element, (AbstractXPathExpressionEngine)xPathEngine, (String)elemento.getNome(), (Logger)this.log) : JsonXmlPathExpressionEngine.extractAndConvertResultAsString((String)elementJson, (String)elemento.getNome(), (Logger)this.log);
                                if (nomeElemento != null) {
                                    matchNodePerCorrelazioneApplicativa = true;
                                }
                            }
                            catch (Exception e) {
                                error = "Calcolo (contentBased) non riuscito [" + elementName + "] [" + elemento.getNome() + "]: " + e.getMessage();
                                this.log.info((String)error);
                            }
                            if (!matchNodePerCorrelazioneApplicativa) {
                                try {
                                    nomeElemento = RegularExpressionEngine.getStringMatchPattern((String)urlProtocolContext.getUrlInvocazione_formBased(), (String)elemento.getNome());
                                    if (nomeElemento != null) {
                                        matchNodePerCorrelazioneApplicativa = true;
                                    }
                                }
                                catch (Exception e) {
                                    error = "Calcolo (urlBased) non riuscito [" + elementName + "] [" + elemento.getNome() + "]: " + e.getMessage();
                                    this.log.info((String)error);
                                }
                            }
                        }
                    }
                    this.riusoIdentificativo = CostantiConfigurazione.ABILITATO.equals((Object)elemento.getRiusoIdentificativo());
                    if (!matchNodePerCorrelazioneApplicativa) continue;
                    if (CostantiConfigurazione.CORRELAZIONE_APPLICATIVA_RICHIESTA_DISABILITATO.equals((Object)elemento.getIdentificazione())) {
                        correlazioneNonRiuscitaDaAccettare = true;
                        findCorrelazione = true;
                        continue block22;
                    }
                    if (readFirstHeaderIntegrazione && headerIntegrazione.getIdApplicativo() != null) {
                        idCorrelazioneApplicativa = headerIntegrazione.getIdApplicativo();
                        findCorrelazione = true;
                        continue block22;
                    }
                    if (CostantiConfigurazione.CORRELAZIONE_APPLICATIVA_RICHIESTA_URL_BASED.equals((Object)elemento.getIdentificazione())) {
                        try {
                            l = RegularExpressionEngine.getAllStringMatchPattern((String)urlProtocolContext.getUrlInvocazione_formBased(), (String)elemento.getPattern());
                            if (l != null && !l.isEmpty()) {
                                bf = new StringBuilder();
                                for (String id : l) {
                                    if (bf.length() > 0) {
                                        bf.append(" ");
                                    }
                                    bf.append(id);
                                }
                                idCorrelazioneApplicativa = bf.toString();
                            }
                            this.checkExtractedIdentifierIsNull(idCorrelazioneApplicativa, true);
                            this.checkExtractedIdentifierIsEmpty(idCorrelazioneApplicativa, true);
                        }
                        catch (Exception e) {
                            if (bloccaIdentificazioneNonRiuscita) {
                                this.errore = ErroriIntegrazione.ERRORE_416_CORRELAZIONE_APPLICATIVA_RICHIESTA_ERRORE.getErrore416_CorrelazioneApplicativaRichiesta("identificativo di correlazione applicativa non identificato nell'elemento [" + nomeElemento + "] con modalita' di acquisizione urlBased (Pattern:" + elemento.getPattern() + "): " + e.getMessage());
                                throw new GestoreMessaggiException(this.errore.getDescrizione(this.protocolFactory), e);
                            }
                            correlazioneNonRiuscitaDaAccettare = true;
                        }
                    } else if (CostantiConfigurazione.CORRELAZIONE_APPLICATIVA_RICHIESTA_HEADER_BASED.equals((Object)elemento.getIdentificazione())) {
                        try {
                            if (message == null || message.getTransportRequestContext() == null || message.getTransportRequestContext().getHeaders() == null || message.getTransportRequestContext().getHeaders().isEmpty()) {
                                throw new CoreException("headers not found");
                            }
                            idCorrelazioneApplicativa = message.getTransportRequestContext().getHeaderFirstValue(elemento.getPattern());
                            if (idCorrelazioneApplicativa == null) {
                                throw new GestoreMessaggiException("header not found");
                            }
                            this.checkExtractedIdentifierIsEmpty(idCorrelazioneApplicativa, true);
                        }
                        catch (Exception e) {
                            if (bloccaIdentificazioneNonRiuscita) {
                                this.errore = ErroriIntegrazione.ERRORE_416_CORRELAZIONE_APPLICATIVA_RICHIESTA_ERRORE.getErrore416_CorrelazioneApplicativaRichiesta("identificativo di correlazione applicativa non identificato nell'elemento [" + nomeElemento + "] con modalita' di acquisizione headerBased (Header:" + elemento.getPattern() + "): " + e.getMessage());
                                throw new GestoreMessaggiException(this.errore.getDescrizione(this.protocolFactory), e);
                            }
                            correlazioneNonRiuscitaDaAccettare = true;
                        }
                    } else if (CostantiConfigurazione.CORRELAZIONE_APPLICATIVA_RICHIESTA_INPUT_BASED.equals((Object)elemento.getIdentificazione())) {
                        idCorrelazioneApplicativa = headerIntegrazione.getIdApplicativo();
                        if (idCorrelazioneApplicativa == null || StringUtils.isEmpty((CharSequence)idCorrelazioneApplicativa) && this.isRichiestaIdentificativoEstrattoIsEmptyThrowError) {
                            if (bloccaIdentificazioneNonRiuscita) {
                                this.errore = ErroriIntegrazione.ERRORE_416_CORRELAZIONE_APPLICATIVA_RICHIESTA_ERRORE.getErrore416_CorrelazioneApplicativaRichiesta("identificativo di correlazione applicativa per l'elemento [" + nomeElemento + "] con modalita' di acquisizione inputBased non presente tra le informazioni di integrazione");
                                throw new GestoreMessaggiException(this.errore.getDescrizione(this.protocolFactory));
                            }
                            correlazioneNonRiuscitaDaAccettare = true;
                        }
                    } else if (CostantiConfigurazione.CORRELAZIONE_APPLICATIVA_RICHIESTA_TEMPLATE.equals((Object)elemento.getIdentificazione()) || CostantiConfigurazione.CORRELAZIONE_APPLICATIVA_RICHIESTA_FREEMARKER_TEMPLATE.equals((Object)elemento.getIdentificazione()) || CostantiConfigurazione.CORRELAZIONE_APPLICATIVA_RICHIESTA_VELOCITY_TEMPLATE.equals((Object)elemento.getIdentificazione())) {
                        try {
                            if (elemento.getPattern() == null || StringUtils.isEmpty((CharSequence)elemento.getPattern())) {
                                throw new CoreException("Template non disponibile");
                            }
                            pTrasporto = null;
                            urlInvocazione = null;
                            pQuery = null;
                            pForm = null;
                            if (this.requestInfo != null && this.requestInfo.getProtocolContext() != null) {
                                pTrasporto = this.requestInfo.getProtocolContext().getHeaders();
                                urlInvocazione = this.requestInfo.getProtocolContext().getUrlInvocazione_formBased();
                                pQuery = this.requestInfo.getProtocolContext().getParameters();
                                if (this.requestInfo.getProtocolContext() instanceof HttpServletTransportRequestContext && (httpServletRequest = (httpServletContext = this.requestInfo.getProtocolContext()).getHttpServletRequest()) instanceof FormUrlEncodedHttpServletRequest && (formServlet = (FormUrlEncodedHttpServletRequest)httpServletRequest).getFormUrlEncodedParametersValues() != null && !formServlet.getFormUrlEncodedParametersValues().isEmpty()) {
                                    pForm = formServlet.getFormUrlEncodedParametersValues();
                                }
                            }
                            messageContent = null;
                            bufferMessageReadOnly = OpenSPCoop2Properties.getInstance().isReadByPathBufferEnabled();
                            if (ServiceBinding.SOAP.equals((Object)message.getServiceBinding())) {
                                messageContent = new MessageContent(message.castAsSoap(), bufferMessageReadOnly, (Context)this.pddContext);
                            } else if (MessageType.XML.equals((Object)message.getMessageType())) {
                                messageContent = new MessageContent(message.castAsRestXml(), bufferMessageReadOnly, (Context)this.pddContext);
                            } else if (MessageType.JSON.equals((Object)message.getMessageType())) {
                                messageContent = new MessageContent(message.castAsRestJson(), bufferMessageReadOnly, (Context)this.pddContext);
                            }
                            dynamicMap = new HashMap<String, Object>();
                            errorHandler = new ErrorHandler();
                            DynamicUtils.fillDynamicMapRequest(this.log, dynamicMap, this.pddContext, urlInvocazione, message, messageContent, this.busta, pTrasporto, pQuery, pForm, errorHandler);
                            if (CostantiConfigurazione.CORRELAZIONE_APPLICATIVA_RICHIESTA_TEMPLATE.equals((Object)elemento.getIdentificazione())) {
                                idCorrelazioneApplicativa = DynamicUtils.convertDynamicPropertyValue("CorrelazioneApplicativaRichiesta.gwt", elemento.getPattern(), dynamicMap, this.pddContext);
                                if (idCorrelazioneApplicativa != null) {
                                    idCorrelazioneApplicativa = ConditionalUtils.normalizeTemplateResult(idCorrelazioneApplicativa);
                                }
                            } else {
                                bout = new ByteArrayOutputStream();
                                configurazionePdDManager = ConfigurazionePdDManager.getInstance(this.state);
                                idPA = null;
                                idPD = null;
                                if (this.pa != null) {
                                    idPA = new IDPortaApplicativa();
                                    idPA.setNome(this.pa.getNome());
                                } else if (this.pd != null) {
                                    idPD = new IDPortaDelegata();
                                    idPD.setNome(this.pd.getNome());
                                } else {
                                    throw new CoreException("Porta non disponibile");
                                }
                                v0 = template = idPA != null ? configurazionePdDManager.getTemplateCorrelazioneApplicativaRichiesta(idPA, elemento.getNome(), elemento.getPattern().getBytes(), this.requestInfo) : configurazionePdDManager.getTemplateCorrelazioneApplicativaRichiesta(idPD, elemento.getNome(), elemento.getPattern().getBytes(), this.requestInfo);
                                if (CostantiConfigurazione.CORRELAZIONE_APPLICATIVA_RICHIESTA_FREEMARKER_TEMPLATE.equals((Object)elemento.getIdentificazione())) {
                                    DynamicUtils.convertFreeMarkerTemplate(template, dynamicMap, bout);
                                } else {
                                    DynamicUtils.convertVelocityTemplate(template, dynamicMap, bout);
                                }
                                bout.flush();
                                bout.close();
                                idCorrelazioneApplicativa = bout.toString();
                                if (idCorrelazioneApplicativa != null) {
                                    idCorrelazioneApplicativa = ConditionalUtils.normalizeTemplateResult(idCorrelazioneApplicativa);
                                }
                            }
                            this.checkExtractedIdentifierIsNull(idCorrelazioneApplicativa, true);
                            this.checkExtractedIdentifierIsEmpty(idCorrelazioneApplicativa, true);
                        }
                        catch (Exception e) {
                            if (bloccaIdentificazioneNonRiuscita) {
                                this.errore = ErroriIntegrazione.ERRORE_416_CORRELAZIONE_APPLICATIVA_RICHIESTA_ERRORE.getErrore416_CorrelazioneApplicativaRichiesta("identificativo di correlazione applicativa non identificato nell'elemento [" + nomeElemento + "] con modalita' di acquisizione " + elemento.getIdentificazione().getValue() + "): " + e.getMessage());
                                throw new GestoreMessaggiException(this.errore.getDescrizione(this.protocolFactory), e);
                            }
                            correlazioneNonRiuscitaDaAccettare = true;
                        }
                    } else {
                        try {
                            if (ServiceBinding.REST.equals((Object)message.getServiceBinding()) && !MessageType.XML.equals((Object)message.getMessageType()) && !MessageType.JSON.equals((Object)message.getMessageType()) && !MessageType.MIME_MULTIPART.equals((Object)message.getMessageType())) {
                                throw new CoreException("MessageType [" + String.valueOf(message.getMessageType()) + "] non supportato con correlazione di tipo '" + CostantiConfigurazione.CORRELAZIONE_APPLICATIVA_RICHIESTA_CONTENT_BASED.toString() + "'");
                            }
                            if (element == null && elementJson == null) {
                                throw new CoreException("Contenuto non disponibile su cui effettuare una correlazione di tipo '" + CostantiConfigurazione.CORRELAZIONE_APPLICATIVA_RICHIESTA_CONTENT_BASED.toString() + "'");
                            }
                            idCorrelazioneApplicativa = element != null ? AbstractXPathExpressionEngine.extractAndConvertResultAsString((Element)element, (AbstractXPathExpressionEngine)xPathEngine, (String)elemento.getPattern(), (Logger)this.log) : JsonXmlPathExpressionEngine.extractAndConvertResultAsString((String)elementJson, (String)elemento.getPattern(), (Logger)this.log);
                            this.checkExtractedIdentifierIsNull(idCorrelazioneApplicativa, true);
                            this.checkExtractedIdentifierIsEmpty(idCorrelazioneApplicativa, true);
                        }
                        catch (Exception e) {
                            if (bloccaIdentificazioneNonRiuscita) {
                                this.errore = ErroriIntegrazione.ERRORE_416_CORRELAZIONE_APPLICATIVA_RICHIESTA_ERRORE.getErrore416_CorrelazioneApplicativaRichiesta("identificativo di correlazione applicativa non identificato nell'elemento [" + nomeElemento + "] con modalita' di acquisizione contentBased (Pattern:" + elemento.getPattern() + "): " + e.getMessage());
                                throw new GestoreMessaggiException(this.errore.getDescrizione(this.protocolFactory), e);
                            }
                            correlazioneNonRiuscitaDaAccettare = true;
                            debugInfo = "[AccettaIdentificazioneFallita] Identificativo di correlazione applicativa non identificato nell'elemento [" + nomeElemento + "] con modalita' di acquisizione contentBased (Pattern:" + elemento.getPattern() + "): " + e.getMessage();
                            this.log.info(debugInfo);
                        }
                    }
                    if (idCorrelazioneApplicativa == null || idCorrelazioneApplicativa.length() <= this.maxLengthCorrelazioneApplicativa) break block110;
                    if (!bloccaIdentificazioneNonRiuscita) ** GOTO lbl293
                    if (this.isTruncateEnabled(true, true)) {
                        idCorrelazioneApplicativa = this.truncate(idCorrelazioneApplicativa, true, true);
                    } else {
                        this.errore = ErroriIntegrazione.ERRORE_416_CORRELAZIONE_APPLICATIVA_RICHIESTA_ERRORE.getErrore416_CorrelazioneApplicativaRichiesta(this.buildErroreLunghezzaIdentificativo(idCorrelazioneApplicativa));
                        throw new GestoreMessaggiException(this.errore.getDescrizione(this.protocolFactory));
lbl293:
                        // 1 sources

                        if (this.isTruncateEnabled(true, false)) {
                            idCorrelazioneApplicativa = this.truncate(idCorrelazioneApplicativa, true, false);
                        } else {
                            erroreId = this.buildErroreLunghezzaIdentificativo(idCorrelazioneApplicativa);
                            this.log.error(erroreId);
                            correlazioneNonRiuscitaDaAccettare = true;
                            idCorrelazioneApplicativa = null;
                        }
                    }
                }
                findCorrelazione = true;
                continue block22;
            }
        }
        if (idCorrelazioneApplicativa == null) {
            generaErrore = false;
            if (!findCorrelazione) {
                generaErrore = this.isRichiestaRegolaCorrelazioneNonTrovataBlocca;
            } else {
                v1 = generaErrore = correlazioneNonRiuscitaDaAccettare == false;
            }
            if (generaErrore) {
                this.errore = ErroriIntegrazione.ERRORE_416_CORRELAZIONE_APPLICATIVA_RICHIESTA_ERRORE.getErrore416_CorrelazioneApplicativaRichiesta("Identificativo di correlazione applicativa non identificato; nessun elemento tra quelli di correlazione definiti \u00e8 presente nel body");
                throw new GestoreMessaggiException(this.errore.getDescrizione(this.protocolFactory));
            }
        } else {
            this.idCorrelazione = idCorrelazioneApplicativa;
            if (this.pddContext != null) {
                this.pddContext.addObject(GestoreCorrelazioneApplicativa.CONTEXT_CORRELAZIONE_APPLICATIVA_RICHIESTA, this.idCorrelazione);
            }
        }
    }

    private boolean verificaCorrelazioneIdentificativoRichiestaEngine() throws GestoreMessaggiException {
        if (this.riusoIdentificativo) {
            try {
                StateMessage stateMSG = (StateMessage)this.state;
                Connection connectionDB = stateMSG.getConnectionDB();
                this.executeVerificaCorrelazioneIdentificativoRichiesta(connectionDB);
            }
            catch (Exception er) {
                this.errore = ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_529_CORRELAZIONE_APPLICATIVA_RICHIESTA_NON_RIUSCITA);
                String error = "Verifica correlazione IDApplicativo - ID non riuscita: " + er.getMessage();
                this.log.error(error);
                throw new GestoreMessaggiException("Verifica correlazione IDApplicativo - ID non riuscita: " + er.getMessage(), er);
            }
            return this.idBustaCorrelato != null;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean executeVerificaCorrelazioneIdentificativoRichiesta(Connection connectionDB) throws SQLException, GestoreMessaggiException {
        Statement pstmt = null;
        ResultSet rs = null;
        boolean correlazionePresente = false;
        try {
            String valoreAzione = "(AZIONE is null)";
            if (this.idServizio.getAzione() != null && !"".equals(this.idServizio.getAzione())) {
                valoreAzione = "AZIONE=?";
            }
            StringBuilder query = new StringBuilder();
            query.append("SELECT * FROM CORRELAZIONE_APPLICATIVA WHERE ID_APPLICATIVO=? AND SERVIZIO_APPLICATIVO=? AND TIPO_MITTENTE=? AND MITTENTE=? AND TIPO_DESTINATARIO=? AND DESTINATARIO=? AND TIPO_SERVIZIO=? AND SERVIZIO=? AND VERSIONE_SERVIZIO=? AND " + valoreAzione);
            pstmt = connectionDB.prepareStatement(query.toString());
            int index = 1;
            pstmt.setString(index++, this.idCorrelazione);
            pstmt.setString(index++, this.servizioApplicativo);
            pstmt.setString(index++, this.soggettoFruitore.getTipo());
            pstmt.setString(index++, this.soggettoFruitore.getNome());
            pstmt.setString(index++, this.idServizio.getSoggettoErogatore().getTipo());
            pstmt.setString(index++, this.idServizio.getSoggettoErogatore().getNome());
            pstmt.setString(index++, this.idServizio.getTipo());
            pstmt.setString(index++, this.idServizio.getNome());
            pstmt.setInt(index++, this.idServizio.getVersione());
            if (this.idServizio.getAzione() != null && !"".equals(this.idServizio.getAzione())) {
                pstmt.setString(index, this.idServizio.getAzione());
            }
            if ((rs = pstmt.executeQuery()) == null) {
                pstmt.close();
                this.log.error("Verifica correlazione IDApplicativo - ID non riuscita: ResultSet is null?");
                throw new GestoreMessaggiException("Verifica correlazione IDApplicativo - ID non riuscita: ResultSet is null?");
            }
            correlazionePresente = rs.next();
            if (correlazionePresente) {
                this.idBustaCorrelato = rs.getString(CORRELAZIONE_APPLICATIVA_COLUMN_ID_MESSAGGIO);
            }
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
            }
            catch (Exception exception) {}
        }
        return correlazionePresente;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void verificaCorrelazioneRisposta(CorrelazioneApplicativaRisposta correlazioneApplicativa, OpenSPCoop2Message message, HeaderIntegrazione headerIntegrazione, boolean readFirstHeaderIntegrazione) throws GestoreMessaggiException, ProtocolException {
        if (this.transaction != null) {
            this.transaction.getTempiElaborazione().startCorrelazioneApplicativaRisposta();
        }
        try {
            this.verificaCorrelazioneRispostaEngine(correlazioneApplicativa, message, headerIntegrazione, readFirstHeaderIntegrazione);
        }
        finally {
            if (this.transaction != null) {
                this.transaction.getTempiElaborazione().endCorrelazioneApplicativaRisposta();
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private void verificaCorrelazioneRispostaEngine(CorrelazioneApplicativaRisposta correlazioneApplicativa, OpenSPCoop2Message message, HeaderIntegrazione headerIntegrazione, boolean readFirstHeaderIntegrazione) throws GestoreMessaggiException, ProtocolException {
        if (correlazioneApplicativa == null) {
            this.errore = ErroriIntegrazione.ERRORE_434_CORRELAZIONE_APPLICATIVA_RISPOSTA_ERRORE.getErrore434_CorrelazioneApplicativaRisposta("dati per l'identificazione dell'id di correlazione non presenti");
            throw new GestoreMessaggiException(this.errore.getDescrizione(this.protocolFactory));
        }
        if (message == null) {
            this.errore = ErroriIntegrazione.ERRORE_434_CORRELAZIONE_APPLICATIVA_RISPOSTA_ERRORE.getErrore434_CorrelazioneApplicativaRisposta("messaggio non presente");
            throw new GestoreMessaggiException(this.errore.getDescrizione(this.protocolFactory));
        }
        element = null;
        elementJson = null;
        try {
            idTransazione = null;
            if (this.pddContext != null) {
                idTransazione = (String)this.pddContext.getObject(Costanti.ID_TRANSAZIONE);
            }
            bufferMessageReadOnly = OpenSPCoop2Properties.getInstance().isReadByPathBufferEnabled();
            checkSoapBodyEmpty = false;
            element = MessageUtils.getContentElement((OpenSPCoop2Message)message, (boolean)checkSoapBodyEmpty, (boolean)bufferMessageReadOnly, (String)idTransazione);
            elementJson = MessageUtils.getContentString((OpenSPCoop2Message)message, (boolean)bufferMessageReadOnly, (String)idTransazione);
        }
        catch (Exception e) {
            throw new GestoreMessaggiException(e.getMessage(), e);
        }
        xPathEngine = new XPathExpressionEngine(message.getFactory());
        checkElementiInTransito = false;
        if (correlazioneApplicativa.sizeElementoList() > 1) {
            checkElementiInTransito = true;
        } else if (correlazioneApplicativa.sizeElementoList() > 0 && (elemento = correlazioneApplicativa.getElemento(0)).getNome() != null && !"".equals(elemento.getNome())) {
            checkElementiInTransito = true;
        }
        nList = null;
        if (checkElementiInTransito) {
            try {
                if (ServiceBinding.SOAP.equals((Object)message.getServiceBinding())) {
                    envelope = (SOAPEnvelope)element;
                    if (envelope == null) {
                        throw new CoreException("Envelope non presente nel messaggio Soap");
                    }
                    if (envelope.getBody() == null || !envelope.getBody().hasChildNodes()) {
                        throw new CoreException("Body applicativo non presente nel messaggio Soap");
                    }
                    nListSoapBody = envelope.getBody().getChildNodes();
                    if (nListSoapBody == null || nListSoapBody.getLength() == 0) {
                        throw new CoreException("Elementi del Body non presenti?");
                    }
                    nList = new ArrayList<E>();
                    for (elem = 0; elem < nListSoapBody.getLength(); ++elem) {
                        nodeInEsame = nListSoapBody.item(elem);
                        if (nodeInEsame instanceof Text || nodeInEsame instanceof Comment) continue;
                        nList.add(nodeInEsame);
                    }
                } else if (MessageType.XML.equals((Object)message.getMessageType()) || MessageType.MIME_MULTIPART.equals((Object)message.getMessageType())) {
                    if (element != null) {
                        nList = new ArrayList<Node>();
                        nList.add(element);
                    }
                } else {
                    checkElementiInTransito = false;
                }
            }
            catch (Exception e) {
                this.errore = ErroriIntegrazione.ERRORE_434_CORRELAZIONE_APPLICATIVA_RISPOSTA_ERRORE.getErrore434_CorrelazioneApplicativaRisposta("errore durante l'analisi dell'elementName: " + e.getMessage());
                throw new GestoreMessaggiException(this.errore.getDescrizione(this.protocolFactory), e);
            }
        }
        c = new ArrayList<CorrelazioneApplicativaRispostaElemento>();
        posizioneElementoQualsiasi = -1;
        for (i = 0; i < correlazioneApplicativa.sizeElementoList(); ++i) {
            elemento = correlazioneApplicativa.getElemento(i);
            if (elemento.getNome() == null || "".equals(elemento.getNome())) {
                if (posizioneElementoQualsiasi != -1) {
                    this.errore = ErroriIntegrazione.ERRORE_434_CORRELAZIONE_APPLICATIVA_RISPOSTA_ERRORE.getErrore434_CorrelazioneApplicativaRisposta("errore durante l'analisi dell'elementName: piu' di un elemento '*' non puo' essere definito");
                    throw new GestoreMessaggiException(this.errore.getDescrizione(this.protocolFactory));
                }
                posizioneElementoQualsiasi = i;
                continue;
            }
            c.add(elemento);
        }
        if (posizioneElementoQualsiasi >= 0) {
            c.add(correlazioneApplicativa.getElemento(posizioneElementoQualsiasi));
        }
        findCorrelazione = false;
        correlazioneNonRiuscitaDaAccettare = false;
        idCorrelazioneApplicativa = null;
        posizioneUltimoNodo = -1;
        if (checkElementiInTransito && nList != null) {
            for (elem = 0; elem < nList.size(); ++elem) {
                nodeInEsame = (Node)nList.get(elem);
                if (nodeInEsame instanceof Text || nodeInEsame instanceof Comment) continue;
                posizioneUltimoNodo = elem;
            }
        } else {
            posizioneUltimoNodo = 0;
        }
        nomiPresentiBody = new ArrayList<String>();
        if (checkElementiInTransito && nList != null) {
            for (elem = 0; elem < nList.size(); ++elem) {
                elementName = null;
                nodeInEsame = (Node)nList.get(elem);
                if (nodeInEsame instanceof Text || nodeInEsame instanceof Comment) continue;
                try {
                    elementName = nodeInEsame.getLocalName();
                }
                catch (Exception e) {
                    this.errore = ErroriIntegrazione.ERRORE_434_CORRELAZIONE_APPLICATIVA_RISPOSTA_ERRORE.getErrore434_CorrelazioneApplicativaRisposta("errore durante l'analisi dell'elementName: " + e.getMessage());
                    throw new GestoreMessaggiException(this.errore.getDescrizione(this.protocolFactory), e);
                }
                if (elementName == null) continue;
                nomiPresentiBody.add(elementName);
            }
        } else {
            nomiPresentiBody.add("PresenteSoloRegola*");
        }
        block18: for (elem = 0; elem < nomiPresentiBody.size(); ++elem) {
            elementName = (String)nomiPresentiBody.get(elem);
            if (findCorrelazione) break;
            for (i = 0; i < c.size(); ++i) {
                block101: {
                    elemento = (CorrelazioneApplicativaRispostaElemento)c.get(i);
                    bloccaIdentificazioneNonRiuscita = true;
                    if (CostantiConfigurazione.ACCETTA.equals((Object)elemento.getIdentificazioneFallita())) {
                        bloccaIdentificazioneNonRiuscita = false;
                    }
                    matchNodePerCorrelazioneApplicativa = false;
                    nomeElemento = null;
                    if (elemento.getNome() == null || "".equals(elemento.getNome())) {
                        matchNodePerCorrelazioneApplicativa = true;
                        nomeElemento = "*";
                        if (elem != posizioneUltimoNodo) {
                            continue;
                        }
                    } else if (this.idServizio != null && this.idServizio.getAzione() != null && this.idServizio.getAzione().equals(elemento.getNome()) || elementName.equals(elemento.getNome())) {
                        matchNodePerCorrelazioneApplicativa = true;
                        nomeElemento = elemento.getNome();
                    } else {
                        isResourceRest = false;
                        if (ServiceBinding.REST.equals((Object)message.getServiceBinding())) {
                            isResourceRest = this.isMatchResourceRest(elemento.getNome());
                        }
                        if (isResourceRest) {
                            matchNodePerCorrelazioneApplicativa = true;
                            nomeElemento = elemento.getNome();
                        } else {
                            try {
                                if (element == null && elementJson == null) {
                                    throw new CoreException("Contenuto non disponibile su cui effettuare un match");
                                }
                                nomeElemento = element != null ? AbstractXPathExpressionEngine.extractAndConvertResultAsString((Element)element, (AbstractXPathExpressionEngine)xPathEngine, (String)elemento.getNome(), (Logger)this.log) : JsonXmlPathExpressionEngine.extractAndConvertResultAsString((String)elementJson, (String)elemento.getNome(), (Logger)this.log);
                                if (nomeElemento != null) {
                                    matchNodePerCorrelazioneApplicativa = true;
                                }
                            }
                            catch (Exception e) {
                                error = "Calcolo non riuscito [" + elementName + "] [" + elemento.getNome() + "]: " + e.getMessage();
                                this.log.info(error);
                            }
                        }
                    }
                    if (!matchNodePerCorrelazioneApplicativa) continue;
                    if (CostantiConfigurazione.CORRELAZIONE_APPLICATIVA_RISPOSTA_DISABILITATO.equals((Object)elemento.getIdentificazione())) {
                        correlazioneNonRiuscitaDaAccettare = true;
                        findCorrelazione = true;
                        continue block18;
                    }
                    if (readFirstHeaderIntegrazione && headerIntegrazione.getIdApplicativo() != null) {
                        idCorrelazioneApplicativa = headerIntegrazione.getIdApplicativo();
                        findCorrelazione = true;
                        continue block18;
                    }
                    if (CostantiConfigurazione.CORRELAZIONE_APPLICATIVA_RISPOSTA_HEADER_BASED.equals((Object)elemento.getIdentificazione())) {
                        try {
                            if (message == null || message.getTransportResponseContext() == null || message.getTransportResponseContext().getHeaders() == null || message.getTransportResponseContext().getHeaders().isEmpty()) {
                                throw new CoreException("headers not found");
                            }
                            idCorrelazioneApplicativa = message.getTransportResponseContext().getHeaderFirstValue(elemento.getPattern());
                            if (idCorrelazioneApplicativa == null) {
                                throw new GestoreMessaggiException("header not found");
                            }
                            this.checkExtractedIdentifierIsEmpty(idCorrelazioneApplicativa, false);
                        }
                        catch (Exception e) {
                            if (bloccaIdentificazioneNonRiuscita) {
                                this.errore = ErroriIntegrazione.ERRORE_434_CORRELAZIONE_APPLICATIVA_RISPOSTA_ERRORE.getErrore434_CorrelazioneApplicativaRisposta("identificativo di correlazione applicativa per l'elemento [" + nomeElemento + "] con modalita' di acquisizione inputBased non presente tra le informazioni di integrazione");
                                throw new GestoreMessaggiException(this.errore.getDescrizione(this.protocolFactory));
                            }
                            correlazioneNonRiuscitaDaAccettare = true;
                        }
                    } else if (CostantiConfigurazione.CORRELAZIONE_APPLICATIVA_RISPOSTA_INPUT_BASED.equals((Object)elemento.getIdentificazione())) {
                        idCorrelazioneApplicativa = headerIntegrazione.getIdApplicativo();
                        if (idCorrelazioneApplicativa == null || StringUtils.isEmpty((CharSequence)idCorrelazioneApplicativa) && this.isRispostaIdentificativoEstrattoIsEmptyThrowError) {
                            if (bloccaIdentificazioneNonRiuscita) {
                                this.errore = ErroriIntegrazione.ERRORE_434_CORRELAZIONE_APPLICATIVA_RISPOSTA_ERRORE.getErrore434_CorrelazioneApplicativaRisposta("identificativo di correlazione applicativa per l'elemento [" + nomeElemento + "] con modalita' di acquisizione inputBased non presente tra le informazioni di integrazione");
                                throw new GestoreMessaggiException(this.errore.getDescrizione(this.protocolFactory));
                            }
                            correlazioneNonRiuscitaDaAccettare = true;
                        }
                    } else if (CostantiConfigurazione.CORRELAZIONE_APPLICATIVA_RISPOSTA_TEMPLATE.equals((Object)elemento.getIdentificazione()) || CostantiConfigurazione.CORRELAZIONE_APPLICATIVA_RISPOSTA_FREEMARKER_TEMPLATE.equals((Object)elemento.getIdentificazione()) || CostantiConfigurazione.CORRELAZIONE_APPLICATIVA_RISPOSTA_VELOCITY_TEMPLATE.equals((Object)elemento.getIdentificazione())) {
                        try {
                            if (elemento.getPattern() == null || StringUtils.isEmpty((CharSequence)elemento.getPattern())) {
                                throw new CoreException("Template non disponibile");
                            }
                            pTrasporto = null;
                            urlInvocazione = null;
                            pQuery = null;
                            pForm = null;
                            if (this.requestInfo != null && this.requestInfo.getProtocolContext() != null) {
                                pTrasporto = this.requestInfo.getProtocolContext().getHeaders();
                                urlInvocazione = this.requestInfo.getProtocolContext().getUrlInvocazione_formBased();
                                pQuery = this.requestInfo.getProtocolContext().getParameters();
                                if (this.requestInfo.getProtocolContext() instanceof HttpServletTransportRequestContext && (httpServletRequest = (httpServletContext = this.requestInfo.getProtocolContext()).getHttpServletRequest()) instanceof FormUrlEncodedHttpServletRequest && (formServlet = (FormUrlEncodedHttpServletRequest)httpServletRequest).getFormUrlEncodedParametersValues() != null && !formServlet.getFormUrlEncodedParametersValues().isEmpty()) {
                                    pForm = formServlet.getFormUrlEncodedParametersValues();
                                }
                            }
                            parametriTrasporto = null;
                            if (message.getTransportResponseContext() != null) {
                                if (message.getTransportResponseContext().getHeaders() != null && !message.getTransportResponseContext().getHeaders().isEmpty()) {
                                    parametriTrasporto = message.getTransportResponseContext().getHeaders();
                                } else {
                                    parametriTrasporto = new HashMap<K, V>();
                                    message.getTransportResponseContext().setHeaders(parametriTrasporto);
                                }
                            }
                            messageContent = null;
                            bufferMessageReadOnly = OpenSPCoop2Properties.getInstance().isReadByPathBufferEnabled();
                            if (ServiceBinding.SOAP.equals((Object)message.getServiceBinding())) {
                                messageContent = new MessageContent(message.castAsSoap(), bufferMessageReadOnly, (Context)this.pddContext);
                            } else if (MessageType.XML.equals((Object)message.getMessageType())) {
                                messageContent = new MessageContent(message.castAsRestXml(), bufferMessageReadOnly, (Context)this.pddContext);
                            } else if (MessageType.JSON.equals((Object)message.getMessageType())) {
                                messageContent = new MessageContent(message.castAsRestJson(), bufferMessageReadOnly, (Context)this.pddContext);
                            }
                            dynamicMapRequest = new HashMap<String, Object>();
                            errorHandlerRequest = new ErrorHandler();
                            DynamicUtils.fillDynamicMapRequest(this.log, dynamicMapRequest, this.pddContext, urlInvocazione, null, null, this.busta, pTrasporto, pQuery, pForm, errorHandlerRequest);
                            dynamicMap = new HashMap<String, Object>();
                            errorHandler = new ErrorHandler();
                            DynamicUtils.fillDynamicMapResponse(this.log, dynamicMap, dynamicMapRequest, this.pddContext, message, messageContent, this.busta, parametriTrasporto, errorHandler);
                            if (CostantiConfigurazione.CORRELAZIONE_APPLICATIVA_RISPOSTA_TEMPLATE.equals((Object)elemento.getIdentificazione())) {
                                idCorrelazioneApplicativa = DynamicUtils.convertDynamicPropertyValue("CorrelazioneApplicativaRisposta.gwt", elemento.getPattern(), dynamicMap, this.pddContext);
                                if (idCorrelazioneApplicativa != null) {
                                    idCorrelazioneApplicativa = ConditionalUtils.normalizeTemplateResult(idCorrelazioneApplicativa);
                                }
                            } else {
                                bout = new ByteArrayOutputStream();
                                configurazionePdDManager = ConfigurazionePdDManager.getInstance(this.state);
                                idPA = null;
                                idPD = null;
                                if (this.pa != null) {
                                    idPA = new IDPortaApplicativa();
                                    idPA.setNome(this.pa.getNome());
                                } else if (this.pd != null) {
                                    idPD = new IDPortaDelegata();
                                    idPD.setNome(this.pd.getNome());
                                } else {
                                    throw new CoreException("Porta non disponibile");
                                }
                                v0 = template = idPA != null ? configurazionePdDManager.getTemplateCorrelazioneApplicativaRisposta(idPA, elemento.getNome(), elemento.getPattern().getBytes(), this.requestInfo) : configurazionePdDManager.getTemplateCorrelazioneApplicativaRisposta(idPD, elemento.getNome(), elemento.getPattern().getBytes(), this.requestInfo);
                                if (CostantiConfigurazione.CORRELAZIONE_APPLICATIVA_RISPOSTA_FREEMARKER_TEMPLATE.equals((Object)elemento.getIdentificazione())) {
                                    DynamicUtils.convertFreeMarkerTemplate(template, dynamicMap, bout);
                                } else {
                                    DynamicUtils.convertVelocityTemplate(template, dynamicMap, bout);
                                }
                                bout.flush();
                                bout.close();
                                idCorrelazioneApplicativa = bout.toString();
                                if (idCorrelazioneApplicativa != null) {
                                    idCorrelazioneApplicativa = ConditionalUtils.normalizeTemplateResult(idCorrelazioneApplicativa);
                                }
                            }
                            this.checkExtractedIdentifierIsNull(idCorrelazioneApplicativa, false);
                            this.checkExtractedIdentifierIsEmpty(idCorrelazioneApplicativa, false);
                        }
                        catch (Exception e) {
                            if (bloccaIdentificazioneNonRiuscita) {
                                this.errore = ErroriIntegrazione.ERRORE_416_CORRELAZIONE_APPLICATIVA_RICHIESTA_ERRORE.getErrore416_CorrelazioneApplicativaRichiesta("identificativo di correlazione applicativa non identificato nell'elemento [" + nomeElemento + "] con modalita' di acquisizione " + elemento.getIdentificazione().getValue() + "): " + e.getMessage());
                                throw new GestoreMessaggiException(this.errore.getDescrizione(this.protocolFactory), e);
                            }
                            correlazioneNonRiuscitaDaAccettare = true;
                        }
                    } else {
                        try {
                            if (ServiceBinding.REST.equals((Object)message.getServiceBinding()) && !MessageType.XML.equals((Object)message.getMessageType()) && !MessageType.JSON.equals((Object)message.getMessageType()) && !MessageType.MIME_MULTIPART.equals((Object)message.getMessageType())) {
                                throw new CoreException("MessageType [" + String.valueOf(message.getMessageType()) + "] non supportato con correlazione di tipo '" + CostantiConfigurazione.CORRELAZIONE_APPLICATIVA_RICHIESTA_CONTENT_BASED.toString() + "'");
                            }
                            if (element == null && elementJson == null) {
                                throw new CoreException("Contenuto non disponibile su cui effettuare una correlazione di tipo '" + CostantiConfigurazione.CORRELAZIONE_APPLICATIVA_RICHIESTA_CONTENT_BASED.toString() + "'");
                            }
                            idCorrelazioneApplicativa = element != null ? AbstractXPathExpressionEngine.extractAndConvertResultAsString((Element)element, (AbstractXPathExpressionEngine)xPathEngine, (String)elemento.getPattern(), (Logger)this.log) : JsonXmlPathExpressionEngine.extractAndConvertResultAsString((String)elementJson, (String)elemento.getPattern(), (Logger)this.log);
                            this.checkExtractedIdentifierIsNull(idCorrelazioneApplicativa, false);
                            this.checkExtractedIdentifierIsEmpty(idCorrelazioneApplicativa, false);
                        }
                        catch (Exception e) {
                            if (bloccaIdentificazioneNonRiuscita) {
                                this.errore = ErroriIntegrazione.ERRORE_434_CORRELAZIONE_APPLICATIVA_RISPOSTA_ERRORE.getErrore434_CorrelazioneApplicativaRisposta("Identificativo di correlazione applicativa non identificato nell'elemento [" + nomeElemento + "] con modalita' di acquisizione contentBased (Pattern:" + elemento.getPattern() + "): " + e.getMessage());
                                throw new GestoreMessaggiException(this.errore.getDescrizione(this.protocolFactory), e);
                            }
                            correlazioneNonRiuscitaDaAccettare = true;
                        }
                    }
                    if (idCorrelazioneApplicativa == null || idCorrelazioneApplicativa.length() <= this.maxLengthCorrelazioneApplicativa) break block101;
                    if (!bloccaIdentificazioneNonRiuscita) ** GOTO lbl269
                    if (this.isTruncateEnabled(false, true)) {
                        idCorrelazioneApplicativa = this.truncate(idCorrelazioneApplicativa, false, true);
                    } else {
                        this.errore = ErroriIntegrazione.ERRORE_434_CORRELAZIONE_APPLICATIVA_RISPOSTA_ERRORE.getErrore434_CorrelazioneApplicativaRisposta(this.buildErroreLunghezzaIdentificativo(idCorrelazioneApplicativa));
                        throw new GestoreMessaggiException(this.errore.getDescrizione(this.protocolFactory));
lbl269:
                        // 1 sources

                        if (this.isTruncateEnabled(false, false)) {
                            idCorrelazioneApplicativa = this.truncate(idCorrelazioneApplicativa, false, false);
                        } else {
                            errorId = this.buildErroreLunghezzaIdentificativo(idCorrelazioneApplicativa);
                            this.log.error(errorId);
                            correlazioneNonRiuscitaDaAccettare = true;
                            idCorrelazioneApplicativa = null;
                        }
                    }
                }
                findCorrelazione = true;
                continue block18;
            }
        }
        if (idCorrelazioneApplicativa == null) {
            generaErrore = false;
            if (!findCorrelazione) {
                generaErrore = this.isRispostaRegolaCorrelazioneNonTrovataBlocca;
            } else {
                v1 = generaErrore = correlazioneNonRiuscitaDaAccettare == false;
            }
            if (generaErrore) {
                this.errore = ErroriIntegrazione.ERRORE_434_CORRELAZIONE_APPLICATIVA_RISPOSTA_ERRORE.getErrore434_CorrelazioneApplicativaRisposta("Identificativo di correlazione applicativa non identificato; nessun elemento tra quelli di correlazione definiti \u00e8 presente nel body");
                throw new GestoreMessaggiException(this.errore.getDescrizione(this.protocolFactory));
            }
        } else {
            this.idCorrelazione = idCorrelazioneApplicativa;
            if (this.pddContext != null) {
                this.pddContext.addObject(GestoreCorrelazioneApplicativa.CONTEXT_CORRELAZIONE_APPLICATIVA_RISPOSTA, this.idCorrelazione);
            }
        }
    }

    private boolean isMatchResourceRest(String elemento) {
        String[] parseResourceRest;
        boolean isResourceRest = false;
        if (elemento != null && !"".equals(elemento) && (parseResourceRest = Utilities.parseResourceRest(elemento)) != null) {
            this.initRestResource();
            if (this.restResource != null) {
                isResourceRest = Utilities.isRestResourceMatch(parseResourceRest, this.restResource);
            }
        }
        return isResourceRest;
    }

    private void initRestResource() {
        if (this.restResource != null) {
            return;
        }
        this.restResource = Utilities.getRestResource(this.log, this.state, this.idServizio, this.requestInfo);
    }

    public void applicaCorrelazione(CorrelazioneApplicativa correlazioneApplicativa, String idApplicativo, String idBustaRequest) throws GestoreMessaggiException, ProtocolException {
        GestoreCorrelazioneApplicativaPSUtilities.applicaCorrelazione(this, correlazioneApplicativa, idApplicativo, idBustaRequest);
    }

    public List<Long> getCorrelazioniScadute(int limit, boolean logQuery, boolean orderBy) throws GestoreMessaggiException {
        ArrayList<Long> idMsg = new ArrayList<Long>();
        Statement pstmtMsgScaduti = null;
        ResultSet rs = null;
        String queryString = null;
        try {
            StateMessage stateMSG = (StateMessage)this.state;
            Connection connectionDB = stateMSG.getConnectionDB();
            Timestamp nowT = DateManager.getTimestamp();
            queryString = this.buildQueryCorrelazioniScadute(limit, orderBy);
            pstmtMsgScaduti = connectionDB.prepareStatement(queryString);
            pstmtMsgScaduti.setTimestamp(1, nowT);
            long startDateSQLCommand = DateManager.getTimeMillis();
            if (logQuery) {
                String debugS = "[QUERY] (CorrelazioneApplicativa.scaduta) [" + queryString + "] 1[" + String.valueOf(nowT) + "]...";
                this.log.debug(debugS);
            }
            rs = pstmtMsgScaduti.executeQuery();
            long endDateSQLCommand = DateManager.getTimeMillis();
            long secondSQLCommand = (endDateSQLCommand - startDateSQLCommand) / 1000L;
            if (logQuery) {
                String debugS = "[QUERY] (CorrelazioneApplicativa.scaduta) [" + queryString + "] 1[" + String.valueOf(nowT) + "] effettuata in " + secondSQLCommand + " secondi";
                this.log.debug(debugS);
            }
            while (rs.next() && this.readCorrelazioniScaduteEngine(idMsg, rs, limit)) {
            }
            rs.close();
            pstmtMsgScaduti.close();
            return idMsg;
        }
        catch (Exception e) {
            String errorMsg = "[GestoreCorrelazioneApplicativa.getCorrelazioniScadute] errore, queryString[" + queryString + "]: " + e.getMessage();
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                if (pstmtMsgScaduti != null) {
                    pstmtMsgScaduti.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.log.error(errorMsg);
            throw new GestoreMessaggiException(errorMsg, e);
        }
    }

    private String buildQueryCorrelazioniScadute(int limit, boolean orderBy) throws SQLQueryObjectException {
        String queryString = null;
        if (Configurazione.getSqlQueryObjectType() == null) {
            StringBuilder query = new StringBuilder();
            query.append("SELECT id FROM ");
            query.append(CORRELAZIONE_APPLICATIVA);
            query.append(" WHERE SCADENZA is not null AND SCADENZA < ?");
            queryString = query.toString();
        } else {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)Configurazione.getSqlQueryObjectType());
            sqlQueryObject.addSelectField("id");
            sqlQueryObject.addSelectField(COLUMN_SCADENZA);
            sqlQueryObject.addFromTable(CORRELAZIONE_APPLICATIVA);
            sqlQueryObject.addWhereCondition("SCADENZA is not null");
            sqlQueryObject.addWhereCondition("SCADENZA < ?");
            sqlQueryObject.setANDLogicOperator(true);
            if (orderBy) {
                sqlQueryObject.addOrderBy(COLUMN_SCADENZA);
                sqlQueryObject.setSortType(true);
            }
            sqlQueryObject.setLimit(limit);
            queryString = sqlQueryObject.createSQLQuery();
        }
        return queryString;
    }

    public List<Long> getCorrelazioniScaduteRispettoOraRegistrazione(int limit, long scadenzaMsg, boolean logQuery, boolean orderBy, boolean escludiCorrelazioniConScadenza) throws GestoreMessaggiException {
        ArrayList<Long> idMsg = new ArrayList<Long>();
        Statement pstmtMsgScaduti = null;
        ResultSet rs = null;
        String queryString = null;
        try {
            StateMessage stateMSG = (StateMessage)this.state;
            Connection connectionDB = stateMSG.getConnectionDB();
            long scadenza = DateManager.getTimeMillis() - scadenzaMsg * 60L * 1000L;
            Timestamp scandenzaT = new Timestamp(scadenza);
            queryString = this.buildQueryCorrelazioniScaduteRispettoOraRegistrazione(limit, orderBy, escludiCorrelazioniConScadenza);
            pstmtMsgScaduti = connectionDB.prepareStatement(queryString);
            pstmtMsgScaduti.setTimestamp(1, scandenzaT);
            long startDateSQLCommand = DateManager.getTimeMillis();
            if (logQuery) {
                String sDebug = "[QUERY] (CorrelazioneApplicativa.storiche) [" + queryString + "] 1[" + String.valueOf(scandenzaT) + "]...";
                this.log.debug(sDebug);
            }
            rs = pstmtMsgScaduti.executeQuery();
            long endDateSQLCommand = DateManager.getTimeMillis();
            long secondSQLCommand = (endDateSQLCommand - startDateSQLCommand) / 1000L;
            if (logQuery) {
                String sDebug = "[QUERY] (CorrelazioneApplicativa.storiche) [" + queryString + "] 1[" + String.valueOf(scandenzaT) + "] effettuata in " + secondSQLCommand + " secondi";
                this.log.debug(sDebug);
            }
            while (rs.next() && this.readCorrelazioniScaduteEngine(idMsg, rs, limit)) {
            }
            rs.close();
            pstmtMsgScaduti.close();
            return idMsg;
        }
        catch (Exception e) {
            String errorMsg = "[GestoreCorrelazioneApplicativa.getCorrelazioniStoriche] errore, queryString[" + queryString + "]: " + e.getMessage();
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                if (pstmtMsgScaduti != null) {
                    pstmtMsgScaduti.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.log.error(errorMsg);
            throw new GestoreMessaggiException(errorMsg, e);
        }
    }

    private String buildQueryCorrelazioniScaduteRispettoOraRegistrazione(int limit, boolean orderBy, boolean escludiCorrelazioniConScadenza) throws SQLQueryObjectException {
        String queryString = null;
        if (Configurazione.getSqlQueryObjectType() == null) {
            StringBuilder query = new StringBuilder();
            query.append("SELECT id FROM ");
            query.append(CORRELAZIONE_APPLICATIVA);
            query.append(" WHERE ORA_REGISTRAZIONE < ?");
            if (escludiCorrelazioniConScadenza) {
                query.append(" AND SCADENZA is null");
            }
            queryString = query.toString();
        } else {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)Configurazione.getSqlQueryObjectType());
            sqlQueryObject.addSelectField("id");
            sqlQueryObject.addSelectField(COLUMN_SCADENZA);
            sqlQueryObject.addFromTable(CORRELAZIONE_APPLICATIVA);
            sqlQueryObject.addWhereCondition("ORA_REGISTRAZIONE < ?");
            if (escludiCorrelazioniConScadenza) {
                sqlQueryObject.addWhereCondition("SCADENZA is null");
            }
            sqlQueryObject.setANDLogicOperator(true);
            if (orderBy) {
                sqlQueryObject.addOrderBy(COLUMN_ORA_REGISTRAZIONE);
                sqlQueryObject.setSortType(true);
            }
            sqlQueryObject.setLimit(limit);
            queryString = sqlQueryObject.createSQLQuery();
        }
        return queryString;
    }

    private boolean readCorrelazioniScaduteEngine(List<Long> idMsg, ResultSet rs, int limit) throws SQLException {
        int countLimit = 0;
        if (Configurazione.getSqlQueryObjectType() == null) {
            idMsg.add(rs.getLong("id"));
            if (++countLimit == limit) {
                return false;
            }
        } else {
            idMsg.add(rs.getLong("id"));
        }
        return true;
    }

    public String[] getIDMappingCorrelazioneApplicativa(long idCorrelazioneApplicativa) throws GestoreMessaggiException {
        PreparedStatement pstmtReadMSG = null;
        ResultSet rs = null;
        try {
            StateMessage stateMSG = (StateMessage)this.state;
            Connection connectionDB = stateMSG.getConnectionDB();
            String query = "SELECT ID_MESSAGGIO,ID_APPLICATIVO  FROM CORRELAZIONE_APPLICATIVA WHERE id=?";
            pstmtReadMSG = connectionDB.prepareStatement(query);
            pstmtReadMSG.setLong(1, idCorrelazioneApplicativa);
            rs = pstmtReadMSG.executeQuery();
            if (rs.next()) {
                String[] s = new String[]{rs.getString(CORRELAZIONE_APPLICATIVA_COLUMN_ID_MESSAGGIO), rs.getString(CORRELAZIONE_APPLICATIVA_COLUMN_ID_APPLICATIVO)};
                rs.close();
                pstmtReadMSG.close();
                return s;
            }
            rs.close();
            pstmtReadMSG.close();
            throw new CoreException("CorrelazioneApplicativa con id[" + idCorrelazioneApplicativa + "] non trovata");
        }
        catch (Exception e) {
            String errorMsg = "GestoreCorrelazioneApplicativa, error getIDMappingCorrelazioneApplicativa [" + idCorrelazioneApplicativa + "] : " + e.getMessage();
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                if (pstmtReadMSG != null) {
                    pstmtReadMSG.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.log.error(errorMsg);
            throw new GestoreMessaggiException(errorMsg, e);
        }
    }

    public void deleteCorrelazioneApplicativa(long idCorrelazioneApplicativa) throws GestoreMessaggiException {
        Statement pstmtDeleteMSG = null;
        try {
            StateMessage stateMSG = (StateMessage)this.state;
            Connection connectionDB = stateMSG.getConnectionDB();
            String query = "DELETE FROM CORRELAZIONE_APPLICATIVA WHERE id=?";
            pstmtDeleteMSG = connectionDB.prepareStatement(query);
            pstmtDeleteMSG.setLong(1, idCorrelazioneApplicativa);
            pstmtDeleteMSG.execute();
            pstmtDeleteMSG.close();
        }
        catch (Exception e) {
            String errorMsg = "GestoreCorrelazioneApplicativa, error deleteCorrelazione [" + idCorrelazioneApplicativa + "] : " + e.getMessage();
            try {
                if (pstmtDeleteMSG != null) {
                    pstmtDeleteMSG.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.log.error(errorMsg);
            throw new GestoreMessaggiException(errorMsg, e);
        }
    }

    public String getIdBustaCorrelato() {
        return this.idBustaCorrelato;
    }

    public ErroreIntegrazione getErrore() {
        return this.errore;
    }

    public String getIdCorrelazione() {
        return this.idCorrelazione;
    }

    public boolean isTruncateEnabled(boolean request, boolean blocca) {
        if (blocca) {
            if (request) {
                return this.maxLengthExceededCorrelazioneApplicativaIdentificazioneFallitaBloccaTruncateRequest > 0 && this.maxLengthExceededCorrelazioneApplicativaIdentificazioneFallitaBloccaTruncateRequest < this.maxLengthCorrelazioneApplicativa;
            }
            return this.maxLengthExceededCorrelazioneApplicativaIdentificazioneFallitaBloccaTruncateResponse > 0 && this.maxLengthExceededCorrelazioneApplicativaIdentificazioneFallitaBloccaTruncateResponse < this.maxLengthCorrelazioneApplicativa;
        }
        if (request) {
            return this.maxLengthExceededCorrelazioneApplicativaIdentificazioneFallitaAccettaTruncateRequest > 0 && this.maxLengthExceededCorrelazioneApplicativaIdentificazioneFallitaAccettaTruncateRequest < this.maxLengthCorrelazioneApplicativa;
        }
        return this.maxLengthExceededCorrelazioneApplicativaIdentificazioneFallitaAccettaTruncateResponse > 0 && this.maxLengthExceededCorrelazioneApplicativaIdentificazioneFallitaAccettaTruncateResponse < this.maxLengthCorrelazioneApplicativa;
    }

    public String truncate(String id, boolean request, boolean blocca) {
        if (blocca) {
            if (request) {
                return id.substring(0, this.maxLengthExceededCorrelazioneApplicativaIdentificazioneFallitaBloccaTruncateRequest);
            }
            return id.substring(0, this.maxLengthExceededCorrelazioneApplicativaIdentificazioneFallitaBloccaTruncateResponse);
        }
        if (request) {
            return id.substring(0, this.maxLengthExceededCorrelazioneApplicativaIdentificazioneFallitaAccettaTruncateRequest);
        }
        return id.substring(0, this.maxLengthExceededCorrelazioneApplicativaIdentificazioneFallitaAccettaTruncateResponse);
    }
}

