/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core;

import java.io.Serializable;
import org.openspcoop2.message.OpenSPCoop2Message;
import org.openspcoop2.pdd.logger.MsgDiagnostico;
import org.openspcoop2.protocol.sdk.Context;
import org.openspcoop2.utils.Map;
import org.openspcoop2.utils.MapKey;

public class CostantiPdD {
    public static final String OPENSPCOOP2_BETA = ".1";
    public static final String OPENSPCOOP2_VERSION = "3.4.1";
    public static final String OPENSPCOOP2_PRODUCT = "GovWay";
    public static final String OPENSPCOOP2_PRODUCT_VERSION = "GovWay/3.4.1";
    public static final String OPENSPCOOP2_DETAILS = "www.govway.org";
    public static final String OPENSPCOOP2_COPYRIGHT = "2005-2025 Link.it srl";
    public static final String OPENSPCOOP2_LICENSE = "This program is free software: you can redistribute it and/or modify\nit under the terms of the GNU General Public License version 3, as published by\nthe Free Software Foundation.\n\nThis program is distributed in the hope that it will be useful,\nbut WITHOUT ANY WARRANTY; without even the implied warranty of\nMERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\nGNU General Public License for more details.\n\nYou should have received a copy of the GNU General Public License\nalong with this program.  If not, see <http://www.gnu.org/licenses/>.";
    public static final String OPENSPCOOP2 = "GovWay";
    public static final String OPENSPCOOP2_LOCAL_HOME = "GOVWAY_HOME";
    public static final String OPENSPCOOP2_LOOKUP = "GOVWAY_LOOKUP";
    public static final String OPENSPCOOP2_LOADER = "OPENSPCOOP2_LOADER";
    public static final String OPENSPCOOP2_LOADER_PROPERTIES = "OPENSPCOOP2_LOADER_PROPERTIES";
    public static final String OPENSPCOOP2_PROPERTIES_LOCAL_PATH = "govway_local.properties";
    public static final String OPENSPCOOP2_PROPERTIES = "OPENSPCOOP2_PROPERTIES";
    public static final String OPENSPCOOP2_CLASSNAME_LOCAL_PATH = "govway_local.classRegistry.properties";
    public static final String OPENSPCOOP2_CLASSNAME_PROPERTIES = "OPENSPCOOP2_CLASSREGISTRY_PROPERTIES";
    public static final String OPENSPCOOP2_PDD_LOCAL_PATH = "govway_local.pdd.properties";
    public static final String OPENSPCOOP2_PDD_PROPERTIES = "OPENSPCOOP2_PDD_PROPERTIES";
    public static final String OPENSPCOOP2_MSGDIAGNOSTICI_LOCAL_PATH = "govway_local.msgDiagnostici.properties";
    public static final String OPENSPCOOP2_MSGDIAGNOSTICI_PROPERTIES = "OPENSPCOOP2_MSGDIAGNOSTICI_PROPERTIES";
    public static final String OPENSPCOOP2_LOGGER_LOCAL_PATH = "govway_local.log4j2.properties";
    public static final String OPENSPCOOP2_LOGGER_PROPERTIES = "OPENSPCOOP2_LOGGER_PROPERTIES";
    public static final String OPENSPCOOP2_LOGGER_PROTOCOL_ID_PROTOCOLLO = "IDPROTOCOLLO";
    private static final String OPENSPCOOP2_LOGGER_PROTOCOL_LOCAL_PATH = "govway_local.protocol_IDPROTOCOLLO.log4j2.properties";
    private static final String OPENSPCOOP2_LOGGER_PROTOCOL_PROPERTIES = "OPENSPCOOP2_LOGGER_PROTOCOL_IDPROTOCOLLO_PROPERTIES";
    private static final String OPENSPCOOP2_LOGGER_FACTORY_NAME = "govway.IDPROTOCOLLO";
    public static final String OPENSPCOOP2_CACHE_DEFAULT_PROPERTIES_NAME = "govway.jcs.properties";
    public static final String OPENSPCOOP2_CACHE_LOCAL_PATH = "govway_local.jcs.properties";
    public static final String OPENSPCOOP2_CACHE_PROPERTIES = "OPENSPCOOP2_CACHE_PROPERTIES";
    public static final String OPENSPCOOP2_CONFIG_LOCAL_PATH = "govway_local.config.properties";
    public static final String OPENSPCOOP2_CONFIG_PROPERTIES = "OPENSPCOOP2_CONFIG_PROPERTIES";
    public static final String IMBUSTAMENTO_ATTACHMENT = "attach";
    public static final String IMBUSTAMENTO_MIME_TYPE = "mime-type";
    public static final String TRACCIAMENTO_IN = "IN";
    public static final String TRACCIAMENTO_OUT = "OUT";
    public static final String TIPOLOGIA_INSTALLER = "installer";
    public static final MapKey<String> CORS_PREFLIGHT_REQUEST_SOAP = Map.newMapKey((String)"CORS_PREFLIGHT_REQUEST_SOAP");
    public static final MapKey<String> NOME_PORTA_INVOCATA = Map.newMapKey((String)"NOME_PORTA_INVOCATA");
    public static final MapKey<String> RESPONSE_CACHE_REQUEST_DIGEST = Map.newMapKey((String)"RESPONSE_CACHE_REQUEST_DIGEST");
    public static final String RESPONSE_CACHE_REQUEST_DIGEST_DEFAULT_ALGORITHM = "MD5";
    public static final MapKey<String> DATA_ACCETTAZIONE_RICHIESTA = Map.newMapKey((String)"CONTEXT_DATA_ACCETTAZIONE_RICHIESTA");
    public static final MapKey<String> DATA_INGRESSO_RICHIESTA = Map.newMapKey((String)"CONTEXT_DATA_INGRESSO_RICHIESTA");
    public static final String DUMP_CONFIG = "DumpConfig";
    public static final String DUMP_RICHIESTA_EFFETTUATO = "DumpRichiestaEffettuato";
    public static final String DUMP_RISPOSTA_EFFETTUATO = "DumpRispostaEffettuato";
    public static final String PROCESS_COMPLETE_SET_TIPO = "PROCESS_COMPLETE_SET_TIPO";
    public static final String PROCESS_COMPLETE_GESTORE_OUT_RESPONSE_HANDLER = "PROCESS_COMPLETE_GESTORE_OUT_RESPONSE_HANDLER";
    public static final int DUMP_BINARIO_THRESHOLD = 0x100000;
    public static final int DUMP_NON_REALTIME_THRESHOLD = 61440;
    public static final String DUMP_NON_REALTIME_MODE_DB = "db";
    public static final String DUMP_NON_REALTIME_MODE_FILE_SYSTEM = "fs";
    public static final String DUMP_NON_REALTIME_MODE_AUTO = "auto";
    public static final String SOGGETTO_ANONIMO = "Anonimo";
    public static final String SERVIZIO_APPLICATIVO_ANONIMO = "Anonimo";
    public static final String HEADER_INTEGRAZIONE = "HEADER_INTEGRAZIONE";
    public static final String GESTIONE_ESITO = "GESTIONE_ESITO";
    public static final String GESTIONE_ESITO_MODULO_FUNZIONALE = "GESTIONE_ESITO_MODULO_FUNZIONALE";
    public static final MapKey<String> OPENSPCOOP2_PDD_CONTEXT_HEADER_HTTP = Map.newMapKey((String)"OPENSPCOOP2_CONTEXT_HEADER_HTTP");
    public static final MapKey<String> OPENSPCOOP2_PDD_CONTEXT_NUMERO_TENTATIVI_RICONSEGNA_UPDATED = Map.newMapKey((String)"NUMERO_TENTATIVI_RICONSEGNA_UPDATED");
    public static final MapKey<String> HEADER_INTEGRAZIONE_TIPO_MITTENTE = new MapKey((Serializable)((Object)"tipoMittente"), 1);
    public static final MapKey<String> HEADER_INTEGRAZIONE_MITTENTE = new MapKey((Serializable)((Object)"mittente"), 2);
    public static final MapKey<String> HEADER_INTEGRAZIONE_TIPO_DESTINATARIO = new MapKey((Serializable)((Object)"tipoDestinatario"), 3);
    public static final MapKey<String> HEADER_INTEGRAZIONE_DESTINATARIO = new MapKey((Serializable)((Object)"destinatario"), 4);
    public static final MapKey<String> HEADER_INTEGRAZIONE_TIPO_SERVIZIO = new MapKey((Serializable)((Object)"tipoServizio"), 5);
    public static final MapKey<String> HEADER_INTEGRAZIONE_SERVIZIO = new MapKey((Serializable)((Object)"servizio"), 6);
    public static final MapKey<String> HEADER_INTEGRAZIONE_VERSIONE_SERVIZIO = new MapKey((Serializable)((Object)"versioneServizio"), 7);
    public static final MapKey<String> HEADER_INTEGRAZIONE_AZIONE = new MapKey((Serializable)((Object)"azione"), 8);
    public static final MapKey<String> HEADER_INTEGRAZIONE_ID_MESSAGGIO = new MapKey((Serializable)((Object)"identificativo"), 9);
    public static final MapKey<String> HEADER_INTEGRAZIONE_RIFERIMENTO_MESSAGGIO = new MapKey((Serializable)((Object)"riferimentoMessaggio"), 10);
    public static final MapKey<String> HEADER_INTEGRAZIONE_ID_APPLICATIVO = new MapKey((Serializable)((Object)"idApplicativo"), 11);
    public static final MapKey<String> HEADER_INTEGRAZIONE_COLLABORAZIONE = new MapKey((Serializable)((Object)"idCollaborazione"), 12);
    public static final MapKey<String> HEADER_INTEGRAZIONE_SERVIZIO_APPLICATIVO = new MapKey((Serializable)((Object)"servizioApplicativo"), 13);
    public static final MapKey<String> HEADER_INTEGRAZIONE_TIPO_MITTENTE_TOKEN = new MapKey((Serializable)((Object)"tipoMittenteToken"), 14);
    public static final MapKey<String> HEADER_INTEGRAZIONE_MITTENTE_TOKEN = new MapKey((Serializable)((Object)"mittenteToken"), 15);
    public static final MapKey<String> HEADER_INTEGRAZIONE_SERVIZIO_APPLICATIVO_TOKEN = new MapKey((Serializable)((Object)"servizioApplicativoToken"), 16);
    public static final MapKey<String> HEADER_INTEGRAZIONE_ID_TRANSAZIONE = new MapKey((Serializable)((Object)"idTransazione"), 17);
    public static final MapKey<String> HEADER_INTEGRAZIONE_PROTOCOL_INFO = new MapKey((Serializable)((Object)"protocolInfo"), 18);
    public static final MapKey<String> HEADER_INTEGRAZIONE_INFO = new MapKey((Serializable)((Object)"info"), 19);
    public static final MapKey<String> HEADER_INTEGRAZIONE_USER_AGENT = new MapKey((Serializable)((Object)"userAgent"), 20);
    public static final String HEADER_HTTP_X_PDD = "GovWay-Version";
    public static final String HEADER_HTTP_X_PDD_DETAILS = "GovWay-Version-Info";
    public static final String URL_BASED_PDD = "version";
    public static final String URL_BASED_PDD_DETAILS = "version_info";
    public static final MapKey<String> TOKEN_VALIDAZIONE_PDND = Map.newMapKey((String)"TOKEN_VALIDAZIONE_PDND");
    public static final MapKey<String> TOKEN_NEGOZIAZIONE_PDND = Map.newMapKey((String)"TOKEN_NEGOZIAZIONE_PDND");
    public static final String TOKEN_ESITO_TRUE = "true";
    public static final String HEADER_INTEGRAZIONE_SOAP_PDD_VERSION = "version";
    public static final String HEADER_INTEGRAZIONE_SOAP_PDD_DETAILS = "versionInfo";
    public static final String HEADER_INTEGRAZIONE_TOKEN_PROCESS_TIME = "processTime";
    public static final String HEADER_INTEGRAZIONE_TOKEN_ISSUER = "issuer";
    public static final String HEADER_INTEGRAZIONE_TOKEN_SUBJECT = "subject";
    public static final String HEADER_INTEGRAZIONE_TOKEN_USERNAME = "username";
    public static final String HEADER_INTEGRAZIONE_TOKEN_AUDIENCE = "audience";
    public static final String HEADER_INTEGRAZIONE_TOKEN_CLIENT_ID = "clientId";
    public static final String HEADER_INTEGRAZIONE_TOKEN_ISSUED_AT = "issuedAt";
    public static final String HEADER_INTEGRAZIONE_TOKEN_EXPIRED = "expired";
    public static final String HEADER_INTEGRAZIONE_TOKEN_NBF = "nbf";
    public static final String HEADER_INTEGRAZIONE_TOKEN_ROLES = "roles";
    public static final String HEADER_INTEGRAZIONE_TOKEN_SCOPES = "scopes";
    public static final String HEADER_INTEGRAZIONE_TOKEN_FULL_NAME = "fullName";
    public static final String HEADER_INTEGRAZIONE_TOKEN_FIRST_NAME = "firstName";
    public static final String HEADER_INTEGRAZIONE_TOKEN_MIDDLE_NAME = "middleName";
    public static final String HEADER_INTEGRAZIONE_TOKEN_FAMILY_NAME = "familyName";
    public static final String HEADER_INTEGRAZIONE_TOKEN_EMAIL = "email";
    public static final String HEADER_INTEGRAZIONE_TOKEN_JTI = "jti";
    public static final String HEADER_INTEGRAZIONE_TOKEN_PDND_ORGANIZATION_NAME = "pdndOrganizationName";
    public static final String HEADER_INTEGRAZIONE_TOKEN_PDND_ORGANIZATION_CATEGORY = "pdndOrganizationCategory";
    public static final String HEADER_INTEGRAZIONE_TOKEN_PDND_ORGANIZATION_SUBUNIT = "pdndOrganizationSubUnit";
    public static final String HEADER_INTEGRAZIONE_TOKEN_PDND_ORGANIZATION_EXTERNAL = "pdndOrganizationExternal";
    public static final String HEADER_INTEGRAZIONE_TOKEN_PDND_ORGANIZATION_EXTERNAL_ORIGIN = "pdndOrganizationExternalOrigin";
    public static final String HEADER_INTEGRAZIONE_TOKEN_PDND_ORGANIZATION_EXTERNAL_ID = "pdndOrganizationExternalId";
    public static final String HEADER_INTEGRAZIONE_TOKEN_PDND_CLIENT_NAME = "pdndClientName";
    public static final String HEADER_INTEGRAZIONE_TOKEN_PDND_CLIENT_DESCRIPTION = "pdndClientDescription";
    public static final String HEADER_INTEGRAZIONE_TOKEN_IDENTIFIER = "identifier";
    public static final String HEADER_INTEGRAZIONE_TOKEN_PURPOSE_ID = "purposeId";
    public static final String HEADER_INTEGRAZIONE_TOKEN_PRODUCER_ID = "producerId";
    public static final String HEADER_INTEGRAZIONE_TOKEN_SERVICE_ID = "eserviceId";
    public static final String HEADER_INTEGRAZIONE_TOKEN_DESCRIPTOR_ID = "descriptorId";
    public static final String HEADER_INTEGRAZIONE_TOKEN_CONSUMER_ID = "consumerId";
    public static final String HEADER_INTEGRAZIONE_TOKEN_SESSION_INFO = "sessionInfo";
    public static final String HEADER_INTEGRAZIONE_TOKEN_CLAIMS = "claims";
    public static final String HEADER_INTEGRAZIONE_TOKEN_AUDIT_DIGEST = "auditDigest";
    public static final String HEADER_INTEGRAZIONE_TOKEN_HEADER_KID = "kid";
    public static final String HEADER_INTEGRAZIONE_TOKEN_HEADER_X509_URL = "x509Url";
    public static final String HEADER_INTEGRAZIONE_TOKEN_FORM_REQUEST_SCOPE = "form.scope";
    public static final String HEADER_INTEGRAZIONE_TOKEN_FORM_REQUEST_AUDIENCE = "form.audience";
    public static final String HEADER_INTEGRAZIONE_TOKEN_FORM_REQUEST_CLIENT_ID = "form.clientId";
    public static final String HEADER_INTEGRAZIONE_TOKEN_FORM_REQUEST_RESOURCE = "form.resource";
    public static final String HEADER_INTEGRAZIONE_TOKEN_FORM_REQUEST_PARAMETERS = "form.parameters";
    public static final String HEADER_INTEGRAZIONE_TOKEN_HTTP_METHOD = "http.method";
    public static final String HEADER_INTEGRAZIONE_TOKEN_HTTP_CONTENT_TYPE = "http.contentType";
    public static final String HEADER_INTEGRAZIONE_TOKEN_HTTP_HEADERS = "http.headers";
    public static final String HEADER_INTEGRAZIONE_TOKEN_HTTP_PAYLOAD_TEMPLATE_TYPE = "http.payload.templateType";
    public static final String HEADER_INTEGRAZIONE_TOKEN_HTTP_PAYLOAD = "http.payload";
    public static final String HEADER_INTEGRAZIONE_TOKEN_FORM_APPLICATIVE_REQUESTER = "applicativeRequester";
    public static final String HEADER_INTEGRAZIONE_TOKEN_FORM_OUTBOUND_INTERFACE = "outboundInterface";
    public static final long GET_LOCK_ATTESA_ATTIVA = 90000L;
    public static final int GET_LOCK_CHECK_INTERVAL = 50;
    public static final long MSG_GIA_IN_PROCESSAMENTO_ATTESA_ATTIVA = 90000L;
    public static final int MSG_GIA_IN_PROCESSAMENTO_CHECK_INTERVAL = 500;
    public static final long TRANSACTION_MANAGER_ATTESA_ATTIVA = 120000L;
    public static final int TRANSACTION_MANAGER_CHECK_INTERVAL = 10;
    public static final int TRANSACTION_MANAGER_CHECK_DB_INTERVAL = 25;
    public static final long TIMER_EJB_ATTESA_ATTIVA = 60000L;
    public static final int TIMER_EJB_CHECK_INTERVAL = 200;
    public static final int TIMER_RICONSEGNA_CONTENUTI_APPLICATIVI_PRESA_IN_CONSEGNA_MAX_LIFE = 1800;
    public static final MapKey<String> TIMER_RICONSEGNA_CONTENUTI_APPLICATIVI_MESSAGGI_SPEDIRE = Map.newMapKey((String)"CONTENUTI_APPLICATIVI_MESSAGGI_SPEDIRE");
    public static final String TIMER_RICONSEGNA_CONTENUTI_APPLICATIVI_CODA_DEFAULT = "DEFAULT";
    public static final String TIMER_RICONSEGNA_CONTENUTI_APPLICATIVI_PRIORITA_DEFAULT = "DEFAULT";
    public static final int WAIT_STARTUP_TIMEOUT_SECONDS = 90;
    public static final int WAIT_STARTUP_CHECK_INTERVAL_MS = 1000;
    public static final int TIMER_LOCK_MAX_LIFE = -1;
    public static final int TIMER_LOCK_IDLE_TIME = -1;
    public static final long NODE_RECEIVER_ATTESA_ATTIVA = 300000L;
    public static final int NODE_RECEIVER_CHECK_INTERVAL = 10;
    public static final int NODE_RECEIVER_CHECK_DB_INTERVAL = 25;
    public static final int RISPOSTA_ASINCRONA_CHECK_INTERVAL = 500;
    public static final long RISPOSTA_ASINCRONA_ATTESA_ATTIVA = 90000L;
    public static final int GESTIONE_CORS_RETURN_CODE = 200;
    public static final int CONNETTORE_CONNECTION_TIMEOUT_INOLTRO_BUSTE = 10000;
    public static final int CONNETTORE_CONNECTION_TIMEOUT_CONSEGNA_CONTENUTI_APPLICATIVI = 10000;
    public static final int CONNETTORE_READ_CONNECTION_TIMEOUT_INOLTRO_BUSTE = 180000;
    public static final int CONNETTORE_READ_CONNECTION_TIMEOUT_CONSEGNA_CONTENUTI_APPLICATIVI = 120000;
    public static final int CONNETTORE_CONNECTION_LIFE_INOLTRO_BUSTE = 1800000;
    public static final int CONNETTORE_CONNECTION_LIFE_CONSEGNA_CONTENUTI_APPLICATIVI = 1800000;
    public static final int CONNETTORE_HTTP_URL_HTTPS_CACHE_SIZE = 10000;
    public static final int CONNETTORE_BIO_SYNC_CLIENT_POOL_SIZE = 100;
    public static final int CONNETTORE_BIO_SYNC_CLIENT_MAX_CONNECTION_FOR_ROUTE = 100;
    public static final int CONNETTORE_BIO_SYNC_CLIENT_MAX_CONNECTION_TOTAL = 100;
    public static final int CONNETTORE_BIO_SYNC_CLIENT_CLOSE_IDLE_CONNECTION_AFTER_SECONDS = 30;
    public static final int CONNETTORE_BIO_SYNC_CLIENT_EXPIRE_UNUSED_AFTER_SECONDS = 300;
    public static final int CONNETTORE_BIO_SYNC_CLIENT_CLOSE_UNUSED_AFTER_SECONDS = 900;
    public static final String CONNETTORE_NIO_ASYNC_CONFIG_AVAILABLE_PROCESSORS = "availableProcessors";
    public static final int CONNETTORE_NIO_ASYNC_CLIENT_MAX_CONNECTION_FOR_ROUTE = 100;
    public static final int CONNETTORE_NIO_ASYNC_CLIENT_MAX_CONNECTION_TOTAL = 100;
    public static final int CONNETTORE_NIO_ASYNC_CLIENT_CLOSE_IDLE_CONNECTION_AFTER_SECONDS = 30;
    public static final int CONNETTORE_NIO_ASYNC_CLIENT_EXPIRE_UNUSED_AFTER_SECONDS = 300;
    public static final int CONNETTORE_NIO_ASYNC_CLIENT_CLOSE_UNUSED_AFTER_SECONDS = 900;
    public static final String CONNETTORE_FASE_GESTIIONE_RICHIESTA = "Request";
    public static final String CONNETTORE_FASE_GESTIIONE_RISPOSTA = "Response";
    public static final int CLUSTER_DINAMICO_REFRESH_SECONDS = 30;
    public static final String JMX_DOMINIO = "org.openspcoop2.pdd";
    public static final String JMX_TYPE = "type";
    public static final String JMX_CONFIGURAZIONE_PDD = "ConfigurazionePdD";
    public static final String JMX_REGISTRO_SERVIZI = "AccessoRegistroServizi";
    public static final String JMX_MONITORAGGIO_RISORSE = "MonitoraggioRisorse";
    public static final String JMX_AUTORIZZAZIONE = "DatiAutorizzazione";
    public static final String JMX_AUTENTICAZIONE = "DatiAutenticazione";
    public static final String JMX_TOKEN = "GestioneToken";
    public static final String JMX_ATTRIBUTE_AUTHORITY = "AttributeAuthority";
    public static final String JMX_RESPONSE_CACHING = "ResponseCaching";
    public static final String JMX_KEYSTORE_CACHING = "Keystore";
    public static final String JMX_LOAD_BALANCER = "LoadBalancer";
    public static final String JMX_GESTORE_RICHIESTE = "DatiRichieste";
    public static final String JMX_REPOSITORY_MESSAGGI = "RepositoryMessaggi";
    public static final String JMX_STATO_SERVIZI_PDD = "StatoServiziPdD";
    public static final String JMX_INFORMAZIONI_STATISTICHE_PDD = "StatistichePdD";
    public static final String JMX_SYSTEM_PROPERTIES_PDD = "SystemPropertiesPdD";
    public static final String JMX_CONFIGURAZIONE_SISTEMA = "ConfigurazioneSistema";
    public static final String JMX_CONTROLLO_TRAFFICO = "ControlloTraffico";
    public static final int LIMIT_MESSAGGI_GESTORI = 50;
    public static final String SCHEMA_XSD = "Schema xsd dei messaggi";
    public static final String WSDL_CONCETTUALE = "Wsdl concettuale";
    public static final String WSDL_FRUITORE = "Wsdl fruitore";
    public static final String WSDL_EROGATORE = "Wsdl erogatore";
    public static final MapKey<String> BUSTA_RISPOSTA = Map.newMapKey((String)"BustaProprietaHeaderIntegrazione");
    public static final MapKey<String> BUSTA_RICHIESTA_SDI_HEADER_INTEGRAZIONE = Map.newMapKey((String)"BustaRichiestaSDIHeaderIntegrazione");
    public static final MapKey<String> BUSTA_RICHIESTA_SDI_NOME_FILE = Map.newMapKey((String)"BustaRichiestaSDINomeFile");
    public static final MapKey<String> BUSTA_RICHIESTA_SDI_IDENTIFICATIVO_SDI = Map.newMapKey((String)"BustaRichiestaSDIIdentificativoSdI");
    public static final String CHECK_STATO_PDD_EXECUTE_HEALTH_CHECK_STATS = "executeHealthCheckStats";
    public static final String CHECK_STATO_PDD_EXECUTE_HOURLY_HEALTH_CHECK_STATS = "executeHourlyHealthCheckStats";
    public static final String CHECK_STATO_PDD_EXECUTE_DAILY_HEALTH_CHECK_STATS = "executeDailyHealthCheckStats";
    public static final String CHECK_STATO_PDD_EXECUTE_WEEKLY_HEALTH_CHECK_STATS = "executeWeeklyHealthCheckStats";
    public static final String CHECK_STATO_PDD_EXECUTE_MONTHLY_HEALTH_CHECK_STATS = "executeMonthlyHealthCheckStats";
    public static final String CHECK_STATO_PDD_EXECUTE_HOURLY_HEALTH_CHECK_STATS_THRESHOLD = "hourlyHealthCheckStatsThreshold";
    public static final String CHECK_STATO_PDD_EXECUTE_DAILY_HEALTH_CHECK_STATS_THRESHOLD = "dailyHealthCheckStatsThreshold";
    public static final String CHECK_STATO_PDD_EXECUTE_WEEKLY_HEALTH_CHECK_STATS_THRESHOLD = "weeklyHealthCheckStatsThreshold";
    public static final String CHECK_STATO_PDD_EXECUTE_MONTHLY_HEALTH_CHECK_STATS_THRESHOLD = "monthlyHealthCheckStatsThreshold";
    public static final String CHECK_STATO_PDD_METHOD_NAME = "methodName";
    public static final String CHECK_STATO_PDD_ATTRIBUTE_NAME = "attributeName";
    public static final String CHECK_STATO_PDD_ATTRIBUTE_VALUE = "attributeValue";
    public static final String CHECK_STATO_PDD_ATTRIBUTE_BOOLEAN_VALUE = "attributeBooleanValue";
    public static final String CHECK_STATO_PDD_RESOURCE_NAME = "resourceName";
    public static final String CHECK_STATO_PDD_PARAM_VALUE = "paramValue";
    public static final String CHECK_STATO_PDD_PARAM_VALUE_2 = "paramValue2";
    public static final String CHECK_STATO_PDD_PARAM_VALUE_3 = "paramValue3";
    public static final String CHECK_STATO_PDD_PARAM_VALUE_4 = "paramValue4";
    public static final String CHECK_STATO_PDD_PARAM_INT_VALUE = "paramIntegerValue";
    public static final String CHECK_STATO_PDD_PARAM_INT_VALUE_2 = "paramIntegerValue2";
    public static final String CHECK_STATO_PDD_PARAM_INT_VALUE_3 = "paramIntegerValue3";
    public static final String CHECK_STATO_PDD_PARAM_INT_VALUE_4 = "paramIntegerValue4";
    public static final String CHECK_STATO_PDD_PARAM_LONG_VALUE = "paramLongValue";
    public static final String CHECK_STATO_PDD_PARAM_LONG_VALUE_2 = "paramLongValue2";
    public static final String CHECK_STATO_PDD_PARAM_LONG_VALUE_3 = "paramLongValue3";
    public static final String CHECK_STATO_PDD_PARAM_LONG_VALUE_4 = "paramLongValue4";
    public static final String CHECK_STATO_PDD_PARAM_BOOLEAN_VALUE = "paramBooleanValue";
    public static final String CHECK_STATO_PDD_PARAM_BOOLEAN_VALUE_2 = "paramBooleanValue2";
    public static final String CHECK_STATO_PDD_PARAM_BOOLEAN_VALUE_3 = "paramBooleanValue3";
    public static final String CHECK_STATO_PDD_PARAM_BOOLEAN_VALUE_4 = "paramBooleanValue4";
    public static final MapKey<String> CONNETTORE_REQUEST_URL = Map.newMapKey((String)"CONNETTORE_REQUEST_URL");
    public static final MapKey<String> CONNETTORE_REQUEST_METHOD = Map.newMapKey((String)"CONNETTORE_REQUEST_METHOD");
    public static final String CONNETTORE_REQUEST_PREFIX_METHOD = "[";
    public static final String CONNETTORE_REQUEST_SUFFIX_METHOD = "]";
    public static final String CONNETTORE_REQUEST_SEPARATOR = " ";
    public static final String KEY_PROTOCOLLO = "@PROTOCOLLO@";
    public static final String KEY_PROTOCOLLO_TIPI_SOGGETTI = "@PROTOCOLLO_TIPI_SOGGETTI@";
    public static final String KEY_PROTOCOLLO_TIPI_SERVIZI = "@PROTOCOLLO_TIPI_SERVIZI@";
    public static final String KEY_ID_MESSAGGIO_RICHIESTA = "@ID_MESSAGGIO_RICHIESTA@";
    public static final String KEY_ID_MESSAGGIO_RISPOSTA = "@ID_MESSAGGIO_RISPOSTA@";
    public static final String KEY_PROFILO_COLLABORAZIONE = "@PROFILO_COLLABORAZIONE@";
    public static final String KEY_RIFERIMENTO_MESSAGGIO_RICHIESTA = "@RIFERIMENTO_MESSAGGIO_RICHIESTA@";
    public static final String KEY_RIFERIMENTO_MESSAGGIO_RISPOSTA = "@RIFERIMENTO_MESSAGGIO_RISPOSTA@";
    public static final String KEY_TIPO_MITTENTE_BUSTA_RICHIESTA = "@TIPO_MITTENTE_BUSTA_RICHIESTA@";
    public static final String KEY_MITTENTE_BUSTA_RICHIESTA = "@MITTENTE_BUSTA_RICHIESTA@";
    public static final String KEY_TIPO_DESTINATARIO_BUSTA_RICHIESTA = "@TIPO_DESTINATARIO_BUSTA_RICHIESTA@";
    public static final String KEY_DESTINATARIO_BUSTA_RICHIESTA = "@DESTINATARIO_BUSTA_RICHIESTA@";
    public static final String KEY_TIPO_SERVIZIO_BUSTA_RICHIESTA = "@TIPO_SERVIZIO_BUSTA_RICHIESTA@";
    public static final String KEY_SERVIZIO_BUSTA_RICHIESTA = "@SERVIZIO_BUSTA_RICHIESTA@";
    public static final String KEY_VERSIONE_SERVIZIO_BUSTA_RICHIESTA = "@VERSIONE_SERVIZIO_BUSTA_RICHIESTA@";
    public static final String KEY_AZIONE_BUSTA_RICHIESTA = "@AZIONE_BUSTA_RICHIESTA@";
    public static final String KEY_INDIRIZZO_TELEMATICO_MITTENTE_RICHIESTA = "@INDIRIZZO_TELEMATICO_MITTENTE_RICHIESTA@";
    public static final String KEY_INDIRIZZO_TELEMATICO_DESTINATARIO_RICHIESTA = "@INDIRIZZO_TELEMATICO_DESTINATARIO_RICHIESTA@";
    public static final String KEY_SCADENZA_BUSTA_RICHIESTA = "@SCADENZA_BUSTA_RICHIESTA@";
    public static final String KEY_TIPO_MITTENTE_BUSTA_RISPOSTA = "@TIPO_MITTENTE_BUSTA_RISPOSTA@";
    public static final String KEY_MITTENTE_BUSTA_RISPOSTA = "@MITTENTE_BUSTA_RISPOSTA@";
    public static final String KEY_TIPO_DESTINATARIO_BUSTA_RISPOSTA = "@TIPO_DESTINATARIO_BUSTA_RISPOSTA@";
    public static final String KEY_DESTINATARIO_BUSTA_RISPOSTA = "@DESTINATARIO_BUSTA_RISPOSTA@";
    public static final String KEY_TIPO_SERVIZIO_BUSTA_RISPOSTA = "@TIPO_SERVIZIO_BUSTA_RISPOSTA@";
    public static final String KEY_SERVIZIO_BUSTA_RISPOSTA = "@SERVIZIO_BUSTA_RISPOSTA@";
    public static final String KEY_VERSIONE_SERVIZIO_BUSTA_RISPOSTA = "@VERSIONE_SERVIZIO_BUSTA_RISPOSTA@";
    public static final String KEY_AZIONE_BUSTA_RISPOSTA = "@AZIONE_BUSTA_RISPOSTA@";
    public static final String KEY_INDIRIZZO_TELEMATICO_MITTENTE_RISPOSTA = "@INDIRIZZO_TELEMATICO_MITTENTE_RISPOSTA@";
    public static final String KEY_INDIRIZZO_TELEMATICO_DESTINATARIO_RISPOSTA = "@INDIRIZZO_TELEMATICO_DESTINATARIO_RISPOSTA@";
    public static final String KEY_SCADENZA_BUSTA_RISPOSTA = "@SCADENZA_BUSTA_RISPOSTA@";
    public static final String KEY_URI_ACCORDO_PARTE_SPECIFICA = "@URI_ACCORDO_PARTE_SPECIFICA@";
    public static final String KEY_SEQUENZA = "@SEQUENZA@";
    public static final String KEY_SA_FRUITORE = "@SERVIZIO_APPLICATIVO_FRUITORE@";
    public static final String KEY_SA_EROGATORE = "@SERVIZIO_APPLICATIVO_EROGATORE@";
    public static final String KEY_ID_CORRELAZIONE_APPLICATIVA = "@ID_CORRELAZIONE_APPLICATIVA@";
    public static final String KEY_ID_CORRELAZIONE_ASINCRONA = "@ID_CORRELAZIONE_ASINCRONA@";
    public static final String KEY_ERRORE_PROCESSAMENTO = "@ERRORE_PROCESSAMENTO@";
    public static final String KEY_POSIZIONE_ERRORE = "@POSIZIONE_ERRORE@";
    public static final String KEY_PROPRIETARIO_MESSAGGIO = "@PROPRIETARIO_MESSAGGIO@";
    public static final String KEY_ID_MESSAGGIO_TRANSACTION_MANAGER = "@ID_MESSAGGIO_TRANSACTION_MANAGER@";
    public static final String KEY_HTTP_HEADER = "@HEADER_HTTP@";
    public static final String KEY_SOAP_ENVELOPE_NAMESPACE = "@SOAP_NAMESPACE@";
    public static final String KEY_SOAP_VERSION = "@SOAP_VERSION@";
    public static final String KEY_SOAP_ENVELOPE_NAMESPACE_ATTESO = "@SOAP_NAMESPACE_ATTESO@";
    public static final String KEY_CONTENT_TYPES_ATTESI = "@CONTENT_TYPES_ATTESI@";
    public static final String KEY_TIPO_MESSAGGIO_BUSTA_ERRORE = "@TIPO_ERRORE_BUSTA@";
    public static final String TIPO_MESSAGGIO_BUSTA_ERRORE_PROCESSAMENTO = "Processamento";
    public static final String TIPO_MESSAGGIO_BUSTA_ERRORE_INTESTAZIONE = "Intestazione";
    public static final String KEY_TIPO_BEHAVIOUR = "@TIPO_BEHAVIOUR@";
    public static final String KEY_DESCRIZIONE_BEHAVIOUR = "@DESCRIZIONE_BEHAVIOUR@";
    public static final String KEY_TIPO_SELETTORE = "@TIPO_SELETTORE@";
    public static final String KEY_PATTERN_SELETTORE = "@PATTERN_SELETTORE@";
    public static final String KEY_CONDIZIONE_CONNETTORE = "@CONDIZIONE_CONNETTORE@";
    public static final String KEY_NOME_CONNETTORE = "@NOME_CONNETTORE@";
    public static final String KEY_CONDIZIONE_STICKY = "@CONDIZIONE_STICKY@";
    public static final String KEY_ID_MESSAGGIO_DA_INOLTRARE = "@ID_MESSAGGIO_DA_INOLTRARE@";
    public static final String KEY_ID_MESSAGGIO_DA_ELIMINARE = "@ID_MESSAGGIO_DA_ELIMINARE@";
    public static final String KEY_TIPO_MESSAGGIO = "@TIPO_MESSAGGIO@";
    public static final String KEY_SCADENZA_MESSAGGIO = "@SCADENZA_MESSAGGIO@";
    public static final String KEY_CREDENZIALI_SA_FRUITORE = "@CREDENZIALI_SA_FRUITORE@";
    public static final String KEY_CREDENZIALI = "@CREDENZIALI@";
    public static final String KEY_PORTA_DELEGATA = "@PORTA_DELEGATA@";
    public static final String KEY_PORTA_APPLICATIVA = "@PORTA_APPLICATIVA@";
    public static final String KEY_TIPOLOGIA_RISPOSTA_APPLICATIVA = "@TIPOLOGIA_RISPOSTA_APPLICATIVA@";
    public static final String KEY_TIMEOUT = "@TIMEOUT@";
    public static final String KEY_OFFSET = "@OFFSET@";
    public static final String KEY_LIMIT = "@LIMIT@";
    public static final String KEY_NUMERO_EVENTI = "@NUMERO_EVENTI@";
    public static final String KEY_ID_EVENTO = "@ID_EVENTO@";
    public static final String KEY_TIPO_EVENTO = "@TIPO_EVENTO@";
    public static final String KEY_DETTAGLI_EVENTO = "@DETTAGLI_EVENTO@";
    public static final String KEY_TEMPO_GESTIONE = "@TEMPO_GESTIONE@";
    public static final String DATA_AGGIORNAMENTO = "@DATA_AGGIORNAMENTO@";
    public static final String KEY_NUMERO_OPERAZIONI = "@NUMERO_OPERAZIONI@";
    public static final String KEY_DATI_OPERAZIONE = "@DATI_OPERAZIONE@";
    public static final String KEY_DETTAGLI_OPERAZIONE = "@DETTAGLI_OPERAZIONE@";
    public static final String KEY_TIPO_RECORD = "@TIPO_RECORD@";
    public static final String KEY_NUMERO_RECORD = "@NUMERO_RECORD@";
    public static final String KEY_TIPO_STATISTICA = "@TIPO_STATISTICA@";
    public static final String KEY_TEMPO_GENERAZIONE = "@TEMPO_GENERAZIONE@";
    public static final String KEY_TIPO_AUTORIZZAZIONE = "@TIPO_AUTORIZZAZIONE@";
    public static final String KEY_TIPO_AUTORIZZAZIONE_CONTENUTO = "@TIPO_AUTORIZZAZIONE_CONTENUTO@";
    public static final String KEY_TIPO_AUTORIZZAZIONE_BUSTE = "@TIPO_AUTORIZZAZIONE_BUSTE@";
    public static final String KEY_TIPO_AUTENTICAZIONE = "@TIPO_AUTENTICAZIONE@";
    public static final String KEY_TOKEN_POLICY_GESTIONE = "@TOKEN_POLICY_GESTIONE@";
    public static final String KEY_TOKEN_TIPO = "@TOKEN_TIPO@";
    public static final String KEY_TOKEN_POLICY_AZIONI = "@TOKEN_POLICY_AZIONI@";
    public static final String KEY_TOKEN_POSIZIONE = "@TOKEN_POSIZIONE@";
    public static final String KEY_TOKEN = "@TOKEN@";
    public static final String KEY_TOKEN_INFO = "@TOKEN_INFO@";
    public static final String KEY_DYNAMIC_DISCOVERY_INFO = "@DYNAMIC_DISCOVERY_INFO@";
    public static final String KEY_TOKEN_ENDPOINT_SERVIZIO_DYNAMIC_DISCOVERY = "@TOKEN_ENDPOINT_SERVIZIO_DYNAMIC_DISCOVERY@";
    public static final String KEY_TOKEN_ENDPOINT_SERVIZIO_INTROSPECTION = "@TOKEN_ENDPOINT_SERVIZIO_INTROSPECTION@";
    public static final String KEY_TOKEN_ENDPOINT_SERVIZIO_USER_INFO = "@TOKEN_ENDPOINT_SERVIZIO_USER_INFO@";
    public static final String KEY_TOKEN_AUTHN_CHECK = "@TOKEN_AUTHN_CHECK@";
    public static final String KEY_TOKEN_CLIENT_ID = "@TOKEN_CLIENT_ID@";
    public static final String KEY_TOKEN_SERVIZIO_APPLICATIVO = "@TOKEN_SERVIZIO_APPLICATIVO@";
    public static final String KEY_ATTRIBUTE_AUTHORITY_NAME = "@ATTRIBUTE_AUTHORITY_NAME@";
    public static final String KEY_ATTRIBUTE_AUTHORITY_ENDPOINT = "@ATTRIBUTE_AUTHORIY_ENDPOINT@";
    public static final String KEY_ATTRIBUTES = "@ATTRIBUTES@";
    public static final String KEY_TIPO_VALIDAZIONE_CONTENUTI = "@TIPO_VALIDAZIONE_CONTENUTI@";
    public static final String KEY_DETAILS_VALIDAZIONE_CONTENUTI = "@DETAILS_VALIDAZIONE_CONTENUTI@";
    public static final String KEY_TIPO_PROCESSAMENTO_MTOM_RICHIESTA = "@TIPO_PROCESSAMENTO_MTOM_RICHIESTA@";
    public static final MapKey<String> TIPO_PROCESSAMENTO_MTOM_RICHIESTA = Map.newMapKey((String)"TIPO_PROCESSAMENTO_MTOM_RICHIESTA");
    public static final String KEY_TIPO_PROCESSAMENTO_MTOM_RISPOSTA = "@TIPO_PROCESSAMENTO_MTOM_RISPOSTA@";
    public static final MapKey<String> TIPO_PROCESSAMENTO_MTOM_RISPOSTA = Map.newMapKey((String)"TIPO_PROCESSAMENTO_MTOM_RISPOSTA");
    public static final String KEY_TIPO_SICUREZZA_MESSAGGIO_RICHIESTA = "@TIPO_SICUREZZA_MESSAGGIO_RICHIESTA@";
    public static final MapKey<String> TIPO_SICUREZZA_MESSAGGIO_RICHIESTA = Map.newMapKey((String)"TIPO_SICUREZZA_MESSAGGIO_RICHIESTA");
    public static final String KEY_TIPO_SICUREZZA_MESSAGGIO_RISPOSTA = "@TIPO_SICUREZZA_MESSAGGIO_RISPOSTA@";
    public static final MapKey<String> TIPO_SICUREZZA_MESSAGGIO_RISPOSTA = Map.newMapKey((String)"TIPO_SICUREZZA_MESSAGGIO_RISPOSTA");
    public static final String KEY_TIPO_TRASFORMAZIONE_RICHIESTA = "@TIPO_TRASFORMAZIONE_RICHIESTA@";
    public static final MapKey<String> TIPO_TRASFORMAZIONE_RICHIESTA = Map.newMapKey((String)"TIPO_TRASFORMAZIONE_RICHIESTA");
    public static final String KEY_TIPO_TRASFORMAZIONE_RISPOSTA = "@TIPO_TRASFORMAZIONE_RISPOSTA@";
    public static final MapKey<String> TIPO_TRASFORMAZIONE_RISPOSTA = Map.newMapKey((String)"TIPO_TRASFORMAZIONE_RISPOSTA");
    public static final String KEY_TIPO_MESSAGGIO_BUSTA = "@TIPO_MESSAGGIO_BUSTA@";
    public static final String KEY_MITTENTE_E_SERVIZIO_DA_AUTORIZZARE = "@MITTENTE_E_SERVIZIO_DA_AUTORIZZARE@";
    public static final String KEY_CREDENZIALI_MITTENTE_MSG = "@CREDENZIALI_MITTENTE_MSG@";
    public static final String KEY_SA_FRUITORE_MSG = "@SERVIZIO_APPLICATIVO_FRUITORE_MSG@";
    public static final String KEY_SUBJECT_MESSAGE_SECURITY_MSG = "@SUBJECT_MESSAGE_SECURITY_MSG@";
    public static final String KEY_TIPO_RICEVUTA_ASINCRONA = "@TIPO_RICEVUTA_ASINCRONA@";
    public static final String KEY_ECCEZIONI = "@ECCEZIONI@";
    public static final String KEY_NUMERO_ECCEZIONI = "@NUMERO_ECCEZIONI@";
    public static final String KEY_OPENSPCOOP2_DETAILS = "@OPENSPCOOP2_DETAILS@";
    public static final String KEY_ID_BUSTA_RISCONTRATA = "@ID_BUSTA_RISCONTRATA@";
    public static final String KEY_DATA_RISCONTRO = "@DATA_RISCONTRO@";
    public static final String KEY_SEQUENZA_ATTESA = "@SEQUENZA_ATTESA@";
    public static final String KEY_TIPO_CONNETTORE = "@TIPO_CONNETTORE@";
    public static final String KEY_LOCATION = "@LOCATION@";
    public static final String KEY_CODICE_CONSEGNA = "@CODICE_CONSEGNA@";
    public static final String KEY_ERRORE_CONSEGNA = "@ERRORE_CONSEGNA@";
    public static final String KEY_DESTINATARIO_TRASMISSIONE = "@DESTINATARIO_TRASMISSIONE@";
    public static final String KEY_SOAP_FAULT = "@SOAP_FAULT@";
    public static final String KEY_REST_PROBLEM = "@REST_PROBLEM@";
    public static final String KEY_FUNZIONALITA_COLLABORAZIONE = "@FUNZIONALITA_COLLABORAZIONE@";
    public static final String KEY_FUNZIONALITA_CONFERMA_RICEZIONE = "@FUNZIONALITA_CONFERMA_RICEZIONE@";
    public static final String KEY_FUNZIONALITA_FILTRO_DUPLICATI = "@FUNZIONALITA_FILTRO_DUPLICATI@";
    public static final String KEY_SCENARIO_COOPERAZIONE_GESTITO = "@SCENARIO_COOPERAZIONE_GESTITO@";
    public static final String KEY_INFO_SERVIZIO_BUSTA = "@INFO_SERVIZIO_BUSTA@";
    public static final String KEY_TIPO_OPERAZIONE_IM = "@TIPO_OPERAZIONE_IM@";
    public static final MapKey<String> TIPO_OPERAZIONE_IM = Map.newMapKey((String)"TIPO_OPERAZIONE_IM");
    public static final String KEY_PARAMETRI_OPERAZIONE_IM = "@PARAMETRI_OPERAZIONE_IM@";
    public static final String KEY_IDMESSAGGIO_OPERAZIONE_IM = "@ID_MESSAGGIO_OPERAZIONE_IM@";
    public static final String KEY_TIPO_HEADER_INTEGRAZIONE = "@TIPO_HEADER_INTEGRAZIONE@";
    public static final String KEY_TIPI_INTEGRAZIONE = "@TIPI_INTEGRAZIONE@";
    public static final String KEY_TIPO_GESTORE_CREDENZIALI = "@TIPO_GESTORE_CREDENZIALI@";
    public static final String KEY_NUOVE_CREDENZIALI = "@NUOVE_CREDENZIALI@";
    public static final String KEY_IDENTITA_GESTORE_CREDENZIALI = "@IDENTITA_GESTORE_CREDENZIALI@";
    public static final String KEY_TIPO_VALIDAZIONE_BUSTA = "@TIPO_VALIDAZIONE_BUSTA@";
    public static final String TIPO_VALIDAZIONE_BUSTA_SINTATTICA = "sintattica";
    public static final String TIPO_VALIDAZIONE_BUSTA_SEMANTICA = "semantica";
    public static final String KEY_INTERMEDIARIO = "@SOGGETTO_INTERMEDIARIO@";
    public static final MapKey<String> INTERMEDIARIO = Map.newMapKey((String)"SOGGETTO_INTERMEDIARIO");
    public static final MapKey<String> SALVA_CONTESTO_IDENTIFICATIVO_MESSAGGIO_NOTIFICA = Map.newMapKey((String)"SALVA_CONTESTO_IDENTIFICATIVO_MESSAGGIO_NOTIFICA");
    public static final MapKey<String> CONTESTO_RICHIESTA_MESSAGGIO_NOTIFICA = Map.newMapKey((String)"CONTESTO_RICHIESTA_MESSAGGIO_NOTIFICA");
    public static final String KEY_TRACCIAMENTO_PERSONALIZZATO = "@TIPO_TRACCIAMENTO_PERSONALIZZATO@";
    public static final String KEY_TRACCIAMENTO_ERRORE = "@ERRORE_TRACCIAMENTO@";
    public static final String KEY_TRACCIA_TIPO = "@TIPO_TRACCIA@";
    public static final String KEY_TRACCIA = "@TRACCIA@";
    public static final String KEY_FASE_TRACCIAMENTO = "@FASE_TRACCIAMENTO@";
    public static final String KEY_LOCK_CAUSALE = "@CAUSA_LOCK@";
    public static final String KEY_LOCK_ID_MODULO = "@ID_MODULO_PROPRIETARIO_LOCK@";
    public static final String KEY_TIMER_GESTORE_RISCONTRI_RICEVUTE = "@ID_TIMER_GESTORE_RISCONTRI_RICEVUTE@";
    public static final String KEY_TIMER_GESTORE_MESSAGGI = "@ID_TIMER_GESTORE_MESSAGGI@";
    public static final String KEY_TIMER_GESTORE_MESSAGGI_NUM_MSG_INBOX_COMPLETATI = "@NUMERO_MESSAGGI_COMPLETATI_INBOX@";
    public static final String KEY_TIMER_GESTORE_MESSAGGI_NUM_MSG_OUTBOX_COMPLETATI = "@NUMERO_MESSAGGI_COMPLETATI_OUTBOX@";
    public static final String KEY_TIMER_GESTORE_MESSAGGI_NUM_MSG_INBOX_SCADUTI = "@NUMERO_MESSAGGI_SCADUTI_INBOX@";
    public static final String KEY_TIMER_GESTORE_MESSAGGI_NUM_MSG_OUTBOX_SCADUTI = "@NUMERO_MESSAGGI_SCADUTI_OUTBOX@";
    public static final String KEY_TIMER_GESTORE_MESSAGGI_NUM_MSG_NON_GESTITI_RICEZIONE_CONTENUTI_APPLICATIVI = "@NUMERO_MESSAGGI_NON_GESTITI_RICEZIONE_CONTENUTI_APPLICATIVI@";
    public static final String KEY_TIMER_GESTORE_MESSAGGI_NUM_MSG_NON_GESTITI_RICEZIONE_BUSTE = "@NUMERO_MESSAGGI_NON_GESTITI_RICEZIONE_BUSTE@";
    public static final String KEY_TIMER_GESTORE_MESSAGGI_NUM_CORRELAZIONI_APPLICATIVE_SCADUTE = "@NUMERO_CORRELAZIONI_APPLICATIVE@";
    public static final String KEY_TIMER_GESTORE_MESSAGGI_TIPO_RICERCA_MSG_DA_ELIMINARE = "@TIPO_RICERCA@";
    public static final String KEY_TIMER_GESTORE_MESSAGGI_RICERCA_MSG_DA_ELIMINARE_PER_RIFERIMENTO = "@RICERCA_TRAMITE_RIFERIMENTO@";
    public static final String KEY_TIMER_GESTORE_MESSAGGI_CODA_JMS_FILTRO_MSG_DA_ELIMINARE = "@CODA_JMS_RICEZIONE@";
    public static final String KEY_TIMER_GESTORE_MESSAGGI_TIPO_CONNESSIONE = "@TIPO_CONNESSIONE@";
    public static final String KEY_TIMER_GESTORE_MESSAGGI_DATA_CREAZIONE_CONNESSIONE = "@DATA_CREAZIONE_CONNESSIONE@";
    public static final String KEY_TIMER = "@ID_TIMER@";
    public static final String KEY_REMOTE_STORE = "@ID_REMOTE_STORE@";
    public static final String KEY_TIMER_CONSEGNA_CONTENUTI_APPLICATIVI_NUMERO_MESSAGGI_INOLTRATI = "@NUMERO_MESSAGGI_INOLTRATI@";
    public static final String KEY_TIMER_GESTORE_MESSAGGI_INCONSISTENTI = "@ID_TIMER_GESTORE_MESSAGGI_INCONSISTENTI@";
    public static final String KEY_TIMER_GESTORE_MESSAGGI_INCONSISTENTI_NUM_MSG_INBOX = "@NUMERO_MESSAGGI_INCONSISTENTI_INBOX@";
    public static final String KEY_TIMER_GESTORE_MESSAGGI_INCONSISTENTI_NUM_MSG_OUTBOX = "@NUMERO_MESSAGGI_INCONSISTENTI_OUTBOX@";
    public static final String KEY_TIMER_GESTORE_REPOSITORY_BUSTE = "@ID_TIMER_GESTORE_REPOSITORY_BUSTE@";
    public static final String KEY_TIMER_GESTORE_REPOSITORY_BUSTE_NUM_MSG_INBOX = "@NUMERO_BUSTE_INBOX@";
    public static final String KEY_TIMER_GESTORE_REPOSITORY_BUSTE_NUM_MSG_OUTBOX = "@NUMERO_BUSTE_OUTBOX@";
    public static final String KEY_TIMER_MONITORAGGIO_RISORSE = "@ID_TIMER_MONITORAGGIO_RISORSE@";
    public static final String KEY_RISORSA_NON_DISPONIBILE = "@RISORSA_NON_DISPONIBILE@";
    public static final String KEY_TIMER_THRESHOLD = "@ID_TIMER_THRESHOLD@";
    public static final String KEY_TIMER_THRESHOLD_TIPO = "@TIPO_THRESHOLD@";
    public static final String KEY_VERSIONE_PORTA = "@VERSIONE@";
    public static final String KEY_TEMPO_AVVIO = "@TEMPO_DI_AVVIO@";
    public static final String KEY_DETAILS = "@DETAILS@";
    private static final String KEY_INFO_IN_CACHE = "@INFO_IN_CACHE@";
    private static final String KEY_INFO_IN_CACHE_VALUE = " (in cache)";
    public static final MapKey<String> KEY_INFO_IN_CACHE_FUNZIONE_AUTENTICAZIONE = Map.newMapKey((String)"RESULT_AUTHN_IN_CACHE");
    public static final MapKey<String> KEY_INFO_IN_CACHE_FUNZIONE_AUTORIZZAZIONE = Map.newMapKey((String)"RESULT_AUTHZ_IN_CACHE");
    public static final MapKey<String> KEY_INFO_IN_CACHE_FUNZIONE_AUTORIZZAZIONE_CONTENUTI = Map.newMapKey((String)"RESULT_AUTHZ_CONTENUTI_IN_CACHE");
    public static final MapKey<String> KEY_INFO_IN_CACHE_FUNZIONE_AUTENTICAZIONE_TOKEN = Map.newMapKey((String)"RESULT_AUTHN_TOKEN_IN_CACHE");
    public static final MapKey<String> KEY_INFO_IN_CACHE_FUNZIONE_MODI_TOKEN_AUTHORIZATION = Map.newMapKey((String)"RESULT_MODI_AUTH_TOKEN_IN_CACHE");
    public static final MapKey<String> KEY_INFO_IN_CACHE_FUNZIONE_MODI_TOKEN_INTEGRITY = Map.newMapKey((String)"RESULT_MODI_INTEGRITY_TOKEN_IN_CACHE");
    public static final MapKey<String> KEY_INFO_IN_CACHE_FUNZIONE_MODI_TOKEN_AUDIT = Map.newMapKey((String)"RESULT_MODI_AUDIT_TOKEN_IN_CACHE");
    public static final MapKey<String> KEY_INFO_IN_CACHE_FUNZIONE_AUTENTICAZIONE_FALLITA = Map.newMapKey((String)"RESULT_AUTHN_FALLITA");
    public static final String KEY_CONTENT_TYPE = "@CONTENT_TYPE@";
    public static final String KEY_CHARSET_DEFAULT = "@CHARSET_DEFAULT@";
    public static final String OPTIONS_MESSAGE_FACTORY = "MessageEngine";
    public static final String PREFIX_HTTP_STATUS_CODE_IN = "In=";
    public static final String PREFIX_HTTP_STATUS_CODE_OUT = "Out=";
    public static final String PREFIX_API = "API=";
    public static final String PREFIX_CONNETTORI_MULTIPLI = "Async=";
    public static final String PREFIX_MESSAGGIO_CONNETTORE_MULTIPLO = "gw-";
    public static final String SEPARATOR_MESSAGGIO_CONNETTORE_MULTIPLO = "-";
    public static final String PREFIX_TIMEOUT_REQUEST = "Request ";
    public static final String PREFIX_TIMEOUT_RESPONSE = "Response ";
    public static final String PREFIX_LIMITED_REQUEST = "Request ";
    public static final String PREFIX_LIMITED_RESPONSE = "Response ";
    public static final MapKey<String> FORCE_SWA_START_PARAMETER_IF_NOT_PRESENT = Map.newMapKey((String)"FORCE_SWA_START_PARAMETER");
    public static final MapKey<String> CONNETTORE_MULTIPLO_SELEZIONATO = Map.newMapKey((String)"CONNETTORE_MULTIPLO_SELEZIONATO");
    public static final MapKey<String> CONNETTORE_MULTIPLO_CONSEGNA_NOTIFICA_DISABILITATA = Map.newMapKey((String)"CONNETTORE_MULTIPLO_CONSEGNA_NOTIFICA_DISABILITATA");
    public static final MapKey<String> FILTRO_DUPLICATI_TEST = Map.newMapKey((String)"FILTRO_DUPLICATI_TEST");
    public static final MapKey<String> REQUEST_READ_TIMEOUT = Map.newMapKey((String)"REQUEST_READ_TIMEOUT");
    public static final String GOVWAY_CHANNEL_BIO = "BIO";
    public static final String GOVWAY_CHANNEL_NIO = "NIO";
    public static final String GOVWAY_CORE = "GovWayCore";
    public static final String GOVWAY_CORE_ERRORE_GENERAZIONE_DIAGNOSTICO = "Errore generazione diagnostico";
    public static final String GOVWAY_CORE_ERRORE_GENERALE = "ErroreGenerale";
    public static final MapKey<String> EXTRA_HEADERS_RESPONSE = Map.newMapKey((String)"MAPPA_HEADERS_EXTRA_RISPOSTA");
    public static final MapKey<String> KEY_OVERRIDE_CONNETTORE = Map.newMapKey((String)"overrideConnettore");

    private CostantiPdD() {
    }

    public static String getOpenspcoop2LoggerProtocolLocalPath(String protocol) {
        return OPENSPCOOP2_LOGGER_PROTOCOL_LOCAL_PATH.replace(OPENSPCOOP2_LOGGER_PROTOCOL_ID_PROTOCOLLO, protocol);
    }

    public static String getOpenspcoop2LoggerProtocolProperties(String protocol) {
        return OPENSPCOOP2_LOGGER_PROTOCOL_PROPERTIES.replace(OPENSPCOOP2_LOGGER_PROTOCOL_ID_PROTOCOLLO, protocol);
    }

    public static String getOpenspcoop2LoggerFactoryName(String protocol) {
        return OPENSPCOOP2_LOGGER_FACTORY_NAME.replace(OPENSPCOOP2_LOGGER_PROTOCOL_ID_PROTOCOLLO, protocol);
    }

    public static boolean isTokenValidazionePdnd(Context context) {
        return CostantiPdD.isTokenPdnd(context, TOKEN_VALIDAZIONE_PDND);
    }

    public static boolean isTokenNegoziazionePdnd(Context context) {
        return CostantiPdD.isTokenPdnd(context, TOKEN_NEGOZIAZIONE_PDND);
    }

    public static boolean isTokenPdnd(Context context, MapKey<String> key) {
        Object o;
        if (context != null && context.containsKey(key) && (o = context.get(key)) instanceof String) {
            return TOKEN_ESITO_TRUE.equals(o);
        }
        return false;
    }

    public static int getAvailableProcessors() {
        return Runtime.getRuntime().availableProcessors();
    }

    public static final String getConnettoreRequest(String url, String method) {
        return CONNETTORE_REQUEST_PREFIX_METHOD + method + "] " + url;
    }

    public static final String readUrlFromConnettoreRequest(String request) {
        String splitSeparator = "] ";
        int indexOf = request.indexOf(splitSeparator);
        if (indexOf > 0 && request.length() > indexOf + splitSeparator.length()) {
            return request.substring(indexOf + splitSeparator.length());
        }
        return null;
    }

    public static final String readMethodFromConnettoreRequest(String request) {
        String s;
        String splitSeparator = "] ";
        int indexOf = request.indexOf(splitSeparator);
        if (indexOf > 0 && (s = request.substring(0, indexOf)).startsWith(CONNETTORE_REQUEST_PREFIX_METHOD)) {
            return s.substring(CONNETTORE_REQUEST_PREFIX_METHOD.length());
        }
        return null;
    }

    public static final void addKeywordInCache(MsgDiagnostico msgDiag, boolean isEsitoPresenteInCache, Context pddContext, MapKey<String> idFUNCTION) {
        if (isEsitoPresenteInCache) {
            msgDiag.addKeyword(KEY_INFO_IN_CACHE, KEY_INFO_IN_CACHE_VALUE);
        } else {
            msgDiag.addKeyword(KEY_INFO_IN_CACHE, "");
        }
        if (idFUNCTION != null) {
            pddContext.addObject(idFUNCTION, (Object)isEsitoPresenteInCache);
        }
    }

    public static final void addKeywordAutenticazioneFallita(MsgDiagnostico msgDiag, String motivo, Context pddContext, MapKey<String> idFUNCTION) {
        msgDiag.addKeyword(KEY_ERRORE_PROCESSAMENTO, motivo);
        pddContext.addObject(idFUNCTION, (Object)motivo);
    }

    public static void addSWAStartParameterIfNotPresent(OpenSPCoop2Message msg) {
        if (msg != null) {
            msg.addContextProperty(FORCE_SWA_START_PARAMETER_IF_NOT_PRESENT, (Object)TOKEN_ESITO_TRUE);
        }
    }

    public static boolean isEnabledAddSWAStartParameterIfNotPresent(OpenSPCoop2Message msg) {
        Object o;
        if (msg != null && (o = msg.getContextProperty(FORCE_SWA_START_PARAMETER_IF_NOT_PRESENT)) instanceof String) {
            return TOKEN_ESITO_TRUE.equals(o);
        }
        return false;
    }
}

