/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.config;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.openspcoop2.core.commons.CoreException;
import org.openspcoop2.core.config.Proprieta;
import org.openspcoop2.pdd.config.OpenSPCoop2Properties;
import org.openspcoop2.pdd.core.dynamic.InformazioniIntegrazioneCodifica;
import org.openspcoop2.pdd.core.dynamic.InformazioniIntegrazioneSorgente;
import org.openspcoop2.pdd.core.integrazione.peer.PeerHeaderDescriptor;
import org.openspcoop2.pdd.core.integrazione.peer.RegexpPeerHeaderDescriptor;
import org.openspcoop2.pdd.core.integrazione.peer.StringPeerHeaderDescriptor;
import org.openspcoop2.utils.BooleanNullable;
import org.openspcoop2.utils.certificate.KeystoreType;
import org.openspcoop2.utils.resources.Charset;
import org.openspcoop2.utils.security.CertificateValidityCheck;
import org.openspcoop2.utils.transport.http.HttpLibrary;
import org.openspcoop2.utils.transport.http.HttpLibraryConnection;
import org.openspcoop2.utils.transport.http.RFC2047Encoding;

public class CostantiProprieta {
    public static final String VALUE_ENABLED = "true";
    public static final String VALUE_DISABLED = "false";
    public static final String VALIDAZIONE_CONTENUTI_PROPERTY_VALUE_ENABLED = "true";
    public static final String VALIDAZIONE_CONTENUTI_PROPERTY_VALUE_DISABLED = "false";
    public static final String VALIDAZIONE_CONTENUTI_PROPERTY_NAME_RICHIESTA_ENABLED = "validation.request.enabled";
    public static final String VALIDAZIONE_CONTENUTI_PROPERTY_NAME_RISPOSTA_ENABLED = "validation.response.enabled";
    public static final String VALIDAZIONE_CONTENUTI_PROPERTY_NAME_RICHIESTA_TIPO = "validation.request.type";
    public static final String VALIDAZIONE_CONTENUTI_PROPERTY_NAME_RISPOSTA_TIPO = "validation.response.type";
    public static final String VALIDAZIONE_CONTENUTI_PROPERTY_NAME_RICHIESTA_ACCEPT_MTOM_MESSAGE = "validation.request.acceptMtom";
    public static final String VALIDAZIONE_CONTENUTI_PROPERTY_NAME_RISPOSTA_ACCEPT_MTOM_MESSAGE = "validation.response.acceptMtom";
    public static final String VALIDAZIONE_CONTENUTI_PROPERTY_VALUE_WARNING_ONLY = "warning";
    public static final String VALIDAZIONE_CONTENUTI_PROPERTY_NAME_COMMONS_ENABLED_SUFFIX = "enabled";
    public static final String VALIDAZIONE_CONTENUTI_PROPERTY_NAME_COMMONS_MERGE_API_SPEC_SUFFIX = "mergeAPISpec";
    public static final String VALIDAZIONE_CONTENUTI_PROPERTY_NAME_COMMONS_VALIDATE_API_SPEC_SUFFIX = "validateAPISpec";
    public static final String VALIDAZIONE_CONTENUTI_PROPERTY_NAME_COMMONS_VALIDATE_REQUEST_PATH_SUFFIX = "validateRequestPath";
    public static final String VALIDAZIONE_CONTENUTI_PROPERTY_NAME_COMMONS_VALIDATE_REQUEST_QUERY_SUFFIX = "validateRequestQuery";
    public static final String VALIDAZIONE_CONTENUTI_PROPERTY_NAME_COMMONS_VALIDATE_REQUEST_UNEXPECTED_QUERY_PARAM_SUFFIX = "validateRequestUnexpectedQueryParam";
    public static final String VALIDAZIONE_CONTENUTI_PROPERTY_NAME_COMMONS_VALIDATE_REQUEST_HEADERS_SUFFIX = "validateRequestHeaders";
    public static final String VALIDAZIONE_CONTENUTI_PROPERTY_NAME_COMMONS_VALIDATE_REQUEST_COOKIES_SUFFIX = "validateRequestCookies";
    public static final String VALIDAZIONE_CONTENUTI_PROPERTY_NAME_COMMONS_VALIDATE_REQUEST_BODY_SUFFIX = "validateRequestBody";
    public static final String VALIDAZIONE_CONTENUTI_PROPERTY_NAME_COMMONS_VALIDATE_RESPONSE_HEADERS_SUFFIX = "validateResponseHeaders";
    public static final String VALIDAZIONE_CONTENUTI_PROPERTY_NAME_COMMONS_VALIDATE_RESPONSE_BODY_SUFFIX = "validateResponseBody";
    public static final String VALIDAZIONE_CONTENUTI_PROPERTY_NAME_COMMONS_VALIDATE_WILDCARD_SUBTYPE_AS_JSON_SUFFIX = "validateWildcardSubtypeAsJson";
    public static final String VALIDAZIONE_CONTENUTI_PROPERTY_NAME_COMMONS_VALIDATE_MULTIPART_OPTIMIZATION_SUFFIX = "validateMultipartOptimization";
    private static final String VALIDAZIONE_CONTENUTI_PROPERTY_NAME_COMMONS_PREFIX = "validation.openApi.";
    public static final String VALIDAZIONE_CONTENUTI_PROPERTY_VALUE_COMMONS_ENABLED = "true";
    public static final String VALIDAZIONE_CONTENUTI_PROPERTY_VALUE_COMMONS_DISABLED = "false";
    public static final String VALIDAZIONE_CONTENUTI_PROPERTY_NAME_COMMONS_MERGE_API_SPEC = "validation.openApi.mergeAPISpec";
    public static final String VALIDAZIONE_CONTENUTI_PROPERTY_NAME_COMMONS_VALIDATE_API_SPEC = "validation.openApi.validateAPISpec";
    public static final String VALIDAZIONE_CONTENUTI_PROPERTY_NAME_COMMONS_VALIDATE_REQUEST_PATH = "validation.openApi.validateRequestPath";
    public static final String VALIDAZIONE_CONTENUTI_PROPERTY_NAME_COMMONS_VALIDATE_REQUEST_QUERY = "validation.openApi.validateRequestQuery";
    public static final String VALIDAZIONE_CONTENUTI_PROPERTY_NAME_COMMONS_VALIDATE_REQUEST_UNEXPECTED_QUERY_PARAM = "validation.openApi.validateRequestUnexpectedQueryParam";
    public static final String VALIDAZIONE_CONTENUTI_PROPERTY_NAME_COMMONS_VALIDATE_REQUEST_HEADERS = "validation.openApi.validateRequestHeaders";
    public static final String VALIDAZIONE_CONTENUTI_PROPERTY_NAME_COMMONS_VALIDATE_REQUEST_COOKIES = "validation.openApi.validateRequestCookies";
    public static final String VALIDAZIONE_CONTENUTI_PROPERTY_NAME_COMMONS_VALIDATE_REQUEST_BODY = "validation.openApi.validateRequestBody";
    public static final String VALIDAZIONE_CONTENUTI_PROPERTY_NAME_COMMONS_VALIDATE_RESPONSE_HEADERS = "validation.openApi.validateResponseHeaders";
    public static final String VALIDAZIONE_CONTENUTI_PROPERTY_NAME_COMMONS_VALIDATE_RESPONSE_BODY = "validation.openApi.validateResponseBody";
    public static final String VALIDAZIONE_CONTENUTI_PROPERTY_NAME_COMMONS_VALIDATE_WILDCARD_SUBTYPE_AS_JSON = "validation.openApi.validateWildcardSubtypeAsJson";
    public static final String VALIDAZIONE_CONTENUTI_PROPERTY_NAME_COMMONS_VALIDATE_MULTIPART_OPTIMIZATION = "validation.openApi.validateMultipartOptimization";
    private static final String VALIDAZIONE_CONTENUTI_PROPERTY_NAME_OPENAPI4J_PREFIX = "validation.openApi4j.";
    public static final String VALIDAZIONE_CONTENUTI_PROPERTY_VALUE_OPENAPI4J_ENABLED = "true";
    public static final String VALIDAZIONE_CONTENUTI_PROPERTY_VALUE_OPENAPI4J_DISABLED = "false";
    public static final String VALIDAZIONE_CONTENUTI_PROPERTY_NAME_OPENAPI4J_ENABLED = "validation.openApi4j.enabled";
    public static final String VALIDAZIONE_CONTENUTI_PROPERTY_NAME_OPENAPI4J_MERGE_API_SPEC = "validation.openApi4j.mergeAPISpec";
    public static final String VALIDAZIONE_CONTENUTI_PROPERTY_NAME_OPENAPI4J_VALIDATE_API_SPEC = "validation.openApi4j.validateAPISpec";
    public static final String VALIDAZIONE_CONTENUTI_PROPERTY_NAME_OPENAPI4J_VALIDATE_REQUEST_PATH = "validation.openApi4j.validateRequestPath";
    public static final String VALIDAZIONE_CONTENUTI_PROPERTY_NAME_OPENAPI4J_VALIDATE_REQUEST_QUERY = "validation.openApi4j.validateRequestQuery";
    public static final String VALIDAZIONE_CONTENUTI_PROPERTY_NAME_OPENAPI4J_VALIDATE_REQUEST_UNEXPECTED_QUERY_PARAM = "validation.openApi4j.validateRequestUnexpectedQueryParam";
    public static final String VALIDAZIONE_CONTENUTI_PROPERTY_NAME_OPENAPI4J_VALIDATE_REQUEST_HEADERS = "validation.openApi4j.validateRequestHeaders";
    public static final String VALIDAZIONE_CONTENUTI_PROPERTY_NAME_OPENAPI4J_VALIDATE_REQUEST_COOKIES = "validation.openApi4j.validateRequestCookies";
    public static final String VALIDAZIONE_CONTENUTI_PROPERTY_NAME_OPENAPI4J_VALIDATE_REQUEST_BODY = "validation.openApi4j.validateRequestBody";
    public static final String VALIDAZIONE_CONTENUTI_PROPERTY_NAME_OPENAPI4J_VALIDATE_RESPONSE_HEADERS = "validation.openApi4j.validateResponseHeaders";
    public static final String VALIDAZIONE_CONTENUTI_PROPERTY_NAME_OPENAPI4J_VALIDATE_RESPONSE_BODY = "validation.openApi4j.validateResponseBody";
    public static final String VALIDAZIONE_CONTENUTI_PROPERTY_NAME_OPENAPI4J_VALIDATE_WILDCARD_SUBTYPE_AS_JSON = "validation.openApi4j.validateWildcardSubtypeAsJson";
    public static final String VALIDAZIONE_CONTENUTI_PROPERTY_NAME_OPENAPI4J_VALIDATE_MULTIPART_OPTIMIZATION = "validation.openApi4j.validateMultipartOptimization";
    private static final String VALIDAZIONE_CONTENUTI_PROPERTY_NAME_SWAGGER_REQUEST_VALIDATOR_PREFIX = "validation.swaggerRequestValidator.";
    public static final String VALIDAZIONE_CONTENUTI_PROPERTY_VALUE_SWAGGER_REQUEST_VALIDATOR_ENABLED = "true";
    public static final String VALIDAZIONE_CONTENUTI_PROPERTY_VALUE_SWAGGER_REQUEST_VALIDATOR_DISABLED = "false";
    public static final String VALIDAZIONE_CONTENUTI_PROPERTY_NAME_SWAGGER_REQUEST_VALIDATOR_ENABLED = "validation.swaggerRequestValidator.enabled";
    public static final String VALIDAZIONE_CONTENUTI_PROPERTY_NAME_SWAGGER_REQUEST_VALIDATOR_MERGE_API_SPEC = "validation.swaggerRequestValidator.mergeAPISpec";
    public static final String VALIDAZIONE_CONTENUTI_PROPERTY_NAME_SWAGGER_REQUEST_VALIDATOR_VALIDATE_API_SPEC = "validation.swaggerRequestValidator.validateAPISpec";
    public static final String VALIDAZIONE_CONTENUTI_PROPERTY_NAME_SWAGGER_REQUEST_VALIDATOR_VALIDATE_REQUEST_PATH = "validation.swaggerRequestValidator.validateRequestPath";
    public static final String VALIDAZIONE_CONTENUTI_PROPERTY_NAME_SWAGGER_REQUEST_VALIDATOR_VALIDATE_REQUEST_QUERY = "validation.swaggerRequestValidator.validateRequestQuery";
    public static final String VALIDAZIONE_CONTENUTI_PROPERTY_NAME_SWAGGER_REQUEST_VALIDATOR_VALIDATE_REQUEST_UNEXPECTED_QUERY_PARAM = "validation.swaggerRequestValidator.validateRequestUnexpectedQueryParam";
    public static final String VALIDAZIONE_CONTENUTI_PROPERTY_NAME_SWAGGER_REQUEST_VALIDATOR_VALIDATE_REQUEST_HEADERS = "validation.swaggerRequestValidator.validateRequestHeaders";
    public static final String VALIDAZIONE_CONTENUTI_PROPERTY_NAME_SWAGGER_REQUEST_VALIDATOR_VALIDATE_REQUEST_COOKIES = "validation.swaggerRequestValidator.validateRequestCookies";
    public static final String VALIDAZIONE_CONTENUTI_PROPERTY_NAME_SWAGGER_REQUEST_VALIDATOR_VALIDATE_REQUEST_BODY = "validation.swaggerRequestValidator.validateRequestBody";
    public static final String VALIDAZIONE_CONTENUTI_PROPERTY_NAME_SWAGGER_REQUEST_VALIDATOR_VALIDATE_RESPONSE_HEADERS = "validation.swaggerRequestValidator.validateResponseHeaders";
    public static final String VALIDAZIONE_CONTENUTI_PROPERTY_NAME_SWAGGER_REQUEST_VALIDATOR_VALIDATE_RESPONSE_BODY = "validation.swaggerRequestValidator.validateResponseBody";
    public static final String VALIDAZIONE_CONTENUTI_PROPERTY_NAME_SWAGGER_REQUEST_VALIDATOR_VALIDATE_WILDCARD_SUBTYPE_AS_JSON = "validation.swaggerRequestValidator.validateWildcardSubtypeAsJson";
    public static final String VALIDAZIONE_CONTENUTI_PROPERTY_NAME_SWAGGER_REQUEST_VALIDATOR_INJECTING_ADDITIONAL_PROPERTIES_FALSE = "validation.swaggerRequestValidator.injectingAdditionalPropertiesFalse";
    public static final String VALIDAZIONE_CONTENUTI_PROPERTY_NAME_SWAGGER_REQUEST_VALIDATOR_RESOLVE_FULLY_API_SPEC = "validation.swaggerRequestValidator.resolveFullyApiSpec";
    public static final String VALIDAZIONE_CONTENUTI_PROPERTY_NAME_BUFFER_ENABLED = "validation.buffer.enabled";
    public static final String VALIDAZIONE_CONTENUTI_PROPERTY_NAME_SOAPACTION_ENABLED = "validation.soapAction.enabled";
    public static final String VALIDAZIONE_CONTENUTI_PROPERTY_NAME_RPC_ACCEPT_ROOT_ELEMENT_UNQUALIFIED_ENABLED = "validation.rpc.rootElementUnqualified.accept";
    public static final String VALIDAZIONE_CONTENUTI_PROPERTY_NAME_REST_FAULT_GOVWAY_ENABLED = "validation.faultGovway.enabled";
    public static final String VALIDAZIONE_CONTENUTI_PROPERTY_NAME_REST_PROBLEM_DETAIL_ENABLED = "validation.problemDetails.enabled";
    public static final String VALIDAZIONE_CONTENUTI_PROPERTY_NAME_REST_EMPTY_RESPONSE_ENABLED = "validation.emptyResponse.enabled";
    public static final String VALIDAZIONE_CONTENUTI_PROPERTY_NAME_REST_RETURN_CODE_LIST_ENABLED = "validation.returnCode";
    public static final String VALIDAZIONE_CONTENUTI_PROPERTY_NAME_REST_RETURN_CODE_LIST_SEPARATOR = ",";
    public static final String VALIDAZIONE_CONTENUTI_PROPERTY_NAME_REST_RETURN_CODE_LIST_INTERVAL_SEPARATOR = "-";
    public static final String VALIDAZIONE_CONTENUTI_PROPERTY_NAME_REST_RETURN_CODE_NOT = "validation.returnCode.not";
    public static final String VALIDAZIONE_CONTENUTI_PROPERTY_NAME_REST_CONTENT_TYPE_LIST_ENABLED = "validation.contentType";
    public static final String VALIDAZIONE_CONTENUTI_PROPERTY_NAME_REST_CONTENT_TYPE_LIST_SEPARATOR = ",";
    public static final String VALIDAZIONE_CONTENUTI_PROPERTY_NAME_REST_CONTENT_TYPE_NOT = "validation.contentType.not";
    public static final String TOKEN_VALIDATION_VALUE_ENABLED = "true";
    public static final String TOKEN_VALIDATION_VALUE_DISABLED = "false";
    public static final String TOKEN_VALIDATION_VALUE_IF_NOT_IN_TRUSTSTORE = "ifNotInTruststore";
    public static final String TOKEN_VALIDATION_VALIDITY_CHECK = "tokenValidation.validityCheck";
    public static final String TOKEN_VALIDATION_CLAIMS_VALUE_ENABLED = "true";
    public static final String TOKEN_VALIDATION_CLAIMS_VALUE_DISABLED = "false";
    public static final String TOKEN_VALIDATION_CLAIMS_IAT_REQUIRED = "tokenValidation.iat.required";
    public static final String TOKEN_VALIDATION_CLAIMS_EXP_REQUIRED = "tokenValidation.exp.required";
    public static final String TOKEN_VALIDATION_CLAIMS_NBF_REQUIRED = "tokenValidation.nbf.required";
    public static final String ATTRIBUTE_AUTHORITY_VALUE_ENABLED = "true";
    public static final String ATTRIBUTE_AUTHORITY_VALUE_DISABLED = "false";
    public static final String ATTRIBUTE_AUTHORITY_VALUE_IF_NOT_IN_TRUSTSTORE = "ifNotInTruststore";
    public static final String ATTRIBUTE_AUTHORITY_VALIDITY_CHECK = "attributeAuthority.validityCheck";
    public static final String AUTENTICAZIONE_VALUE_ENABLED = "true";
    public static final String AUTENTICAZIONE_VALUE_DISABLED = "false";
    public static final String AUTENTICAZIONE_HTTPS_VALIDITY_CHECK = "authentication.https.validityCheck";
    public static final String AUTENTICAZIONE_HTTPS_TRUSTSTORE_ENABLED = "authentication.https.truststore.enabled";
    public static final String AUTENTICAZIONE_HTTPS_TRUSTSTORE = "authentication.https.truststore";
    public static final String AUTENTICAZIONE_HTTPS_TRUSTSTORE_PASSWORD = "authentication.https.truststore.password";
    public static final String AUTENTICAZIONE_HTTPS_TRUSTSTORE_TYPE = "authentication.https.truststore.type";
    public static final String AUTENTICAZIONE_HTTPS_TRUSTSTORE_CRLS = "authentication.https.truststore.crls";
    public static final String AUTENTICAZIONE_HTTPS_TRUSTSTORE_OCSP_POLICY = "authentication.https.truststore.ocspPolicy";
    public static final String CORRELAZIONE_APPLICATIVA_VALUE_ENABLED = "true";
    public static final String CORRELAZIONE_APPLICATIVA_VALUE_DISABLED = "false";
    public static final String CORRELAZIONE_APPLICATIVA_PROPERTY_NAME_TRUNCATE_ID = "correlation.truncate";
    public static final String CORRELAZIONE_APPLICATIVA_PROPERTY_NAME_ACCEPT_IDENTIFICATION_FAILED_TRUNCATE_ID = "correlation.acceptIdentificationFailed.truncate";
    public static final String CORRELAZIONE_APPLICATIVA_PROPERTY_NAME_BLOCK_IDENTIFICATION_FAILED_TRUNCATE_ID = "correlation.blockIdentificationFailed.truncate";
    public static final String CORRELAZIONE_APPLICATIVA_RICHIESTA_PROPERTY_NAME_TRUNCATE_ID = "correlation.request.truncate";
    public static final String CORRELAZIONE_APPLICATIVA_RICHIESTA_PROPERTY_NAME_ACCEPT_IDENTIFICATION_FAILED_TRUNCATE_ID = "correlation.request.acceptIdentificationFailed.truncate";
    public static final String CORRELAZIONE_APPLICATIVA_RICHIESTA_PROPERTY_NAME_BLOCK_IDENTIFICATION_FAILED_TRUNCATE_ID = "correlation.request.blockIdentificationFailed.truncate";
    public static final String CORRELAZIONE_APPLICATIVA_RISPOSTA_PROPERTY_NAME_TRUNCATE_ID = "correlation.response.truncate";
    public static final String CORRELAZIONE_APPLICATIVA_RISPOSTA_PROPERTY_NAME_ACCEPT_IDENTIFICATION_FAILED_TRUNCATE_ID = "correlation.response.acceptIdentificationFailed.truncate";
    public static final String CORRELAZIONE_APPLICATIVA_RISPOSTA_PROPERTY_NAME_BLOCK_IDENTIFICATION_FAILED_TRUNCATE_ID = "correlation.response.blockIdentificationFailed.truncate";
    public static final String CORRELAZIONE_APPLICATIVA_RICHIESTA_PROPERTY_NAME_EXTRACTED_IDENTIFIER_IS_NULL_ABORT_TRANSACTION_ID = "correlation.request.extractedIdentifierIsNull.abortTransaction";
    public static final String CORRELAZIONE_APPLICATIVA_RISPOSTA_PROPERTY_NAME_EXTRACTED_IDENTIFIER_IS_NULL_ABORT_TRANSACTION_ID = "correlation.response.extractedIdentifierIsNull.abortTransaction";
    public static final String CORRELAZIONE_APPLICATIVA_RICHIESTA_PROPERTY_NAME_EXTRACTED_IDENTIFIER_IS_EMPTY_ABORT_TRANSACTION_ID = "correlation.request.extractedIdentifierIsEmpty.abortTransaction";
    public static final String CORRELAZIONE_APPLICATIVA_RISPOSTA_PROPERTY_NAME_EXTRACTED_IDENTIFIER_IS_EMPTY_ABORT_TRANSACTION_ID = "correlation.response.extractedIdentifierIsEmpty.abortTransaction";
    public static final String CORRELAZIONE_APPLICATIVA_RICHIESTA_PROPERTY_NAME_RULE_NOT_FOUND_ABORT_TRANSACTION_ID = "correlation.request.ruleNotFound.abortTransaction";
    public static final String CORRELAZIONE_APPLICATIVA_RISPOSTA_PROPERTY_NAME_RULE_NOT_FOUND_ABORT_TRANSACTION_ID = "correlation.response.ruleNotFound.abortTransaction";
    public static final String CONNETTORE_VALUE_ENABLED = "true";
    public static final String CONNETTORE_VALUE_DISABLED = "false";
    private static final String CONNETTORE_TIMEOUT_INPUT_STREAM_ENABLED = "connettori.timeoutInputStream.enabled";
    private static final String CONNETTORE_TIMEOUT_INPUT_STREAM_REQUEST_TIMEOUT = "connettori.request.timeoutMs";
    public static final String CONNETTORE_HEADER_VALUE_ENCODING_RFC2047_RICHIESTA_ENABLED = "connettori.header.value.encodingRFC2047.request.enabled";
    public static final String CONNETTORE_HEADER_VALUE_ENCODING_RFC2047_RISPOSTA_ENABLED = "connettori.header.value.encodingRFC2047.response.enabled";
    public static final String CONNETTORE_HEADER_VALUE_ENCODING_RFC2047_ENABLED = "connettori.header.value.encodingRFC2047.enabled";
    public static final String CONNETTORE_HEADER_VALUE_ENCODING_RFC2047_RICHIESTA_ENCODING = "connettori.header.value.encodingRFC2047.request.type";
    public static final String CONNETTORE_HEADER_VALUE_ENCODING_RFC2047_RISPOSTA_ENCODING = "connettori.header.value.encodingRFC2047.response.type";
    public static final String CONNETTORE_HEADER_VALUE_ENCODING_RFC2047_ENCODING = "connettori.header.value.encodingRFC2047.type";
    public static final String CONNETTORE_HEADER_VALUE_ENCODING_RFC2047_RICHIESTA_CHARSET = "connettori.header.value.encodingRFC2047.request.charset";
    public static final String CONNETTORE_HEADER_VALUE_ENCODING_RFC2047_RISPOSTA_CHARSET = "connettori.header.value.encodingRFC2047.response.charset";
    public static final String CONNETTORE_HEADER_VALUE_ENCODING_RFC2047_CHARSET = "connettori.header.value.encodingRFC2047.charset";
    public static final String CONNETTORE_HEADER_VALIDATION_RICHIESTA_ENABLED = "connettori.header.validation.request.enabled";
    public static final String CONNETTORE_HEADER_VALIDATION_RISPOSTA_ENABLED = "connettori.header.validation.response.enabled";
    public static final String CONNETTORE_HEADER_VALIDATION_ENABLED = "connettori.header.validation.enabled";
    public static final String CONNETTORE_SERVER_SENT_EVENTS_ENABLED = "connettori.serverSentEvents.enabled";
    public static final String CONNETTORE_POOL_CONNECTION_MAX_PER_ROUTE = "connettori.connection.pool.maxPerRoute";
    public static final String CONNETTORE_POOL_CONNECTION_MAX_TOTAL = "connettori.connection.pool.maxTotal";
    public static final String CONNETTORE_POOL_CONNECTION_VALIDATE_AFTER_INACTIVITY = "connettori.connection.pool.validateAfterInactivity";
    public static final String CONNETTORE_PEER_HEADER_PREFIX = "connettori.peer-header.";
    public static final String CONNETTORE_PEER_HEADER_ENABLED = "connettori.peer-header.default.enabled";
    public static final String CONNETTORE_PROXY_PASS_VALUE_ENABLED = "true";
    public static final String CONNETTORE_PROXY_PASS_VALUE_DISABLED = "false";
    private static final String CONNETTORE_PROXY_PASS_REVERSE_ENABLED = "connettori.proxyPassReverse.enabled";
    private static final String CONNETTORE_PROXY_PASS_REVERSE_HEADERS = "connettori.proxyPassReverse.headers";
    private static final String CONNETTORE_PROXY_PASS_REVERSE_SETCOOKIE_ENABLED = "connettori.proxyPassReverse.setCookie.enabled";
    private static final String CONNETTORE_PROXY_PASS_REVERSE_SETCOOKIE_PATH_ENABLED = "connettori.proxyPassReverse.setCookie.path.enabled";
    private static final String CONNETTORE_PROXY_PASS_REVERSE_SETCOOKIE_DOMAIN_ENABLED = "connettori.proxyPassReverse.setCookie.domain.enabled";
    private static final String CONNETTORE_PROXY_PASS_REVERSE_SETCOOKIE_HEADERS = "connettori.proxyPassReverse.setCookie.headers";
    private static final String CONNETTORE_PROXY_PASS_REVERSE_USE_PROTOCOL_PREFIX = "connettori.proxyPassReverse.useProtocolPrefix";
    public static final String CONNETTORE_HTTPS_ENDPOINT_JVM_CONFIG_OVERRIDE_VALUE_ENABLED = "true";
    public static final String CONNETTORE_HTTPS_ENDPOINT_JVM_CONFIG_OVERRIDE_VALUE_DISABLED = "false";
    private static final String CONNETTORE_HTTPS_ENDPOINT_JVM_CONFIG_OVERRIDE_ENABLED = "connettori.httpsEndpoint.jvmConfigOverride.enabled";
    private static final String CONNETTORE_HTTPS_ENDPOINT_JVM_CONFIG_OVERRIDE_REPOSITORY = "connettori.httpsEndpoint.jvmConfigOverride.repository";
    private static final String CONNETTORE_HTTPS_ENDPOINT_JVM_CONFIG_OVERRIDE_CONFIG = "connettori.httpsEndpoint.jvmConfigOverride.config";
    public static final String CONNETTORE_TOKEN_VALIDATE_LIBRARY = "connettori.token.validate.httplibrary";
    public static final String CONNETTORE_TOKEN_RETRIEVE_LIBRARY = "connettori.token.retrieve.httplibrary";
    public static final String CONNETTORE_TOKEN_AUTHORITY_LIBRARY = "connettori.token.authority.httplibrary";
    private static final String REGISTRAZIONE_MESSAGGI_WHITE_LIST = "registrazioneMessaggi.whiteList";
    private static final String REGISTRAZIONE_MESSAGGI_BLACK_LIST = "registrazioneMessaggi.blackList";
    private static final String REGISTRAZIONE_MESSAGGI_RICHIESTA_INGRESSO_WHITE_LIST = "registrazioneMessaggi.richiestaIngresso.whiteList";
    private static final String REGISTRAZIONE_MESSAGGI_RICHIESTA_INGRESSO_BLACK_LIST = "registrazioneMessaggi.richiestaIngresso.blackList";
    private static final String REGISTRAZIONE_MESSAGGI_RICHIESTA_USCITA_WHITE_LIST = "registrazioneMessaggi.richiestaUscita.whiteList";
    private static final String REGISTRAZIONE_MESSAGGI_RICHIESTA_USCITA_BLACK_LIST = "registrazioneMessaggi.richiestaUscita.blackList";
    private static final String REGISTRAZIONE_MESSAGGI_RISPOSTA_INGRESSO_WHITE_LIST = "registrazioneMessaggi.rispostaIngresso.whiteList";
    private static final String REGISTRAZIONE_MESSAGGI_RISPOSTA_INGRESSO_BLACK_LIST = "registrazioneMessaggi.rispostaIngresso.blackList";
    private static final String REGISTRAZIONE_MESSAGGI_RISPOSTA_USCITA_WHITE_LIST = "registrazioneMessaggi.rispostaUscita.whiteList";
    private static final String REGISTRAZIONE_MESSAGGI_RISPOSTA_USCITA_BLACK_LIST = "registrazioneMessaggi.rispostaUscita.blackList";
    private static final String FILE_TRACE_VALUE_ENABLED = "true";
    private static final String FILE_TRACE_VALUE_DISABLED = "false";
    private static final String FILE_TRACE_ENABLED = "fileTrace.enabled";
    private static final String FILE_TRACE_DUMP_BINARIO_ENABLED = "fileTrace.dumpBinario.enabled";
    private static final String FILE_TRACE_DUMP_BINARIO_PAYLOAD_ENABLED = "fileTrace.dumpBinario.payload.enabled";
    private static final String FILE_TRACE_DUMP_BINARIO_HEADERS_ENABLED = "fileTrace.dumpBinario.headers.enabled";
    private static final String FILE_TRACE_DUMP_BINARIO_CONNETTORE_ENABLED = "fileTrace.dumpBinario.connettore.enabled";
    private static final String FILE_TRACE_DUMP_BINARIO_CONNETTORE_PAYLOAD_ENABLED = "fileTrace.dumpBinario.connettore.payload.enabled";
    private static final String FILE_TRACE_DUMP_BINARIO_CONNETTORE_HEADERS_ENABLED = "fileTrace.dumpBinario.connettore.headers.enabled";
    private static final String FILE_TRACE_CONFIG = "fileTrace.config";
    public static final String FILTRO_DUPLICATI_TEST_ENABLED = "true";
    public static final String FILTRO_DUPLICATI_TEST_DISABLED = "false";
    private static final String FILTRO_DUPLICATI_TEST = "duplicates-filter-test.enabled";
    public static final String INFORMAZIONI_INTEGRAZIONE_VALUE_ENABLED = "true";
    public static final String INFORMAZIONI_INTEGRAZIONE_VALUE_DISABLED = "false";
    private static final String INFORMAZIONI_INTEGRAZIONE_ENABLED = "integrationInfo.enabled";
    private static final String INFORMAZIONI_INTEGRAZIONE_TYPE = "integrationInfo.type";
    private static final String INFORMAZIONI_INTEGRAZIONE_NAME = "integrationInfo.name";
    private static final String INFORMAZIONI_INTEGRAZIONE_ENCODE = "integrationInfo.encode";
    private static final String INFORMAZIONI_INTEGRAZIONE_REQUIRED = "integrationInfo.required";
    public static final String INFORMAZIONI_INTEGRAZIONE_RISPOSTA_VALUE_ENABLED = "true";
    public static final String INFORMAZIONI_INTEGRAZIONE_RISPOSTA_VALUE_DISABLED = "false";
    private static final String INFORMAZIONI_INTEGRAZIONE_RISPOSTA_ENABLED = "responseIntegrationInfo.enabled";
    private static final String INFORMAZIONI_INTEGRAZIONE_RISPOSTA_NAME = "responseIntegrationInfo.name";
    private static final String INFORMAZIONI_INTEGRAZIONE_RISPOSTA_ENCODE = "responseIntegrationInfo.encode";
    private static final String INFORMAZIONI_INTEGRAZIONE_RISPOSTA_REQUIRED = "responseIntegrationInfo.required";
    public static final String SECURITY_HEADERS_VALUE_ENABLED = "true";
    public static final String SECURITY_HEADERS_VALUE_DISABLED = "false";
    private static final String SECURITY_HEADERS_ENABLED = "securityHeaders.enabled";
    private static final String SECURITY_HEADERS_DEFAULT_ENABLED = "securityHeaders.default";
    private static final String SECURITY_HEADERS_LIST = "securityHeaders";
    private static final String SECURITY_HEADERS_PREFIX = "securityHeaders.";
    public static final String RATE_LIMITING_VALUE_ENABLED = "true";
    public static final String RATE_LIMITING_VALUE_DISABLED = "false";
    private static final String RATE_LIMITING_USE_HTTP_CONTENT_LENGTH = "rateLimiting.useHttpContentLength";
    private static final String RATE_LIMITING_USE_HTTP_CONTENT_LENGTH_ACCEPT_ZERO_VALUE = "rateLimiting.useHttpContentLength.acceptZeroValue";
    public static final String MODI_VALUE_ENABLED = "true";
    public static final String MODI_VALUE_DISABLED = "false";
    private static final String MODI_AUDIT_CLAIM_PREFIX = "modi.audit.";
    private static final String MODI_AUDIT_SUFFIX_TRACE_ENABLED = ".trace.enabled";
    private static final String MODI_AUDIT_SUFFIX_FORWARD_BACKEND_ENABLED = ".forwardBackend.enabled";
    private static final String MODI_AUDIT_SUFFIX_FORWARD_BACKEND = ".forwardBackend";
    private static final String MODI_TRACE_JTI_SOURCE = "modi.trace.jti.source";
    public static final String MODI_TRACE_JTI_SOURCE_VALUE_AUTHORIZATION = "authorization";
    public static final String MODI_TRACE_JTI_SOURCE_VALUE_INTEGRITY = "integrity";
    private static final String PDND_ABORT_TRANSACTION_ORGANIZATION_READ_ERROR = "pdnd.readByApiInterop.organization.failed.abortTransaction";
    private static final String PDND_ABORT_TRANSACTION_CLIENT_READ_ERROR = "pdnd.readByApiInterop.client.failed.abortTransaction";
    private static final String PDND_ABORT_TRANSACTION_ORGANIZATION_NOT_AVAILABLE_RATE_LIMITING = "pdnd.rateLimitingByOrganization.infoNotAvailable.abortTransaction";
    public static final String PDND_SIGNAL_HUB_NAMESPACE = "pdnd.signalHub.namespace";
    public static final String PDND_VALUE_ENABLED = "true";
    public static final String PDND_VALUE_DISABLED = "false";

    private CostantiProprieta() {
    }

    public static CertificateValidityCheck getTokenValidationCertificateValidityCheck(List<Proprieta> proprieta, CertificateValidityCheck defaultValue) {
        CertificateValidityCheck c;
        String v = CostantiProprieta.readValue(proprieta, TOKEN_VALIDATION_VALIDITY_CHECK);
        if (v != null && !StringUtils.isEmpty((CharSequence)v) && (c = CertificateValidityCheck.parseCertificateValidityCheck((String)(v = v.trim()))) != null) {
            return c;
        }
        return defaultValue;
    }

    public static boolean isTokenValidationClaimsIatRequired(List<Proprieta> proprieta, boolean defaultValue) {
        return CostantiProprieta.readBooleanValueWithDefault(proprieta, TOKEN_VALIDATION_CLAIMS_IAT_REQUIRED, defaultValue, "true", "false");
    }

    public static boolean isTokenValidationClaimsExpRequired(List<Proprieta> proprieta, boolean defaultValue) {
        return CostantiProprieta.readBooleanValueWithDefault(proprieta, TOKEN_VALIDATION_CLAIMS_EXP_REQUIRED, defaultValue, "true", "false");
    }

    public static boolean isTokenValidationClaimsNbfRequired(List<Proprieta> proprieta, boolean defaultValue) {
        return CostantiProprieta.readBooleanValueWithDefault(proprieta, TOKEN_VALIDATION_CLAIMS_NBF_REQUIRED, defaultValue, "true", "false");
    }

    public static CertificateValidityCheck getAttributeAuthorityCertificateValidityCheck(List<Proprieta> proprieta, CertificateValidityCheck defaultValue) {
        CertificateValidityCheck c;
        String v = CostantiProprieta.readValue(proprieta, ATTRIBUTE_AUTHORITY_VALIDITY_CHECK);
        if (v != null && !StringUtils.isEmpty((CharSequence)v) && (c = CertificateValidityCheck.parseCertificateValidityCheck((String)(v = v.trim()))) != null) {
            return c;
        }
        return defaultValue;
    }

    public static boolean isAutenticazioneHttpsValidityCheck(List<Proprieta> proprieta, boolean defaultValue) {
        return CostantiProprieta.readBooleanValueWithDefault(proprieta, AUTENTICAZIONE_HTTPS_VALIDITY_CHECK, defaultValue, "true", "false");
    }

    public static boolean isAutenticazioneHttpsTrustStore(List<Proprieta> proprieta, File pathDefaultValue) {
        String enabled = CostantiProprieta.readValue(proprieta, AUTENTICAZIONE_HTTPS_TRUSTSTORE_ENABLED);
        boolean isEnabled = true;
        if (enabled != null && !StringUtils.isEmpty((CharSequence)enabled) && "false".equals(enabled.trim())) {
            isEnabled = false;
        }
        if (!isEnabled) {
            return false;
        }
        String path = CostantiProprieta.readValue(proprieta, AUTENTICAZIONE_HTTPS_TRUSTSTORE);
        if ((path == null || StringUtils.isEmpty((CharSequence)path)) && pathDefaultValue != null) {
            path = pathDefaultValue.getAbsolutePath();
        }
        return path != null && StringUtils.isNotEmpty((CharSequence)path);
    }

    public static String getAutenticazioneHttpsTrustStorePath(List<Proprieta> proprieta, File pathDefaultValue) {
        String path = CostantiProprieta.readValue(proprieta, AUTENTICAZIONE_HTTPS_TRUSTSTORE);
        if ((path == null || StringUtils.isEmpty((CharSequence)path)) && pathDefaultValue != null) {
            path = pathDefaultValue.getAbsolutePath();
        }
        return path;
    }

    public static String getAutenticazioneHttpsTrustStorePassword(List<Proprieta> proprieta, String passwordDefaultValue) {
        String password = CostantiProprieta.readValue(proprieta, AUTENTICAZIONE_HTTPS_TRUSTSTORE_PASSWORD);
        if (password == null) {
            password = passwordDefaultValue;
        }
        return password;
    }

    public static String getAutenticazioneHttpsTrustStoreType(List<Proprieta> proprieta, String typeDefaultValue) {
        String type = CostantiProprieta.readValue(proprieta, AUTENTICAZIONE_HTTPS_TRUSTSTORE_TYPE);
        if (type == null) {
            type = typeDefaultValue;
        }
        if (type == null) {
            type = KeystoreType.JKS.getNome();
        }
        return type;
    }

    public static String getAutenticazioneHttpsTrustStoreCRLs(List<Proprieta> proprieta, String crlsDefaultValue) {
        String crls = CostantiProprieta.readValue(proprieta, AUTENTICAZIONE_HTTPS_TRUSTSTORE_CRLS);
        if (crls == null) {
            crls = crlsDefaultValue;
        }
        return crls;
    }

    public static String getAutenticazioneHttpsTrustStoreOCSPPolicy(List<Proprieta> proprieta, String crlsDefaultValue) {
        String crls = CostantiProprieta.readValue(proprieta, AUTENTICAZIONE_HTTPS_TRUSTSTORE_OCSP_POLICY);
        if (crls == null) {
            crls = crlsDefaultValue;
        }
        return crls;
    }

    public static boolean isCorrelazioneApplicativaRichiestaIdentificazioneFallitaBloccaTruncate(List<Proprieta> proprieta, boolean defaultValue) {
        return CostantiProprieta.isCorrelazioneApplicativaTruncate(proprieta, defaultValue, CORRELAZIONE_APPLICATIVA_RICHIESTA_PROPERTY_NAME_BLOCK_IDENTIFICATION_FAILED_TRUNCATE_ID, CORRELAZIONE_APPLICATIVA_RICHIESTA_PROPERTY_NAME_TRUNCATE_ID, CORRELAZIONE_APPLICATIVA_PROPERTY_NAME_BLOCK_IDENTIFICATION_FAILED_TRUNCATE_ID, CORRELAZIONE_APPLICATIVA_PROPERTY_NAME_TRUNCATE_ID);
    }

    public static boolean isCorrelazioneApplicativaRichiestaIdentificazioneFallitaAccettaTruncate(List<Proprieta> proprieta, boolean defaultValue) {
        return CostantiProprieta.isCorrelazioneApplicativaTruncate(proprieta, defaultValue, CORRELAZIONE_APPLICATIVA_RICHIESTA_PROPERTY_NAME_ACCEPT_IDENTIFICATION_FAILED_TRUNCATE_ID, CORRELAZIONE_APPLICATIVA_RICHIESTA_PROPERTY_NAME_TRUNCATE_ID, CORRELAZIONE_APPLICATIVA_PROPERTY_NAME_ACCEPT_IDENTIFICATION_FAILED_TRUNCATE_ID, CORRELAZIONE_APPLICATIVA_PROPERTY_NAME_TRUNCATE_ID);
    }

    public static boolean isCorrelazioneApplicativaRispostaIdentificazioneFallitaBloccaTruncate(List<Proprieta> proprieta, boolean defaultValue) {
        return CostantiProprieta.isCorrelazioneApplicativaTruncate(proprieta, defaultValue, CORRELAZIONE_APPLICATIVA_RISPOSTA_PROPERTY_NAME_BLOCK_IDENTIFICATION_FAILED_TRUNCATE_ID, CORRELAZIONE_APPLICATIVA_RISPOSTA_PROPERTY_NAME_TRUNCATE_ID, CORRELAZIONE_APPLICATIVA_PROPERTY_NAME_BLOCK_IDENTIFICATION_FAILED_TRUNCATE_ID, CORRELAZIONE_APPLICATIVA_PROPERTY_NAME_TRUNCATE_ID);
    }

    public static boolean isCorrelazioneApplicativaRispostaIdentificazioneFallitaAccettaTruncate(List<Proprieta> proprieta, boolean defaultValue) {
        return CostantiProprieta.isCorrelazioneApplicativaTruncate(proprieta, defaultValue, CORRELAZIONE_APPLICATIVA_RISPOSTA_PROPERTY_NAME_ACCEPT_IDENTIFICATION_FAILED_TRUNCATE_ID, CORRELAZIONE_APPLICATIVA_RISPOSTA_PROPERTY_NAME_TRUNCATE_ID, CORRELAZIONE_APPLICATIVA_PROPERTY_NAME_ACCEPT_IDENTIFICATION_FAILED_TRUNCATE_ID, CORRELAZIONE_APPLICATIVA_PROPERTY_NAME_TRUNCATE_ID);
    }

    private static boolean isCorrelazioneApplicativaTruncate(List<Proprieta> proprieta, boolean defaultValue, String propertyNameIdentificationFailedFlow, String propertyNameFlow, String propertyNameIdentificationFailed, String propertyName) {
        BooleanNullable flow = CostantiProprieta.isCorrelazioneApplicativaTruncateFlow(proprieta, propertyNameIdentificationFailedFlow, propertyNameFlow);
        if (flow != null && flow.getValue() != null) {
            return flow.getValue();
        }
        String valueS = CostantiProprieta.readValue(proprieta, propertyNameIdentificationFailed);
        if (valueS != null && StringUtils.isNotEmpty((CharSequence)valueS)) {
            if ("true".equals(valueS.trim())) {
                return true;
            }
            if ("false".equals(valueS.trim())) {
                return false;
            }
        }
        if ((valueS = CostantiProprieta.readValue(proprieta, propertyName)) != null && StringUtils.isNotEmpty((CharSequence)valueS)) {
            if ("true".equals(valueS.trim())) {
                return true;
            }
            if ("false".equals(valueS.trim())) {
                return false;
            }
        }
        return defaultValue;
    }

    private static BooleanNullable isCorrelazioneApplicativaTruncateFlow(List<Proprieta> proprieta, String propertyNameIdentificationFailedFlow, String propertyNameFlow) {
        String valueS = CostantiProprieta.readValue(proprieta, propertyNameIdentificationFailedFlow);
        if (valueS != null && StringUtils.isNotEmpty((CharSequence)valueS)) {
            if ("true".equals(valueS.trim())) {
                return BooleanNullable.TRUE();
            }
            if ("false".equals(valueS.trim())) {
                return BooleanNullable.FALSE();
            }
        }
        if ((valueS = CostantiProprieta.readValue(proprieta, propertyNameFlow)) != null && StringUtils.isNotEmpty((CharSequence)valueS)) {
            if ("true".equals(valueS.trim())) {
                return BooleanNullable.TRUE();
            }
            if ("false".equals(valueS.trim())) {
                return BooleanNullable.FALSE();
            }
        }
        return BooleanNullable.NULL();
    }

    public static boolean isCorrelazioneApplicativaRichiestaIdentificativoEstrattoIsNullTerminaTransazioneConErrore(List<Proprieta> proprieta, boolean defaultValue) {
        return CostantiProprieta.readBooleanValueWithDefault(proprieta, CORRELAZIONE_APPLICATIVA_RICHIESTA_PROPERTY_NAME_EXTRACTED_IDENTIFIER_IS_NULL_ABORT_TRANSACTION_ID, defaultValue, "true", "false");
    }

    public static boolean isCorrelazioneApplicativaRispostaIdentificativoEstrattoIsNullTerminaTransazioneConErrore(List<Proprieta> proprieta, boolean defaultValue) {
        return CostantiProprieta.readBooleanValueWithDefault(proprieta, CORRELAZIONE_APPLICATIVA_RISPOSTA_PROPERTY_NAME_EXTRACTED_IDENTIFIER_IS_NULL_ABORT_TRANSACTION_ID, defaultValue, "true", "false");
    }

    public static boolean isCorrelazioneApplicativaRichiestaIdentificativoEstrattoIsEmptyTerminaTransazioneConErrore(List<Proprieta> proprieta, boolean defaultValue) {
        return CostantiProprieta.readBooleanValueWithDefault(proprieta, CORRELAZIONE_APPLICATIVA_RICHIESTA_PROPERTY_NAME_EXTRACTED_IDENTIFIER_IS_EMPTY_ABORT_TRANSACTION_ID, defaultValue, "true", "false");
    }

    public static boolean isCorrelazioneApplicativaRispostaIdentificativoEstrattoIsEmptyTerminaTransazioneConErrore(List<Proprieta> proprieta, boolean defaultValue) {
        return CostantiProprieta.readBooleanValueWithDefault(proprieta, CORRELAZIONE_APPLICATIVA_RISPOSTA_PROPERTY_NAME_EXTRACTED_IDENTIFIER_IS_EMPTY_ABORT_TRANSACTION_ID, defaultValue, "true", "false");
    }

    public static boolean isCorrelazioneApplicativaRichiestaRegolaNonTrovataTerminaTransazioneConErrore(List<Proprieta> proprieta, boolean defaultValue) {
        return CostantiProprieta.readBooleanValueWithDefault(proprieta, CORRELAZIONE_APPLICATIVA_RICHIESTA_PROPERTY_NAME_RULE_NOT_FOUND_ABORT_TRANSACTION_ID, defaultValue, "true", "false");
    }

    public static boolean isCorrelazioneApplicativaRispostaRegolaNonTrovataTerminaTransazioneConErrore(List<Proprieta> proprieta, boolean defaultValue) {
        return CostantiProprieta.readBooleanValueWithDefault(proprieta, CORRELAZIONE_APPLICATIVA_RISPOSTA_PROPERTY_NAME_RULE_NOT_FOUND_ABORT_TRANSACTION_ID, defaultValue, "true", "false");
    }

    public static boolean isConnettoriUseTimeoutInputStream(List<Proprieta> proprieta, boolean defaultValue) {
        return CostantiProprieta.readBooleanValueWithDefault(proprieta, CONNETTORE_TIMEOUT_INPUT_STREAM_ENABLED, defaultValue, "true", "false");
    }

    public static int getConnettoriRequestTimeout(List<Proprieta> proprieta, int defaultValue) {
        return CostantiProprieta.readIntValueWithDefault(proprieta, CONNETTORE_TIMEOUT_INPUT_STREAM_REQUEST_TIMEOUT, defaultValue);
    }

    public static boolean existsConnettoriRequestTimeout(List<Proprieta> proprieta) {
        return CostantiProprieta.readIntValueWithDefault(proprieta, CONNETTORE_TIMEOUT_INPUT_STREAM_REQUEST_TIMEOUT, -1) > 0;
    }

    public static boolean isConnettoriHeaderValueEncodingRFC2047RequestEnabled(List<Proprieta> proprieta, boolean defaultValue) {
        String isEnabled = CostantiProprieta.readValue(proprieta, CONNETTORE_HEADER_VALUE_ENCODING_RFC2047_RICHIESTA_ENABLED);
        if (isEnabled != null && !"".equals(isEnabled)) {
            if ("true".equals(isEnabled.trim())) {
                return true;
            }
            if ("false".equals(isEnabled.trim())) {
                return false;
            }
        }
        return CostantiProprieta.readBooleanValueWithDefault(proprieta, CONNETTORE_HEADER_VALUE_ENCODING_RFC2047_ENABLED, defaultValue, "true", "false");
    }

    public static boolean isConnettoriHeaderValueEncodingRFC2047ResponseEnabled(List<Proprieta> proprieta, boolean defaultValue) {
        String isEnabled = CostantiProprieta.readValue(proprieta, CONNETTORE_HEADER_VALUE_ENCODING_RFC2047_RISPOSTA_ENABLED);
        if (isEnabled != null && !"".equals(isEnabled)) {
            if ("true".equals(isEnabled.trim())) {
                return true;
            }
            if ("false".equals(isEnabled.trim())) {
                return false;
            }
        }
        return CostantiProprieta.readBooleanValueWithDefault(proprieta, CONNETTORE_HEADER_VALUE_ENCODING_RFC2047_ENABLED, defaultValue, "true", "false");
    }

    public static RFC2047Encoding getConnettoriHeaderValueEncodingRFC2047RequestType(List<Proprieta> proprieta, RFC2047Encoding defaultValue) {
        return CostantiProprieta.getConnettoriHeaderValueEncodingRFC2047Type(CONNETTORE_HEADER_VALUE_ENCODING_RFC2047_RICHIESTA_ENCODING, proprieta, defaultValue);
    }

    public static RFC2047Encoding getConnettoriHeaderValueEncodingRFC2047ResponseType(List<Proprieta> proprieta, RFC2047Encoding defaultValue) {
        return CostantiProprieta.getConnettoriHeaderValueEncodingRFC2047Type(CONNETTORE_HEADER_VALUE_ENCODING_RFC2047_RISPOSTA_ENCODING, proprieta, defaultValue);
    }

    private static RFC2047Encoding getConnettoriHeaderValueEncodingRFC2047Type(String pName, List<Proprieta> proprieta, RFC2047Encoding defaultValue) {
        RFC2047Encoding t2;
        String type = CostantiProprieta.readValue(proprieta, pName);
        if (type != null && !"".equals(type)) {
            try {
                t2 = RFC2047Encoding.valueOf((String)type);
                if (t2 != null) {
                    return t2;
                }
            }
            catch (Exception t2) {
                // empty catch block
            }
        }
        if ((type = CostantiProprieta.readValue(proprieta, CONNETTORE_HEADER_VALUE_ENCODING_RFC2047_ENCODING)) != null && !"".equals(type)) {
            try {
                t2 = RFC2047Encoding.valueOf((String)type);
                if (t2 != null) {
                    return t2;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    public static Charset getConnettoriHeaderValueEncodingRFC2047RequestCharset(List<Proprieta> proprieta, Charset defaultValue) {
        return CostantiProprieta.getConnettoriHeaderValueEncodingRFC2047Charset(CONNETTORE_HEADER_VALUE_ENCODING_RFC2047_RICHIESTA_CHARSET, proprieta, defaultValue);
    }

    public static Charset getConnettoriHeaderValueEncodingRFC2047ResponseCharset(List<Proprieta> proprieta, Charset defaultValue) {
        return CostantiProprieta.getConnettoriHeaderValueEncodingRFC2047Charset(CONNETTORE_HEADER_VALUE_ENCODING_RFC2047_RISPOSTA_CHARSET, proprieta, defaultValue);
    }

    private static Charset getConnettoriHeaderValueEncodingRFC2047Charset(String pName, List<Proprieta> proprieta, Charset defaultValue) {
        Charset t;
        String type = CostantiProprieta.readValue(proprieta, pName);
        if (type != null && !"".equals(type) && (t = CostantiProprieta.parseCharset(type)) != null) {
            return t;
        }
        type = CostantiProprieta.readValue(proprieta, CONNETTORE_HEADER_VALUE_ENCODING_RFC2047_CHARSET);
        if (type != null && !"".equals(type) && (t = CostantiProprieta.parseCharset(type)) != null) {
            return t;
        }
        return defaultValue;
    }

    private static Charset parseCharset(String type) {
        if (type != null && !"".equals(type)) {
            try {
                Charset t = Charset.toEnumConstant((String)type);
                if (t != null) {
                    return t;
                }
                throw new CoreException("Type '" + type + "' invalid");
            }
            catch (Exception e) {
                try {
                    Charset t = Charset.valueOf((String)type);
                    if (t != null) {
                        return t;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    public static boolean isConnettoriHeaderValidationRequestEnabled(List<Proprieta> proprieta, boolean defaultValue) {
        String isEnabled = CostantiProprieta.readValue(proprieta, CONNETTORE_HEADER_VALIDATION_RICHIESTA_ENABLED);
        if (isEnabled != null && !"".equals(isEnabled)) {
            if ("true".equals(isEnabled.trim())) {
                return true;
            }
            if ("false".equals(isEnabled.trim())) {
                return false;
            }
        }
        return CostantiProprieta.readBooleanValueWithDefault(proprieta, CONNETTORE_HEADER_VALIDATION_ENABLED, defaultValue, "true", "false");
    }

    public static boolean isConnettoriHeaderValidationResponseEnabled(List<Proprieta> proprieta, boolean defaultValue) {
        String isEnabled = CostantiProprieta.readValue(proprieta, CONNETTORE_HEADER_VALIDATION_RISPOSTA_ENABLED);
        if (isEnabled != null && !"".equals(isEnabled)) {
            if ("true".equals(isEnabled.trim())) {
                return true;
            }
            if ("false".equals(isEnabled.trim())) {
                return false;
            }
        }
        return CostantiProprieta.readBooleanValueWithDefault(proprieta, CONNETTORE_HEADER_VALIDATION_ENABLED, defaultValue, "true", "false");
    }

    public static boolean isConnettoriSupportServerSentEventsEnabled(List<Proprieta> proprieta, boolean defaultValue) {
        String isEnabled = CostantiProprieta.readValue(proprieta, CONNETTORE_SERVER_SENT_EVENTS_ENABLED);
        if (isEnabled != null && !"".equals(isEnabled)) {
            if ("true".equals(isEnabled.trim())) {
                return true;
            }
            if ("false".equals(isEnabled.trim())) {
                return false;
            }
        }
        return defaultValue;
    }

    public static Integer getConnettoriConnectionPoolMaxPerRoute(List<Proprieta> proprieta, Integer defaultValue) {
        return CostantiProprieta.readIntegerValueWithDefault(proprieta, CONNETTORE_POOL_CONNECTION_MAX_PER_ROUTE, defaultValue);
    }

    public static Integer getConnettoriConnectionPoolMaxTotal(List<Proprieta> proprieta, Integer defaultValue) {
        return CostantiProprieta.readIntegerValueWithDefault(proprieta, CONNETTORE_POOL_CONNECTION_MAX_TOTAL, defaultValue);
    }

    public static Integer getConnettoriConnectionPoolValidateAfterInactivity(List<Proprieta> proprieta, Integer defaultValue) {
        return CostantiProprieta.readIntegerValueWithDefault(proprieta, CONNETTORE_POOL_CONNECTION_VALIDATE_AFTER_INACTIVITY, defaultValue);
    }

    public static boolean isPeerHeaderDefaultEnabled(List<Proprieta> proprieta) {
        String value = CostantiProprieta.readValue(proprieta, CONNETTORE_PEER_HEADER_ENABLED);
        return value == null || !value.equals(Boolean.FALSE.toString());
    }

    public static List<PeerHeaderDescriptor> getPeerHeaderDescriptors(List<Proprieta> proprieta) {
        ArrayList<PeerHeaderDescriptor> desc = new ArrayList<PeerHeaderDescriptor>();
        for (Proprieta prop : proprieta) {
            String nome = prop.getNome();
            if (!nome.startsWith(CONNETTORE_PEER_HEADER_PREFIX)) continue;
            String valore = prop.getValore();
            String endRegexp = ".regexp";
            if (nome.endsWith(".regexp")) {
                nome = nome.substring(CONNETTORE_PEER_HEADER_PREFIX.length(), nome.length() - ".regexp".length());
                desc.add(new RegexpPeerHeaderDescriptor(nome, valore));
                continue;
            }
            nome = nome.substring(CONNETTORE_PEER_HEADER_PREFIX.length());
            desc.add(new StringPeerHeaderDescriptor(nome, valore));
        }
        return desc;
    }

    public static boolean isConnettoriProxyPassReverseEnabled(List<Proprieta> proprieta, boolean defaultValue) {
        return CostantiProprieta.readBooleanValueWithDefault(proprieta, CONNETTORE_PROXY_PASS_REVERSE_ENABLED, defaultValue, "true", "false");
    }

    public static List<String> getConnettoriProxyPassReverseHeaders(List<Proprieta> proprieta, List<String> defaultValue) {
        return CostantiProprieta.engineGetConnettoriProxyPassReverseHeaders(CONNETTORE_PROXY_PASS_REVERSE_HEADERS, proprieta, defaultValue);
    }

    public static boolean isConnettoriProxyPassReverseSetCookiePathEnabled(List<Proprieta> proprieta, boolean defaultValue) {
        String setCookieEnabled = CostantiProprieta.readValue(proprieta, CONNETTORE_PROXY_PASS_REVERSE_SETCOOKIE_PATH_ENABLED);
        if (setCookieEnabled != null && !"".equals(setCookieEnabled)) {
            if ("true".equals(setCookieEnabled.trim())) {
                return true;
            }
            if ("false".equals(setCookieEnabled.trim())) {
                return false;
            }
        }
        return CostantiProprieta.readBooleanValueWithDefault(proprieta, CONNETTORE_PROXY_PASS_REVERSE_SETCOOKIE_ENABLED, defaultValue, "true", "false");
    }

    public static boolean isConnettoriProxyPassReverseSetCookieDomainEnabled(List<Proprieta> proprieta, boolean defaultValue) {
        String setCookieEnabled = CostantiProprieta.readValue(proprieta, CONNETTORE_PROXY_PASS_REVERSE_SETCOOKIE_DOMAIN_ENABLED);
        if (setCookieEnabled != null && !"".equals(setCookieEnabled)) {
            if ("true".equals(setCookieEnabled.trim())) {
                return true;
            }
            if ("false".equals(setCookieEnabled.trim())) {
                return false;
            }
        }
        return CostantiProprieta.readBooleanValueWithDefault(proprieta, CONNETTORE_PROXY_PASS_REVERSE_SETCOOKIE_ENABLED, defaultValue, "true", "false");
    }

    public static List<String> getConnettoriProxyPassReverseSetCookieHeaders(List<Proprieta> proprieta, List<String> defaultValue) {
        return CostantiProprieta.engineGetConnettoriProxyPassReverseHeaders(CONNETTORE_PROXY_PASS_REVERSE_SETCOOKIE_HEADERS, proprieta, defaultValue);
    }

    public static boolean isConnettoriProxyPassReverseUseProtocolPrefix(List<Proprieta> proprieta, boolean defaultValue) {
        return CostantiProprieta.readBooleanValueWithDefault(proprieta, CONNETTORE_PROXY_PASS_REVERSE_USE_PROTOCOL_PREFIX, defaultValue, "true", "false");
    }

    private static List<String> engineGetConnettoriProxyPassReverseHeaders(String pName, List<Proprieta> proprieta, List<String> defaultValue) {
        String v = CostantiProprieta.readValue(proprieta, pName);
        if (v == null || StringUtils.isEmpty((CharSequence)v)) {
            return defaultValue;
        }
        ArrayList<String> l = new ArrayList<String>();
        if (v.contains(",")) {
            String[] tmp = v.split(",");
            for (int i = 0; i < tmp.length; ++i) {
                l.add(tmp[i].trim());
            }
        } else {
            l.add(v);
        }
        return l;
    }

    public static boolean isConnettoriHttpsEndpointJvmConfigOverrideEnabled(List<Proprieta> proprieta, boolean defaultValue) {
        return CostantiProprieta.readBooleanValueWithDefault(proprieta, CONNETTORE_HTTPS_ENDPOINT_JVM_CONFIG_OVERRIDE_ENABLED, defaultValue, "true", "false");
    }

    public static String getConnettoriHttpsEndpointJvmConfigOverrideRepository(List<Proprieta> proprieta, String defaultValue) {
        String v = CostantiProprieta.readValue(proprieta, CONNETTORE_HTTPS_ENDPOINT_JVM_CONFIG_OVERRIDE_REPOSITORY);
        if (v == null || StringUtils.isEmpty((CharSequence)v)) {
            return defaultValue;
        }
        return v;
    }

    public static String getConnettoriHttpsEndpointJvmConfigOverrideConfig(List<Proprieta> proprieta, String defaultValue) {
        String v = CostantiProprieta.readValue(proprieta, CONNETTORE_HTTPS_ENDPOINT_JVM_CONFIG_OVERRIDE_CONFIG);
        if (v == null || StringUtils.isEmpty((CharSequence)v)) {
            return defaultValue;
        }
        return v;
    }

    public static HttpLibrary getConnettoreHttpLibrary(List<Proprieta> props, String type) {
        String name = CostantiProprieta.readValue(props, type);
        if (name == null || StringUtils.isEmpty((CharSequence)name)) {
            return HttpLibraryConnection.getDefaultLibrary();
        }
        return HttpLibrary.fromName((String)name);
    }

    public static List<String> getRegistrazioneMessaggiWhiteList(List<Proprieta> proprieta) {
        return CostantiProprieta.getRegistrazioneMessaggiLista(proprieta, REGISTRAZIONE_MESSAGGI_WHITE_LIST);
    }

    public static List<String> getRegistrazioneMessaggiBlackList(List<Proprieta> proprieta) {
        return CostantiProprieta.getRegistrazioneMessaggiLista(proprieta, REGISTRAZIONE_MESSAGGI_BLACK_LIST);
    }

    public static List<String> getRegistrazioneMessaggiRichiestaIngressoWhiteList(List<Proprieta> proprieta) {
        return CostantiProprieta.getRegistrazioneMessaggiLista(proprieta, REGISTRAZIONE_MESSAGGI_RICHIESTA_INGRESSO_WHITE_LIST);
    }

    public static List<String> getRegistrazioneMessaggiRichiestaIngressoBlackList(List<Proprieta> proprieta) {
        return CostantiProprieta.getRegistrazioneMessaggiLista(proprieta, REGISTRAZIONE_MESSAGGI_RICHIESTA_INGRESSO_BLACK_LIST);
    }

    public static List<String> getRegistrazioneMessaggiRichiestaUscitaWhiteList(List<Proprieta> proprieta) {
        return CostantiProprieta.getRegistrazioneMessaggiLista(proprieta, REGISTRAZIONE_MESSAGGI_RICHIESTA_USCITA_WHITE_LIST);
    }

    public static List<String> getRegistrazioneMessaggiRichiestaUscitaBlackList(List<Proprieta> proprieta) {
        return CostantiProprieta.getRegistrazioneMessaggiLista(proprieta, REGISTRAZIONE_MESSAGGI_RICHIESTA_USCITA_BLACK_LIST);
    }

    public static List<String> getRegistrazioneMessaggiRispostaIngressoWhiteList(List<Proprieta> proprieta) {
        return CostantiProprieta.getRegistrazioneMessaggiLista(proprieta, REGISTRAZIONE_MESSAGGI_RISPOSTA_INGRESSO_WHITE_LIST);
    }

    public static List<String> getRegistrazioneMessaggiRispostaIngressoBlackList(List<Proprieta> proprieta) {
        return CostantiProprieta.getRegistrazioneMessaggiLista(proprieta, REGISTRAZIONE_MESSAGGI_RISPOSTA_INGRESSO_BLACK_LIST);
    }

    public static List<String> getRegistrazioneMessaggiRispostaUscitaWhiteList(List<Proprieta> proprieta) {
        return CostantiProprieta.getRegistrazioneMessaggiLista(proprieta, REGISTRAZIONE_MESSAGGI_RISPOSTA_USCITA_WHITE_LIST);
    }

    public static List<String> getRegistrazioneMessaggiRispostaUscitaBlackList(List<Proprieta> proprieta) {
        return CostantiProprieta.getRegistrazioneMessaggiLista(proprieta, REGISTRAZIONE_MESSAGGI_RISPOSTA_USCITA_BLACK_LIST);
    }

    private static List<String> getRegistrazioneMessaggiLista(List<Proprieta> proprieta, String propertyName) {
        ArrayList<String> l = new ArrayList<String>();
        String v = CostantiProprieta.readValue(proprieta, propertyName);
        if (v == null || StringUtils.isEmpty((CharSequence)v)) {
            return l;
        }
        CostantiProprieta.initList(l, v);
        return l;
    }

    public static boolean isFileTraceEnabled(List<Proprieta> proprieta, boolean defaultValue) {
        return CostantiProprieta.readBooleanValueWithDefault(proprieta, FILE_TRACE_ENABLED, defaultValue, "true", "false");
    }

    public static boolean isFileTraceDumpBinarioPayloadEnabled(List<Proprieta> proprieta, boolean defaultValue) {
        String fileTraceEnabled = CostantiProprieta.readValue(proprieta, FILE_TRACE_DUMP_BINARIO_PAYLOAD_ENABLED);
        if (fileTraceEnabled != null && !"".equals(fileTraceEnabled)) {
            if ("true".equals(fileTraceEnabled.trim())) {
                return true;
            }
            if ("false".equals(fileTraceEnabled.trim())) {
                return false;
            }
        }
        return CostantiProprieta.readBooleanValueWithDefault(proprieta, FILE_TRACE_DUMP_BINARIO_ENABLED, defaultValue, "true", "false");
    }

    public static boolean isFileTraceDumpBinarioHeadersEnabled(List<Proprieta> proprieta, boolean defaultValue) {
        String fileTraceEnabled = CostantiProprieta.readValue(proprieta, FILE_TRACE_DUMP_BINARIO_HEADERS_ENABLED);
        if (fileTraceEnabled != null && !"".equals(fileTraceEnabled)) {
            if ("true".equals(fileTraceEnabled.trim())) {
                return true;
            }
            if ("false".equals(fileTraceEnabled.trim())) {
                return false;
            }
        }
        return CostantiProprieta.readBooleanValueWithDefault(proprieta, FILE_TRACE_DUMP_BINARIO_ENABLED, defaultValue, "true", "false");
    }

    public static boolean isFileTraceDumpBinarioConnettorePayloadEnabled(List<Proprieta> proprieta, boolean defaultValue) {
        String fileTraceEnabled = CostantiProprieta.readValue(proprieta, FILE_TRACE_DUMP_BINARIO_CONNETTORE_PAYLOAD_ENABLED);
        if (fileTraceEnabled != null && !"".equals(fileTraceEnabled)) {
            if ("true".equals(fileTraceEnabled.trim())) {
                return true;
            }
            if ("false".equals(fileTraceEnabled.trim())) {
                return false;
            }
        }
        return CostantiProprieta.readBooleanValueWithDefault(proprieta, FILE_TRACE_DUMP_BINARIO_CONNETTORE_ENABLED, defaultValue, "true", "false");
    }

    public static boolean isFileTraceDumpBinarioConnettoreHeadersEnabled(List<Proprieta> proprieta, boolean defaultValue) {
        String fileTraceEnabled = CostantiProprieta.readValue(proprieta, FILE_TRACE_DUMP_BINARIO_CONNETTORE_HEADERS_ENABLED);
        if (fileTraceEnabled != null && !"".equals(fileTraceEnabled)) {
            if ("true".equals(fileTraceEnabled.trim())) {
                return true;
            }
            if ("false".equals(fileTraceEnabled.trim())) {
                return false;
            }
        }
        return CostantiProprieta.readBooleanValueWithDefault(proprieta, FILE_TRACE_DUMP_BINARIO_CONNETTORE_ENABLED, defaultValue, "true", "false");
    }

    public static File getFileTraceConfig(List<Proprieta> proprieta, File defaultValue) throws CoreException {
        String rootDir;
        String v = CostantiProprieta.readValue(proprieta, FILE_TRACE_CONFIG);
        if (v == null || StringUtils.isEmpty((CharSequence)v)) {
            return defaultValue;
        }
        File getTransazioniFileTraceConfig = new File(v);
        if (!getTransazioniFileTraceConfig.exists() && (rootDir = OpenSPCoop2Properties.getInstance().getRootDirectory()) != null && !"".equals(rootDir)) {
            getTransazioniFileTraceConfig = new File(rootDir, v);
        }
        CostantiProprieta.checkFile(getTransazioniFileTraceConfig);
        return getTransazioniFileTraceConfig;
    }

    public static boolean isFiltroDuplicatiTestEnabled(List<Proprieta> proprieta, boolean defaultValue) {
        return CostantiProprieta.readBooleanValueWithDefault(proprieta, FILTRO_DUPLICATI_TEST, defaultValue, "true", "false");
    }

    public static boolean isInformazioniIntegrazioneEnabled(List<Proprieta> proprieta, boolean defaultValue) {
        return CostantiProprieta.readBooleanValueWithDefault(proprieta, INFORMAZIONI_INTEGRAZIONE_ENABLED, defaultValue, "true", "false");
    }

    public static InformazioniIntegrazioneSorgente getTipoInformazioniIntegrazione(List<Proprieta> proprieta, InformazioniIntegrazioneSorgente defaultValue) throws CoreException {
        String valueS = CostantiProprieta.readValue(proprieta, INFORMAZIONI_INTEGRAZIONE_TYPE);
        if (valueS != null && !StringUtils.isEmpty((CharSequence)valueS)) {
            try {
                return InformazioniIntegrazioneSorgente.valueOf(valueS);
            }
            catch (Exception t) {
                throw CostantiProprieta.newTipoInformazioniIntegrazioneException(valueS);
            }
        }
        return defaultValue;
    }

    private static CoreException newTipoInformazioniIntegrazioneException(String valueS) {
        InformazioniIntegrazioneSorgente[] s = InformazioniIntegrazioneSorgente.values();
        StringBuilder sb = new StringBuilder();
        if (s != null) {
            for (InformazioniIntegrazioneSorgente informazioniIntegrazioneSorgente : s) {
                if (!sb.isEmpty()) {
                    sb.append(", ");
                }
                sb.append((Object)informazioniIntegrazioneSorgente);
            }
        }
        return CostantiProprieta.newCoreException(valueS, INFORMAZIONI_INTEGRAZIONE_TYPE, sb.toString());
    }

    public static String getNomeSorgenteInformazioniIntegrazione(List<Proprieta> proprieta, String defaultValue) {
        String valueS = CostantiProprieta.readValue(proprieta, INFORMAZIONI_INTEGRAZIONE_NAME);
        if (valueS != null && !StringUtils.isEmpty((CharSequence)valueS)) {
            return valueS;
        }
        return defaultValue;
    }

    public static InformazioniIntegrazioneCodifica getTipoCodificaInformazioniIntegrazione(List<Proprieta> proprieta, InformazioniIntegrazioneCodifica defaultValue) throws CoreException {
        String valueS = CostantiProprieta.readValue(proprieta, INFORMAZIONI_INTEGRAZIONE_ENCODE);
        if (valueS != null && !StringUtils.isEmpty((CharSequence)valueS)) {
            try {
                return InformazioniIntegrazioneCodifica.valueOf(valueS);
            }
            catch (Exception t) {
                throw CostantiProprieta.newTipoCodificaInformazioniIntegrazioneException(valueS);
            }
        }
        return defaultValue;
    }

    private static CoreException newTipoCodificaInformazioniIntegrazioneException(String valueS) {
        InformazioniIntegrazioneCodifica[] s = InformazioniIntegrazioneCodifica.values();
        StringBuilder sb = new StringBuilder();
        if (s != null) {
            for (InformazioniIntegrazioneCodifica informazioniIntegrazioneCodifica : s) {
                if (!sb.isEmpty()) {
                    sb.append(", ");
                }
                sb.append((Object)informazioniIntegrazioneCodifica);
            }
        }
        return CostantiProprieta.newCoreException(valueS, INFORMAZIONI_INTEGRAZIONE_ENCODE, sb.toString());
    }

    public static boolean isInformazioniIntegrazioneRequired(List<Proprieta> proprieta, boolean defaultValue) {
        return CostantiProprieta.readBooleanValueWithDefault(proprieta, INFORMAZIONI_INTEGRAZIONE_REQUIRED, defaultValue, "true", "false");
    }

    public static boolean isInformazioniIntegrazioneRispostaEnabled(List<Proprieta> proprieta, boolean defaultValue) {
        return CostantiProprieta.readBooleanValueWithDefault(proprieta, INFORMAZIONI_INTEGRAZIONE_RISPOSTA_ENABLED, defaultValue, "true", "false");
    }

    public static String getNomeSorgenteInformazioniIntegrazioneRisposta(List<Proprieta> proprieta, String defaultValue) {
        String valueS = CostantiProprieta.readValue(proprieta, INFORMAZIONI_INTEGRAZIONE_RISPOSTA_NAME);
        if (valueS != null && !StringUtils.isEmpty((CharSequence)valueS)) {
            return valueS;
        }
        return defaultValue;
    }

    public static InformazioniIntegrazioneCodifica getTipoCodificaInformazioniIntegrazioneRisposta(List<Proprieta> proprieta, InformazioniIntegrazioneCodifica defaultValue) throws CoreException {
        String valueS = CostantiProprieta.readValue(proprieta, INFORMAZIONI_INTEGRAZIONE_RISPOSTA_ENCODE);
        if (valueS != null && !StringUtils.isEmpty((CharSequence)valueS)) {
            try {
                return InformazioniIntegrazioneCodifica.valueOf(valueS);
            }
            catch (Exception t) {
                throw CostantiProprieta.newTipoCodificaInformazioniIntegrazioneRispostaException(valueS);
            }
        }
        return defaultValue;
    }

    private static CoreException newTipoCodificaInformazioniIntegrazioneRispostaException(String valueS) {
        InformazioniIntegrazioneCodifica[] s = InformazioniIntegrazioneCodifica.values();
        StringBuilder sb = new StringBuilder();
        if (s != null) {
            for (InformazioniIntegrazioneCodifica informazioniIntegrazioneCodifica : s) {
                if (!sb.isEmpty()) {
                    sb.append(", ");
                }
                sb.append((Object)informazioniIntegrazioneCodifica);
            }
        }
        return CostantiProprieta.newCoreException(valueS, INFORMAZIONI_INTEGRAZIONE_RISPOSTA_ENCODE, sb.toString());
    }

    public static boolean isInformazioniIntegrazioneRispostaRequired(List<Proprieta> proprieta, boolean defaultValue) {
        return CostantiProprieta.readBooleanValueWithDefault(proprieta, INFORMAZIONI_INTEGRAZIONE_RISPOSTA_REQUIRED, defaultValue, "true", "false");
    }

    public static boolean isSecurityHeadersEnabled(List<Proprieta> proprieta, boolean defaultValue) {
        return CostantiProprieta.readBooleanValueWithDefault(proprieta, SECURITY_HEADERS_ENABLED, defaultValue, "true", "false");
    }

    public static Map<String, String> getSecurityHeaders(List<Proprieta> proprieta, Properties defaultConfig) {
        HashMap<String, String> p = new HashMap<String, String>();
        boolean useDefault = CostantiProprieta.readBooleanValueWithDefault(proprieta, SECURITY_HEADERS_DEFAULT_ENABLED, true, "true", "false");
        if (useDefault) {
            for (Object oKey : defaultConfig.keySet()) {
                if (!(oKey instanceof String)) continue;
                String key = (String)oKey;
                String value = defaultConfig.getProperty(key);
                if (!StringUtils.isNotEmpty((CharSequence)key) || value == null || !StringUtils.isNotEmpty((CharSequence)value)) continue;
                p.put(key, value);
            }
        }
        CostantiProprieta.fillSecurityHeaders(p, proprieta);
        return p;
    }

    private static void fillSecurityHeaders(Map<String, String> p, List<Proprieta> proprieta) {
        String[] tmp;
        String pLista = CostantiProprieta.readValue(proprieta, SECURITY_HEADERS_LIST);
        if (pLista != null && StringUtils.isNotEmpty((CharSequence)pLista) && (tmp = pLista.split(",")) != null && tmp.length > 0) {
            for (String key : tmp) {
                CostantiProprieta.addSecurityHeader(p, key, proprieta);
            }
        }
    }

    private static void addSecurityHeader(Map<String, String> p, String key, List<Proprieta> proprieta) {
        String pName;
        String value;
        if (key != null && StringUtils.isNotEmpty((CharSequence)(key = key.trim())) && (value = CostantiProprieta.readValue(proprieta, pName = SECURITY_HEADERS_PREFIX + key)) != null) {
            value = value.trim();
            p.put(key, value);
        }
    }

    public static boolean isRateLimitingUseHttpContentLength(List<Proprieta> proprieta, boolean defaultValue) {
        return CostantiProprieta.readBooleanValueWithDefault(proprieta, RATE_LIMITING_USE_HTTP_CONTENT_LENGTH, defaultValue, "true", "false");
    }

    public static boolean isRateLimitingUseHttpContentLengthAcceptZeroValue(List<Proprieta> proprieta, boolean defaultValue) {
        return CostantiProprieta.readBooleanValueWithDefault(proprieta, RATE_LIMITING_USE_HTTP_CONTENT_LENGTH_ACCEPT_ZERO_VALUE, defaultValue, "true", "false");
    }

    public static boolean isModIAuditTraceEnabled(List<Proprieta> proprieta, String claim, boolean defaultValue) {
        String p = MODI_AUDIT_CLAIM_PREFIX + claim + MODI_AUDIT_SUFFIX_TRACE_ENABLED;
        return CostantiProprieta.readBooleanValueWithDefault(proprieta, p, defaultValue, "true", "false");
    }

    public static boolean isModIAuditForwardBackendEnabled(List<Proprieta> proprieta, String claim, boolean defaultValue) {
        String p = MODI_AUDIT_CLAIM_PREFIX + claim + MODI_AUDIT_SUFFIX_FORWARD_BACKEND_ENABLED;
        return CostantiProprieta.readBooleanValueWithDefault(proprieta, p, defaultValue, "true", "false");
    }

    public static String getModIAuditForwardBackend(List<Proprieta> proprieta, String claim, String defaultValue) {
        String p = MODI_AUDIT_CLAIM_PREFIX + claim + MODI_AUDIT_SUFFIX_FORWARD_BACKEND;
        String valueS = CostantiProprieta.readValue(proprieta, p);
        if (valueS != null && !StringUtils.isEmpty((CharSequence)valueS)) {
            return valueS;
        }
        return defaultValue;
    }

    public static boolean isModITraceJtiSourceAuthorization(List<Proprieta> proprieta, boolean defaultValue) {
        String p = MODI_TRACE_JTI_SOURCE;
        String valueS = CostantiProprieta.readValue(proprieta, p);
        if (valueS != null && !StringUtils.isEmpty((CharSequence)valueS)) {
            return valueS.equalsIgnoreCase(MODI_TRACE_JTI_SOURCE_VALUE_AUTHORIZATION);
        }
        return defaultValue;
    }

    public static boolean isModITraceJtiSourceIntegrity(List<Proprieta> proprieta, boolean defaultValue) {
        String p = MODI_TRACE_JTI_SOURCE;
        String valueS = CostantiProprieta.readValue(proprieta, p);
        if (valueS != null && !StringUtils.isEmpty((CharSequence)valueS)) {
            return valueS.equalsIgnoreCase(MODI_TRACE_JTI_SOURCE_VALUE_INTEGRITY);
        }
        return defaultValue;
    }

    public static boolean isPdndReadByApiInteropOrganizationFailedAbortTransaction(List<Proprieta> proprieta, boolean defaultValue) {
        String p = PDND_ABORT_TRANSACTION_ORGANIZATION_READ_ERROR;
        String valueS = CostantiProprieta.readValue(proprieta, p);
        if (valueS != null && !StringUtils.isEmpty((CharSequence)valueS)) {
            return valueS.equalsIgnoreCase("true");
        }
        return defaultValue;
    }

    public static boolean isPdndReadByApiInteropClientFailedAbortTransaction(List<Proprieta> proprieta, boolean defaultValue) {
        String p = PDND_ABORT_TRANSACTION_CLIENT_READ_ERROR;
        String valueS = CostantiProprieta.readValue(proprieta, p);
        if (valueS != null && !StringUtils.isEmpty((CharSequence)valueS)) {
            return valueS.equalsIgnoreCase("true");
        }
        return defaultValue;
    }

    public static boolean isPdndRateLimitingByOrganizationInfoNotAvailableAbortTransaction(List<Proprieta> proprieta, boolean defaultValue) {
        String p = PDND_ABORT_TRANSACTION_ORGANIZATION_NOT_AVAILABLE_RATE_LIMITING;
        String valueS = CostantiProprieta.readValue(proprieta, p);
        if (valueS != null && !StringUtils.isEmpty((CharSequence)valueS)) {
            return valueS.equalsIgnoreCase("true");
        }
        return defaultValue;
    }

    public static String getPdndSignalHubNamespace(List<Proprieta> props, String defaultValue) {
        String p = PDND_SIGNAL_HUB_NAMESPACE;
        String valueS = CostantiProprieta.readValue(props, p);
        return Objects.requireNonNullElse(valueS, defaultValue);
    }

    private static CoreException newCoreException(String valueS, String property, String supportedValues) {
        return new CoreException("Uncorrect value '" + valueS + "' for property '" + property + "' (Supported values: " + supportedValues + ")");
    }

    private static String readValue(List<Proprieta> proprieta, String nome) {
        if (proprieta == null || proprieta.isEmpty()) {
            return null;
        }
        for (Proprieta proprietaCheck : proprieta) {
            if (!nome.equalsIgnoreCase(proprietaCheck.getNome())) continue;
            return proprietaCheck.getValore() != null ? proprietaCheck.getValore().trim() : null;
        }
        return null;
    }

    private static boolean readBooleanValueWithDefault(List<Proprieta> proprieta, String nome, boolean defaultValue, String trueValue, String falseValue) {
        String valueS = CostantiProprieta.readValue(proprieta, nome);
        if (valueS != null && !StringUtils.isEmpty((CharSequence)valueS)) {
            if (trueValue.equals(valueS.trim())) {
                return true;
            }
            if (falseValue.equals(valueS.trim())) {
                return false;
            }
        }
        return defaultValue;
    }

    private static int readIntValueWithDefault(List<Proprieta> proprieta, String nome, int defaultValue) {
        String valueS = CostantiProprieta.readValue(proprieta, nome);
        if (valueS != null && !StringUtils.isEmpty((CharSequence)valueS)) {
            try {
                return Integer.valueOf(valueS);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    private static Integer readIntegerValueWithDefault(List<Proprieta> proprieta, String nome, Integer defaultValue) {
        String valueS = CostantiProprieta.readValue(proprieta, nome);
        if (valueS != null && !StringUtils.isEmpty((CharSequence)valueS)) {
            try {
                return Integer.valueOf(valueS);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    private static void initList(List<String> list, String tmp) {
        if (tmp != null && !"".equals(tmp.trim())) {
            if ((tmp = tmp.trim()).contains(",")) {
                String[] split = tmp.split(",");
                CostantiProprieta.initList(list, split);
            } else {
                list.add(tmp);
            }
        }
    }

    private static void initList(List<String> list, String[] split) {
        if (split != null && split.length > 0) {
            for (String s : split) {
                if (s == null || "".equals(s = s.trim())) continue;
                list.add(s);
            }
        }
    }

    public static void checkFile(File file) throws CoreException {
        CostantiProprieta.checkFileEngine(file, false);
    }

    public static void checkDir(File file) throws CoreException {
        CostantiProprieta.checkFileEngine(file, true);
    }

    private static void checkFileEngine(File file, boolean expectedDir) throws CoreException {
        String prefix = "Config file [" + file.getAbsolutePath() + "] ";
        if (!file.exists()) {
            throw new CoreException(prefix + "not exists");
        }
        if (expectedDir) {
            if (!file.isDirectory()) {
                throw new CoreException(prefix + "isn't directory");
            }
        } else if (file.isDirectory()) {
            throw new CoreException(prefix + "is directory");
        }
        if (!file.canRead()) {
            throw new CoreException(prefix + "cannot read");
        }
    }
}

