/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.config;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import org.openspcoop2.core.allarmi.Allarme;
import org.openspcoop2.core.allarmi.AllarmeParametro;
import org.openspcoop2.core.allarmi.IdAllarme;
import org.openspcoop2.core.allarmi.constants.RuoloPorta;
import org.openspcoop2.core.allarmi.constants.StatoAllarme;
import org.openspcoop2.core.allarmi.dao.IAllarmeServiceSearch;
import org.openspcoop2.core.allarmi.utils.AllarmiConverterUtils;
import org.openspcoop2.core.allarmi.utils.FiltroRicercaAllarmi;
import org.openspcoop2.core.allarmi.utils.ProjectInfo;
import org.openspcoop2.core.commons.dao.DAOFactory;
import org.openspcoop2.core.config.driver.DriverConfigurazioneException;
import org.openspcoop2.core.config.driver.DriverConfigurazioneNotFound;
import org.openspcoop2.core.config.driver.db.DriverConfigurazioneDB;
import org.openspcoop2.core.plugins.dao.IServiceManager;
import org.openspcoop2.generic_project.beans.IProjectInfo;
import org.openspcoop2.generic_project.exception.NotFoundException;
import org.openspcoop2.generic_project.expression.IPaginatedExpression;
import org.openspcoop2.generic_project.expression.LikeMode;
import org.openspcoop2.generic_project.expression.SortOrder;
import org.openspcoop2.generic_project.utils.ServiceManagerProperties;
import org.openspcoop2.monitor.engine.alarm.AlarmImpl;
import org.openspcoop2.monitor.engine.alarm.AlarmManager;
import org.openspcoop2.monitor.sdk.alarm.AlarmStatus;
import org.openspcoop2.monitor.sdk.alarm.IAlarm;
import org.openspcoop2.pdd.config.AbstractConfigurazionePdDConnectionResourceManager;
import org.openspcoop2.pdd.config.ConfigurazionePdDConnectionResource;
import org.openspcoop2.pdd.config.OpenSPCoop2Properties;
import org.openspcoop2.pdd.logger.OpenSPCoop2Logger;
import org.slf4j.Logger;

public class ConfigurazionePdD_allarmi
extends AbstractConfigurazionePdDConnectionResourceManager {
    private ServiceManagerProperties smp = new ServiceManagerProperties();

    public ConfigurazionePdD_allarmi(OpenSPCoop2Properties openspcoopProperties, DriverConfigurazioneDB driver, boolean useConnectionPdD) {
        super(openspcoopProperties, driver, useConnectionPdD, OpenSPCoop2Logger.getLoggerOpenSPCoopAllarmiSql(openspcoopProperties.isAllarmiDebug()));
        this.smp.setShowSql(this.openspcoopProperties.isAllarmiDebug());
        this.smp.setDatabaseType(this.driver.getTipoDB());
    }

    public Allarme getAllarme(Connection connectionPdD, String nomeAllarme) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        Allarme allarme = null;
        ConfigurazionePdDConnectionResource cr = null;
        try {
            cr = this.getConnection(connectionPdD, "Allarmi.searchAllarmi");
            org.openspcoop2.core.allarmi.dao.IServiceManager sm = (org.openspcoop2.core.allarmi.dao.IServiceManager)DAOFactory.getInstance((Logger)this.log).getServiceManager((IProjectInfo)ProjectInfo.getInstance(), cr.connectionDB, this.smp, this.log);
            IdAllarme id = new IdAllarme();
            id.setNome(nomeAllarme);
            allarme = (Allarme)sm.getAllarmeServiceSearch().get((Object)id);
        }
        catch (NotFoundException e) {
            String errorMsg = "Allarme '" + nomeAllarme + "' non trovato";
            this.log.debug(errorMsg, (Throwable)e);
            throw new DriverConfigurazioneNotFound(errorMsg, (Throwable)e);
        }
        catch (Exception e) {
            String errorMsg = "Errore durante la ricerca dell'allarme '" + nomeAllarme + "': " + e.getMessage();
            this.log.error(errorMsg, (Throwable)e);
            throw new DriverConfigurazioneException(errorMsg, (Throwable)e);
        }
        finally {
            this.releaseConnection(cr);
        }
        if (allarme != null) {
            return allarme;
        }
        throw new DriverConfigurazioneNotFound("Allarme '" + nomeAllarme + "' non trovato");
    }

    public List<Allarme> searchAllarmi(Connection connectionPdD, FiltroRicercaAllarmi filtroRicerca) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        ArrayList<Allarme> list = new ArrayList<Allarme>();
        ConfigurazionePdDConnectionResource cr = null;
        try {
            List l;
            cr = this.getConnection(connectionPdD, "Allarmi.searchAllarmi");
            org.openspcoop2.core.allarmi.dao.IServiceManager sm = (org.openspcoop2.core.allarmi.dao.IServiceManager)DAOFactory.getInstance((Logger)this.log).getServiceManager((IProjectInfo)ProjectInfo.getInstance(), cr.connectionDB, this.smp, this.log);
            String tipo = filtroRicerca.getTipo();
            if (tipo == null || "".equals(tipo)) {
                throw new Exception("Tipo allarme non fornito");
            }
            String idParametroCluster = filtroRicerca.getIdParametroCluster();
            String idCluster = filtroRicerca.getIdCluster();
            boolean idClusterOpzionale = filtroRicerca.isIdClusterOpzionale();
            String idParametro = filtroRicerca.getIdParametro();
            String valoreParametro = filtroRicerca.getValoreParametro();
            boolean recuperaSoloAllarmiInStatoDiversoDaOk = filtroRicerca.isRecuperaSoloAllarmiInStatoDiversoDaOk();
            Boolean globale = filtroRicerca.getGlobale();
            RuoloPorta ruoloPorta = null;
            String nomePorta = null;
            if (globale != null && !globale.booleanValue()) {
                ruoloPorta = filtroRicerca.getRuoloPorta();
                nomePorta = filtroRicerca.getNomePorta();
            }
            IAllarmeServiceSearch allarmeServiceSearch = sm.getAllarmeServiceSearch();
            IPaginatedExpression expr = allarmeServiceSearch.newPaginatedExpression();
            expr.limit(1000);
            expr.addOrder(Allarme.model().NOME, SortOrder.ASC);
            expr.and();
            expr.equals(Allarme.model().TIPO, (Object)tipo);
            expr.equals(Allarme.model().ENABLED, (Object)1);
            if (globale != null) {
                if (globale.booleanValue()) {
                    expr.isNull(Allarme.model().FILTRO.NOME_PORTA);
                } else {
                    expr.equals(Allarme.model().FILTRO.RUOLO_PORTA, (Object)ruoloPorta.getValue()).and().equals(Allarme.model().FILTRO.NOME_PORTA, (Object)nomePorta);
                }
            }
            if (recuperaSoloAllarmiInStatoDiversoDaOk) {
                expr.notEquals(Allarme.model().STATO, (Object)AllarmiConverterUtils.toIntegerValue((StatoAllarme)StatoAllarme.OK));
            }
            if (idParametro != null) {
                expr.equals(Allarme.model().ALLARME_PARAMETRO.ID_PARAMETRO, (Object)idParametro);
                if (valoreParametro != null) {
                    expr.like(Allarme.model().ALLARME_PARAMETRO.VALORE, valoreParametro, LikeMode.EXACT);
                } else {
                    expr.isNull(Allarme.model().ALLARME_PARAMETRO.VALORE);
                }
            }
            if ((l = allarmeServiceSearch.findAll(expr)) != null && l.size() > 0) {
                for (Allarme configurazioneAllarme : l) {
                    boolean add = true;
                    if (idParametroCluster != null) {
                        for (AllarmeParametro configurazioneAllarmeParametro : configurazioneAllarme.getAllarmeParametroList()) {
                            if (!idParametroCluster.equals(configurazioneAllarmeParametro.getIdParametro())) continue;
                            if (idCluster != null) {
                                if (idCluster.equals(configurazioneAllarmeParametro.getValore())) break;
                                if (idClusterOpzionale) {
                                    if (configurazioneAllarmeParametro.getValore() == null || "".equals(configurazioneAllarmeParametro.getValore()) || "-".equals(configurazioneAllarmeParametro.getValore())) break;
                                    add = false;
                                    break;
                                }
                                add = false;
                                break;
                            }
                            if (idClusterOpzionale) {
                                if (configurazioneAllarmeParametro.getValore() == null || "".equals(configurazioneAllarmeParametro.getValore()) || "-".equals(configurazioneAllarmeParametro.getValore())) break;
                                add = false;
                                break;
                            }
                            add = false;
                            break;
                        }
                    }
                    if (!add) continue;
                    list.add(configurazioneAllarme);
                }
            }
        }
        catch (Exception e) {
            String errorMsg = "Errore durante la ricerca degli allarmi: " + e.getMessage();
            this.log.error(errorMsg, (Throwable)e);
            throw new DriverConfigurazioneException(errorMsg, (Throwable)e);
        }
        finally {
            this.releaseConnection(cr);
        }
        if (list != null && !list.isEmpty()) {
            return list;
        }
        throw new DriverConfigurazioneNotFound("Allarmi non trovati");
    }

    public List<IAlarm> instanceAllarmi(Connection connectionPdD, List<Allarme> listAllarmi) throws DriverConfigurazioneException {
        ConfigurazionePdDConnectionResource cr = null;
        try {
            cr = this.getConnection(connectionPdD, "Allarmi.instanceAllarmi");
            DAOFactory daoFactory = DAOFactory.getInstance((Logger)this.log);
            IServiceManager smPlugins = (IServiceManager)daoFactory.getServiceManager((IProjectInfo)org.openspcoop2.core.plugins.utils.ProjectInfo.getInstance(), cr.connectionDB, this.smp, this.log);
            if (listAllarmi == null || listAllarmi.isEmpty()) {
                throw new Exception("Non sono stati forniti allarmi da istanziare");
            }
            ArrayList<IAlarm> list = new ArrayList<IAlarm>();
            for (Allarme allarme : listAllarmi) {
                list.add(AlarmManager.getAlarm((Allarme)allarme, (Logger)this.log, (DAOFactory)daoFactory, (IServiceManager)smPlugins));
            }
            ArrayList<IAlarm> arrayList = list;
            return arrayList;
        }
        catch (Exception e) {
            String errorMsg = "Errore durante l'istanziazione degli allarmi: " + e.getMessage();
            this.log.error(errorMsg, (Throwable)e);
            throw new DriverConfigurazioneException(errorMsg, (Throwable)e);
        }
        finally {
            this.releaseConnection(cr);
        }
    }

    public boolean changeStatus(Connection connectionPdD, AlarmImpl alarm, AlarmStatus nuovoStatoAllarme) throws DriverConfigurazioneException {
        return this._changeStatus(connectionPdD, (IAlarm)alarm, nuovoStatoAllarme);
    }

    public boolean changeStatus(Connection connectionPdD, IAlarm alarm, AlarmStatus nuovoStatoAllarme) throws DriverConfigurazioneException {
        return this._changeStatus(connectionPdD, alarm, nuovoStatoAllarme);
    }

    private boolean _changeStatus(Connection connectionPdD, IAlarm alarm, AlarmStatus nuovoStatoAllarme) throws DriverConfigurazioneException {
        ConfigurazionePdDConnectionResource cr = null;
        try {
            cr = this.getConnection(connectionPdD, "Allarmi.changeStato");
            if (alarm instanceof AlarmImpl) {
                ((AlarmImpl)alarm).changeStatus(this.log, cr.connectionDB, this.smp, nuovoStatoAllarme);
            } else {
                alarm.changeStatus(nuovoStatoAllarme);
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            String errorMsg = "Errore durante update stato degli allarmi: " + e.getMessage();
            this.log.error(errorMsg, (Throwable)e);
            throw new DriverConfigurazioneException(errorMsg, (Throwable)e);
        }
        finally {
            this.releaseConnection(cr);
        }
    }
}

