/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.protocol.engine.validator;

import java.util.List;
import org.openspcoop2.message.OpenSPCoop2Message;
import org.openspcoop2.protocol.engine.Configurazione;
import org.openspcoop2.protocol.sdk.Eccezione;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.protocol.sdk.state.IState;
import org.openspcoop2.protocol.sdk.validator.IValidazioneConSchema;
import org.slf4j.Logger;

public class ValidazioneConSchema {
    private List<Eccezione> erroriValidazione;
    private List<Eccezione> erroriProcessamento;
    private OpenSPCoop2Message message;
    private boolean isErroreProcessamento = false;
    private boolean isErroreIntestazione = false;
    private boolean validazioneManifestAttachments = false;
    private IProtocolFactory<?> protocolFactory;
    private IState state;

    public ValidazioneConSchema(OpenSPCoop2Message message, boolean isErroreProcessamento, boolean isErroreIntestazione, boolean validazioneManifestAttachments, IProtocolFactory<?> protocolFactory, IState state) {
        this(message, isErroreProcessamento, isErroreIntestazione, validazioneManifestAttachments, Configurazione.getLibraryLog(), protocolFactory, state);
    }

    public ValidazioneConSchema(OpenSPCoop2Message message, boolean isErroreProcessamento, boolean isErroreIntestazione, boolean validazioneManifestAttachments, Logger aLog, IProtocolFactory<?> protocolFactory, IState state) {
        this.message = message;
        this.isErroreProcessamento = isErroreProcessamento;
        this.isErroreIntestazione = isErroreIntestazione;
        this.validazioneManifestAttachments = validazioneManifestAttachments;
        this.protocolFactory = protocolFactory;
        this.state = state;
    }

    public IProtocolFactory<?> getProtocolFactory() {
        return this.protocolFactory;
    }

    public List<Eccezione> getEccezioniValidazione() {
        return this.erroriValidazione;
    }

    public List<Eccezione> getEccezioniProcessamento() {
        return this.erroriProcessamento;
    }

    public void valida(boolean isMessaggioConAttachments) throws Exception {
        IValidazioneConSchema validazione = this.protocolFactory.createValidazioneConSchema(this.state);
        validazione.valida(this.message, this.isErroreProcessamento, this.isErroreIntestazione, isMessaggioConAttachments, this.validazioneManifestAttachments);
        this.erroriProcessamento = validazione.getEccezioniProcessamento();
        this.erroriValidazione = validazione.getEccezioniValidazione();
    }
}

