/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.protocol.engine;

import jakarta.servlet.http.HttpServletRequest;
import java.io.Serializable;
import org.openspcoop2.core.constants.Costanti;
import org.openspcoop2.protocol.engine.ProtocolFactoryManager;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.protocol.sdk.constants.IDService;
import org.openspcoop2.protocol.sdk.state.FunctionContextsCustom;
import org.openspcoop2.protocol.sdk.state.URLProtocolContext;
import org.openspcoop2.utils.UtilsException;
import org.slf4j.Logger;

public class URLProtocolContextImpl
extends URLProtocolContext
implements Serializable {
    private static final long serialVersionUID = 1L;

    public URLProtocolContextImpl(Logger logCore) throws UtilsException {
        super(logCore);
    }

    public URLProtocolContextImpl(HttpServletRequest req, Logger logCore, boolean debug, FunctionContextsCustom customContexts) throws ProtocolException, UtilsException {
        super(req, logCore, debug, customContexts);
    }

    public URLProtocolContextImpl(HttpServletRequest req, Logger logCore, boolean debug, boolean integrationManagerEngine, FunctionContextsCustom customContexts) throws ProtocolException, UtilsException {
        super(req, logCore, debug, integrationManagerEngine, customContexts);
    }

    protected void init(HttpServletRequest req, Logger logCore, boolean debug, boolean integrationManagerEngine, FunctionContextsCustom customContexts) throws ProtocolException, UtilsException {
        block69: {
            String servletContext = req.getContextPath();
            String urlInvocazione = req.getRequestURI();
            String servizioInvocato = null;
            if (logCore != null) {
                logCore.debug("SERVLET CONTEXT [" + servletContext + "] URL[" + urlInvocazione + "]");
            }
            try {
                ProtocolFactoryManager protocolFactoryManager = ProtocolFactoryManager.getInstance();
                IProtocolFactory<?> pfEmptyContext = null;
                IDService idServiceDefaultEmptyContext = null;
                try {
                    pfEmptyContext = protocolFactoryManager.getProtocolFactoryWithEmptyContext();
                    idServiceDefaultEmptyContext = protocolFactoryManager.getDefaultServiceForEmptyContext();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                if (urlInvocazione.startsWith(servletContext + "/")) {
                    servizioInvocato = urlInvocazione.substring((servletContext + "/").length());
                } else if (urlInvocazione.equals(servletContext)) {
                    servizioInvocato = null;
                } else {
                    throw new Exception("GovWay [protocol/]service to be used not supplied (context error)");
                }
                if (logCore != null) {
                    logCore.debug("SERVIZIO RICHIESTO: [" + servizioInvocato + "]");
                }
                if (servizioInvocato == null || "".equals(servizioInvocato.trim())) {
                    if (pfEmptyContext != null && idServiceDefaultEmptyContext != null) {
                        this.protocolName = pfEmptyContext.getProtocol();
                        this.idServiceCustom = idServiceDefaultEmptyContext;
                        switch (idServiceDefaultEmptyContext) {
                            case PORTA_DELEGATA: {
                                this.function = "out";
                                break;
                            }
                            case PORTA_APPLICATIVA: {
                                this.function = "in";
                                break;
                            }
                            case PORTA_DELEGATA_XML_TO_SOAP: {
                                this.function = "out/xml2soap";
                                break;
                            }
                            default: {
                                throw new Exception("GovWay [protocol/]service to be used not supplied");
                            }
                        }
                        this.functionParameters = servizioInvocato;
                        this.protocolWebContext = "@EMPTY@";
                        break block69;
                    }
                    throw new Exception("GovWay [protocol/]service to be used not supplied");
                }
                String protocollo = null;
                Object function = null;
                String functionParameters = null;
                if (servizioInvocato.indexOf("/") >= 0) {
                    protocollo = servizioInvocato.substring(0, servizioInvocato.indexOf("/"));
                    function = servizioInvocato.substring(servizioInvocato.indexOf("/") + 1, servizioInvocato.length());
                } else {
                    protocollo = servizioInvocato;
                    function = servizioInvocato;
                }
                if (logCore != null) {
                    logCore.debug("PROTOCOLLO[" + protocollo + "] FUNCTION[" + (String)function + "]");
                }
                boolean IMengine = false;
                if (integrationManagerEngine && protocollo.equals("IntegrationManagerEngine")) {
                    if (logCore != null) {
                        logCore.debug("SERVLET INTEGRATION MANAGER SERVICE");
                    }
                    function = protocollo;
                    IMengine = true;
                    Object o = this.getHttpServletRequest().getAttribute((String)((Object)Costanti.PROTOCOL_NAME.getValue()));
                    if (o == null || !(o instanceof String)) {
                        throw new Exception("Indicazione del protocollo non presente");
                    }
                    this.protocolName = (String)o;
                    IProtocolFactory<?> pf = protocolFactoryManager.getProtocolFactoryByName(this.protocolName);
                    if (pf == null) {
                        throw new Exception("Non risulta registrato un protocollo con nome [" + this.protocolName + "]");
                    }
                    o = this.getHttpServletRequest().getAttribute((String)((Object)Costanti.PROTOCOL_WEB_CONTEXT.getValue()));
                    if (o == null || !(o instanceof String)) {
                        throw new Exception("Indicazione del web context del protocollo non presente");
                    }
                    this.protocolWebContext = (String)o;
                    pf = protocolFactoryManager.getProtocolFactoryByServletContext(this.protocolWebContext);
                    if (pf == null) {
                        if (!"@EMPTY@".equals(this.protocolWebContext)) {
                            throw new Exception("Non risulta registrato un protocollo con contesto [" + this.protocolWebContext + "]");
                        }
                        throw new Exception("Non risulta registrato un protocollo con contesto speciale 'vuoto'");
                    }
                    int sizePrefix = (req.getContextPath() + "/" + (String)function + "/").length();
                    if (req.getRequestURI().length() > sizePrefix) {
                        functionParameters = req.getRequestURI().substring(sizePrefix);
                    }
                    if (functionParameters != null && functionParameters.startsWith("PD")) {
                        function = (String)function + "_PD";
                        Object oPD = this.getHttpServletRequest().getAttribute((String)((Object)Costanti.PORTA_DELEGATA.getValue()));
                        if (oPD == null || !(oPD instanceof String)) {
                            throw new Exception("Indicazione della porta delegata non presente");
                        }
                        functionParameters = (String)oPD;
                    } else if (functionParameters != null && functionParameters.startsWith("MessageBox")) {
                        function = (String)function + "_MessageBox";
                        if (functionParameters.length() > "MessageBox".length()) {
                            functionParameters = functionParameters.substring("MessageBox".length());
                        }
                    }
                } else if (protocollo.equals("PA") || protocollo.equals("PD") || protocollo.equals("PDtoSOAP") || protocollo.equals("IntegrationManager") || protocollo.equals("check") || protocollo.equals("proxy") || customContexts != null && customContexts.isMatch(protocollo, (String)function)) {
                    if (logCore != null) {
                        logCore.debug("SERVLET PATH EMPTY");
                    }
                    if (customContexts != null && customContexts.isMatch(protocollo, (String)function)) {
                        this.idServiceCustom = customContexts.getServiceMatch(protocollo, (String)function);
                        function = customContexts.getFunctionMatch(protocollo, (String)function);
                        if (logCore != null) {
                            logCore.debug("CUSTOM FUNCTION [" + (String)function + "] [" + String.valueOf(this.idServiceCustom) + "]");
                        }
                    } else {
                        function = protocollo;
                    }
                    protocollo = "@EMPTY@";
                    int sizePrefix = (req.getContextPath() + "/" + (String)function + "/").length();
                    functionParameters = req.getRequestURI().length() > sizePrefix ? req.getRequestURI().substring(sizePrefix) : null;
                } else {
                    boolean casoSpeciale_noProtocollo_noFunction;
                    block70: {
                        casoSpeciale_noProtocollo_noFunction = false;
                        try {
                            IProtocolFactory<?> pfCheck = protocolFactoryManager.getProtocolFactoryByServletContext(protocollo);
                            if (pfCheck == null) {
                                throw new Exception("NotFound");
                            }
                        }
                        catch (Exception e) {
                            if (pfEmptyContext == null) break block70;
                            function = function != null && !"".equals(function) ? protocollo + "/" + (String)function : protocollo;
                            protocollo = "@EMPTY@";
                            casoSpeciale_noProtocollo_noFunction = true;
                        }
                    }
                    String functionParameterForCheckCustom = null;
                    if (((String)function).indexOf("/") > 0 && (functionParameterForCheckCustom = ((String)function).substring(((String)function).indexOf("/"))).length() > 1 && functionParameterForCheckCustom.startsWith("/")) {
                        functionParameterForCheckCustom = functionParameterForCheckCustom.substring(1);
                    }
                    if (((String)function).indexOf("/") > 0) {
                        function = ((String)function).substring(0, ((String)function).indexOf("/"));
                    } else if (((String)function).indexOf("?") > 0) {
                        function = ((String)function).substring(0, ((String)function).indexOf("?"));
                    }
                    if (logCore != null) {
                        logCore.debug("FUNCTION [" + (String)function + "]");
                    }
                    boolean emptyFunction = false;
                    if (!(!casoSpeciale_noProtocollo_noFunction && (((String)function).equals("PA") || ((String)function).equals("PD") || ((String)function).equals("PDtoSOAP") || ((String)function).equals("IntegrationManager") || ((String)function).equals("check") || ((String)function).equals("proxy") || customContexts != null && customContexts.isMatch((String)function, functionParameterForCheckCustom)))) {
                        IDService idS = null;
                        if (casoSpeciale_noProtocollo_noFunction) {
                            if (pfEmptyContext != null && idServiceDefaultEmptyContext != null) {
                                idS = idServiceDefaultEmptyContext;
                            }
                        } else {
                            idS = protocolFactoryManager.getDefaultServiceForWebContext(protocollo);
                        }
                        if (idS != null) {
                            this.protocolName = pfEmptyContext.getProtocol();
                            this.idServiceCustom = idS;
                            switch (idS) {
                                case PORTA_DELEGATA: {
                                    function = "out";
                                    emptyFunction = true;
                                    break;
                                }
                                case PORTA_APPLICATIVA: {
                                    function = "in";
                                    emptyFunction = true;
                                    break;
                                }
                                case PORTA_DELEGATA_XML_TO_SOAP: {
                                    function = "out/xml2soap";
                                    emptyFunction = true;
                                    break;
                                }
                            }
                        }
                    }
                    StringBuilder bfSizePrefix = new StringBuilder(req.getContextPath());
                    if (!"@EMPTY@".equals(protocollo)) {
                        bfSizePrefix.append("/").append(protocollo);
                    }
                    if (!emptyFunction) {
                        bfSizePrefix.append("/").append((String)function);
                    }
                    bfSizePrefix.append("/");
                    int sizePrefix = bfSizePrefix.length();
                    functionParameters = req.getRequestURI().length() > sizePrefix ? req.getRequestURI().substring(sizePrefix) : null;
                    if (!casoSpeciale_noProtocollo_noFunction && !emptyFunction && customContexts != null && customContexts.isMatch((String)function, functionParameters)) {
                        this.idServiceCustom = customContexts.getServiceMatch((String)function, functionParameters);
                        function = customContexts.getFunctionMatch((String)function, functionParameters);
                        if (logCore != null) {
                            logCore.debug("CUSTOM FUNCTION [" + (String)function + "] [" + String.valueOf(this.idServiceCustom) + "]");
                        }
                        sizePrefix = (req.getContextPath() + "/" + protocollo + "/" + (String)function + "/").length();
                        functionParameters = req.getRequestURI().length() > sizePrefix ? req.getRequestURI().substring(sizePrefix) : null;
                    }
                    if (casoSpeciale_noProtocollo_noFunction && emptyFunction) {
                        this.requestURI = this.requestURI.replace(servletContext + "/", servletContext + "/" + (String)function + "/");
                    } else if (emptyFunction) {
                        this.requestURI = this.requestURI.replace(servletContext + "/" + protocollo + "/", servletContext + "/" + protocollo + "/" + (String)function + "/");
                    }
                }
                if (logCore != null) {
                    logCore.debug("Elaborazione finale Protocollo[" + protocollo + "] Function[" + (String)function + "] FunctionParameters [" + functionParameters + "]");
                }
                if (!IMengine) {
                    this.protocolWebContext = protocollo;
                    IProtocolFactory<?> pf = protocolFactoryManager.getProtocolFactoryByServletContext(this.protocolWebContext);
                    if (pf == null) {
                        if (!"@EMPTY@".equals(this.protocolWebContext)) {
                            throw new Exception("Non risulta registrato un protocollo con contesto [" + this.protocolWebContext + "]");
                        }
                        throw new Exception("Non risulta registrato un protocollo con contesto speciale 'vuoto'");
                    }
                    this.protocolName = pf.getProtocol();
                }
                this.function = function;
                this.functionParameters = functionParameters;
            }
            catch (Exception e) {
                throw new ProtocolException(e.getMessage(), (Throwable)e);
            }
        }
    }

    public String toString() {
        return this.toString("");
    }

    public String toString(String prefix) {
        StringBuilder sb = new StringBuilder(super.toString(prefix));
        if (this.idServiceCustom != null) {
            sb.append("\n").append(prefix).append("idServiceCustom: ").append(this.idServiceCustom);
        }
        return sb.toString();
    }
}

