/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.protocol.engine;

import jakarta.servlet.http.HttpServletRequest;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openspcoop2.message.OpenSPCoop2MessageFactory;
import org.openspcoop2.message.constants.ServiceBinding;
import org.openspcoop2.protocol.basic.BasicFactory;
import org.openspcoop2.protocol.engine.URLProtocolContextImpl;
import org.openspcoop2.protocol.engine.mapping.InformazioniServizioURLMapping;
import org.openspcoop2.protocol.manifest.DefaultIntegrationError;
import org.openspcoop2.protocol.manifest.Integration;
import org.openspcoop2.protocol.manifest.IntegrationConfiguration;
import org.openspcoop2.protocol.manifest.IntegrationConfigurationElementName;
import org.openspcoop2.protocol.manifest.IntegrationConfigurationResourceIdentificationMode;
import org.openspcoop2.protocol.manifest.IntegrationError;
import org.openspcoop2.protocol.manifest.Openspcoop2;
import org.openspcoop2.protocol.manifest.RestConfiguration;
import org.openspcoop2.protocol.manifest.SoapConfiguration;
import org.openspcoop2.protocol.manifest.SubContextMapping;
import org.openspcoop2.protocol.manifest.Web;
import org.openspcoop2.protocol.manifest.constants.ActorType;
import org.openspcoop2.protocol.manifest.constants.FunctionType;
import org.openspcoop2.protocol.manifest.constants.MessageType;
import org.openspcoop2.protocol.manifest.constants.ResourceIdentificationType;
import org.openspcoop2.protocol.manifest.utils.XMLUtils;
import org.openspcoop2.protocol.sdk.ConfigurazionePdD;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.protocol.sdk.config.ITraduttore;
import org.openspcoop2.protocol.sdk.constants.CodiceErroreCooperazione;
import org.openspcoop2.protocol.sdk.constants.ContestoCodificaEccezione;
import org.openspcoop2.protocol.sdk.constants.IDService;
import org.openspcoop2.protocol.sdk.constants.Inoltro;
import org.openspcoop2.protocol.sdk.constants.LivelloRilevanza;
import org.openspcoop2.protocol.sdk.constants.ProfiloDiCollaborazione;
import org.openspcoop2.protocol.sdk.constants.TipoOraRegistrazione;
import org.openspcoop2.protocol.sdk.state.FunctionContextsCustom;
import org.openspcoop2.protocol.utils.EsitiProperties;
import org.openspcoop2.utils.Utilities;
import org.openspcoop2.utils.resources.ClassLoaderUtilities;
import org.openspcoop2.utils.resources.Loader;
import org.openspcoop2.utils.resources.MapReader;
import org.slf4j.Logger;

public class ProtocolFactoryManager {
    private static ProtocolFactoryManager protocolFactoryManager = null;
    private MapReader<String, Openspcoop2> manifests = null;
    private MapReader<String, URL> manifestURLs = null;
    private MapReader<String, IProtocolFactory<?>> factories = null;
    private StringBuilder protocolLoaded = new StringBuilder();
    private String protocolDefault = null;
    private MapReader<String, List<String>> tipiSoggettiValidi = null;
    private MapReader<String, String> tipiSoggettiDefault = null;
    private MapReader<String, List<String>> tipiServiziValidi_soap = null;
    private MapReader<String, String> tipiServiziDefault_soap = null;
    private MapReader<String, List<String>> tipiServiziValidi_rest = null;
    private MapReader<String, String> tipiServiziDefault_rest = null;
    private MapReader<String, List<String>> versioniValide = null;
    private MapReader<String, String> versioniDefault = null;
    private Logger log = null;

    public static synchronized void initialize(Logger log, ConfigurazionePdD configPdD, String protocolDefault) throws ProtocolException {
        if (protocolFactoryManager == null) {
            protocolFactoryManager = new ProtocolFactoryManager(log, configPdD, protocolDefault, false);
            EsitiProperties.initialize((String)configPdD.getConfigurationDir(), (Logger)log, (Loader)configPdD.getLoader(), protocolFactoryManager.getProtocolFactories());
            protocolFactoryManager.initStaticInstance();
        }
    }

    public static synchronized void initializeSingleProtocol(Logger log, ConfigurazionePdD configPdD, String protocol) throws ProtocolException {
        if (protocolFactoryManager == null) {
            protocolFactoryManager = new ProtocolFactoryManager(log, configPdD, protocol, true);
            EsitiProperties.initialize((String)configPdD.getConfigurationDir(), (Logger)log, (Loader)configPdD.getLoader(), protocolFactoryManager.getProtocolFactories());
            protocolFactoryManager.initStaticInstance();
        }
    }

    public static ProtocolFactoryManager getInstance() throws ProtocolException {
        if (protocolFactoryManager == null) {
            Class<ProtocolFactoryManager> clazz = ProtocolFactoryManager.class;
            synchronized (ProtocolFactoryManager.class) {
                throw new ProtocolException("ProtocolFactoryManager not initialized");
            }
        }
        return protocolFactoryManager;
    }

    public static void updateLogger(Logger log) {
        if (protocolFactoryManager != null) {
            ProtocolFactoryManager.protocolFactoryManager.log = log;
        }
    }

    public boolean isSupportedProtocolLogger(String protocol) throws ProtocolException {
        IProtocolFactory<?> p = this.getProtocolFactoryByName(protocol);
        return p.getManifest().getProtocol().isLogger();
    }

    public void initializeAllProtocols() throws ProtocolException {
        if (this.factories != null) {
            Enumeration factories = this.factories.elements();
            while (factories.hasMoreElements()) {
                IProtocolFactory iProtocolFactory = (IProtocolFactory)factories.nextElement();
                iProtocolFactory.getProtocol();
                iProtocolFactory.getInformazioniProtocol();
                Openspcoop2 manifest = iProtocolFactory.getManifest();
                iProtocolFactory.getConfigurazionePdD();
                iProtocolFactory.getLogger();
                if (manifest.getProtocol().isLogger()) {
                    iProtocolFactory.getProtocolLogger();
                }
                iProtocolFactory.createBustaBuilder(null);
                iProtocolFactory.createErroreApplicativoBuilder();
                iProtocolFactory.createEsitoBuilder();
                iProtocolFactory.createValidatoreErrori(null);
                iProtocolFactory.createValidazioneSintattica(null);
                iProtocolFactory.createValidazioneSemantica(null);
                iProtocolFactory.createValidazioneConSchema(null);
                iProtocolFactory.createValidazioneDocumenti();
                iProtocolFactory.createValidazioneAccordi();
                iProtocolFactory.createDiagnosticDriver();
                iProtocolFactory.createDiagnosticProducer();
                iProtocolFactory.createDiagnosticSerializer();
                iProtocolFactory.createTracciaDriver();
                iProtocolFactory.createTracciaProducer();
                iProtocolFactory.createTracciaSerializer();
                iProtocolFactory.createArchive();
                List versioni = iProtocolFactory.createProtocolConfiguration().getVersioni();
                for (String version : versioni) {
                    iProtocolFactory.createProtocolVersionManager(version);
                }
                iProtocolFactory.createProtocolManager();
                ITraduttore traduttore = iProtocolFactory.createTraduttore();
                traduttore.toString(CodiceErroreCooperazione.AZIONE);
                traduttore.toString(ContestoCodificaEccezione.INTESTAZIONE);
                traduttore.toString(Inoltro.CON_DUPLICATI);
                traduttore.toString(LivelloRilevanza.INFO);
                traduttore.toString(ProfiloDiCollaborazione.SINCRONO);
                traduttore.toString(TipoOraRegistrazione.LOCALE);
                iProtocolFactory.createDynamicConfigurationConsole();
            }
        }
    }

    private ProtocolFactoryManager(Logger log, ConfigurazionePdD configPdD, String protocolDefault, boolean searchSingleManifest) throws ProtocolException {
        try {
            HashMap<String, Openspcoop2> tmp_manifests = new HashMap<String, Openspcoop2>();
            HashMap<String, URL> tmp_manifestURLs = new HashMap<String, URL>();
            HashMap tmp_factories = new HashMap();
            HashMap<String, List<String>> tmp_tipiSoggettiValidi = new HashMap<String, List<String>>();
            HashMap<String, String> tmp_tipiSoggettiDefault = new HashMap<String, String>();
            HashMap<String, List<String>> tmp_tipiServiziValidi_soap = new HashMap<String, List<String>>();
            HashMap<String, String> tmp_tipiServiziDefault_soap = new HashMap<String, String>();
            HashMap<String, List<String>> tmp_tipiServiziValidi_rest = new HashMap<String, List<String>>();
            HashMap<String, String> tmp_tipiServiziDefault_rest = new HashMap<String, String>();
            HashMap<String, List<String>> tmp_versioniValide = new HashMap<String, List<String>>();
            HashMap<String, String> tmp_versioniDefault = new HashMap<String, String>();
            this.log = configPdD.getLog();
            this.protocolDefault = protocolDefault;
            configPdD.getLog().debug("Init ProtocolFactoryManager ...");
            if (searchSingleManifest) {
                URL pluginURL = ProtocolFactoryManager.class.getResource("/openspcoop2-manifest.xml");
                this.loadManifest(configPdD, pluginURL, false, tmp_manifests, tmp_manifestURLs);
            } else {
                URL pluginURL;
                Enumeration<URL> en = ProtocolFactoryManager.class.getClassLoader().getResources("/openspcoop2-manifest.xml");
                while (en.hasMoreElements()) {
                    pluginURL = en.nextElement();
                    this.loadManifest(configPdD, pluginURL, false, tmp_manifests, tmp_manifestURLs);
                }
                if (tmp_manifests.size() <= 0) {
                    en = ProtocolFactoryManager.class.getClassLoader().getResources("openspcoop2-manifest.xml");
                    while (en.hasMoreElements()) {
                        pluginURL = en.nextElement();
                        this.loadManifest(configPdD, pluginURL, true, tmp_manifests, tmp_manifestURLs);
                    }
                }
            }
            if (tmp_manifests.size() <= 0) {
                throw new Exception("Protocol plugins not found");
            }
            configPdD.getLog().debug("Validate Manifests ...");
            this.validateProtocolFactoryLoaded(tmp_manifests, tmp_tipiSoggettiValidi, tmp_tipiSoggettiDefault, tmp_tipiServiziValidi_soap, tmp_tipiServiziDefault_soap, tmp_tipiServiziValidi_rest, tmp_tipiServiziDefault_rest, tmp_versioniValide, tmp_versioniDefault);
            configPdD.getLog().debug("Validate Manifests ok");
            for (String protocolManifest : tmp_manifests.keySet()) {
                configPdD.getLog().debug("Init ProtocolFactory for protocol [" + protocolManifest + "] ...");
                Openspcoop2 manifestOpenspcoop2 = (Openspcoop2)tmp_manifests.get(protocolManifest);
                IProtocolFactory<?> p = this.getProtocolFactoryEngine(manifestOpenspcoop2);
                p.init(configPdD.getLog(), protocolManifest, configPdD, manifestOpenspcoop2);
                if (!p.createValidazioneConSchema(null).initialize(OpenSPCoop2MessageFactory.getDefaultMessageFactory())) {
                    throw new Exception("[protocol:" + protocolManifest + "] Inizialize with error for ValidazioneConSchema");
                }
                tmp_factories.put(protocolManifest, p);
                if (this.protocolLoaded.length() > 0) {
                    this.protocolLoaded.append(",");
                }
                this.protocolLoaded.append(protocolManifest);
                InformazioniServizioURLMapping.initMappingProperties(p);
                StringBuilder context = new StringBuilder();
                if (manifestOpenspcoop2.getWeb().getEmptyContext() != null && manifestOpenspcoop2.getWeb().getEmptyContext().getEnabled()) {
                    context.append("@EMPTY-CONTEXT@");
                }
                for (int i = 0; i < manifestOpenspcoop2.getWeb().sizeContextList(); ++i) {
                    if (context.length() > 0) {
                        context.append(",");
                    }
                    context.append(manifestOpenspcoop2.getWeb().getContext(i).getName());
                }
                log.info("Protocol loaded with id[" + protocolManifest + "] factory[" + manifestOpenspcoop2.getProtocol().getFactory() + "] contexts[" + context.toString() + "]");
                configPdD.getLog().debug("Init ProtocolFactory for protocol [" + protocolManifest + "] ok");
            }
            this.manifests = new MapReader(tmp_manifests, true);
            this.manifestURLs = new MapReader(tmp_manifestURLs, true);
            this.factories = new MapReader(tmp_factories, true);
            this.tipiSoggettiValidi = new MapReader(tmp_tipiSoggettiValidi, true);
            this.tipiSoggettiDefault = new MapReader(tmp_tipiSoggettiDefault, true);
            this.tipiServiziValidi_soap = new MapReader(tmp_tipiServiziValidi_soap, true);
            this.tipiServiziDefault_soap = new MapReader(tmp_tipiServiziDefault_soap, true);
            this.tipiServiziValidi_rest = new MapReader(tmp_tipiServiziValidi_rest, true);
            this.tipiServiziDefault_rest = new MapReader(tmp_tipiServiziDefault_rest, true);
            this.versioniValide = new MapReader(tmp_versioniValide, true);
            this.versioniDefault = new MapReader(tmp_versioniDefault, true);
        }
        catch (Exception e) {
            configPdD.getLog().error("Init ProtocolFactoryManager failed: " + e.getMessage(), (Throwable)e);
            throw new ProtocolException("Inizializzazione ProtocolFactoryManager fallita: " + String.valueOf(e), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadManifest(ConfigurazionePdD configPdD, URL pluginURL, boolean filtraSenzaErroreProtocolloGiaCaricato, Map<String, Openspcoop2> tmp_manifests, Map<String, URL> tmp_manifestURLs) throws Exception {
        configPdD.getLog().debug("Analyze manifest [" + pluginURL.toString() + "] ...");
        InputStream openStream = null;
        byte[] manifest = null;
        try {
            openStream = pluginURL.openStream();
            manifest = Utilities.getAsByteArray((InputStream)openStream);
        }
        finally {
            try {
                if (openStream != null) {
                    openStream.close();
                }
            }
            catch (Exception exception) {}
        }
        configPdD.getLog().debug("Analyze manifest [" + pluginURL.toString() + "] convertToOpenSPCoop2Manifest...");
        Openspcoop2 manifestOpenspcoop2 = XMLUtils.getOpenspcoop2Manifest((Logger)configPdD.getLog(), (byte[])manifest);
        String protocollo = manifestOpenspcoop2.getProtocol().getName();
        configPdD.getLog().debug("Analyze manifest [" + pluginURL.toString() + "] with protocolName: [" + protocollo + "]");
        if (tmp_manifests.containsKey(protocollo)) {
            URL urlGiaPresente = tmp_manifestURLs.get(protocollo);
            if (filtraSenzaErroreProtocolloGiaCaricato) {
                configPdD.getLog().warn("ProtocolName [" + protocollo + "] is same for more plugin [" + pluginURL.toString() + "] and [" + String.valueOf(urlGiaPresente.toURI()) + "]");
            } else {
                throw new Exception("ProtocolName [" + protocollo + "] is same for more plugin [" + pluginURL.toString() + "] and [" + String.valueOf(urlGiaPresente.toURI()) + "]");
            }
        }
        tmp_manifests.put(protocollo, manifestOpenspcoop2);
        tmp_manifestURLs.put(protocollo, pluginURL);
        configPdD.getLog().debug("Analyze manifest [" + pluginURL.toString() + "] with success");
    }

    /*
     * WARNING - void declaration
     */
    private void validateProtocolFactoryLoaded(Map<String, Openspcoop2> tmp_manifests, Map<String, List<String>> tmp_tipiSoggettiValidi, Map<String, String> tmp_tipiSoggettiDefault, Map<String, List<String>> tmp_tipiServiziValidi_soap, Map<String, String> tmp_tipiServiziDefault_soap, Map<String, List<String>> tmp_tipiServiziValidi_rest, Map<String, String> tmp_tipiServiziDefault_rest, Map<String, List<String>> tmp_versioniValide, Map<String, String> tmp_versioniDefault) throws Exception {
        void var14_25;
        Openspcoop2 manifestOpenspcoop2;
        String protocolContextEmpty = null;
        for (String string : tmp_manifests.keySet()) {
            Openspcoop2 openspcoop2 = tmp_manifests.get(string);
            if (openspcoop2.getWeb().getEmptyContext() == null || !openspcoop2.getWeb().getEmptyContext().getEnabled()) continue;
            if (protocolContextEmpty == null) {
                protocolContextEmpty = string;
                continue;
            }
            throw new Exception("Protocol [" + protocolContextEmpty + "] and [" + string + "] with empty context. Only one is permitted");
        }
        HashMap<String, String> mappingContextToProtocol = new HashMap<String, String>();
        for (String string : tmp_manifests.keySet()) {
            Openspcoop2 openspcoop2 = tmp_manifests.get(string);
            for (int i = 0; i < openspcoop2.getWeb().sizeContextList(); ++i) {
                String context = openspcoop2.getWeb().getContext(i).getName();
                if (mappingContextToProtocol.containsKey(context)) {
                    throw new Exception("Protocol [" + (String)mappingContextToProtocol.get(context) + "] and [" + string + "] with same context [" + context + "]");
                }
                mappingContextToProtocol.put(context, string);
            }
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (String string : tmp_manifests.keySet()) {
            Openspcoop2 manifestOpenspcoop24 = tmp_manifests.get(string);
            String label = manifestOpenspcoop24.getProtocol().getLabel();
            if (!hashMap.containsKey(label)) {
                hashMap.put(label, string);
                continue;
            }
            throw new Exception("Protocol [" + (String)hashMap.get(label) + "] and [" + string + "] with same label [" + label + "]");
        }
        HashMap<String, String> hashMap2 = new HashMap<String, String>();
        for (String protocolManifest : tmp_manifests.keySet()) {
            int i;
            Openspcoop2 manifestOpenspcoop25 = tmp_manifests.get(protocolManifest);
            int size = manifestOpenspcoop25.getRegistry().getOrganization().getTypes().sizeTypeList();
            if (size <= 0) {
                throw new Exception("Organization type not defined for protocol [" + protocolManifest + "]");
            }
            for (i = 0; i < size; ++i) {
                String tipo = manifestOpenspcoop25.getRegistry().getOrganization().getTypes().getType(i).getName();
                if (hashMap2.containsKey(tipo)) {
                    throw new Exception("Protocol [" + (String)hashMap2.get(tipo) + "] and [" + protocolManifest + "] with same subject type [" + tipo + "]");
                }
                hashMap2.put(tipo, protocolManifest);
                List<Object> tipiSoggettiPerProtocollo = null;
                tipiSoggettiPerProtocollo = tmp_tipiSoggettiValidi.containsKey(protocolManifest) ? tmp_tipiSoggettiValidi.remove(protocolManifest) : new ArrayList();
                tipiSoggettiPerProtocollo.add(tipo);
                tmp_tipiSoggettiValidi.put(protocolManifest, tipiSoggettiPerProtocollo);
            }
            for (i = 0; i < size; ++i) {
                String protocolType = manifestOpenspcoop25.getRegistry().getOrganization().getTypes().getType(i).getProtocol();
                if (protocolType == null) continue;
                int count = 0;
                for (int j = 0; j < size; ++j) {
                    String protocolTypeCheck = manifestOpenspcoop25.getRegistry().getOrganization().getTypes().getType(j).getProtocol();
                    if (protocolTypeCheck == null || !protocolTypeCheck.equals(protocolType)) continue;
                    ++count;
                }
                if (count <= true) continue;
                throw new Exception("Protocol [" + protocolManifest + "] with same subject 'protocol conversion type' [" + protocolType + "]");
            }
            String tipoDefault = manifestOpenspcoop25.getRegistry().getOrganization().getTypes().getType(0).getName();
            if (!tmp_tipiSoggettiValidi.get(protocolManifest).contains(tipoDefault)) {
                throw new Exception("Unknown default subject type [" + tipoDefault + "] defined in protocol [" + protocolManifest + "]");
            }
            tmp_tipiSoggettiDefault.put(protocolManifest, tipoDefault);
        }
        Object var14_24 = null;
        String tipoServizioDefaultRest = null;
        HashMap<String, String> mappingTipiServiziToProtocol = new HashMap<String, String>();
        for (String protocolManifest : tmp_manifests.keySet()) {
            int i;
            manifestOpenspcoop2 = tmp_manifests.get(protocolManifest);
            int size = manifestOpenspcoop2.getRegistry().getService().getTypes().sizeTypeList();
            if (size <= 0) {
                throw new Exception("Service type not defined for protocol [" + protocolManifest + "]");
            }
            for (i = 0; i < size; ++i) {
                String tipo = manifestOpenspcoop2.getRegistry().getService().getTypes().getType(i).getName();
                org.openspcoop2.protocol.manifest.constants.ServiceBinding serviceBinding = manifestOpenspcoop2.getRegistry().getService().getTypes().getType(i).getBinding();
                if (!mappingTipiServiziToProtocol.containsKey(tipo)) {
                    mappingTipiServiziToProtocol.put(tipo, protocolManifest);
                    List<Object> tipiServiziPerProtocollo_soap = null;
                    if (tmp_tipiServiziValidi_soap.containsKey(protocolManifest)) {
                        tipiServiziPerProtocollo_soap = tmp_tipiServiziValidi_soap.get(protocolManifest);
                    } else {
                        tipiServiziPerProtocollo_soap = new ArrayList();
                        tmp_tipiServiziValidi_soap.put(protocolManifest, tipiServiziPerProtocollo_soap);
                    }
                    List<Object> tipiServiziPerProtocollo_rest = null;
                    if (tmp_tipiServiziValidi_rest.containsKey(protocolManifest)) {
                        tipiServiziPerProtocollo_rest = tmp_tipiServiziValidi_rest.get(protocolManifest);
                    } else {
                        tipiServiziPerProtocollo_rest = new ArrayList();
                        tmp_tipiServiziValidi_rest.put(protocolManifest, tipiServiziPerProtocollo_rest);
                    }
                    if (serviceBinding == null || org.openspcoop2.protocol.manifest.constants.ServiceBinding.SOAP.equals((Object)serviceBinding)) {
                        tipiServiziPerProtocollo_soap.add(tipo);
                        if (var14_25 == null) {
                            String string = tipo;
                        }
                    }
                    if (serviceBinding != null && !org.openspcoop2.protocol.manifest.constants.ServiceBinding.REST.equals((Object)serviceBinding)) continue;
                    tipiServiziPerProtocollo_rest.add(tipo);
                    if (tipoServizioDefaultRest != null) continue;
                    tipoServizioDefaultRest = tipo;
                    continue;
                }
                throw new Exception("Protocol [" + (String)mappingTipiServiziToProtocol.get(tipo) + "] and [" + protocolManifest + "] with same service type [" + tipo + "]");
            }
            for (i = 0; i < size; ++i) {
                String protocolType = manifestOpenspcoop2.getRegistry().getService().getTypes().getType(i).getProtocol();
                if (protocolType == null) continue;
                int count = 0;
                for (int j = 0; j < size; ++j) {
                    String protocolTypeCheck = manifestOpenspcoop2.getRegistry().getService().getTypes().getType(j).getProtocol();
                    if (protocolTypeCheck == null || !protocolTypeCheck.equals(protocolType)) continue;
                    ++count;
                }
                if (count <= true) continue;
                throw new Exception("Protocol [" + protocolManifest + "] with same service 'protocol conversion type' [" + protocolType + "]");
            }
            if (var14_25 != null) {
                tmp_tipiServiziDefault_soap.put(protocolManifest, (String)var14_25);
            }
            if (tipoServizioDefaultRest == null) continue;
            tmp_tipiServiziDefault_rest.put(protocolManifest, tipoServizioDefaultRest);
        }
        for (String protocolManifest : tmp_manifests.keySet()) {
            manifestOpenspcoop2 = tmp_manifests.get(protocolManifest);
            int size = manifestOpenspcoop2.getRegistry().getVersions().sizeVersionList();
            if (size <= 0) {
                throw new Exception("Version not defined for protocol [" + protocolManifest + "]");
            }
            for (int i = 0; i < size; ++i) {
                String version = manifestOpenspcoop2.getRegistry().getVersions().getVersion(i).getName();
                List<Object> versioniPerProtocollo = null;
                versioniPerProtocollo = tmp_versioniValide.containsKey(protocolManifest) ? tmp_versioniValide.remove(protocolManifest) : new ArrayList();
                versioniPerProtocollo.add(version);
                tmp_versioniValide.put(protocolManifest, versioniPerProtocollo);
            }
            String versioneDefault = manifestOpenspcoop2.getRegistry().getVersions().getVersion(0).getName();
            if (!tmp_versioniValide.get(protocolManifest).contains(versioneDefault)) {
                throw new Exception("Unknown default version [" + versioneDefault + "] defined in protocol [" + protocolManifest + "]");
            }
            tmp_versioniDefault.put(protocolManifest, versioneDefault);
        }
        for (String protocolManifest : tmp_manifests.keySet()) {
            manifestOpenspcoop2 = tmp_manifests.get(protocolManifest);
            if (manifestOpenspcoop2.getBinding() == null) {
                throw new Exception("Binding not defined for protocol [" + protocolManifest + "]");
            }
            if (manifestOpenspcoop2.getBinding().getSoap() == null && manifestOpenspcoop2.getBinding().getRest() == null) {
                throw new Exception("Binding (soap/rest) not defined for protocol [" + protocolManifest + "]");
            }
            if (manifestOpenspcoop2.getBinding().getSoap() != null && manifestOpenspcoop2.getBinding().getRest() != null && manifestOpenspcoop2.getBinding().getDefault() == null) {
                throw new Exception("Unknown default binding for protocol [" + protocolManifest + "]");
            }
            boolean soapEnabled = false;
            if (manifestOpenspcoop2.getBinding().getSoap() != null) {
                if (!manifestOpenspcoop2.getBinding().getSoap().isSoap11() && !manifestOpenspcoop2.getBinding().getSoap().isSoap12()) {
                    throw new Exception("Binding Soap for protocol [" + protocolManifest + "]: none of the soap versions is enabled");
                }
                if (manifestOpenspcoop2.getBinding().getSoap().isSoap11Mtom() && !manifestOpenspcoop2.getBinding().getSoap().isSoap11()) {
                    throw new Exception("Binding Soap for protocol [" + protocolManifest + "]: if soap 1.1 is not enabled you can not enable MTOM");
                }
                if (manifestOpenspcoop2.getBinding().getSoap().isSoap11WithAttachments() && !manifestOpenspcoop2.getBinding().getSoap().isSoap11()) {
                    throw new Exception("Binding Soap for protocol [" + protocolManifest + "]: if soap 1.1 is not enabled you can not enable attachments");
                }
                if (manifestOpenspcoop2.getBinding().getSoap().isSoap12Mtom() && !manifestOpenspcoop2.getBinding().getSoap().isSoap12()) {
                    throw new Exception("Binding Soap for protocol [" + protocolManifest + "]: if soap 1.2 is not enabled you can not enable MTOM");
                }
                if (manifestOpenspcoop2.getBinding().getSoap().isSoap12WithAttachments() && !manifestOpenspcoop2.getBinding().getSoap().isSoap12()) {
                    throw new Exception("Binding Soap for protocol [" + protocolManifest + "]: if soap 1.2 is not enabled you can not enable attachments");
                }
                if (manifestOpenspcoop2.getBinding().getSoap().getIntegrationError() == null) {
                    throw new Exception("Binding Soap for protocol [" + protocolManifest + "]: it has not defined the configuration for error handling");
                }
                if (manifestOpenspcoop2.getBinding().getSoap().getIntegrationError().getInternal() == null) {
                    throw new Exception("Binding Soap for protocol [" + protocolManifest + "]: it has not defined the configuration for internal error handling");
                }
                if (manifestOpenspcoop2.getBinding().getSoap().getIntegrationError().getInternal().getDefault() == null) {
                    throw new Exception("Binding Soap for protocol [" + protocolManifest + "]: it has not defined the default configuration for internal error handling");
                }
                this.checkHttpReturnCode(manifestOpenspcoop2.getBinding().getSoap().getIntegrationError().getInternal().getDefault(), "default");
                this.checkHttpReturnCode(manifestOpenspcoop2.getBinding().getSoap().getIntegrationError().getInternal().getAuthentication(), "authentication");
                this.checkHttpReturnCode(manifestOpenspcoop2.getBinding().getSoap().getIntegrationError().getInternal().getAuthorization(), "authorization");
                this.checkHttpReturnCode(manifestOpenspcoop2.getBinding().getSoap().getIntegrationError().getInternal().getNotFound(), "notFound");
                this.checkHttpReturnCode(manifestOpenspcoop2.getBinding().getSoap().getIntegrationError().getInternal().getBadRequest(), "badRequest");
                this.checkHttpReturnCode(manifestOpenspcoop2.getBinding().getSoap().getIntegrationError().getInternal().getConflict(), "conflict");
                this.checkHttpReturnCode(manifestOpenspcoop2.getBinding().getSoap().getIntegrationError().getInternal().getLimitExceeded(), "limitExceeded");
                this.checkHttpReturnCode(manifestOpenspcoop2.getBinding().getSoap().getIntegrationError().getInternal().getTooManyRequests(), "tooManyRequests");
                this.checkHttpReturnCode(manifestOpenspcoop2.getBinding().getSoap().getIntegrationError().getInternal().getServiceUnavailable(), "serviceUnavailable");
                this.checkHttpReturnCode(manifestOpenspcoop2.getBinding().getSoap().getIntegrationError().getInternal().getEndpointRequestTimedOut(), "endpointRequestTimedOut");
                this.checkHttpReturnCode(manifestOpenspcoop2.getBinding().getSoap().getIntegrationError().getInternal().getBadResponse(), "badResponse");
                this.checkHttpReturnCode(manifestOpenspcoop2.getBinding().getSoap().getIntegrationError().getInternal().getInternalRequestError(), "internalRequestError");
                this.checkHttpReturnCode(manifestOpenspcoop2.getBinding().getSoap().getIntegrationError().getInternal().getInternalResponseError(), "internalResponseError");
                if (manifestOpenspcoop2.getBinding().getSoap().getIntegrationError().getExternal() == null) {
                    throw new Exception("Binding Soap for protocol [" + protocolManifest + "]: it has not defined the configuration for external error handling");
                }
                if (manifestOpenspcoop2.getBinding().getSoap().getIntegrationError().getExternal().getDefault() == null) {
                    throw new Exception("Binding Soap for protocol [" + protocolManifest + "]: it has not defined the default configuration for external error handling");
                }
                this.checkHttpReturnCode(manifestOpenspcoop2.getBinding().getSoap().getIntegrationError().getExternal().getDefault(), "default");
                this.checkHttpReturnCode(manifestOpenspcoop2.getBinding().getSoap().getIntegrationError().getExternal().getAuthentication(), "authentication");
                this.checkHttpReturnCode(manifestOpenspcoop2.getBinding().getSoap().getIntegrationError().getExternal().getAuthorization(), "authorization");
                this.checkHttpReturnCode(manifestOpenspcoop2.getBinding().getSoap().getIntegrationError().getExternal().getNotFound(), "notFound");
                this.checkHttpReturnCode(manifestOpenspcoop2.getBinding().getSoap().getIntegrationError().getExternal().getBadRequest(), "badRequest");
                this.checkHttpReturnCode(manifestOpenspcoop2.getBinding().getSoap().getIntegrationError().getExternal().getConflict(), "conflict");
                this.checkHttpReturnCode(manifestOpenspcoop2.getBinding().getSoap().getIntegrationError().getExternal().getLimitExceeded(), "limitExceeded");
                this.checkHttpReturnCode(manifestOpenspcoop2.getBinding().getSoap().getIntegrationError().getExternal().getTooManyRequests(), "tooManyRequests");
                this.checkHttpReturnCode(manifestOpenspcoop2.getBinding().getSoap().getIntegrationError().getExternal().getServiceUnavailable(), "serviceUnavailable");
                this.checkHttpReturnCode(manifestOpenspcoop2.getBinding().getSoap().getIntegrationError().getExternal().getEndpointRequestTimedOut(), "endpointRequestTimedOut");
                this.checkHttpReturnCode(manifestOpenspcoop2.getBinding().getSoap().getIntegrationError().getExternal().getBadResponse(), "badResponse");
                this.checkHttpReturnCode(manifestOpenspcoop2.getBinding().getSoap().getIntegrationError().getExternal().getInternalRequestError(), "internalRequestError");
                this.checkHttpReturnCode(manifestOpenspcoop2.getBinding().getSoap().getIntegrationError().getExternal().getInternalResponseError(), "internalResponseError");
                if (manifestOpenspcoop2.getBinding().getSoap().getMediaTypeCollection() == null) {
                    throw new Exception("Binding Soap for protocol [" + protocolManifest + "]: media type collection undefined");
                }
                if (manifestOpenspcoop2.getBinding().getSoap().getMediaTypeCollection().sizeMediaTypeList() <= 0 && manifestOpenspcoop2.getBinding().getSoap().getMediaTypeCollection().getDefault() == null && manifestOpenspcoop2.getBinding().getSoap().getMediaTypeCollection().getUndefined() == null) {
                    throw new Exception("Binding Soap for protocol [" + protocolManifest + "]: media type collection undefined");
                }
                soapEnabled = true;
            }
            boolean restEnabled = false;
            if (manifestOpenspcoop2.getBinding().getRest() != null) {
                if (!(manifestOpenspcoop2.getBinding().getRest().isBinary() || manifestOpenspcoop2.getBinding().getRest().isJson() || manifestOpenspcoop2.getBinding().getRest().isXml() || manifestOpenspcoop2.getBinding().getRest().isMimeMultipart())) {
                    throw new Exception("Binding Rest for protocol [" + protocolManifest + "]: none of the message types is enabled");
                }
                if (manifestOpenspcoop2.getBinding().getRest().getIntegrationError() == null) {
                    throw new Exception("Binding Rest for protocol [" + protocolManifest + "]: it has not defined the configuration for error handling");
                }
                if (manifestOpenspcoop2.getBinding().getRest().getIntegrationError().getInternal() == null) {
                    throw new Exception("Binding Rest for protocol [" + protocolManifest + "]: it has not defined the configuration for internal error handling");
                }
                if (manifestOpenspcoop2.getBinding().getRest().getIntegrationError().getInternal().getDefault() == null) {
                    throw new Exception("Binding Rest for protocol [" + protocolManifest + "]: it has not defined the default configuration for internal error handling");
                }
                this.checkHttpReturnCode(manifestOpenspcoop2.getBinding().getRest().getIntegrationError().getInternal().getDefault(), "default");
                this.checkHttpReturnCode(manifestOpenspcoop2.getBinding().getRest().getIntegrationError().getInternal().getAuthentication(), "authentication");
                this.checkHttpReturnCode(manifestOpenspcoop2.getBinding().getRest().getIntegrationError().getInternal().getAuthorization(), "authorization");
                this.checkHttpReturnCode(manifestOpenspcoop2.getBinding().getRest().getIntegrationError().getInternal().getNotFound(), "notFound");
                this.checkHttpReturnCode(manifestOpenspcoop2.getBinding().getRest().getIntegrationError().getInternal().getBadRequest(), "badRequest");
                this.checkHttpReturnCode(manifestOpenspcoop2.getBinding().getRest().getIntegrationError().getInternal().getConflict(), "conflict");
                this.checkHttpReturnCode(manifestOpenspcoop2.getBinding().getRest().getIntegrationError().getInternal().getLimitExceeded(), "limitExceeded");
                this.checkHttpReturnCode(manifestOpenspcoop2.getBinding().getRest().getIntegrationError().getInternal().getTooManyRequests(), "tooManyRequests");
                this.checkHttpReturnCode(manifestOpenspcoop2.getBinding().getRest().getIntegrationError().getInternal().getServiceUnavailable(), "serviceUnavailable");
                this.checkHttpReturnCode(manifestOpenspcoop2.getBinding().getRest().getIntegrationError().getInternal().getEndpointRequestTimedOut(), "endpointRequestTimedOut");
                this.checkHttpReturnCode(manifestOpenspcoop2.getBinding().getRest().getIntegrationError().getInternal().getBadResponse(), "badResponse");
                this.checkHttpReturnCode(manifestOpenspcoop2.getBinding().getRest().getIntegrationError().getInternal().getInternalRequestError(), "internalRequestError");
                this.checkHttpReturnCode(manifestOpenspcoop2.getBinding().getRest().getIntegrationError().getInternal().getInternalResponseError(), "internalResponseError");
                if (manifestOpenspcoop2.getBinding().getRest().getIntegrationError().getExternal() == null) {
                    throw new Exception("Binding Rest for protocol [" + protocolManifest + "]: it has not defined the configuration for external error handling");
                }
                if (manifestOpenspcoop2.getBinding().getRest().getIntegrationError().getExternal().getDefault() == null) {
                    throw new Exception("Binding Rest for protocol [" + protocolManifest + "]: it has not defined the default configuration for external error handling");
                }
                this.checkHttpReturnCode(manifestOpenspcoop2.getBinding().getRest().getIntegrationError().getExternal().getDefault(), "default");
                this.checkHttpReturnCode(manifestOpenspcoop2.getBinding().getRest().getIntegrationError().getExternal().getAuthentication(), "authentication");
                this.checkHttpReturnCode(manifestOpenspcoop2.getBinding().getRest().getIntegrationError().getExternal().getAuthorization(), "authorization");
                this.checkHttpReturnCode(manifestOpenspcoop2.getBinding().getRest().getIntegrationError().getExternal().getNotFound(), "notFound");
                this.checkHttpReturnCode(manifestOpenspcoop2.getBinding().getRest().getIntegrationError().getExternal().getBadRequest(), "badRequest");
                this.checkHttpReturnCode(manifestOpenspcoop2.getBinding().getRest().getIntegrationError().getExternal().getConflict(), "conflict");
                this.checkHttpReturnCode(manifestOpenspcoop2.getBinding().getRest().getIntegrationError().getExternal().getLimitExceeded(), "limitExceeded");
                this.checkHttpReturnCode(manifestOpenspcoop2.getBinding().getRest().getIntegrationError().getExternal().getTooManyRequests(), "tooManyRequests");
                this.checkHttpReturnCode(manifestOpenspcoop2.getBinding().getRest().getIntegrationError().getExternal().getServiceUnavailable(), "serviceUnavailable");
                this.checkHttpReturnCode(manifestOpenspcoop2.getBinding().getRest().getIntegrationError().getExternal().getEndpointRequestTimedOut(), "endpointRequestTimedOut");
                this.checkHttpReturnCode(manifestOpenspcoop2.getBinding().getRest().getIntegrationError().getExternal().getBadResponse(), "badResponse");
                this.checkHttpReturnCode(manifestOpenspcoop2.getBinding().getRest().getIntegrationError().getExternal().getInternalRequestError(), "internalRequestError");
                this.checkHttpReturnCode(manifestOpenspcoop2.getBinding().getRest().getIntegrationError().getExternal().getInternalResponseError(), "internalResponseError");
                if (manifestOpenspcoop2.getBinding().getRest().getMediaTypeCollection() == null) {
                    throw new Exception("Binding Rest for protocol [" + protocolManifest + "]: media type collection undefined");
                }
                if (manifestOpenspcoop2.getBinding().getRest().getMediaTypeCollection().sizeMediaTypeList() <= 0 && manifestOpenspcoop2.getBinding().getRest().getMediaTypeCollection().getDefault() == null && manifestOpenspcoop2.getBinding().getRest().getMediaTypeCollection().getUndefined() == null) {
                    throw new Exception("Binding Rest for protocol [" + protocolManifest + "]: media type collection undefined");
                }
                restEnabled = true;
            }
            for (int i = 0; i < manifestOpenspcoop2.getWeb().sizeContextList(); ++i) {
                String context = manifestOpenspcoop2.getWeb().getContext(i).getName();
                org.openspcoop2.protocol.manifest.constants.ServiceBinding serviceBinding = manifestOpenspcoop2.getWeb().getContext(i).getBinding();
                if (serviceBinding != null) {
                    if (org.openspcoop2.protocol.manifest.constants.ServiceBinding.REST.equals((Object)serviceBinding)) {
                        if (!restEnabled) {
                            throw new Exception("Binding Rest for protocol [" + protocolManifest + "] is disabled: cannot define restriction for web context " + context);
                        }
                    } else if (!soapEnabled) {
                        throw new Exception("Binding Soap for protocol [" + protocolManifest + "] is disabled: cannot define restriction for web context " + context);
                    }
                }
                for (int j = 0; j < manifestOpenspcoop2.getWeb().getContext(i).sizeSubContextList(); ++j) {
                    SubContextMapping subContext = manifestOpenspcoop2.getWeb().getContext(i).getSubContext(j);
                    this.checkMessageType(context, subContext.getBase(), subContext.getMessageType(), manifestOpenspcoop2.getBinding().getSoap(), manifestOpenspcoop2.getBinding().getRest());
                }
                if (manifestOpenspcoop2.getWeb().getContext(i).getEmptySubContext() != null) {
                    this.checkMessageType(context, "@EMPTY@", manifestOpenspcoop2.getWeb().getContext(i).getEmptySubContext().getMessageType(), manifestOpenspcoop2.getBinding().getSoap(), manifestOpenspcoop2.getBinding().getRest());
                }
                if (!(manifestOpenspcoop2.getWeb().getContext(i).getSoapMediaTypeCollection() == null || manifestOpenspcoop2.getWeb().getContext(i).getSoapMediaTypeCollection().sizeMediaTypeList() <= 0 && manifestOpenspcoop2.getWeb().getContext(i).getSoapMediaTypeCollection().getDefault() == null && manifestOpenspcoop2.getWeb().getContext(i).getSoapMediaTypeCollection().getUndefined() == null || soapEnabled)) {
                    throw new ProtocolException("(Context:" + context + ") SoapMediaType not supported; Soap disabled");
                }
                if (manifestOpenspcoop2.getWeb().getContext(i).getRestMediaTypeCollection() == null || manifestOpenspcoop2.getWeb().getContext(i).getRestMediaTypeCollection().sizeMediaTypeList() <= 0 && manifestOpenspcoop2.getWeb().getContext(i).getRestMediaTypeCollection().getDefault() == null && manifestOpenspcoop2.getWeb().getContext(i).getRestMediaTypeCollection().getUndefined() == null || restEnabled) continue;
                throw new ProtocolException("(Context:" + context + ") RestMediaType not supported; Rest disabled");
            }
            if (manifestOpenspcoop2.getWeb().getEmptyContext() != null) {
                org.openspcoop2.protocol.manifest.constants.ServiceBinding serviceBinding = manifestOpenspcoop2.getWeb().getEmptyContext().getBinding();
                if (serviceBinding != null) {
                    if (org.openspcoop2.protocol.manifest.constants.ServiceBinding.REST.equals((Object)serviceBinding)) {
                        if (!restEnabled) {
                            throw new Exception("Binding Rest for protocol [" + protocolManifest + "] is disabled: cannot define restriction for empty web context");
                        }
                    } else if (!soapEnabled) {
                        throw new Exception("Binding Soap for protocol [" + protocolManifest + "] is disabled: cannot define restriction for empty web context");
                    }
                }
                for (int j = 0; j < manifestOpenspcoop2.getWeb().getEmptyContext().sizeSubContextList(); ++j) {
                    SubContextMapping subContext = manifestOpenspcoop2.getWeb().getEmptyContext().getSubContext(j);
                    this.checkMessageType("@EMPTY@", subContext.getBase(), subContext.getMessageType(), manifestOpenspcoop2.getBinding().getSoap(), manifestOpenspcoop2.getBinding().getRest());
                }
                if (manifestOpenspcoop2.getWeb().getEmptyContext().getEmptySubContext() != null) {
                    this.checkMessageType("@EMPTY@", "@EMPTY@", manifestOpenspcoop2.getWeb().getEmptyContext().getEmptySubContext().getMessageType(), manifestOpenspcoop2.getBinding().getSoap(), manifestOpenspcoop2.getBinding().getRest());
                }
                if (!(manifestOpenspcoop2.getWeb().getEmptyContext().getSoapMediaTypeCollection() == null || manifestOpenspcoop2.getWeb().getEmptyContext().getSoapMediaTypeCollection().sizeMediaTypeList() <= 0 && manifestOpenspcoop2.getWeb().getEmptyContext().getSoapMediaTypeCollection().getDefault() == null && manifestOpenspcoop2.getWeb().getEmptyContext().getSoapMediaTypeCollection().getUndefined() == null || soapEnabled)) {
                    throw new ProtocolException("(Context:@EMPTY@) SoapMediaType not supported; Soap disabled");
                }
                if (!(manifestOpenspcoop2.getWeb().getEmptyContext().getRestMediaTypeCollection() == null || manifestOpenspcoop2.getWeb().getEmptyContext().getRestMediaTypeCollection().sizeMediaTypeList() <= 0 && manifestOpenspcoop2.getWeb().getEmptyContext().getRestMediaTypeCollection().getDefault() == null && manifestOpenspcoop2.getWeb().getEmptyContext().getRestMediaTypeCollection().getUndefined() == null || restEnabled)) {
                    throw new ProtocolException("(Context:@EMPTY@) RestMediaType not supported; Rest disabled");
                }
            }
            for (int i = 0; i < manifestOpenspcoop2.getRegistry().getService().getTypes().sizeTypeList(); ++i) {
                String serviceType = manifestOpenspcoop2.getRegistry().getService().getTypes().getType(i).getName();
                org.openspcoop2.protocol.manifest.constants.ServiceBinding serviceBinding = manifestOpenspcoop2.getRegistry().getService().getTypes().getType(i).getBinding();
                if (serviceBinding != null) {
                    if (org.openspcoop2.protocol.manifest.constants.ServiceBinding.REST.equals((Object)serviceBinding)) {
                        if (!restEnabled) {
                            throw new Exception("Binding Rest for protocol [" + protocolManifest + "] is disabled: cannot define restriction for service type " + serviceType);
                        }
                    } else if (!soapEnabled) {
                        throw new Exception("Binding Soap for protocol [" + protocolManifest + "] is disabled: cannot define restriction for service type " + serviceType);
                    }
                }
                if (!(manifestOpenspcoop2.getRegistry().getService().getTypes().getType(i).getSoapMediaTypeCollection() == null || manifestOpenspcoop2.getRegistry().getService().getTypes().getType(i).getSoapMediaTypeCollection().sizeMediaTypeList() <= 0 && manifestOpenspcoop2.getRegistry().getService().getTypes().getType(i).getSoapMediaTypeCollection().getDefault() == null && manifestOpenspcoop2.getRegistry().getService().getTypes().getType(i).getSoapMediaTypeCollection().getUndefined() == null || soapEnabled)) {
                    throw new ProtocolException("(ServiceType:" + serviceType + ") SoapMediaType not supported; Soap disabled");
                }
                if (manifestOpenspcoop2.getRegistry().getService().getTypes().getType(i).getRestMediaTypeCollection() == null || manifestOpenspcoop2.getRegistry().getService().getTypes().getType(i).getRestMediaTypeCollection().sizeMediaTypeList() <= 0 && manifestOpenspcoop2.getRegistry().getService().getTypes().getType(i).getRestMediaTypeCollection().getDefault() == null && manifestOpenspcoop2.getRegistry().getService().getTypes().getType(i).getRestMediaTypeCollection().getUndefined() == null || restEnabled) continue;
                throw new ProtocolException("(ServiceType:" + serviceType + ") RestMediaType not supported; Rest disabled");
            }
            if (soapEnabled && var14_25 == null) {
                throw new Exception("Service type not defined for protocol [" + protocolManifest + "] compatible with soap");
            }
            if (!restEnabled || tipoServizioDefaultRest != null) continue;
            throw new Exception("Service type not defined for protocol [" + protocolManifest + "] compatible with rest");
        }
        for (String protocolManifest : tmp_manifests.keySet()) {
            manifestOpenspcoop2 = tmp_manifests.get(protocolManifest);
            if (manifestOpenspcoop2.getBinding().getRest() != null) {
                if (manifestOpenspcoop2.getBinding().getRest().getIntegration() == null) {
                    throw new Exception("BindingIntegrationRest not defined for protocol [" + protocolManifest + "]");
                }
                Integration integrationRestConfig = manifestOpenspcoop2.getBinding().getRest().getIntegration();
                this.checkIntegration(integrationRestConfig, false, protocolManifest);
            }
            if (manifestOpenspcoop2.getBinding().getSoap() == null) continue;
            if (manifestOpenspcoop2.getBinding().getSoap().getIntegration() == null) {
                throw new Exception("BindingIntegrationSoap not defined for protocol [" + protocolManifest + "]");
            }
            Integration integrationSoapConfig = manifestOpenspcoop2.getBinding().getSoap().getIntegration();
            this.checkIntegration(integrationSoapConfig, true, protocolManifest);
        }
    }

    private void checkIntegration(Integration integrationConfig, boolean soap, String protocolManifest) throws Exception {
        String prefix;
        String string = prefix = soap ? "Soap" : "Rest";
        if (integrationConfig.getImplementation() == null) {
            throw new Exception("BindingIntegration" + prefix + ", implementation not defined for protocol [" + protocolManifest + "]");
        }
        IntegrationConfiguration integrationConfigImpl = integrationConfig.getImplementation();
        this.checkIntegration(integrationConfigImpl, soap, true, protocolManifest);
        if (integrationConfig.getSubscription() == null) {
            throw new Exception("BindingIntegration" + prefix + ", subscription not defined for protocol [" + protocolManifest + "]");
        }
        IntegrationConfiguration integrationConfigSub = integrationConfig.getSubscription();
        this.checkIntegration(integrationConfigSub, soap, false, protocolManifest);
    }

    private void checkIntegration(IntegrationConfiguration integrationConfig, boolean soap, boolean impl, String protocolManifest) throws Exception {
        Object prefix = soap ? "Soap" : "Rest";
        prefix = (String)prefix + (impl ? "Implementation" : "Subscription");
        if (integrationConfig.getName() == null || integrationConfig.getName().sizeParamList() <= 0) {
            throw new Exception("BindingIntegration" + (String)prefix + ", name not defined for protocol [" + protocolManifest + "]");
        }
        this.checkIntegrationName(integrationConfig.getName().getParamList(), protocolManifest, (String)prefix, "name", false, false);
        if (integrationConfig.getResourceIdentification() == null) {
            throw new Exception("BindingIntegration" + (String)prefix + ", resource identification not defined for protocol [" + protocolManifest + "]");
        }
        if (integrationConfig.getResourceIdentification().getIdentificationModes() == null || integrationConfig.getResourceIdentification().getIdentificationModes().sizeModeList() <= 0) {
            throw new Exception("BindingIntegration" + (String)prefix + ", resource identification modes not defined for protocol [" + protocolManifest + "]");
        }
        ResourceIdentificationType defaultR = integrationConfig.getResourceIdentification().getIdentificationModes().getDefault();
        if (defaultR == null) {
            if (integrationConfig.getResourceIdentification().getIdentificationModes().sizeModeList() > 1) {
                throw new Exception("BindingIntegration" + (String)prefix + ", resource identification default mode undefined for protocol [" + protocolManifest + "]");
            }
            defaultR = integrationConfig.getResourceIdentification().getIdentificationModes().getMode(0).getName();
        }
        boolean defaultFound = false;
        for (IntegrationConfigurationResourceIdentificationMode mode : integrationConfig.getResourceIdentification().getIdentificationModes().getModeList()) {
            if (!soap && ResourceIdentificationType.SOAP_ACTION.equals((Object)mode.getName())) {
                throw new Exception("BindingIntegration" + (String)prefix + ", resource identification mode '" + String.valueOf(mode.getName()) + "' not permit in rest binding, founded in protocol [" + protocolManifest + "]");
            }
            if (!impl && ResourceIdentificationType.PROTOCOL.equals((Object)mode.getName())) {
                throw new Exception("BindingIntegration" + (String)prefix + ", resource identification mode '" + String.valueOf(mode.getName()) + "' not permit in subscription binding, founded in protocol [" + protocolManifest + "]");
            }
            if (defaultR == null || !mode.getName().equals((Object)defaultR)) continue;
            defaultFound = true;
        }
        if (!defaultFound) {
            throw new Exception("BindingIntegration" + (String)prefix + ", resource identification default mode '" + String.valueOf(defaultR) + "' not found in supported modes for protocol [" + protocolManifest + "]");
        }
        if (ResourceIdentificationType.CONTENT.equals((Object)defaultR) || ResourceIdentificationType.HEADER.equals((Object)defaultR) || ResourceIdentificationType.URL.equals((Object)defaultR)) {
            if (integrationConfig.getResourceIdentification().getIdentificationParameter() == null || integrationConfig.getResourceIdentification().getIdentificationParameter().sizeParamList() <= 0) {
                throw new Exception("BindingIntegration" + (String)prefix + ", resource identification default mode '" + String.valueOf(defaultR) + "' require identification parameter for protocol [" + protocolManifest + "]");
            }
            this.checkIntegrationName(integrationConfig.getResourceIdentification().getIdentificationParameter().getParamList(), protocolManifest, (String)prefix, "identificationParameter", true, false);
        }
        if (integrationConfig.getResourceIdentification().getSpecificResource() == null) {
            throw new Exception("BindingIntegration" + (String)prefix + ", specific resource config not defined for protocol [" + protocolManifest + "]");
        }
        if (integrationConfig.getResourceIdentification().getSpecificResource().getName() == null || integrationConfig.getResourceIdentification().getSpecificResource().getName().sizeParamList() <= 0) {
            throw new Exception("BindingIntegration" + (String)prefix + ", specific resource name undefined for protocol [" + protocolManifest + "]");
        }
        this.checkIntegrationName(integrationConfig.getResourceIdentification().getSpecificResource().getName().getParamList(), protocolManifest, (String)prefix, "specific resource name", true, true);
    }

    private void checkIntegrationName(List<IntegrationConfigurationElementName> list, String protocolManifest, String prefix, String object, boolean namePermit, boolean ruleNamePermit) throws Exception {
        for (IntegrationConfigurationElementName name : list) {
            if (name == null) {
                throw new Exception("BindingIntegration" + prefix + ", " + object + " not defined for protocol [" + protocolManifest + "]");
            }
            if ((name.getPrefix() == null || "".equals(name.getPrefix())) && name.getActor() == null && (name.getSuffix() == null || "".equals(name.getSuffix()))) {
                throw new Exception("BindingIntegration" + prefix + ", " + object + " with wrong param (prefix, actor and suffix undefined) for protocol [" + protocolManifest + "]");
            }
            if (ActorType.NAME.equals((Object)name.getActor()) && !namePermit) {
                throw new Exception("BindingIntegration" + prefix + ", " + object + " with wrong param (actor '" + String.valueOf(name.getActor()) + "' not permit in this context) for protocol [" + protocolManifest + "]");
            }
            if (!ActorType.RULE_NAME.equals((Object)name.getActor()) || ruleNamePermit) continue;
            throw new Exception("BindingIntegration" + prefix + ", " + object + " with wrong param (actor '" + String.valueOf(name.getActor()) + "' not permit in this context) for protocol [" + protocolManifest + "]");
        }
    }

    private void checkHttpReturnCode(DefaultIntegrationError ir, String function) throws ProtocolException {
        if (ir != null) {
            int httpReturnCode = ir.getErrorCode().getHttp();
            this.checkHttpReturnCode(httpReturnCode, function + ".http");
            int govwayReturnCode = ir.getErrorCode().getGovway();
            this.checkHttpReturnCode(govwayReturnCode, function + ".govway");
        }
    }

    private void checkHttpReturnCode(IntegrationError ir, String function) throws ProtocolException {
        if (ir != null) {
            int httpReturnCode = ir.getErrorCode().getHttp();
            this.checkHttpReturnCode(httpReturnCode, function + ".http");
            int govwayReturnCode = ir.getErrorCode().getGovway();
            this.checkHttpReturnCode(govwayReturnCode, function + ".rfc7807");
        }
    }

    private void checkHttpReturnCode(int httpReturnCode, String function) throws ProtocolException {
        String msgError = "The value provided (" + httpReturnCode + ") is not used as http return code (use [200,299],[400-599])";
        if (httpReturnCode < 200) {
            throw new ProtocolException(msgError);
        }
        if (httpReturnCode >= 300 && httpReturnCode < 400) {
            throw new ProtocolException(msgError);
        }
        if (httpReturnCode >= 600) {
            throw new ProtocolException(msgError);
        }
    }

    private void checkMessageType(String context, String subContext, MessageType messageType, SoapConfiguration soapBinding, RestConfiguration restBinding) throws ProtocolException {
        if (MessageType.XML.equals((Object)messageType)) {
            if (restBinding == null) {
                throw new ProtocolException("(Context:" + context + " SubContext:" + subContext + ") MessageType [" + String.valueOf(messageType) + "] not supported; Rest disabled");
            }
            if (!restBinding.isXml()) {
                throw new ProtocolException("(Context:" + context + " SubContext:" + subContext + ") MessageType [" + String.valueOf(messageType) + "] not supported in RestBinding; Xml disabled");
            }
        } else if (MessageType.JSON.equals((Object)messageType)) {
            if (restBinding == null) {
                throw new ProtocolException("(Context:" + context + " SubContext:" + subContext + ") MessageType [" + String.valueOf(messageType) + "] not supported; Rest disabled");
            }
            if (!restBinding.isJson()) {
                throw new ProtocolException("(Context:" + context + " SubContext:" + subContext + ") MessageType [" + String.valueOf(messageType) + "] not supported in RestBinding; Json disabled");
            }
        } else if (MessageType.BINARY.equals((Object)messageType)) {
            if (restBinding == null) {
                throw new ProtocolException("(Context:" + context + " SubContext:" + subContext + ") MessageType [" + String.valueOf(messageType) + "] not supported; Rest disabled");
            }
            if (!restBinding.isBinary()) {
                throw new ProtocolException("(Context:" + context + " SubContext:" + subContext + ") MessageType [" + String.valueOf(messageType) + "] not supported in RestBinding; Binary disabled");
            }
        } else if (MessageType.MIME_MULTIPART.equals((Object)messageType)) {
            if (restBinding == null) {
                throw new ProtocolException("(Context:" + context + " SubContext:" + subContext + ") MessageType [" + String.valueOf(messageType) + "] not supported; Rest disabled");
            }
            if (!restBinding.isMimeMultipart()) {
                throw new ProtocolException("(Context:" + context + " SubContext:" + subContext + ") MessageType [" + String.valueOf(messageType) + "] not supported in RestBinding; MimeMultipart disabled");
            }
        } else if (MessageType.SOAP_11.equals((Object)messageType)) {
            if (soapBinding == null) {
                throw new ProtocolException("(Context:" + context + " SubContext:" + subContext + ") MessageType [" + String.valueOf(messageType) + "] not supported; Soap disabled");
            }
            if (!soapBinding.isSoap11()) {
                throw new ProtocolException("(Context:" + context + " SubContext:" + subContext + ") MessageType [" + String.valueOf(messageType) + "] not supported in SoapBinding; Soap11 disabled");
            }
        } else if (MessageType.SOAP_12.equals((Object)messageType)) {
            if (soapBinding == null) {
                throw new ProtocolException("(Context:" + context + " SubContext:" + subContext + ") MessageType [" + String.valueOf(messageType) + "] not supported; Soap disabled");
            }
            if (!soapBinding.isSoap12()) {
                throw new ProtocolException("(Context:" + context + " SubContext:" + subContext + ") MessageType [" + String.valueOf(messageType) + "] not supported in SoapBinding; Soap12 disabled");
            }
        } else {
            throw new ProtocolException("(Context:" + context + " SubContext:" + subContext + ") MessageType [" + String.valueOf(messageType) + "] not supported in Binding");
        }
    }

    private IProtocolFactory<?> getProtocolFactoryEngine(Openspcoop2 openspcoop2Manifest) throws ProtocolException {
        String factoryClass = null;
        try {
            factoryClass = openspcoop2Manifest.getProtocol().getFactory();
            IProtocolFactory p = (IProtocolFactory)ClassLoaderUtilities.newInstance((String)factoryClass);
            return p;
        }
        catch (Exception e) {
            throw new ProtocolException("Impossibile caricare la factory indicata [" + factoryClass + "] " + String.valueOf(e), (Throwable)e);
        }
    }

    public Openspcoop2 getProtocolManifest(HttpServletRequest request, FunctionContextsCustom customContexts) throws ProtocolException {
        URLProtocolContextImpl urlProtocolContext = null;
        try {
            urlProtocolContext = new URLProtocolContextImpl(request, this.log, true, customContexts);
        }
        catch (Exception e) {
            throw new ProtocolException("Impossibile recuperare il nome del contesto dalla request: ServletContext[" + request.getContextPath() + "] RequestURI[" + request.getRequestURI() + "]", (Throwable)e);
        }
        return this.getProtocolManifest(urlProtocolContext.getProtocolWebContext());
    }

    public Openspcoop2 getProtocolManifest(String servletContextName) throws ProtocolException {
        try {
            for (Openspcoop2 openspcoop2Manifest : this.manifests.values()) {
                Web webContext = openspcoop2Manifest.getWeb();
                if ("@EMPTY@".equals(servletContextName)) {
                    if (webContext.getEmptyContext() == null || !webContext.getEmptyContext().getEnabled()) continue;
                    return openspcoop2Manifest;
                }
                for (int i = 0; i < webContext.sizeContextList(); ++i) {
                    if (!webContext.getContext(i).getName().equals(servletContextName)) continue;
                    return openspcoop2Manifest;
                }
            }
            throw new ProtocolException("Contesto [" + servletContextName + "] non assegnato a nessun protocollo");
        }
        catch (Exception e) {
            throw new ProtocolException("Impossibile individuare il protocollo assegnato al contesto [" + servletContextName + "]: " + String.valueOf(e), (Throwable)e);
        }
    }

    public IProtocolFactory<?> getProtocolFactoryByServletContext(HttpServletRequest request, FunctionContextsCustom customContexts) throws ProtocolException {
        Openspcoop2 m = this.getProtocolManifest(request, customContexts);
        if (this.factories.containsKey((Object)m.getProtocol().getName())) {
            return (IProtocolFactory)this.factories.get((Object)m.getProtocol().getName());
        }
        throw new ProtocolException("ProtocolPlugin with name [" + m.getProtocol().getName() + "] not found");
    }

    public IProtocolFactory<?> getProtocolFactoryByServletContext(String servletContext) throws ProtocolException {
        Openspcoop2 m = this.getProtocolManifest(servletContext);
        if (this.factories.containsKey((Object)m.getProtocol().getName())) {
            return (IProtocolFactory)this.factories.get((Object)m.getProtocol().getName());
        }
        throw new ProtocolException("ProtocolPlugin with name [" + m.getProtocol().getName() + "] not found");
    }

    public IProtocolFactory<?> getProtocolFactoryByName(String protocol) throws ProtocolException {
        if (this.factories.containsKey((Object)protocol)) {
            return (IProtocolFactory)this.factories.get((Object)protocol);
        }
        throw new ProtocolException("ProtocolPlugin with name [" + protocol + "] not found");
    }

    public boolean existsProtocolFactory(String protocol) {
        return this.factories.containsKey((Object)protocol);
    }

    public IProtocolFactory<?> getProtocolFactoryByOrganizationType(String organizationType) throws ProtocolException {
        String protocol = this.getProtocolByOrganizationType(organizationType);
        return this.getProtocolFactoryByName(protocol);
    }

    public IProtocolFactory<?> getProtocolFactoryByServiceType(String serviceType) throws ProtocolException {
        String protocol = this.getProtocolByServiceType(serviceType);
        return this.getProtocolFactoryByName(protocol);
    }

    public IProtocolFactory<?> getProtocolFactoryWithEmptyContext() throws ProtocolException {
        Openspcoop2 m = this.getProtocolManifest("@EMPTY@");
        if (this.factories.containsKey((Object)m.getProtocol().getName())) {
            return (IProtocolFactory)this.factories.get((Object)m.getProtocol().getName());
        }
        return null;
    }

    public IDService getDefaultServiceForWebContext(String context) throws ProtocolException {
        IProtocolFactory<?> pf = this.getProtocolFactoryByServletContext(context);
        if (pf == null) {
            return null;
        }
        if (pf.getManifest().getWeb().sizeContextList() <= 0) {
            return null;
        }
        FunctionType fType = null;
        for (int i = 0; i < pf.getManifest().getWeb().sizeContextList(); ++i) {
            if (!pf.getManifest().getWeb().getContext(i).getName().equals(context)) continue;
            fType = pf.getManifest().getWeb().getContext(i).getEmptyFunction();
            break;
        }
        if (fType == null) {
            return null;
        }
        switch (fType) {
            case PD: {
                return IDService.PORTA_DELEGATA;
            }
            case PA: {
                return IDService.PORTA_APPLICATIVA;
            }
            case PDTO_SOAP: {
                return IDService.PORTA_DELEGATA_XML_TO_SOAP;
            }
        }
        return null;
    }

    public IDService getDefaultServiceForEmptyContext() throws ProtocolException {
        IProtocolFactory<?> pf = this.getProtocolFactoryWithEmptyContext();
        if (pf == null) {
            return null;
        }
        if (pf.getManifest().getWeb().getEmptyContext() == null) {
            return null;
        }
        FunctionType fType = pf.getManifest().getWeb().getEmptyContext().getEmptyFunction();
        if (fType == null) {
            return null;
        }
        switch (fType) {
            case PD: {
                return IDService.PORTA_DELEGATA;
            }
            case PA: {
                return IDService.PORTA_APPLICATIVA;
            }
            case PDTO_SOAP: {
                return IDService.PORTA_DELEGATA_XML_TO_SOAP;
            }
        }
        return null;
    }

    public IProtocolFactory<?> getDefaultProtocolFactory() throws ProtocolException {
        try {
            if (this.factories.size() == 1) {
                return (IProtocolFactory)this.factories.get((Object)((String)this.factories.keys().nextElement()));
            }
            if (this.protocolDefault == null) {
                throw new Exception("Non e' stato definito un protocollo di default e sono stati riscontrati piu' protocolli disponibili (size:" + this.factories.size() + ")");
            }
            if (this.factories.containsKey((Object)this.protocolDefault)) {
                return (IProtocolFactory)this.factories.get((Object)this.protocolDefault);
            }
            throw new Exception("Il protocollo di default [" + this.protocolDefault + "] indicato non corrisponde a nessuno di quelli caricati");
        }
        catch (Exception e) {
            throw new ProtocolException("Impossibile individuare il protocollo assegnato al contesto: " + String.valueOf(e), (Throwable)e);
        }
    }

    public MapReader<String, List<String>> getOrganizationTypes() {
        return this.tipiSoggettiValidi;
    }

    public String[] getOrganizationTypesAsArray() {
        Enumeration listeTipiSoggettiValidi = this.tipiSoggettiValidi.elements();
        ArrayList listaTipiSoggetti = new ArrayList();
        while (listeTipiSoggettiValidi.hasMoreElements()) {
            listaTipiSoggetti.addAll((Collection)listeTipiSoggettiValidi.nextElement());
        }
        return listaTipiSoggetti.toArray(new String[1]);
    }

    public List<String> getOrganizationTypesAsList() {
        Enumeration listeTipiSoggettiValidi = this.tipiSoggettiValidi.elements();
        ArrayList<String> listaTipiSoggetti = new ArrayList<String>();
        while (listeTipiSoggettiValidi.hasMoreElements()) {
            listaTipiSoggetti.addAll((Collection)listeTipiSoggettiValidi.nextElement());
        }
        return listaTipiSoggetti;
    }

    public MapReader<String, String> getDefaultOrganizationTypes() {
        return this.tipiSoggettiDefault;
    }

    public HashMap<String, List<String>> _getServiceTypes() {
        MapReader<String, List<String>> soap;
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        MapReader<String, List<String>> rest = this.getServiceTypes(org.openspcoop2.protocol.manifest.constants.ServiceBinding.REST);
        if (rest != null && rest.size() > 0) {
            Enumeration en = rest.keys();
            while (en.hasMoreElements()) {
                String protocollo = (String)en.nextElement();
                map.put(protocollo, (List)rest.get((Object)protocollo));
            }
        }
        if ((soap = this.getServiceTypes(org.openspcoop2.protocol.manifest.constants.ServiceBinding.SOAP)) != null && soap.size() > 0) {
            Enumeration en = soap.keys();
            while (en.hasMoreElements()) {
                String protocollo = (String)en.nextElement();
                if (map.containsKey(protocollo)) {
                    List<String> restP = map.get(protocollo);
                    List soapP = (List)soap.get((Object)protocollo);
                    for (String tipo : soapP) {
                        if (restP.contains(tipo)) continue;
                        restP.add(tipo);
                    }
                    continue;
                }
                map.put(protocollo, (List)soap.get((Object)protocollo));
            }
        }
        return map;
    }

    public MapReader<String, List<String>> getServiceTypes(org.openspcoop2.protocol.manifest.constants.ServiceBinding serviceBinding) {
        if (org.openspcoop2.protocol.manifest.constants.ServiceBinding.SOAP.equals((Object)serviceBinding)) {
            return this.tipiServiziValidi_soap;
        }
        return this.tipiServiziValidi_rest;
    }

    public String[] getServiceTypesAsArray(org.openspcoop2.protocol.manifest.constants.ServiceBinding serviceBinding) {
        Enumeration listeTipiServiziValidi = null;
        listeTipiServiziValidi = org.openspcoop2.protocol.manifest.constants.ServiceBinding.SOAP.equals((Object)serviceBinding) ? this.tipiServiziValidi_soap.elements() : this.tipiServiziValidi_rest.elements();
        ArrayList listaTipiServizi = new ArrayList();
        while (listeTipiServiziValidi.hasMoreElements()) {
            listaTipiServizi.addAll((Collection)listeTipiServiziValidi.nextElement());
        }
        return listaTipiServizi.toArray(new String[1]);
    }

    public List<String> getServiceTypesAsList(org.openspcoop2.protocol.manifest.constants.ServiceBinding serviceBinding) {
        Enumeration listeTipiServiziValidi = null;
        listeTipiServiziValidi = org.openspcoop2.protocol.manifest.constants.ServiceBinding.SOAP.equals((Object)serviceBinding) ? this.tipiServiziValidi_soap.elements() : this.tipiServiziValidi_rest.elements();
        ArrayList<String> listaTipiServizi = new ArrayList<String>();
        while (listeTipiServiziValidi.hasMoreElements()) {
            listaTipiServizi.addAll((Collection)listeTipiServiziValidi.nextElement());
        }
        return listaTipiServizi;
    }

    public MapReader<String, String> getDefaultServiceTypes(org.openspcoop2.protocol.manifest.constants.ServiceBinding serviceBinding) {
        if (org.openspcoop2.protocol.manifest.constants.ServiceBinding.SOAP.equals((Object)serviceBinding)) {
            return this.tipiServiziDefault_soap;
        }
        return this.tipiServiziDefault_rest;
    }

    public MapReader<String, List<String>> getVersion() {
        return this.versioniValide;
    }

    public String[] getVersionAsArray() {
        Enumeration listeVersioniValidi = this.versioniValide.elements();
        ArrayList listaVersioni = new ArrayList();
        while (listeVersioniValidi.hasMoreElements()) {
            listaVersioni.addAll((Collection)listeVersioniValidi.nextElement());
        }
        return listaVersioni.toArray(new String[1]);
    }

    public List<String> getVersionAsList() {
        Enumeration listeVersioniValide = this.versioniValide.elements();
        ArrayList<String> listaVersioni = new ArrayList<String>();
        while (listeVersioniValide.hasMoreElements()) {
            listaVersioni.addAll((Collection)listeVersioniValide.nextElement());
        }
        return listaVersioni;
    }

    public MapReader<String, String> getDefaultVersion() {
        return this.versioniDefault;
    }

    public MapReader<String, IProtocolFactory<?>> getProtocolFactories() {
        return this.factories;
    }

    public Enumeration<String> getProtocolNames() {
        return this.factories.keys();
    }

    public List<String> getProtocolNamesAsList() {
        ArrayList<String> protocolli = new ArrayList<String>();
        Enumeration<String> en = this.getProtocolNames();
        while (en.hasMoreElements()) {
            String protocollo = en.nextElement();
            protocolli.add(protocollo);
        }
        return protocolli;
    }

    public void initStaticInstance() throws ProtocolException {
        Enumeration en;
        if (this.factories != null && this.factories.size() > 0 && (en = this.factories.elements()) != null) {
            while (en.hasMoreElements()) {
                IProtocolFactory iProtocolFactory = (IProtocolFactory)en.nextElement();
                if (iProtocolFactory == null || !(iProtocolFactory instanceof BasicFactory)) continue;
                ((BasicFactory)iProtocolFactory).initStaticInstance();
            }
        }
    }

    public String getProtocolByOrganizationType(String organizationType) throws ProtocolException {
        Enumeration protocolli = this.factories.keys();
        while (protocolli.hasMoreElements()) {
            String protocollo = (String)protocolli.nextElement();
            IProtocolFactory protocolFactory = (IProtocolFactory)this.factories.get((Object)protocollo);
            List tipiP = protocolFactory.createProtocolConfiguration().getTipiSoggetti();
            if (!tipiP.contains(organizationType)) continue;
            return protocollo;
        }
        throw new ProtocolException("Non esiste un protocollo associato al tipo di soggetto [" + organizationType + "]");
    }

    public String getProtocolByServiceType(String serviceType) throws ProtocolException {
        Enumeration protocolli = this.factories.keys();
        while (protocolli.hasMoreElements()) {
            String protocollo = (String)protocolli.nextElement();
            IProtocolFactory protocolFactory = (IProtocolFactory)this.factories.get((Object)protocollo);
            List tipiP = protocolFactory.createProtocolConfiguration().getTipiServizi(ServiceBinding.SOAP);
            if (tipiP.contains(serviceType)) {
                return protocollo;
            }
            tipiP = protocolFactory.createProtocolConfiguration().getTipiServizi(ServiceBinding.REST);
            if (!tipiP.contains(serviceType)) continue;
            return protocollo;
        }
        throw new ProtocolException("Non esiste un protocollo associato al tipo di servizio [" + serviceType + "]");
    }
}

