/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.lib.audit.log.utils.serializer;

import jakarta.xml.bind.JAXBElement;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import org.openspcoop2.generic_project.exception.SerializerException;
import org.openspcoop2.utils.beans.WriteToSerializerType;
import org.openspcoop2.utils.xml.JaxbUtils;
import org.openspcoop2.web.lib.audit.log.Binary;
import org.openspcoop2.web.lib.audit.log.Operation;

public abstract class AbstractSerializer {
    protected abstract WriteToSerializerType getType();

    protected void _objToXml(OutputStream out, Class<?> c, Object object, boolean prettyPrint) throws Exception {
        if (object instanceof JAXBElement) {
            JaxbUtils.objToXml((OutputStream)out, c, (Object)object, (boolean)prettyPrint);
        } else {
            Method m = c.getMethod("writeTo", OutputStream.class, WriteToSerializerType.class);
            m.invoke(object, out, this.getType());
        }
    }

    protected void objToXml(OutputStream out, Class<?> c, Object object, boolean prettyPrint) throws SerializerException {
        try {
            this._objToXml(out, c, object, prettyPrint);
        }
        catch (Exception e) {
            throw new SerializerException(e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                out.flush();
            }
            catch (Exception exception) {}
        }
    }

    protected void objToXml(String fileName, Class<?> c, Object object, boolean prettyPrint) throws SerializerException {
        try {
            this.objToXml(new File(fileName), c, object, prettyPrint);
        }
        catch (Exception e) {
            throw new SerializerException(e.getMessage(), (Throwable)e);
        }
    }

    protected void objToXml(File file, Class<?> c, Object object, boolean prettyPrint) throws SerializerException {
        FileOutputStream fout = null;
        try {
            fout = new FileOutputStream(file);
            this._objToXml(fout, c, object, prettyPrint);
        }
        catch (Exception e) {
            throw new SerializerException(e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                if (fout != null) {
                    fout.flush();
                }
            }
            catch (Exception exception) {}
            try {
                if (fout != null) {
                    fout.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    protected ByteArrayOutputStream objToXml(Class<?> c, Object object, boolean prettyPrint) throws SerializerException {
        ByteArrayOutputStream bout = null;
        try {
            bout = new ByteArrayOutputStream();
            this._objToXml(bout, c, object, prettyPrint);
        }
        catch (Exception e) {
            throw new SerializerException(e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                if (bout != null) {
                    bout.flush();
                }
            }
            catch (Exception exception) {}
            try {
                if (bout != null) {
                    bout.close();
                }
            }
            catch (Exception exception) {}
        }
        return bout;
    }

    public void write(String fileName, Operation operation) throws SerializerException {
        this.objToXml(fileName, Operation.class, (Object)operation, false);
    }

    public void write(String fileName, Operation operation, boolean prettyPrint) throws SerializerException {
        this.objToXml(fileName, Operation.class, (Object)operation, prettyPrint);
    }

    public void write(File file, Operation operation) throws SerializerException {
        this.objToXml(file, Operation.class, (Object)operation, false);
    }

    public void write(File file, Operation operation, boolean prettyPrint) throws SerializerException {
        this.objToXml(file, Operation.class, (Object)operation, prettyPrint);
    }

    public void write(OutputStream out, Operation operation) throws SerializerException {
        this.objToXml(out, Operation.class, (Object)operation, false);
    }

    public void write(OutputStream out, Operation operation, boolean prettyPrint) throws SerializerException {
        this.objToXml(out, Operation.class, (Object)operation, prettyPrint);
    }

    public byte[] toByteArray(Operation operation) throws SerializerException {
        return this.objToXml(Operation.class, operation, false).toByteArray();
    }

    public byte[] toByteArray(Operation operation, boolean prettyPrint) throws SerializerException {
        return this.objToXml(Operation.class, operation, prettyPrint).toByteArray();
    }

    public String toString(Operation operation) throws SerializerException {
        return this.objToXml(Operation.class, operation, false).toString();
    }

    public String toString(Operation operation, boolean prettyPrint) throws SerializerException {
        return this.objToXml(Operation.class, operation, prettyPrint).toString();
    }

    public void write(String fileName, Binary binary) throws SerializerException {
        this.objToXml(fileName, Binary.class, (Object)binary, false);
    }

    public void write(String fileName, Binary binary, boolean prettyPrint) throws SerializerException {
        this.objToXml(fileName, Binary.class, (Object)binary, prettyPrint);
    }

    public void write(File file, Binary binary) throws SerializerException {
        this.objToXml(file, Binary.class, (Object)binary, false);
    }

    public void write(File file, Binary binary, boolean prettyPrint) throws SerializerException {
        this.objToXml(file, Binary.class, (Object)binary, prettyPrint);
    }

    public void write(OutputStream out, Binary binary) throws SerializerException {
        this.objToXml(out, Binary.class, (Object)binary, false);
    }

    public void write(OutputStream out, Binary binary, boolean prettyPrint) throws SerializerException {
        this.objToXml(out, Binary.class, (Object)binary, prettyPrint);
    }

    public byte[] toByteArray(Binary binary) throws SerializerException {
        return this.objToXml(Binary.class, binary, false).toByteArray();
    }

    public byte[] toByteArray(Binary binary, boolean prettyPrint) throws SerializerException {
        return this.objToXml(Binary.class, binary, prettyPrint).toByteArray();
    }

    public String toString(Binary binary) throws SerializerException {
        return this.objToXml(Binary.class, binary, false).toString();
    }

    public String toString(Binary binary, boolean prettyPrint) throws SerializerException {
        return this.objToXml(Binary.class, binary, prettyPrint).toString();
    }
}

