/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.protocol.modipa.validator;

import jakarta.xml.soap.SOAPBody;
import jakarta.xml.soap.SOAPElement;
import jakarta.xml.soap.SOAPEnvelope;
import jakarta.xml.soap.SOAPHeader;
import jakarta.xml.soap.SOAPHeaderElement;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import org.openspcoop2.message.OpenSPCoop2Message;
import org.openspcoop2.message.OpenSPCoop2MessageFactory;
import org.openspcoop2.message.OpenSPCoop2SoapMessage;
import org.openspcoop2.message.constants.MessageRole;
import org.openspcoop2.message.constants.MessageType;
import org.openspcoop2.message.exception.MessageException;
import org.openspcoop2.message.exception.MessageNotSupportedException;
import org.openspcoop2.message.soap.reference.Reference;
import org.openspcoop2.message.soap.wsaddressing.WSAddressingHeader;
import org.openspcoop2.security.SecurityException;
import org.openspcoop2.security.message.MessageSecurityContext;
import org.openspcoop2.security.message.wss4j.MessageSecurityReceiver_wss4j;
import org.w3c.dom.Node;

public class ModISOAPSecurity {
    private SOAPHeaderElement securityHeader;
    private WSAddressingHeader wsAddressingHeader;
    private SOAPHeaderElement requestDigestHeader;
    private String wsuIdBodyRef;
    private MessageSecurityReceiver_wss4j wss4jSignature;
    private MessageSecurityContext messageSecurityContext;
    private List<Reference> elementsToClean;

    public SOAPHeaderElement getSecurityHeader() {
        return this.securityHeader;
    }

    public void setSecurityHeader(SOAPHeaderElement securityHeader) {
        this.securityHeader = securityHeader;
    }

    public WSAddressingHeader getWsAddressingHeader() {
        return this.wsAddressingHeader;
    }

    public void setWsAddressingHeader(WSAddressingHeader wsAddressingHeader) {
        this.wsAddressingHeader = wsAddressingHeader;
    }

    public SOAPHeaderElement getRequestDigestHeader() {
        return this.requestDigestHeader;
    }

    public void setRequestDigestHeader(SOAPHeaderElement requestDigestHeader) {
        this.requestDigestHeader = requestDigestHeader;
    }

    public String getWsuIdBodyRef() {
        return this.wsuIdBodyRef;
    }

    public void setWsuIdBodyRef(String wsuIdBodyRef) {
        this.wsuIdBodyRef = wsuIdBodyRef;
    }

    public List<Reference> getElementsToClean() {
        return this.elementsToClean;
    }

    public void setElementsToClean(List<Reference> elementsToClean) {
        this.elementsToClean = elementsToClean;
    }

    public MessageSecurityReceiver_wss4j getWss4jSignature() {
        return this.wss4jSignature;
    }

    public void setWss4jSignature(MessageSecurityReceiver_wss4j wss4jSignature) {
        this.wss4jSignature = wss4jSignature;
    }

    public MessageSecurityContext getMessageSecurityContext() {
        return this.messageSecurityContext;
    }

    public void setMessageSecurityContext(MessageSecurityContext messageSecurityContext) {
        this.messageSecurityContext = messageSecurityContext;
    }

    public void clean(OpenSPCoop2SoapMessage soapMessage) throws SecurityException, MessageException, MessageNotSupportedException {
        SOAPHeader header;
        boolean detachValue = true;
        boolean removeAllIdRefValue = true;
        this.wss4jSignature.cleanDirtyElements(this.messageSecurityContext, soapMessage, this.elementsToClean, detachValue, removeAllIdRefValue);
        if ((this.wsAddressingHeader != null || this.requestDigestHeader != null) && (header = soapMessage.getSOAPHeader()) != null) {
            if (this.wsAddressingHeader != null) {
                if (this.wsAddressingHeader.getTo() != null) {
                    this.removeHeader(header, this.wsAddressingHeader.getTo());
                }
                if (this.wsAddressingHeader.getFrom() != null) {
                    this.removeHeader(header, this.wsAddressingHeader.getFrom());
                }
                if (this.wsAddressingHeader.getAction() != null) {
                    this.removeHeader(header, this.wsAddressingHeader.getAction());
                }
                if (this.wsAddressingHeader.getId() != null) {
                    this.removeHeader(header, this.wsAddressingHeader.getId());
                }
                if (this.wsAddressingHeader.getRelatesTo() != null) {
                    this.removeHeader(header, this.wsAddressingHeader.getRelatesTo());
                }
                if (this.wsAddressingHeader.getReplyTo() != null) {
                    this.removeHeader(header, this.wsAddressingHeader.getReplyTo());
                }
                if (this.wsAddressingHeader.getFaultTo() != null) {
                    this.removeHeader(header, this.wsAddressingHeader.getFaultTo());
                }
            }
            if (this.requestDigestHeader != null) {
                this.removeHeader(header, this.requestDigestHeader);
            }
        }
    }

    private void removeHeader(SOAPHeader hdr, SOAPHeaderElement soapHeader) {
        Iterator it = hdr.examineAllHeaderElements();
        while (it.hasNext()) {
            SOAPHeaderElement headerElementCheck = (SOAPHeaderElement)it.next();
            if (soapHeader.getNamespaceURI() == null ? headerElementCheck.getNamespaceURI() != null : headerElementCheck.getNamespaceURI() == null || !soapHeader.getNamespaceURI().equals(headerElementCheck.getNamespaceURI())) continue;
            if (soapHeader.getLocalName() == null ? headerElementCheck.getLocalName() != null : headerElementCheck.getLocalName() == null || !soapHeader.getLocalName().equals(headerElementCheck.getLocalName())) continue;
            if (soapHeader.getPrefix() != null ? headerElementCheck.getPrefix() == null || !soapHeader.getPrefix().equals(headerElementCheck.getPrefix()) : headerElementCheck.getPrefix() != null) continue;
            hdr.removeChild((Node)headerElementCheck);
            break;
        }
    }

    public SOAPEnvelope buildTraccia(MessageType type) throws MessageException {
        try {
            SOAPBody body;
            OpenSPCoop2Message msg = OpenSPCoop2MessageFactory.getDefaultMessageFactory().createEmptyMessage(type, MessageRole.NONE);
            OpenSPCoop2SoapMessage soapMessage = msg.castAsSoap();
            SOAPHeader header = soapMessage.getSOAPHeader();
            if (header == null) {
                header = soapMessage.getSOAPPart().getEnvelope().addHeader();
            }
            boolean add = false;
            if (this.securityHeader != null) {
                header.addChildElement((SOAPElement)this.securityHeader);
                add = true;
            }
            if (this.wsAddressingHeader != null) {
                if (this.wsAddressingHeader.getTo() != null) {
                    header.addChildElement((SOAPElement)this.wsAddressingHeader.getTo());
                    add = true;
                }
                if (this.wsAddressingHeader.getFrom() != null) {
                    header.addChildElement((SOAPElement)this.wsAddressingHeader.getFrom());
                    add = true;
                }
                if (this.wsAddressingHeader.getAction() != null) {
                    header.addChildElement((SOAPElement)this.wsAddressingHeader.getAction());
                    add = true;
                }
                if (this.wsAddressingHeader.getId() != null) {
                    header.addChildElement((SOAPElement)this.wsAddressingHeader.getId());
                    add = true;
                }
                if (this.wsAddressingHeader.getRelatesTo() != null) {
                    header.addChildElement((SOAPElement)this.wsAddressingHeader.getRelatesTo());
                    add = true;
                }
                if (this.wsAddressingHeader.getReplyTo() != null) {
                    header.addChildElement((SOAPElement)this.wsAddressingHeader.getReplyTo());
                    add = true;
                }
                if (this.wsAddressingHeader.getFaultTo() != null) {
                    header.addChildElement((SOAPElement)this.wsAddressingHeader.getFaultTo());
                    add = true;
                }
            }
            if (this.requestDigestHeader != null) {
                header.addChildElement((SOAPElement)this.requestDigestHeader);
                add = true;
            }
            if ((body = soapMessage.getSOAPBody()) == null) {
                body = soapMessage.getSOAPPart().getEnvelope().addBody();
            }
            if (this.wsuIdBodyRef != null) {
                QName qname = new QName("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Id", "wsu");
                body.addAttribute(qname, this.wsuIdBodyRef);
            }
            body.setTextContent("...");
            if (add) {
                return soapMessage.getSOAPPart().getEnvelope();
            }
            return null;
        }
        catch (Exception e) {
            throw new MessageException(e.getMessage(), (Throwable)e);
        }
    }
}

