/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.protocol.as4.services.message;

import java.io.File;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.oasis_open.docs.ebxml_msg.ebms.v3_0.ns.core._200704.UserMessage;
import org.openspcoop2.core.constants.Costanti;
import org.openspcoop2.message.OpenSPCoop2Message;
import org.openspcoop2.message.OpenSPCoop2MessageFactory;
import org.openspcoop2.message.OpenSPCoop2MessageParseResult;
import org.openspcoop2.message.constants.MessageRole;
import org.openspcoop2.message.constants.MessageType;
import org.openspcoop2.message.constants.ServiceBinding;
import org.openspcoop2.message.soap.reader.OpenSPCoop2MessageSoapStreamReader;
import org.openspcoop2.pdd.config.OpenSPCoop2Properties;
import org.openspcoop2.pdd.core.PdDContext;
import org.openspcoop2.pdd.core.controllo_traffico.SogliaDimensioneMessaggio;
import org.openspcoop2.pdd.core.controllo_traffico.SogliaReadTimeout;
import org.openspcoop2.pdd.logger.MsgDiagnostico;
import org.openspcoop2.pdd.logger.OpenSPCoop2Logger;
import org.openspcoop2.pdd.services.connector.ConnectorException;
import org.openspcoop2.pdd.services.connector.ConnectorUtils;
import org.openspcoop2.pdd.services.connector.RicezioneBusteConnector;
import org.openspcoop2.pdd.services.connector.messages.ConnectorInMessage;
import org.openspcoop2.protocol.as4.config.AS4Properties;
import org.openspcoop2.protocol.as4.constants.AS4Costanti;
import org.openspcoop2.protocol.engine.ProtocolFactoryManager;
import org.openspcoop2.protocol.engine.URLProtocolContextImpl;
import org.openspcoop2.protocol.sdk.Context;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.protocol.sdk.constants.IDService;
import org.openspcoop2.protocol.sdk.state.RequestInfo;
import org.openspcoop2.protocol.sdk.state.URLProtocolContext;
import org.openspcoop2.utils.LimitExceededIOException;
import org.openspcoop2.utils.LoggerWrapperFactory;
import org.openspcoop2.utils.date.DateManager;
import org.openspcoop2.utils.io.DumpByteArrayOutputStream;
import org.openspcoop2.utils.io.notifier.NotifierInputStreamParams;
import org.openspcoop2.utils.transport.Credential;
import org.openspcoop2.utils.transport.TransportRequestContext;
import org.openspcoop2.utils.transport.TransportUtils;
import org.slf4j.Logger;

public class AS4ConnectorInMessage
implements ConnectorInMessage {
    private OpenSPCoop2Message message;
    private Logger log;
    private String idModulo;
    private IDService idModuloAsIDService;
    private RequestInfo requestInfo;
    private IProtocolFactory<?> protocolFactory;
    private String function;
    private String url;
    private PdDContext pddContext;
    private Date dataIngressoRichiesta;
    protected OpenSPCoop2Properties openspcoopProperties;
    private Context context;
    private String idTransazione;
    private int soglia;
    private File repositoryFile;
    private SogliaReadTimeout requestReadTimeout;
    private SogliaDimensioneMessaggio requestLimitSize;
    private boolean useDiagnosticInputStream;
    private MsgDiagnostico msgDiagnostico;
    private Map<String, Object> attributes = new HashMap<String, Object>();
    private Map<String, List<String>> headers = new HashMap<String, List<String>>();
    private Map<String, List<String>> parameters = new HashMap<String, List<String>>();

    public AS4ConnectorInMessage(UserMessage userMessage, Map<String, byte[]> content) throws ConnectorException {
        try {
            this.message = OpenSPCoop2MessageFactory.getDefaultMessageFactory().createEmptyMessage(MessageType.SOAP_12, MessageRole.REQUEST);
            this.message.addContextProperty(AS4Costanti.AS4_CONTEXT_USER_MESSAGE, (Object)userMessage);
            this.message.addContextProperty(AS4Costanti.AS4_CONTEXT_CONTENT, content);
            this.openspcoopProperties = OpenSPCoop2Properties.getInstance();
            this.log = OpenSPCoop2Logger.getLoggerOpenSPCoopCore();
            if (this.log == null) {
                this.log = LoggerWrapperFactory.getLogger(AS4ConnectorInMessage.class);
            }
            this.idModuloAsIDService = RicezioneBusteConnector.ID_SERVICE;
            this.idModulo = "RicezioneBuste_JmsDomibus";
            this.protocolFactory = ProtocolFactoryManager.getInstance().getProtocolFactoryByName("as4");
            this.function = "PA";
            this.url = "/as4/" + this.function;
            this.pddContext = new PdDContext();
            URLProtocolContextImpl urlProtocolContext = new URLProtocolContextImpl(this.log);
            HashMap<String, List<String>> pFormBased = new HashMap<String, List<String>>();
            pFormBased.putAll(this.parameters);
            urlProtocolContext.setParameters(pFormBased);
            HashMap<String, List<String>> pTrasporto = new HashMap<String, List<String>>();
            pTrasporto.putAll(this.headers);
            urlProtocolContext.setHeaders(pTrasporto);
            urlProtocolContext.setFunction(this.function);
            urlProtocolContext.setProtocol(this.protocolFactory.getProtocol(), ((org.openspcoop2.protocol.manifest.Context)this.protocolFactory.getManifest().getWeb().getContextList().get(0)).getName());
            urlProtocolContext.setRequestURI(this.url);
            urlProtocolContext.setWebContext("/openspcoop2");
            urlProtocolContext.setSource("domibus/jmsQueue/" + AS4Properties.getInstance().getDomibusGatewayJMS_queueReceiver());
            this.requestInfo = ConnectorUtils.getRequestInfo(this.protocolFactory, (URLProtocolContext)urlProtocolContext);
            this.setAttribute((String)((Object)Costanti.REQUEST_INFO.getValue()), this.requestInfo);
            if (this.openspcoopProperties != null) {
                this.useDiagnosticInputStream = this.openspcoopProperties.isConnettoriUseDiagnosticInputStreamRicezioneBuste();
            }
            this.message.setTransportRequestContext((TransportRequestContext)urlProtocolContext);
        }
        catch (Exception e) {
            throw new ConnectorException(e.getMessage(), (Throwable)e);
        }
    }

    public void setThresholdContext(Context context, int soglia, File repositoryFile) {
        this.context = context;
        if (this.context != null) {
            this.idTransazione = (String)this.context.getObject(Costanti.ID_TRANSAZIONE);
        }
        this.soglia = soglia;
        this.repositoryFile = repositoryFile;
    }

    public void setRequestReadTimeout(SogliaReadTimeout timeout) {
        this.requestReadTimeout = timeout;
    }

    public void disableReadTimeout() {
    }

    public void setRequestLimitedStream(SogliaDimensioneMessaggio requestLimitSize) {
        this.requestLimitSize = requestLimitSize;
    }

    public void disableLimitedStream() {
    }

    public void checkContentLengthLimit() throws LimitExceededIOException {
    }

    public void setDiagnosticProducer(Context context, MsgDiagnostico msgDiag) {
        if (this.context == null) {
            this.context = context;
        }
        this.msgDiagnostico = msgDiag;
    }

    public IDService getIdModuloAsIDService() {
        return this.idModuloAsIDService;
    }

    public String getIdModulo() {
        return this.idModulo;
    }

    public void updateRequestInfo(RequestInfo requestInfo) throws ConnectorException {
        this.requestInfo = requestInfo;
        if (this.pddContext != null) {
            this.setAttribute((String)((Object)Costanti.REQUEST_INFO.getValue()), this.requestInfo);
        }
    }

    public RequestInfo getRequestInfo() {
        return this.requestInfo;
    }

    public MessageType getRequestMessageType() {
        return this.message.getMessageType();
    }

    public void setAttribute(String key, Object object) {
        this.attributes.put(key, object);
    }

    public Object getAttribute(String key) throws ConnectorException {
        return this.attributes.get(key);
    }

    public void addHeader(String key, String value) {
        TransportUtils.addHeader(this.headers, (String)key, (String)value);
    }

    public List<String> getHeaderValues(String key) throws ConnectorException {
        return (List)TransportUtils.getRawObject(this.headers, (String)key);
    }

    public void addParameter(String key, String value) {
        TransportUtils.addParameter(this.parameters, (String)key, (String)value);
    }

    public List<String> getParameterValues(String key) throws ConnectorException {
        return (List)TransportUtils.getRawObject(this.parameters, (String)key);
    }

    public IProtocolFactory<?> getProtocolFactory() throws ConnectorException {
        return this.protocolFactory;
    }

    public String getContentType() throws ConnectorException {
        try {
            return this.message.getContentType();
        }
        catch (Exception e) {
            throw new ConnectorException(e.getMessage(), (Throwable)e);
        }
    }

    public String getSOAPAction() throws ConnectorException {
        try {
            return this.message.castAsSoap().getSoapAction();
        }
        catch (Exception e) {
            throw new ConnectorException(e.getMessage(), (Throwable)e);
        }
    }

    public OpenSPCoop2MessageSoapStreamReader getSoapReader() throws ConnectorException {
        if (this.message != null && ServiceBinding.SOAP.equals((Object)this.message.getServiceBinding())) {
            try {
                return this.message.castAsSoap().getSoapReader();
            }
            catch (Exception e) {
                throw new ConnectorException(e.getMessage(), (Throwable)e);
            }
        }
        return null;
    }

    public OpenSPCoop2MessageParseResult getRequest(NotifierInputStreamParams notifierInputStreamParams) throws ConnectorException {
        try {
            OpenSPCoop2MessageParseResult pr = new OpenSPCoop2MessageParseResult();
            pr.setMessage(this.message);
            this.dataIngressoRichiesta = DateManager.getDate();
            return pr;
        }
        catch (Exception e) {
            throw new ConnectorException(e.getMessage(), (Throwable)e);
        }
    }

    public DumpByteArrayOutputStream getRequest() throws ConnectorException {
        return this.getRequest(true);
    }

    public DumpByteArrayOutputStream getRequest(boolean consume) throws ConnectorException {
        try {
            this.dataIngressoRichiesta = DateManager.getDate();
            return null;
        }
        catch (Exception e) {
            throw new ConnectorException(e.getMessage(), (Throwable)e);
        }
    }

    public Date getDataIngressoRichiesta() {
        return this.dataIngressoRichiesta;
    }

    public URLProtocolContext getURLProtocolContext() throws ConnectorException {
        try {
            return this.requestInfo.getProtocolContext();
        }
        catch (Exception e) {
            throw new ConnectorException(e.getMessage(), (Throwable)e);
        }
    }

    public Credential getCredential() throws ConnectorException {
        return null;
    }

    public String getSource() throws ConnectorException {
        return "DomibusJMS_" + this.function;
    }

    public String getProtocol() throws ConnectorException {
        return "DomibusJMS";
    }

    public int getContentLength() throws ConnectorException {
        return -1;
    }

    public String getRemoteAddress() throws ConnectorException {
        return "DomibusJMS";
    }

    public void close() throws ConnectorException {
    }
}

