/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.protocol.as4.services;

import jakarta.jms.MapMessage;
import jakarta.jms.Message;
import jakarta.servlet.ServletException;
import jakarta.xml.soap.SOAPFault;
import java.util.Date;
import java.util.HashMap;
import org.oasis_open.docs.ebxml_msg.ebms.v3_0.ns.core._200704.UserMessage;
import org.openspcoop2.message.OpenSPCoop2MessageFactory;
import org.openspcoop2.message.OpenSPCoop2RestMessage;
import org.openspcoop2.message.OpenSPCoop2SoapMessage;
import org.openspcoop2.message.constants.ServiceBinding;
import org.openspcoop2.message.soap.SoapUtils;
import org.openspcoop2.pdd.services.connector.ConnectorUtils;
import org.openspcoop2.pdd.services.connector.messages.ConnectorInMessage;
import org.openspcoop2.pdd.services.connector.messages.ConnectorOutMessage;
import org.openspcoop2.pdd.services.error.RicezioneBusteExternalErrorGenerator;
import org.openspcoop2.pdd.services.service.RicezioneBusteService;
import org.openspcoop2.protocol.as4.config.AS4Properties;
import org.openspcoop2.protocol.as4.services.AbstractRicezioneConnector;
import org.openspcoop2.protocol.as4.services.RicezioneBusteConnettoreUtils;
import org.openspcoop2.protocol.as4.services.message.AS4ConnectorInMessage;
import org.openspcoop2.protocol.as4.services.message.AS4ConnectorOutMessage;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.utils.LoggerWrapperFactory;
import org.openspcoop2.utils.Utilities;
import org.openspcoop2.utils.date.DateManager;
import org.openspcoop2.utils.threads.RunnableLogger;
import org.slf4j.Logger;

public class RicezioneBusteConnector
extends AbstractRicezioneConnector {
    public RicezioneBusteConnector(RunnableLogger runnableLog, AS4Properties asProperties) throws Exception {
        super(runnableLog, asProperties, false);
    }

    @Override
    protected void check(Message mapParam) throws Exception {
        OpenSPCoop2SoapMessage soapMsg;
        Date dataAccettazioneRichiesta = DateManager.getDate();
        MapMessage map = null;
        if (!(mapParam instanceof MapMessage)) {
            throw new Exception("Tipo di messaggio [" + mapParam.getClass().getName() + "] non atteso");
        }
        map = (MapMessage)mapParam;
        RicezioneBusteConnettoreUtils utils = new RicezioneBusteConnettoreUtils(this.log);
        HashMap<String, byte[]> content = new HashMap<String, byte[]>();
        UserMessage userMessage = new UserMessage();
        utils.fillUserMessage(map, userMessage, content);
        AS4ConnectorInMessage as4In = null;
        try {
            as4In = new AS4ConnectorInMessage(userMessage, content);
        }
        catch (Exception e) {
            ConnectorUtils.getErrorLog().error("AS4ConnectorInMessage init error: " + e.getMessage(), (Throwable)e);
            throw new ServletException(e.getMessage(), (Throwable)e);
        }
        IProtocolFactory<?> protocolFactory = null;
        try {
            protocolFactory = as4In.getProtocolFactory();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        AS4ConnectorOutMessage as4Out = null;
        try {
            as4Out = new AS4ConnectorOutMessage();
        }
        catch (Exception e) {
            ConnectorUtils.getErrorLog().error("AS4ConnectorOutMessage init error: " + e.getMessage(), (Throwable)e);
            throw new ServletException(e.getMessage(), (Throwable)e);
        }
        RicezioneBusteExternalErrorGenerator generatoreErrore = null;
        try {
            generatoreErrore = new RicezioneBusteExternalErrorGenerator(protocolFactory != null ? protocolFactory.getLogger() : LoggerWrapperFactory.getLogger(this.getClass()), org.openspcoop2.pdd.services.connector.RicezioneBusteConnector.ID_MODULO, as4In.getRequestInfo(), null);
        }
        catch (Exception e) {
            throw new Exception("Inizializzazione Generatore Errore fallita: " + Utilities.readFirstErrorValidMessageFromException((Throwable)e), e);
        }
        RicezioneBusteService ricezioneBuste = new RicezioneBusteService(generatoreErrore);
        try {
            ricezioneBuste.process((ConnectorInMessage)as4In, (ConnectorOutMessage)as4Out, dataAccettazioneRichiesta, false);
        }
        catch (Exception e) {
            ConnectorUtils.getErrorLog().error("RicezioneBusteConnector.process error: " + e.getMessage(), (Throwable)e);
            throw new ServletException(e.getMessage(), (Throwable)e);
        }
        if (as4Out.getResponseStatus() != 200 && as4Out.getResponseStatus() != 202) {
            if (as4Out.getMessage() != null) {
                if (ServiceBinding.SOAP.equals((Object)as4Out.getMessage().getServiceBinding())) {
                    OpenSPCoop2SoapMessage soapMsg2 = as4Out.getMessage().castAsSoap();
                    if (soapMsg2.getSOAPBody() != null && soapMsg2.getSOAPBody().hasFault()) {
                        throw new Exception("Servizio Ricezione Buste terminato con codice '" + as4Out.getResponseStatus() + "' e con un soapFault: " + SoapUtils.safe_toString((OpenSPCoop2MessageFactory)soapMsg2.getFactory(), (SOAPFault)soapMsg2.getSOAPBody().getFault(), (Logger)this.log.getLog()));
                    }
                    throw new Exception("Servizio Ricezione Buste terminato con codice (Messaggio SOAP senza Fault): " + as4Out.getResponseStatus());
                }
                OpenSPCoop2RestMessage restMsg = as4Out.getMessage().castAsRest();
                if (restMsg.isFault() && restMsg.hasContent()) {
                    throw new Exception("Servizio Ricezione Buste terminato con codice '" + as4Out.getResponseStatus() + "' e con un restFault: " + restMsg.getContentAsString());
                }
                throw new Exception("Servizio Ricezione Buste terminato con codice (Messaggio SOAP senza Fault): " + as4Out.getResponseStatus());
            }
            throw new Exception("Servizio Ricezione Buste terminato con codice: " + as4Out.getResponseStatus());
        }
        if (as4Out.getMessage() != null && (soapMsg = as4Out.getMessage().castAsSoap()).getSOAPBody() != null && soapMsg.getSOAPBody().hasFault()) {
            throw new Exception("Servizio Ricezione Buste terminato con un soapFault: " + SoapUtils.safe_toString((OpenSPCoop2MessageFactory)soapMsg.getFactory(), (SOAPFault)soapMsg.getSOAPBody().getFault(), (Logger)this.log.getLog()));
        }
    }
}

