/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.protocol.as4.pmode.beans;

import java.util.ArrayList;
import java.util.List;
import org.openspcoop2.utils.xml.XMLUtils;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PayloadProfile {
    private String name;
    private Long maxSize;
    private List<String> attachments;

    public PayloadProfile(Node node) throws Exception {
        this.name = node.getAttributes().getNamedItem("name").getNodeValue();
        this.maxSize = Long.parseLong(node.getAttributes().getNamedItem("maxSize").getNodeValue());
        NodeList attachments = XMLUtils.getInstance().getAsDocument(node).getElementsByTagName("attachment");
        this.attachments = new ArrayList<String>();
        for (int i = 0; i < attachments.getLength(); ++i) {
            Node item = attachments.item(i);
            Node namedItem = item.getAttributes().getNamedItem("name");
            this.attachments.add(namedItem.getNodeValue());
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Long getMaxSize() {
        return this.maxSize;
    }

    public String getMaxSizeAsString() {
        return this.maxSize.toString();
    }

    public void setMaxSize(Long maxSize) {
        this.maxSize = maxSize;
    }

    public List<String> getAttachments() {
        return this.attachments;
    }

    public void setAttachments(List<String> attachments) {
        this.attachments = attachments;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PayloadProfile)) {
            return false;
        }
        PayloadProfile p = (PayloadProfile)obj;
        if (!this.name.equals(p.getName())) {
            return false;
        }
        if (!this.maxSize.equals(p.getMaxSize())) {
            return false;
        }
        if (this.attachments.size() != p.getAttachments().size()) {
            return false;
        }
        for (String att : this.attachments) {
            if (p.getAttachments().contains(att)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuilder bf = new StringBuilder();
        if (this.name != null) {
            bf.append("name");
            bf.append(":");
            bf.append(this.name);
        }
        if (this.maxSize != null) {
            if (bf.length() > 0) {
                bf.append("\n");
            }
            bf.append("maxSize");
            bf.append(":");
            bf.append(this.maxSize);
        }
        if (this.attachments != null) {
            if (bf.length() > 0) {
                bf.append("\n");
            }
            bf.append("attachments");
            bf.append(":");
            bf.append(this.attachments.size());
        }
        return bf.toString();
    }

    public int hashCode() {
        return this.toString().hashCode();
    }
}

