/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.protocol.as4.config;

import org.openspcoop2.core.constants.TipoPdD;
import org.openspcoop2.message.constants.ServiceBinding;
import org.openspcoop2.protocol.as4.config.AS4Properties;
import org.openspcoop2.protocol.basic.config.BasicConfiguration;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.protocol.sdk.constants.FunzionalitaProtocollo;
import org.openspcoop2.utils.transport.TransportRequestContext;

public class AS4ProtocolConfiguration
extends BasicConfiguration {
    private AS4Properties properties = AS4Properties.getInstance();

    public AS4ProtocolConfiguration(IProtocolFactory<?> factory) throws ProtocolException {
        super(factory);
    }

    public ServiceBinding getProtocolServiceBinding(ServiceBinding integrationServiceBinding, TransportRequestContext transportRequest) throws ProtocolException {
        return ServiceBinding.SOAP;
    }

    public boolean isIntegrationInfoRequired(TipoPdD tipoPdD, ServiceBinding serviceBinding, FunzionalitaProtocollo funzionalitaProtocollo) throws ProtocolException {
        if (FunzionalitaProtocollo.RIFERIMENTO_ID_RICHIESTA.equals((Object)funzionalitaProtocollo)) {
            if (TipoPdD.DELEGATA.equals((Object)tipoPdD)) {
                return this.properties.isRiferimentoIDRichiesta_PD_Required();
            }
            return this.properties.isRiferimentoIDRichiesta_PA_Required();
        }
        return super.isIntegrationInfoRequired(tipoPdD, serviceBinding, funzionalitaProtocollo);
    }

    public boolean isDataPresenteInIdentificativoMessaggio() {
        return this.properties.generateIDasUUID() == false;
    }
}

