/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.query.impl.predicates;

import com.hazelcast.internal.serialization.BinaryInterface;
import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.query.PartitionPredicate;
import com.hazelcast.query.Predicate;
import com.hazelcast.query.impl.predicates.PredicateDataSerializerHook;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.Set;

@BinaryInterface
public class MultiPartitionPredicateImpl<K, V>
implements PartitionPredicate<K, V>,
IdentifiedDataSerializable {
    private static final Random RANDOM = new Random();
    private Set<? extends Object> partitionKeys;
    private Predicate<K, V> target;

    public MultiPartitionPredicateImpl() {
    }

    public MultiPartitionPredicateImpl(Set<? extends Object> partitionKeys, Predicate<K, V> target) {
        this.partitionKeys = Preconditions.checkNotNull(partitionKeys, "partitionKeys can't be null");
        Preconditions.checkTrue(partitionKeys.size() > 0, "partitionKeys must not be empty");
        this.target = Preconditions.checkNotNull(target, "target predicate can't be null");
    }

    @Override
    public Collection<? extends Object> getPartitionKeys() {
        return this.partitionKeys;
    }

    @Override
    public Object getPartitionKey() {
        if (this.partitionKeys.size() == 1) {
            return this.getSinglePartitionKey();
        }
        return this.partitionKeys.stream().skip(RANDOM.nextInt(this.partitionKeys.size())).findFirst().get();
    }

    @Override
    public Predicate<K, V> getTarget() {
        return this.target;
    }

    @Override
    public boolean apply(Map.Entry<K, V> mapEntry) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getFactoryId() {
        return PredicateDataSerializerHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 21;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeObject(this.partitionKeys);
        out.writeObject(this.target);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.partitionKeys = (Set)in.readObject();
        this.target = (Predicate)in.readObject();
    }

    public String toString() {
        return "MultiPartitionPredicate{partitionKeys=" + this.partitionKeys + ", target=" + this.target + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MultiPartitionPredicateImpl that = (MultiPartitionPredicateImpl)o;
        return Objects.equals(this.partitionKeys, that.partitionKeys) && Objects.equals(this.target, that.target);
    }

    public int hashCode() {
        int result = this.partitionKeys != null ? this.partitionKeys.hashCode() : 0;
        result = 31 * result + (this.target != null ? this.target.hashCode() : 0);
        return result;
    }

    private Object getSinglePartitionKey() {
        Iterator<? extends Object> iterator = this.partitionKeys.iterator();
        if (iterator.hasNext()) {
            Object key = iterator.next();
            return key;
        }
        throw new RuntimeException("Unreachable branch. PartitionPredicateImpl constructor should check and throw if partitionKeys is empty");
    }
}

