/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.processor;

import com.hazelcast.function.BiFunctionEx;
import com.hazelcast.jet.Traverser;
import com.hazelcast.jet.core.Inbox;
import com.hazelcast.jet.core.ProcessorSupplier;
import com.hazelcast.jet.impl.processor.AsyncTransformUsingServiceOrderedP;
import com.hazelcast.jet.impl.processor.ProcessorSupplierWithService;
import com.hazelcast.jet.pipeline.ServiceFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class AsyncTransformUsingServiceBatchedP<C, S, T, R>
extends AsyncTransformUsingServiceOrderedP<C, S, List<T>, Traverser<R>, R> {
    private final int maxBatchSize;

    public AsyncTransformUsingServiceBatchedP(@Nonnull ServiceFactory<C, S> serviceFactory, @Nullable C serviceContext, int maxConcurrentOps, int maxBatchSize, @Nonnull BiFunctionEx<? super S, ? super List<T>, ? extends CompletableFuture<Traverser<R>>> callAsyncFn) {
        super(serviceFactory, serviceContext, maxConcurrentOps, callAsyncFn, (? super T i, ? super IR r) -> r);
        this.maxBatchSize = maxBatchSize;
    }

    @Override
    public void process(int ordinal, @Nonnull Inbox inbox) {
        if (!this.makeRoomInQueue()) {
            return;
        }
        ArrayList batch = new ArrayList(Math.min(inbox.size(), this.maxBatchSize));
        inbox.drainTo(batch, this.maxBatchSize);
        boolean res = super.tryProcessInt(batch);
        assert (res);
    }

    public static <C, S, T, R> ProcessorSupplier supplier(@Nonnull ServiceFactory<C, S> serviceFactory, int maxConcurrentOps, int maxBatchSize, @Nonnull BiFunctionEx<? super S, ? super List<T>, ? extends CompletableFuture<Traverser<R>>> callAsyncFn) {
        return ProcessorSupplierWithService.supplierWithService(serviceFactory, (factory, context) -> new AsyncTransformUsingServiceBatchedP(factory, context, maxConcurrentOps, maxBatchSize, callAsyncFn));
    }
}

