/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.accumulator;

import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class PickAnyAccumulator<T> {
    private T value;

    public PickAnyAccumulator() {
    }

    public PickAnyAccumulator(T value) {
        this.value = value;
    }

    public void accumulate(@Nullable T t) {
        if (t == null) {
            return;
        }
        if (this.value == null) {
            this.value = t;
        }
    }

    public void combine(@Nonnull PickAnyAccumulator<T> other) {
        if (this.value == null) {
            this.value = other.value;
        }
    }

    public T get() {
        return this.value;
    }

    public boolean equals(Object o) {
        return this == o || o != null && this.getClass() == o.getClass() && Objects.equals(this.value, ((PickAnyAccumulator)o).value);
    }

    public int hashCode() {
        long hc = 17L;
        hc = 73L * hc + (long)(this.value != null ? this.value.hashCode() : 0);
        return Long.hashCode(hc);
    }

    public String toString() {
        return "MutableReference(" + this.value + ')';
    }
}

