/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.tpcengine.util;

import com.hazelcast.internal.tpcengine.util.UnsafeLocator;

public final class OS {
    private static final String OS_NAME = System.getProperty("os.name", "?");
    private static final String OS_VERSION = System.getProperty("os.version", "?");
    private static final boolean IS_LINUX = OS.isLinux0(OS_NAME);
    private static final boolean IS_WINDOWS = OS.isWindows0(OS_NAME);
    private static final boolean IS_MAC = OS.isMac0(OS_NAME);
    private static final int LINUX_KERNEL_MAJOR_VERSION = OS.linuxMajorVersion0(OS_VERSION, IS_LINUX);
    private static final int LINUX_KERNEL_MINOR_VERSION = OS.linuxMinorVersion0(OS_VERSION, IS_LINUX);
    private static final int PAGE_SIZE = UnsafeLocator.UNSAFE.pageSize();
    private static final String OS_ARCH = System.getProperty("os.arch", "?");
    private static final boolean IS_64BIT = OS.is64bit0(OS_ARCH);
    private static final boolean IS_X86_64 = OS_ARCH.equals("amd64");

    private OS() {
    }

    private static boolean is64bit0(String osArch) {
        return osArch.contains("64");
    }

    static boolean isLinux0(String osName) {
        return osName.toLowerCase().startsWith("linux");
    }

    static boolean isWindows0(String osName) {
        osName = osName.toLowerCase();
        return osName.contains("windows");
    }

    static boolean isMac0(String osName) {
        return (osName = osName.toLowerCase()).contains("mac") || osName.contains("darwin");
    }

    static int linuxMajorVersion0(String version, boolean isLinux) {
        if (!isLinux) {
            return -1;
        }
        String[] versionTokens = version.split("\\.");
        try {
            return Integer.parseInt(versionTokens[0]);
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    static int linuxMinorVersion0(String version, boolean isLinux) {
        if (!isLinux) {
            return -1;
        }
        String[] versionTokens = version.split("\\.");
        try {
            return Integer.parseInt(versionTokens[1]);
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    public static boolean isX86_64() {
        return IS_X86_64;
    }

    public static int pageSize() {
        return PAGE_SIZE;
    }

    public static boolean isLinux() {
        return IS_LINUX;
    }

    public static String osName() {
        return OS_NAME;
    }

    public static String osVersion() {
        return OS_VERSION;
    }

    public static String osArch() {
        return OS_ARCH;
    }

    public static int linuxKernelMajorVersion() {
        if (!IS_LINUX) {
            throw new IllegalStateException(OS_NAME + " is not a Linux OS");
        }
        return LINUX_KERNEL_MAJOR_VERSION;
    }

    public static int linuxKernelMinorVersion() {
        if (!IS_LINUX) {
            throw new IllegalStateException(OS_NAME + " is not a Linux OS");
        }
        return LINUX_KERNEL_MINOR_VERSION;
    }

    public static boolean is64bit() {
        return IS_64BIT;
    }

    public static boolean isMac() {
        return IS_MAC;
    }

    public static boolean isWindows() {
        return IS_WINDOWS;
    }
}

