/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.serialization.impl;

import com.hazelcast.internal.util.ConstructorFunction;
import com.hazelcast.internal.util.VersionAwareConstructorFunction;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.nio.serialization.impl.VersionedDataSerializableFactory;
import com.hazelcast.version.Version;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class ArrayDataSerializableFactory
implements VersionedDataSerializableFactory {
    private final ConstructorFunction<Integer, IdentifiedDataSerializable>[] constructors;
    private final int len;

    public ArrayDataSerializableFactory(ConstructorFunction<Integer, IdentifiedDataSerializable>[] ctorArray) {
        if (ctorArray == null || ctorArray.length <= 0) {
            throw new IllegalArgumentException("ConstructorFunction array cannot be null");
        }
        this.len = ctorArray.length;
        this.constructors = new ConstructorFunction[this.len];
        System.arraycopy(ctorArray, 0, this.constructors, 0, this.len);
    }

    @Override
    @Nullable
    public IdentifiedDataSerializable create(int typeId) {
        if (typeId >= 0 && typeId < this.len) {
            ConstructorFunction<Integer, IdentifiedDataSerializable> factory = this.constructors[typeId];
            return factory != null ? factory.createNew(typeId) : null;
        }
        return null;
    }

    @Override
    @Nullable
    public IdentifiedDataSerializable create(int typeId, Version clusterVersion, Version wanProtocolVersion) {
        if (typeId >= 0 && typeId < this.len) {
            ConstructorFunction<Integer, IdentifiedDataSerializable> factory = this.constructors[typeId];
            if (factory == null) {
                return null;
            }
            if (factory instanceof VersionAwareConstructorFunction) {
                return (IdentifiedDataSerializable)((VersionAwareConstructorFunction)factory).createNew(typeId, clusterVersion, wanProtocolVersion);
            }
            return factory.createNew(typeId);
        }
        return null;
    }

    public void mergeConstructors(@Nonnull ConstructorFunction<Integer, IdentifiedDataSerializable>[] ctorArray) {
        if (this.constructors.length < ctorArray.length) {
            throw new IllegalArgumentException("Too many constructors");
        }
        for (int i = 0; i < ctorArray.length; ++i) {
            if (ctorArray[i] == null) continue;
            if (this.constructors[i] != null) {
                throw new IllegalArgumentException("Overwriting a constructor");
            }
            this.constructors[i] = ctorArray[i];
        }
    }
}

