/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cp.internal.raft.impl.state;

import com.hazelcast.internal.util.Clock;

public class FollowerState {
    static final int MIN_BACKOFF_ROUNDS = 4;
    static final int MAX_BACKOFF_ROUND = 20;
    private long matchIndex;
    private long nextIndex;
    private int backoffRound;
    private int nextBackoffPower;
    private long appendRequestAckTimestamp;
    private long flowControlSequenceNumber;

    FollowerState(long matchIndex, long nextIndex) {
        this.matchIndex = matchIndex;
        this.nextIndex = nextIndex;
        this.appendRequestAckTimestamp = Clock.currentTimeMillis();
    }

    public long matchIndex() {
        return this.matchIndex;
    }

    public void matchIndex(long matchIndex) {
        this.matchIndex = matchIndex;
    }

    public long nextIndex() {
        return this.nextIndex;
    }

    public void nextIndex(long nextIndex) {
        this.nextIndex = nextIndex;
    }

    public boolean isAppendRequestBackoffSet() {
        return this.backoffRound > 0;
    }

    public long setAppendRequestBackoff() {
        assert (this.backoffRound == 0) : "backoff round: " + this.backoffRound;
        this.backoffRound = this.nextBackoffRound();
        return ++this.flowControlSequenceNumber;
    }

    private int nextBackoffRound() {
        return Math.min(Math.max((1 << this.nextBackoffPower++) * 4, 4), 20);
    }

    public void setMaxAppendRequestBackoff() {
        this.backoffRound = 20;
    }

    public boolean completeAppendRequestBackoffRound() {
        assert (this.backoffRound > 0);
        return --this.backoffRound == 0;
    }

    public boolean appendRequestAckReceived(long flowControlSequenceNumber) {
        boolean success;
        this.appendRequestAckTimestamp = Clock.currentTimeMillis();
        boolean bl = success = this.flowControlSequenceNumber == flowControlSequenceNumber;
        if (flowControlSequenceNumber == -1L) {
            success = true;
        }
        if (success) {
            this.resetRequestBackoff();
        }
        return success;
    }

    public void resetRequestBackoff() {
        this.backoffRound = 0;
        this.nextBackoffPower = 0;
    }

    public long appendRequestAckTimestamp() {
        return this.appendRequestAckTimestamp;
    }

    int backoffRound() {
        return this.backoffRound;
    }

    public long flowControlSequenceNumber() {
        return this.flowControlSequenceNumber;
    }

    public String toString() {
        return "FollowerState{matchIndex=" + this.matchIndex + ", nextIndex=" + this.nextIndex + ", backoffRound=" + this.backoffRound + ", nextBackoffPower=" + this.nextBackoffPower + ", appendRequestAckTime=" + this.appendRequestAckTimestamp + ", flowControlSequenceNumber=" + this.flowControlSequenceNumber + '}';
    }
}

