/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.config;

import com.hazelcast.config.PersistentMemoryConfig;
import com.hazelcast.config.PersistentMemoryDirectoryConfig;
import com.hazelcast.core.HazelcastException;
import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.memory.Capacity;
import com.hazelcast.memory.MemorySize;
import com.hazelcast.memory.MemoryUnit;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class NativeMemoryConfig {
    public static final int DEFAULT_MIN_BLOCK_SIZE = 16;
    public static final int DEFAULT_PAGE_SIZE = 0x400000;
    public static final float DEFAULT_METADATA_SPACE_PERCENTAGE = 12.5f;
    public static final int MIN_INITIAL_MEMORY_SIZE = 512;
    public static final int INITIAL_MEMORY_SIZE = 512;
    private boolean enabled;
    private Capacity capacity = new Capacity(512L, MemoryUnit.MEGABYTES);
    private MemoryAllocatorType allocatorType = MemoryAllocatorType.POOLED;
    private int minBlockSize = 16;
    private int pageSize = 0x400000;
    private float metadataSpacePercentage = 12.5f;
    private PersistentMemoryConfig persistentMemoryConfig = new PersistentMemoryConfig();

    public NativeMemoryConfig() {
    }

    public NativeMemoryConfig(NativeMemoryConfig nativeMemoryConfig) {
        this.enabled = nativeMemoryConfig.enabled;
        this.capacity = nativeMemoryConfig.capacity;
        this.allocatorType = nativeMemoryConfig.allocatorType;
        this.minBlockSize = nativeMemoryConfig.minBlockSize;
        this.pageSize = nativeMemoryConfig.pageSize;
        this.metadataSpacePercentage = nativeMemoryConfig.metadataSpacePercentage;
        this.persistentMemoryConfig = new PersistentMemoryConfig(nativeMemoryConfig.persistentMemoryConfig);
    }

    @Deprecated
    public MemorySize getSize() {
        return new MemorySize(this.capacity.getValue(), this.capacity.getUnit());
    }

    @Deprecated
    public NativeMemoryConfig setSize(MemorySize capacity) {
        this.capacity = Preconditions.isNotNull(capacity, "size");
        return this;
    }

    public Capacity getCapacity() {
        return this.capacity;
    }

    public NativeMemoryConfig setCapacity(Capacity capacity) {
        this.capacity = Preconditions.isNotNull(capacity, "capacity");
        return this;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public NativeMemoryConfig setEnabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public MemoryAllocatorType getAllocatorType() {
        return this.allocatorType;
    }

    public NativeMemoryConfig setAllocatorType(MemoryAllocatorType allocatorType) {
        this.allocatorType = allocatorType;
        return this;
    }

    public int getMinBlockSize() {
        return this.minBlockSize;
    }

    public NativeMemoryConfig setMinBlockSize(int minBlockSize) {
        this.minBlockSize = Preconditions.checkPositive("minBlockSize", minBlockSize);
        return this;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public NativeMemoryConfig setPageSize(int pageSize) {
        this.pageSize = Preconditions.checkPositive("pageSize", pageSize);
        return this;
    }

    public float getMetadataSpacePercentage() {
        return this.metadataSpacePercentage;
    }

    public NativeMemoryConfig setMetadataSpacePercentage(float metadataSpacePercentage) {
        this.metadataSpacePercentage = metadataSpacePercentage;
        return this;
    }

    @Nonnull
    public PersistentMemoryConfig getPersistentMemoryConfig() {
        return this.persistentMemoryConfig;
    }

    public void setPersistentMemoryConfig(@Nonnull PersistentMemoryConfig persistentMemoryConfig) {
        this.persistentMemoryConfig = Objects.requireNonNull(persistentMemoryConfig);
    }

    @Deprecated
    @Nullable
    public String getPersistentMemoryDirectory() {
        List<PersistentMemoryDirectoryConfig> directoryConfigs = this.persistentMemoryConfig.getDirectoryConfigs();
        int directoriesDefined = directoryConfigs.size();
        if (directoriesDefined > 1) {
            throw new HazelcastException("There are multiple persistent memory directories configured. Please use PersistentMemoryConfig.getDirectoryConfigs()!");
        }
        return directoriesDefined == 1 ? directoryConfigs.get(0).getDirectory() : null;
    }

    @Nonnull
    @Deprecated
    public NativeMemoryConfig setPersistentMemoryDirectory(@Nullable String directory) {
        if (directory != null) {
            this.persistentMemoryConfig.setDirectoryConfig(new PersistentMemoryDirectoryConfig(directory));
        } else {
            this.persistentMemoryConfig.getDirectoryConfigs().clear();
        }
        return this;
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof NativeMemoryConfig)) {
            return false;
        }
        NativeMemoryConfig that = (NativeMemoryConfig)o;
        if (this.enabled != that.enabled) {
            return false;
        }
        if (this.minBlockSize != that.minBlockSize) {
            return false;
        }
        if (this.pageSize != that.pageSize) {
            return false;
        }
        if (Float.compare(that.metadataSpacePercentage, this.metadataSpacePercentage) != 0) {
            return false;
        }
        if (!Objects.equals(this.capacity, that.capacity)) {
            return false;
        }
        if (!this.persistentMemoryConfig.equals(that.persistentMemoryConfig)) {
            return false;
        }
        return this.allocatorType == that.allocatorType;
    }

    public final int hashCode() {
        int result = this.enabled ? 1 : 0;
        result = 31 * result + (this.capacity != null ? this.capacity.hashCode() : 0);
        result = 31 * result + (this.allocatorType != null ? this.allocatorType.hashCode() : 0);
        result = 31 * result + this.minBlockSize;
        result = 31 * result + this.pageSize;
        result = 31 * result + (this.metadataSpacePercentage != 0.0f ? Float.floatToIntBits(this.metadataSpacePercentage) : 0);
        result = 31 * result + this.persistentMemoryConfig.hashCode();
        return result;
    }

    public String toString() {
        return "NativeMemoryConfig{enabled=" + this.enabled + ", size=" + this.capacity + ", allocatorType=" + (Object)((Object)this.allocatorType) + ", minBlockSize=" + this.minBlockSize + ", pageSize=" + this.pageSize + ", metadataSpacePercentage=" + this.metadataSpacePercentage + ", persistentMemoryConfig=" + this.persistentMemoryConfig + '}';
    }

    public static enum MemoryAllocatorType {
        STANDARD,
        POOLED;

    }
}

