/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.collection.impl.queue;

import com.hazelcast.collection.impl.queue.QueueItem;
import java.util.Comparator;
import java.util.Objects;
import javax.annotation.Nonnull;

public final class ForwardingQueueItemComparator<T>
implements Comparator<QueueItem> {
    private final Comparator<T> customComparator;

    public ForwardingQueueItemComparator(@Nonnull Comparator<T> customComparator) {
        Objects.requireNonNull(customComparator, "Custom comparator cannot be null.");
        this.customComparator = customComparator;
    }

    @Override
    public int compare(QueueItem o1, QueueItem o2) {
        Object object1 = o1.getDeserializedObject();
        Object object2 = o2.getDeserializedObject();
        return this.customComparator.compare(object1, object2);
    }

    public String toString() {
        return "ForwardingQueueItemComparator{" + super.toString() + "} ";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ForwardingQueueItemComparator that = (ForwardingQueueItemComparator)o;
        return Objects.equals(this.customComparator, that.customComparator);
    }

    public int hashCode() {
        return Objects.hash(this.customComparator);
    }
}

