/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.connection.tcp;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.ClientAuthenticationCodec;
import com.hazelcast.client.impl.protocol.codec.ClientAuthenticationCustomCodec;
import com.hazelcast.client.impl.protocol.codec.ExperimentalAuthenticationCodec;
import com.hazelcast.client.impl.protocol.codec.ExperimentalAuthenticationCustomCodec;
import com.hazelcast.cluster.Address;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;

public final class AuthenticationResponse {
    private final byte status;
    private final Address address;
    private final UUID memberUuid;
    private final byte serializationVersion;
    private final String serverHazelcastVersion;
    private final int partitionCount;
    private final UUID clusterId;
    private final boolean failoverSupported;
    private final List<Integer> tpcPorts;
    private final byte[] tpcToken;

    private AuthenticationResponse(byte status, Address address, UUID memberUuid, byte serializationVersion, String serverHazelcastVersion, int partitionCount, UUID clusterId, boolean failoverSupported, List<Integer> tpcPorts, byte[] tpcToken) {
        this.status = status;
        this.address = address;
        this.memberUuid = memberUuid;
        this.serializationVersion = serializationVersion;
        this.serverHazelcastVersion = serverHazelcastVersion;
        this.partitionCount = partitionCount;
        this.clusterId = clusterId;
        this.failoverSupported = failoverSupported;
        this.tpcPorts = tpcPorts;
        this.tpcToken = tpcToken;
    }

    public byte getStatus() {
        return this.status;
    }

    @Nullable
    public Address getAddress() {
        return this.address;
    }

    @Nullable
    public UUID getMemberUuid() {
        return this.memberUuid;
    }

    public byte getSerializationVersion() {
        return this.serializationVersion;
    }

    public String getServerHazelcastVersion() {
        return this.serverHazelcastVersion;
    }

    public int getPartitionCount() {
        return this.partitionCount;
    }

    public UUID getClusterId() {
        return this.clusterId;
    }

    public boolean isFailoverSupported() {
        return this.failoverSupported;
    }

    @Nullable
    public List<Integer> getTpcPorts() {
        return this.tpcPorts;
    }

    @Nullable
    public byte[] getTpcToken() {
        return this.tpcToken;
    }

    public static AuthenticationResponse from(ClientMessage message) {
        switch (message.getMessageType()) {
            case 257: {
                return AuthenticationResponse.fromAuthenticationCodec(message);
            }
            case 513: {
                return AuthenticationResponse.fromAuthenticationCustomCodec(message);
            }
            case 16580865: {
                return AuthenticationResponse.fromExperimentalAuthenticationCodec(message);
            }
            case 16581121: {
                return AuthenticationResponse.fromExperimentalAuthenticationCustomCodec(message);
            }
        }
        throw new IllegalStateException("Unexpected response message type");
    }

    private static AuthenticationResponse fromAuthenticationCodec(ClientMessage message) {
        ClientAuthenticationCodec.ResponseParameters parameters = ClientAuthenticationCodec.decodeResponse(message);
        return new AuthenticationResponse(parameters.status, parameters.address, parameters.memberUuid, parameters.serializationVersion, parameters.serverHazelcastVersion, parameters.partitionCount, parameters.clusterId, parameters.failoverSupported, null, null);
    }

    private static AuthenticationResponse fromAuthenticationCustomCodec(ClientMessage message) {
        ClientAuthenticationCustomCodec.ResponseParameters parameters = ClientAuthenticationCustomCodec.decodeResponse(message);
        return new AuthenticationResponse(parameters.status, parameters.address, parameters.memberUuid, parameters.serializationVersion, parameters.serverHazelcastVersion, parameters.partitionCount, parameters.clusterId, parameters.failoverSupported, null, null);
    }

    private static AuthenticationResponse fromExperimentalAuthenticationCodec(ClientMessage message) {
        ExperimentalAuthenticationCodec.ResponseParameters parameters = ExperimentalAuthenticationCodec.decodeResponse(message);
        return new AuthenticationResponse(parameters.status, parameters.address, parameters.memberUuid, parameters.serializationVersion, parameters.serverHazelcastVersion, parameters.partitionCount, parameters.clusterId, parameters.failoverSupported, parameters.tpcPorts, parameters.tpcToken);
    }

    private static AuthenticationResponse fromExperimentalAuthenticationCustomCodec(ClientMessage message) {
        ExperimentalAuthenticationCustomCodec.ResponseParameters parameters = ExperimentalAuthenticationCustomCodec.decodeResponse(message);
        return new AuthenticationResponse(parameters.status, parameters.address, parameters.memberUuid, parameters.serializationVersion, parameters.serverHazelcastVersion, parameters.partitionCount, parameters.clusterId, parameters.failoverSupported, parameters.tpcPorts, parameters.tpcToken);
    }
}

