/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.renderkit.html_basic;

import com.sun.faces.renderkit.RenderKitUtils;
import com.sun.faces.renderkit.html_basic.HtmlBasicRenderer;
import com.sun.faces.util.Util;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.faces.component.UIColumn;
import javax.faces.component.UIComponent;
import javax.faces.component.UIData;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;

public abstract class BaseTableRenderer
extends HtmlBasicRenderer {
    protected abstract void renderHeader(FacesContext var1, UIComponent var2, ResponseWriter var3) throws IOException;

    protected abstract void renderFooter(FacesContext var1, UIComponent var2, ResponseWriter var3) throws IOException;

    protected abstract void renderRow(FacesContext var1, UIComponent var2, UIComponent var3, ResponseWriter var4) throws IOException;

    protected void renderTableStart(FacesContext context, UIComponent table, ResponseWriter writer, String[] passThroughAttributes) throws IOException {
        if (RenderKitUtils.shouldRenderScriptForEventHandler(context, table)) {
            String scriptContentForEventHandler = RenderKitUtils.getScriptContentForEventHandler(writer, context, table, "table");
            RenderKitUtils.writeScript(writer, context, table, scriptContentForEventHandler);
        }
        String styleClass = (String)table.getAttributes().get("styleClass");
        String style = (String)table.getAttributes().get("style");
        if (style != null) {
            String cssClassName = RenderKitUtils.getCssId(context, table);
            RenderKitUtils.writeStyle(writer, context, table, cssClassName, style);
            styleClass = RenderKitUtils.concatStyleClasses(styleClass, cssClassName);
        }
        writer.startElement("table", table);
        this.writeIdAttributeIfNecessary(context, writer, table);
        if (styleClass != null) {
            writer.writeAttribute("class", styleClass, "styleClass");
        }
        RenderKitUtils.renderPassThruAttributes(writer, table, passThroughAttributes);
        writer.writeText("\n", table, null);
    }

    protected void renderTableEnd(FacesContext context, UIComponent table, ResponseWriter writer) throws IOException {
        writer.endElement("table");
        writer.writeText("\n", table, null);
    }

    protected void renderCaption(FacesContext context, UIComponent table, ResponseWriter writer) throws IOException {
        UIComponent caption = this.getFacet(table, "caption");
        if (caption != null) {
            String captionClass = (String)table.getAttributes().get("captionClass");
            String captionStyle = (String)table.getAttributes().get("captionStyle");
            if (captionStyle != null) {
                String cssClassName = RenderKitUtils.getCssId(context, caption);
                RenderKitUtils.writeStyle(writer, context, caption, cssClassName, captionStyle);
                captionClass = RenderKitUtils.concatStyleClasses(captionClass, cssClassName);
            }
            writer.startElement("caption", table);
            if (captionClass != null) {
                writer.writeAttribute("class", captionClass, "captionClass");
            }
            this.encodeRecursive(context, caption);
            writer.endElement("caption");
        }
    }

    protected void renderTableBodyStart(FacesContext context, UIComponent table, ResponseWriter writer) throws IOException {
        writer.startElement("tbody", table);
        writer.writeText("\n", table, null);
    }

    protected void renderTableBodyEnd(FacesContext context, UIComponent table, ResponseWriter writer) throws IOException {
        writer.endElement("tbody");
        writer.writeText("\n", table, null);
    }

    protected void renderRowStart(FacesContext context, UIComponent table, ResponseWriter writer) throws IOException {
        TableMetaInfo info = this.getMetaInfo(context, table);
        writer.startElement("tr", table);
        if (info.rowClasses.length > 0) {
            writer.writeAttribute("class", info.getCurrentRowClass(), "rowClasses");
        }
        writer.writeText("\n", table, null);
    }

    protected void renderRowEnd(FacesContext context, UIComponent table, ResponseWriter writer) throws IOException {
        writer.endElement("tr");
        writer.writeText("\n", table, null);
    }

    protected TableMetaInfo getMetaInfo(FacesContext context, UIComponent table) {
        String key = this.createKey(table);
        Map<String, Object> reqMap = context.getExternalContext().getRequestMap();
        TableMetaInfo info = (TableMetaInfo)reqMap.get(key);
        if (info == null) {
            info = new TableMetaInfo(table);
            reqMap.put(key, info);
        }
        return info;
    }

    protected void clearMetaInfo(FacesContext context, UIComponent table) {
        context.getExternalContext().getRequestMap().remove(this.createKey(table));
    }

    protected String createKey(UIComponent table) {
        return TableMetaInfo.KEY + table.hashCode();
    }

    protected static class TableMetaInfo {
        private static final UIColumn PLACE_HOLDER_COLUMN = new UIColumn();
        private static final String[] EMPTY_STRING_ARRAY = new String[0];
        public static final String KEY = TableMetaInfo.class.getName();
        public final String[] rowClasses;
        public final String[] columnClasses;
        public final List<UIColumn> columns;
        public final boolean hasHeaderFacets;
        public final boolean hasFooterFacets;
        public final int columnCount;
        public int columnStyleCounter;
        public int rowStyleCounter;

        public TableMetaInfo(UIComponent table) {
            this.rowClasses = TableMetaInfo.getRowClasses(table);
            this.columnClasses = TableMetaInfo.getColumnClasses(table);
            this.columns = TableMetaInfo.getColumns(table);
            this.columnCount = this.columns.size();
            this.hasHeaderFacets = TableMetaInfo.hasFacet("header", this.columns);
            this.hasFooterFacets = TableMetaInfo.hasFacet("footer", this.columns);
        }

        public void newRow() {
            this.columnStyleCounter = 0;
        }

        public String getCurrentColumnClass() {
            String style = null;
            if (this.columnStyleCounter < this.columnClasses.length && this.columnStyleCounter <= this.columnCount) {
                style = this.columnClasses[this.columnStyleCounter++];
            }
            return style != null && style.length() > 0 ? style : null;
        }

        public String getCurrentRowClass() {
            String style = this.rowClasses[this.rowStyleCounter++];
            if (this.rowStyleCounter >= this.rowClasses.length) {
                this.rowStyleCounter = 0;
            }
            return style;
        }

        private static String[] getColumnClasses(UIComponent table) {
            String values = (String)table.getAttributes().get("columnClasses");
            if (values == null) {
                return EMPTY_STRING_ARRAY;
            }
            return Util.split(values.trim(), ",");
        }

        private static List<UIColumn> getColumns(UIComponent table) {
            if (table instanceof UIData) {
                int childCount = table.getChildCount();
                if (childCount > 0) {
                    ArrayList<UIColumn> results = new ArrayList<UIColumn>(childCount);
                    for (UIComponent kid : table.getChildren()) {
                        if (!(kid instanceof UIColumn) || !kid.isRendered()) continue;
                        results.add((UIColumn)kid);
                    }
                    return results;
                }
                return Collections.emptyList();
            }
            Object value = table.getAttributes().get("columns");
            int count = value != null && value instanceof Integer ? (Integer)value : 2;
            if (count < 1) {
                count = 1;
            }
            ArrayList<UIColumn> result = new ArrayList<UIColumn>(count);
            for (int i = 0; i < count; ++i) {
                result.add(PLACE_HOLDER_COLUMN);
            }
            return result;
        }

        private static boolean hasFacet(String name, List<UIColumn> columns) {
            if (!columns.isEmpty()) {
                for (UIColumn column : columns) {
                    if (column.getFacetCount() <= 0 || !column.getFacets().containsKey(name)) continue;
                    return true;
                }
            }
            return false;
        }

        private static String[] getRowClasses(UIComponent table) {
            String values = (String)table.getAttributes().get("rowClasses");
            if (values == null) {
                return EMPTY_STRING_ARRAY;
            }
            return Util.split(values.trim(), ",");
        }
    }
}

