/*
 * Decompiled with CFR 0.152.
 */
package com.sun.facelets.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public final class Classpath {
    public static URL[] search(String prefix, String suffix) throws IOException {
        return Classpath.search(Thread.currentThread().getContextClassLoader(), prefix, suffix);
    }

    public static URL[] search(ClassLoader cl, String prefix, String suffix) throws IOException {
        Enumeration[] e = new Enumeration[]{cl.getResources(prefix), cl.getResources(prefix + "MANIFEST.MF")};
        LinkedHashSet<URL> all = new LinkedHashSet<URL>();
        int s = e.length;
        for (int i = 0; i < s; ++i) {
            while (e[i].hasMoreElements()) {
                URL url = (URL)e[i].nextElement();
                URLConnection conn = url.openConnection();
                conn.setUseCaches(false);
                conn.setDefaultUseCaches(false);
                JarFile jarFile = conn instanceof JarURLConnection ? ((JarURLConnection)conn).getJarFile() : Classpath.getAlternativeJarFile(url);
                if (jarFile != null) {
                    Classpath.searchJar(cl, all, jarFile, prefix, suffix);
                    continue;
                }
                boolean searchDone = Classpath.searchDir(all, new File(URLDecoder.decode(url.getFile(), "UTF-8")), suffix);
                if (searchDone) continue;
                Classpath.searchFromURL(all, prefix, suffix, url);
            }
        }
        URL[] urlArray = all.toArray(new URL[all.size()]);
        return urlArray;
    }

    private static boolean searchDir(Set<URL> result, File file, String suffix) throws IOException {
        if (file.exists() && file.isDirectory()) {
            File[] fc = file.listFiles();
            for (int i = 0; i < fc.length; ++i) {
                String path = fc[i].getAbsolutePath();
                if (fc[i].isDirectory()) {
                    Classpath.searchDir(result, fc[i], suffix);
                    continue;
                }
                if (!path.endsWith(suffix)) continue;
                result.add(fc[i].toURI().toURL());
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void searchFromURL(Set<URL> result, String prefix, String suffix, URL url) throws IOException {
        boolean done = false;
        InputStream is = Classpath.getInputStream(url);
        if (is != null) {
            try (ZipInputStream zis = is instanceof ZipInputStream ? (ZipInputStream)is : new ZipInputStream(is);){
                ZipEntry entry = zis.getNextEntry();
                boolean bl = done = entry != null;
                while (entry != null) {
                    String entryName = entry.getName();
                    if (entryName.endsWith(suffix)) {
                        String urlString = url.toExternalForm();
                        result.add(new URL(urlString + entryName));
                    }
                    entry = zis.getNextEntry();
                }
            }
            catch (Exception zis2) {
                // empty catch block
            }
        }
        if (!done && prefix.length() > 0) {
            String urlString = url.toExternalForm() + "/";
            String[] split = prefix.split("/");
            prefix = Classpath.join(split, true);
            String end = Classpath.join(split, false);
            int p = urlString.lastIndexOf(end);
            url = new URL(urlString.substring(0, p));
            Classpath.searchFromURL(result, prefix, suffix, url);
        }
    }

    private static String join(String[] tokens, boolean excludeLast) {
        StringBuffer join = new StringBuffer();
        for (int i = 0; i < tokens.length - (excludeLast ? 1 : 0); ++i) {
            join.append(tokens[i]).append("/");
        }
        return join.toString();
    }

    private static InputStream getInputStream(URL url) {
        try {
            return url.openStream();
        }
        catch (Throwable t) {
            return null;
        }
    }

    private static JarFile getAlternativeJarFile(URL url) throws IOException {
        String urlFile = url.getFile();
        int separatorIndex = urlFile.indexOf("!/");
        if (separatorIndex == -1) {
            separatorIndex = urlFile.indexOf(33);
        }
        if (separatorIndex != -1) {
            String jarFileUrl = urlFile.substring(0, separatorIndex);
            if (jarFileUrl.startsWith("file:")) {
                jarFileUrl = jarFileUrl.substring("file:".length());
                jarFileUrl = URLDecoder.decode(jarFileUrl, "UTF-8");
            }
            return new JarFile(jarFileUrl);
        }
        return null;
    }

    private static void searchJar(ClassLoader cl, Set<URL> result, JarFile file, String prefix, String suffix) throws IOException {
        Enumeration<JarEntry> e = file.entries();
        while (e.hasMoreElements()) {
            JarEntry entry;
            try {
                entry = e.nextElement();
            }
            catch (Throwable t) {
                continue;
            }
            String name = entry.getName();
            if (!name.startsWith(prefix) || !name.endsWith(suffix)) continue;
            Enumeration<URL> e2 = cl.getResources(name);
            while (e2.hasMoreElements()) {
                result.add(e2.nextElement());
            }
        }
    }
}

