/*
 * Decompiled with CFR 0.152.
 */
package com.sun.facelets.tag.jstl.core;

import jakarta.el.ELContext;
import jakarta.el.ValueExpression;
import java.io.Serializable;
import java.util.Map;

public final class MappedValueExpression
extends ValueExpression {
    private static final long serialVersionUID = 1L;
    private final Object key;
    private final ValueExpression orig;

    public MappedValueExpression(ValueExpression orig, Map.Entry entry) {
        this.orig = orig;
        this.key = entry.getKey();
    }

    public Object getValue(ELContext context) {
        Object base = this.orig.getValue(context);
        if (base != null) {
            context.setPropertyResolved(true);
            return new Entry((Map)base, this.key);
        }
        return null;
    }

    public void setValue(ELContext context, Object value) {
        Object base = this.orig.getValue(context);
        if (base != null) {
            context.setPropertyResolved(false);
            context.getELResolver().setValue(context, base, this.key, value);
        }
    }

    public boolean isReadOnly(ELContext context) {
        Object base = this.orig.getValue(context);
        if (base != null) {
            context.setPropertyResolved(false);
            return context.getELResolver().isReadOnly(context, base, this.key);
        }
        return true;
    }

    public Class getType(ELContext context) {
        Object base = this.orig.getValue(context);
        if (base != null) {
            context.setPropertyResolved(false);
            return context.getELResolver().getType(context, base, this.key);
        }
        return null;
    }

    public Class getExpectedType() {
        return Object.class;
    }

    public String getExpressionString() {
        return this.orig.getExpressionString();
    }

    public boolean equals(Object obj) {
        return this.orig.equals(obj);
    }

    public int hashCode() {
        return 0;
    }

    public boolean isLiteralText() {
        return false;
    }

    private static final class Entry
    implements Map.Entry,
    Serializable {
        private final Map src;
        private final Object key;

        public Entry(Map src, Object key) {
            this.src = src;
            this.key = key;
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.src.get(this.key);
        }

        public Object setValue(Object value) {
            return this.src.put(this.key, value);
        }
    }
}

