/*
 * Decompiled with CFR 0.152.
 */
package com.sun.facelets.impl;

import com.sun.facelets.FaceletContext;
import com.sun.facelets.FaceletException;
import com.sun.facelets.TemplateClient;
import com.sun.facelets.el.DefaultVariableMapper;
import com.sun.facelets.el.ELAdaptor;
import com.sun.facelets.impl.DefaultFacelet;
import jakarta.el.ELContext;
import jakarta.el.ELException;
import jakarta.el.ELResolver;
import jakarta.el.ExpressionFactory;
import jakarta.el.FunctionMapper;
import jakarta.el.ValueExpression;
import jakarta.el.VariableMapper;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;

final class DefaultFaceletContext
extends FaceletContext {
    private final FacesContext faces;
    private final ELContext ctx;
    private final DefaultFacelet facelet;
    private final List faceletHierarchy;
    private VariableMapper varMapper;
    private FunctionMapper fnMapper;
    private final Map ids;
    private final Map prefixes;
    private String prefix;
    private final StringBuffer uniqueIdBuilder = new StringBuffer(30);
    private final List clients;

    public DefaultFaceletContext(DefaultFaceletContext ctx, DefaultFacelet facelet) {
        this.ctx = ctx.ctx;
        this.clients = ctx.clients;
        this.faces = ctx.faces;
        this.fnMapper = ctx.fnMapper;
        this.ids = ctx.ids;
        this.prefixes = ctx.prefixes;
        this.varMapper = ctx.varMapper;
        this.faceletHierarchy = new ArrayList(ctx.faceletHierarchy.size() + 1);
        this.faceletHierarchy.addAll(ctx.faceletHierarchy);
        this.faceletHierarchy.add(facelet);
        this.facelet = facelet;
    }

    public DefaultFaceletContext(FacesContext faces, DefaultFacelet facelet) {
        this.ctx = ELAdaptor.getELContext(faces);
        this.ids = new HashMap();
        this.prefixes = new HashMap();
        this.clients = new ArrayList(5);
        this.faces = faces;
        this.faceletHierarchy = new ArrayList(1);
        this.faceletHierarchy.add(facelet);
        this.facelet = facelet;
        this.varMapper = this.ctx.getVariableMapper();
        if (this.varMapper == null) {
            this.varMapper = new DefaultVariableMapper();
        }
        this.fnMapper = this.ctx.getFunctionMapper();
    }

    @Override
    public FacesContext getFacesContext() {
        return this.faces;
    }

    @Override
    public ExpressionFactory getExpressionFactory() {
        return this.facelet.getExpressionFactory();
    }

    @Override
    public void setVariableMapper(VariableMapper varMapper) {
        this.varMapper = varMapper;
    }

    @Override
    public void setFunctionMapper(FunctionMapper fnMapper) {
        this.fnMapper = fnMapper;
    }

    @Override
    public void includeFacelet(UIComponent parent, String relativePath) throws IOException, FacesException, ELException {
        this.facelet.include(this, parent, relativePath);
    }

    public FunctionMapper getFunctionMapper() {
        return this.fnMapper;
    }

    public VariableMapper getVariableMapper() {
        return this.varMapper;
    }

    public Object getContext(Class key) {
        return this.ctx.getContext(key);
    }

    public void putContext(Class key, Object contextObject) {
        this.ctx.putContext(key, contextObject);
    }

    @Override
    public String generateUniqueId(String base) {
        Integer cnt;
        if (this.prefix == null) {
            StringBuffer builder = new StringBuffer(this.faceletHierarchy.size() * 30);
            for (int i = 0; i < this.faceletHierarchy.size(); ++i) {
                DefaultFacelet facelet = (DefaultFacelet)this.faceletHierarchy.get(i);
                builder.append(facelet.getAlias());
            }
            Integer prefixInt = new Integer(builder.toString().hashCode());
            Integer cnt2 = (Integer)this.prefixes.get(prefixInt);
            if (cnt2 == null) {
                this.prefixes.put(prefixInt, new Integer(0));
                this.prefix = prefixInt.toString();
            } else {
                int i = cnt2 + 1;
                this.prefixes.put(prefixInt, new Integer(i));
                this.prefix = prefixInt + "_" + i;
            }
        }
        if ((cnt = (Integer)this.ids.get(base)) == null) {
            this.ids.put(base, new Integer(0));
            this.uniqueIdBuilder.delete(0, this.uniqueIdBuilder.length());
            this.uniqueIdBuilder.append(this.prefix);
            this.uniqueIdBuilder.append("_");
            this.uniqueIdBuilder.append(base);
            return this.uniqueIdBuilder.toString();
        }
        int i = cnt + 1;
        this.ids.put(base, new Integer(i));
        this.uniqueIdBuilder.delete(0, this.uniqueIdBuilder.length());
        this.uniqueIdBuilder.append(this.prefix);
        this.uniqueIdBuilder.append("_");
        this.uniqueIdBuilder.append(base);
        this.uniqueIdBuilder.append("_");
        this.uniqueIdBuilder.append(i);
        return this.uniqueIdBuilder.toString();
    }

    @Override
    public Object getAttribute(String name) {
        ValueExpression ve;
        if (this.varMapper != null && (ve = this.varMapper.resolveVariable(name)) != null) {
            return ve.getValue((ELContext)this);
        }
        return null;
    }

    @Override
    public void setAttribute(String name, Object value) {
        if (this.varMapper != null) {
            if (value == null) {
                this.varMapper.setVariable(name, null);
            } else {
                this.varMapper.setVariable(name, this.facelet.getExpressionFactory().createValueExpression(value, Object.class));
            }
        }
    }

    @Override
    public void includeFacelet(UIComponent parent, URL absolutePath) throws IOException, FacesException, ELException {
        this.facelet.include(this, parent, absolutePath);
    }

    public ELResolver getELResolver() {
        return this.ctx.getELResolver();
    }

    @Override
    public void popClient(TemplateClient client) {
        if (!this.clients.isEmpty()) {
            Iterator itr = this.clients.iterator();
            while (itr.hasNext()) {
                if (!itr.next().equals(client)) continue;
                itr.remove();
                return;
            }
        }
        throw new IllegalStateException(client + " not found");
    }

    @Override
    public void pushClient(TemplateClient client) {
        this.clients.add(0, new TemplateManager(this.facelet, client, true));
    }

    @Override
    public void extendClient(TemplateClient client) {
        this.clients.add(new TemplateManager(this.facelet, client, false));
    }

    @Override
    public boolean includeDefinition(UIComponent parent, String name) throws IOException, FaceletException, FacesException, ELException {
        boolean found = false;
        int size = this.clients.size();
        for (int i = 0; i < size && !found; ++i) {
            TemplateManager client = (TemplateManager)this.clients.get(i);
            if (client.equals(this.facelet)) continue;
            found = client.apply(this, parent, name);
        }
        return found;
    }

    public boolean isPropertyResolved() {
        return this.ctx.isPropertyResolved();
    }

    public void setPropertyResolved(boolean resolved) {
        this.ctx.setPropertyResolved(resolved);
    }

    private static final class TemplateManager
    implements TemplateClient {
        private final DefaultFacelet owner;
        private final TemplateClient target;
        private final boolean root;
        private final Set names = new HashSet();

        public TemplateManager(DefaultFacelet owner, TemplateClient target, boolean root) {
            this.owner = owner;
            this.target = target;
            this.root = root;
        }

        @Override
        public boolean apply(FaceletContext ctx, UIComponent parent, String name) throws IOException, FacesException, FaceletException, ELException {
            String testName;
            String string = testName = name != null ? name : "facelets._NULL_DEF_";
            if (this.names.contains(testName)) {
                return false;
            }
            this.names.add(testName);
            boolean found = false;
            found = this.target.apply(new DefaultFaceletContext((DefaultFaceletContext)ctx, this.owner), parent, name);
            this.names.remove(testName);
            return found;
        }

        public boolean equals(Object o) {
            return this.owner == o || this.target == o;
        }

        public boolean isRoot() {
            return this.root;
        }
    }
}

