/*
 * Decompiled with CFR 0.152.
 */
package org.govway.struts.util;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URLEncoder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.govway.struts.util.MessageResources;

public class ResponseUtils {
    protected static MessageResources messages = MessageResources.getMessageResources("org.govway.struts.util.LocalStrings");
    private static Method encode = null;
    private static final Log log = LogFactory.getLog(ResponseUtils.class);

    public static String filter(String value) {
        if (value == null || value.length() == 0) {
            return value;
        }
        StringBuffer result = null;
        String filtered = null;
        for (int i = 0; i < value.length(); ++i) {
            filtered = null;
            switch (value.charAt(i)) {
                case '<': {
                    filtered = "&lt;";
                    break;
                }
                case '>': {
                    filtered = "&gt;";
                    break;
                }
                case '&': {
                    filtered = "&amp;";
                    break;
                }
                case '\"': {
                    filtered = "&quot;";
                    break;
                }
                case '\'': {
                    filtered = "&#39;";
                }
            }
            if (result == null) {
                if (filtered == null) continue;
                result = new StringBuffer(value.length() + 50);
                if (i > 0) {
                    result.append(value.substring(0, i));
                }
                result.append(filtered);
                continue;
            }
            if (filtered == null) {
                result.append(value.charAt(i));
                continue;
            }
            result.append(filtered);
        }
        return result == null ? value : result.toString();
    }

    public static String encodeURL(String url) {
        return ResponseUtils.encodeURL(url, "UTF-8");
    }

    public static String encodeURL(String url, String enc) {
        try {
            if (enc == null || enc.length() == 0) {
                enc = "UTF-8";
            }
            if (encode != null) {
                return (String)encode.invoke(null, url, enc);
            }
        }
        catch (IllegalAccessException e) {
            log.debug((Object)"Could not find Java 1.4 encode method.  Using deprecated version.", (Throwable)e);
        }
        catch (InvocationTargetException e) {
            log.debug((Object)"Could not find Java 1.4 encode method. Using deprecated version.", (Throwable)e);
        }
        return URLEncoder.encode(url);
    }

    static {
        try {
            Class[] args = new Class[]{String.class, String.class};
            encode = URLEncoder.class.getMethod("encode", args);
        }
        catch (NoSuchMethodException e) {
            log.debug((Object)"Could not find Java 1.4 encode method.  Using deprecated version.", (Throwable)e);
        }
    }
}

