/*
 * Decompiled with CFR 0.152.
 */
package org.govway.struts.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Locale;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.govway.struts.util.MessageResources;
import org.govway.struts.util.MessageResourcesFactory;

public class PropertyMessageResources
extends MessageResources {
    private static final int MODE_DEFAULT = 0;
    private static final int MODE_JSTL = 1;
    private static final int MODE_RESOURCE_BUNDLE = 2;
    protected static final Log log = LogFactory.getLog(PropertyMessageResources.class);
    protected HashMap locales = new HashMap();
    protected HashMap messages = new HashMap();
    private int mode = 0;

    public PropertyMessageResources(MessageResourcesFactory factory, String config) {
        super(factory, config);
        log.trace((Object)("Initializing, config='" + config + "'"));
    }

    public PropertyMessageResources(MessageResourcesFactory factory, String config, boolean returnNull) {
        super(factory, config, returnNull);
        log.trace((Object)("Initializing, config='" + config + "', returnNull=" + returnNull));
    }

    public void setMode(String mode) {
        String value;
        String string = value = mode == null ? null : mode.trim();
        if ("jstl".equalsIgnoreCase(value)) {
            this.mode = 1;
            if (log.isDebugEnabled()) {
                log.info((Object)("Operating in JSTL compatible mode [" + mode + "]"));
            }
        } else if ("resource".equalsIgnoreCase(value)) {
            this.mode = 2;
            if (log.isDebugEnabled()) {
                log.info((Object)("Operating in PropertyResourceBundle compatible mode [" + mode + "]"));
            }
        } else {
            this.mode = 0;
            if (log.isDebugEnabled()) {
                log.info((Object)("Operating in Default mode [" + mode + "]"));
            }
        }
    }

    @Override
    public String getMessage(Locale locale, String key) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("getMessage(" + String.valueOf(locale) + "," + key + ")"));
        }
        String localeKey = this.localeKey(locale);
        String originalKey = this.messageKey(localeKey, key);
        String message = null;
        message = this.findMessage(locale, key, originalKey);
        if (message != null) {
            return message;
        }
        if (this.mode != 1) {
            if (this.mode == 2) {
                if (!this.defaultLocale.equals(locale)) {
                    message = this.findMessage(this.defaultLocale, key, originalKey);
                }
            } else if (!this.defaultLocale.equals(locale)) {
                localeKey = this.localeKey(this.defaultLocale);
                message = this.findMessage(localeKey, key, originalKey);
            }
        }
        if (message != null) {
            return message;
        }
        message = this.findMessage("", key, originalKey);
        if (message != null) {
            return message;
        }
        if (this.returnNull) {
            return null;
        }
        return "???" + this.messageKey(locale, key) + "???";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void loadLocale(String localeKey) {
        ClassLoader classLoader;
        if (log.isTraceEnabled()) {
            log.trace((Object)("loadLocale(" + localeKey + ")"));
        }
        if (this.locales.get(localeKey) != null) {
            return;
        }
        this.locales.put(localeKey, localeKey);
        Object name = this.config.replace('.', '/');
        if (localeKey.length() > 0) {
            name = (String)name + "_" + localeKey;
        }
        name = (String)name + ".properties";
        InputStream is = null;
        Properties props = new Properties();
        if (log.isTraceEnabled()) {
            log.trace((Object)("  Loading resource '" + (String)name + "'"));
        }
        if ((classLoader = Thread.currentThread().getContextClassLoader()) == null) {
            classLoader = this.getClass().getClassLoader();
        }
        if ((is = classLoader.getResourceAsStream((String)name)) != null) {
            try {
                props.load(is);
            }
            catch (IOException e) {
                log.error((Object)"loadLocale()", (Throwable)e);
            }
            finally {
                try {
                    is.close();
                }
                catch (IOException e) {
                    log.error((Object)"loadLocale()", (Throwable)e);
                }
            }
            if (log.isTraceEnabled()) {
                log.trace((Object)"  Loading resource completed");
            }
        } else if (log.isWarnEnabled()) {
            log.warn((Object)("  Resource " + (String)name + " Not Found."));
        }
        if (props.size() < 1) {
            return;
        }
        HashMap hashMap = this.messages;
        synchronized (hashMap) {
            for (String string : props.keySet()) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)("  Saving message key '" + this.messageKey(localeKey, string)));
                }
                this.messages.put(this.messageKey(localeKey, string), props.getProperty(string));
            }
        }
    }

    private String findMessage(Locale locale, String key, String originalKey) {
        String localeKey = this.localeKey(locale);
        Object messageKey = null;
        String message = null;
        int underscore = 0;
        while ((message = this.findMessage(localeKey, key, originalKey)) == null && (underscore = localeKey.lastIndexOf("_")) >= 0) {
            localeKey = localeKey.substring(0, underscore);
        }
        return message;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String findMessage(String localeKey, String key, String originalKey) {
        this.loadLocale(localeKey);
        String messageKey = this.messageKey(localeKey, key);
        boolean addIt = !messageKey.equals(originalKey);
        HashMap hashMap = this.messages;
        synchronized (hashMap) {
            String message = (String)this.messages.get(messageKey);
            if (message != null && addIt) {
                this.messages.put(originalKey, message);
            }
            return message;
        }
    }
}

