/*
 * Decompiled with CFR 0.152.
 */
package org.govway.struts.config;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.govway.struts.action.ActionForward;
import org.govway.struts.config.ActionConfig;
import org.govway.struts.config.ExceptionConfig;
import org.govway.struts.config.ForwardConfig;
import org.govway.struts.util.WildcardHelper;

public class ActionConfigMatcher
implements Serializable {
    private static final Log log = LogFactory.getLog(ActionConfigMatcher.class);
    private static final WildcardHelper wildcard = new WildcardHelper();
    private List compiledPaths = new ArrayList();

    public ActionConfigMatcher(ActionConfig[] configs) {
        for (int x = 0; x < configs.length; ++x) {
            String path = configs[x].getPath();
            if (path == null || path.indexOf(42) <= -1) continue;
            if (path.length() > 0 && path.charAt(0) == '/') {
                path = path.substring(1);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Compiling action config path '" + path + "'"));
            }
            int[] pattern = wildcard.compilePattern(path);
            this.compiledPaths.add(new Mapping(pattern, configs[x]));
        }
    }

    public ActionConfig match(String path) {
        ActionConfig config = null;
        if (this.compiledPaths.size() > 0) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Attempting to match '" + path + "' to a wildcard pattern"));
            }
            if (path.length() > 0 && path.charAt(0) == '/') {
                path = path.substring(1);
            }
            HashMap vars = new HashMap();
            for (Mapping m : this.compiledPaths) {
                if (!wildcard.match(vars, path, m.getPattern())) continue;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Path matches pattern '" + m.getActionConfig().getPath() + "'"));
                }
                config = this.convertActionConfig(path, m.getActionConfig(), vars);
            }
        }
        return config;
    }

    protected ActionConfig convertActionConfig(String path, ActionConfig orig, Map vars) {
        ActionConfig config = null;
        try {
            config = (ActionConfig)BeanUtils.cloneBean((Object)orig);
        }
        catch (Exception ex) {
            log.warn((Object)"Unable to clone action config, recommend not using wildcards", (Throwable)ex);
            return null;
        }
        config.setName(this.convertParam(orig.getName(), vars));
        if (((String)path).length() == 0 || ((String)path).charAt(0) != '/') {
            path = "/" + (String)path;
        }
        config.setPath((String)path);
        config.setType(this.convertParam(orig.getType(), vars));
        config.setRoles(this.convertParam(orig.getRoles(), vars));
        config.setParameter(this.convertParam(orig.getParameter(), vars));
        config.setAttribute(this.convertParam(orig.getAttribute(), vars));
        config.setForward(this.convertParam(orig.getForward(), vars));
        config.setInclude(this.convertParam(orig.getInclude(), vars));
        config.setInput(this.convertParam(orig.getInput(), vars));
        config.setCatalog(this.convertParam(orig.getCatalog(), vars));
        config.setCommand(this.convertParam(orig.getCommand(), vars));
        config.setMultipartClass(this.convertParam(orig.getMultipartClass(), vars));
        config.setPrefix(this.convertParam(orig.getPrefix(), vars));
        config.setSuffix(this.convertParam(orig.getSuffix(), vars));
        ForwardConfig[] fConfigs = orig.findForwardConfigs();
        for (int x = 0; x < fConfigs.length; ++x) {
            ActionForward cfg;
            try {
                cfg = (ActionForward)BeanUtils.cloneBean((Object)fConfigs[x]);
            }
            catch (Exception ex) {
                log.warn((Object)"Unable to clone action config, recommend not using wildcards", (Throwable)ex);
                return null;
            }
            cfg.setName(fConfigs[x].getName());
            cfg.setPath(this.convertParam(fConfigs[x].getPath(), vars));
            cfg.setRedirect(fConfigs[x].getRedirect());
            cfg.setCommand(this.convertParam(fConfigs[x].getCommand(), vars));
            cfg.setCatalog(this.convertParam(fConfigs[x].getCatalog(), vars));
            cfg.setModule(this.convertParam(fConfigs[x].getModule(), vars));
            this.replaceProperties(fConfigs[x].getProperties(), cfg.getProperties(), vars);
            config.removeForwardConfig(fConfigs[x]);
            config.addForwardConfig(cfg);
        }
        this.replaceProperties(orig.getProperties(), config.getProperties(), vars);
        ExceptionConfig[] exConfigs = orig.findExceptionConfigs();
        for (int x = 0; x < exConfigs.length; ++x) {
            config.addExceptionConfig(exConfigs[x]);
        }
        config.freeze();
        return config;
    }

    protected void replaceProperties(Properties orig, Properties props, Map vars) {
        Map.Entry<Object, Object> entry2 = null;
        for (Map.Entry<Object, Object> entry2 : orig.entrySet()) {
            props.setProperty((String)entry2.getKey(), this.convertParam((String)entry2.getValue(), vars));
        }
    }

    protected String convertParam(String val, Map vars) {
        if (val == null) {
            return null;
        }
        if (val.indexOf("{") == -1) {
            return val;
        }
        StringBuffer key = new StringBuffer("{0}");
        StringBuffer ret = new StringBuffer(val);
        for (Map.Entry entry : vars.entrySet()) {
            int x;
            key.setCharAt(1, ((String)entry.getKey()).charAt(0));
            String keyTmp = key.toString();
            while ((x = ret.toString().indexOf(keyTmp)) > -1) {
                ret.replace(x, x + 3, (String)entry.getValue());
            }
        }
        return ret.toString();
    }

    private class Mapping
    implements Serializable {
        private int[] pattern;
        private ActionConfig config;

        public Mapping(int[] pattern, ActionConfig config) {
            this.pattern = pattern;
            this.config = config;
        }

        public int[] getPattern() {
            return this.pattern;
        }

        public ActionConfig getActionConfig() {
            return this.config;
        }
    }
}

